/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.TransformGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.KeyMotionBehavior;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.NavigationPanel;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.SliderBehavior;

public class ControlPanel
extends JPanel
implements ChangeListener {
    private SliderBehavior sliderBehavior;
    private JLabel label;
    private double scale = 0.01;
    private double curSliderValue = 0.0;

    public ControlPanel(TransformGroup sliderTarget, KeyMotionBehavior keyMotionBehavior, BoundingLeaf boundingLeaf) {
        this.setBorder(new BevelBorder(0));
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(110, 130));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.label = new JLabel("Map position: 0.0");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.label, gbc);
        this.sliderBehavior = this.createSliderBehavior(sliderTarget, boundingLeaf, this);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        this.add((Component)this.sliderBehavior.getSlider(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 2;
        gbc.fill = 0;
        gbc.anchor = 13;
        this.add((Component)new NavigationPanel(keyMotionBehavior), gbc);
    }

    public Behavior getSliderBehavior() {
        return this.sliderBehavior;
    }

    public double getSliderValue() {
        return this.curSliderValue;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.curSliderValue = this.scale * (double)((JSlider)e.getSource()).getValue();
        this.label.setText("Map position: " + String.valueOf(this.curSliderValue));
    }

    protected SliderBehavior createSliderBehavior(TransformGroup sliderTarget, BoundingLeaf boundingLeaf, ChangeListener l) {
        SliderBehavior sliderBehavior = new SliderBehavior(sliderTarget);
        sliderBehavior.setSchedulingBoundingLeaf(boundingLeaf);
        sliderBehavior.getSlider().addChangeListener(l);
        sliderBehavior.setOrientation(0);
        sliderBehavior.setMinimum(-30);
        sliderBehavior.setMaximum(30);
        sliderBehavior.setValue(0);
        sliderBehavior.setScale(this.scale);
        return sliderBehavior;
    }
}

