/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tease;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterBrowser;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DistanceMetricPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEEntrezSupportDataFile;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEInitDialog;
import org.tigr.microarray.mev.resources.IResourceManager;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.ResourcererAnnotationFileDefinition;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class TEASEInitDialog
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    private int result = 2;
    private ConfigPanel configPanel;
    private ModePanel modePanel;
    private PopSelectionPanel popPanel;
    private ColorBoundaryPanel colorPanel;
    private ClusterBrowser browser;
    private EventListener listener;
    private EaseParameterPanel easeParamPanel;
    private HCLSelectionPanel hclPanel;
    private AlphaPanel alphaPanel;
    private JTabbedPane tabbedPane;
    private Font font;
    private String sep;
    private Frame parent;
    private static String ANNOTATION_LINK = "ENTREZ_ID";
    protected boolean useLoadedAnnotationFile = false;
    protected File defaultEaseFileLocation;
    protected String speciesName;
    protected String arrayName;
    protected IResourceManager resourceManager;
    protected Hashtable<String, Vector<String>> speciestoarrays;
    protected File annotationFile;

    public TEASEInitDialog(Frame parent, String[] annotationLabels, String globalMetricName, boolean globalAbsoluteDistance, boolean showDistancePanel, File defaultEaseFileLocation, IResourceManager rm, String speciesName, String arrayName, Hashtable<String, Vector<String>> speciestoarrays, boolean isAnnotationLoaded) {
        super(parent, "TEASE: TEASE Annotation Analysis", true);
        this.speciesName = speciesName;
        this.arrayName = arrayName;
        this.resourceManager = rm;
        this.speciestoarrays = speciestoarrays;
        this.useLoadedAnnotationFile = isAnnotationLoaded;
        if (defaultEaseFileLocation == null) {
            defaultEaseFileLocation = new File(TMEV.getSettingForOption((String)"last-tease-file-location"));
        } else {
            this.defaultEaseFileLocation = defaultEaseFileLocation;
        }
        if (defaultEaseFileLocation == null || !defaultEaseFileLocation.canRead()) {
            defaultEaseFileLocation = new File("./data/ease");
        }
        this.parent = parent;
        this.font = new Font("Dialog", 1, 12);
        this.listener = new EventListener();
        this.addWindowListener(this.listener);
        this.tabbedPane = new JTabbedPane();
        this.configPanel = new ConfigPanel();
        this.hclPanel = new HCLSelectionPanel(globalMetricName, globalAbsoluteDistance, showDistancePanel);
        this.hclPanel.setTreeSelectionControls(false);
        this.tabbedPane.add("HCL Clustering", this.hclPanel);
        JPanel popNClusterPanel = new JPanel(new GridBagLayout());
        popNClusterPanel.setBackground(Color.white);
        this.popPanel = new PopSelectionPanel();
        this.colorPanel = new ColorBoundaryPanel();
        popNClusterPanel.add((Component)this.popPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        popNClusterPanel.add((Component)this.colorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.add("Population/Color", popNClusterPanel);
        this.easeParamPanel = new EaseParameterPanel(annotationLabels);
        this.tabbedPane.add("Annotation Parameters", this.easeParamPanel);
        this.alphaPanel = new AlphaPanel();
        this.tabbedPane.add("Statistical Parameters", this.alphaPanel);
        JPanel parameters = new JPanel(new GridBagLayout());
        parameters.setBackground(Color.white);
        this.modePanel = new ModePanel();
        parameters.add((Component)this.configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.modePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.tabbedPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(this.listener);
        this.setSize(570, 750);
    }

    public File getDefaultBaseFileLocation() {
        return this.defaultEaseFileLocation;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.setVisible(true);
        return this.result;
    }

    private void resetControls() {
        this.hclPanel.ALC.setSelected(true);
        this.hclPanel.metricPanel.reset();
        this.hclPanel.maxField.setText("100");
        this.hclPanel.minField.setText("10");
        this.alphaPanel.fisherBox.setSelected(true);
    }

    public String getUpperBoundary() {
        return this.colorPanel.upperField.getText();
    }

    public String getLowerBoundary() {
        return this.colorPanel.lowerField.getText();
    }

    public String isHCLOnly() {
        return String.valueOf(this.modePanel.hclOnlyButton.isSelected());
    }

    public boolean isClusterModeSelected() {
        return this.modePanel.clusterAnalysisButton.isSelected();
    }

    public Cluster getSelectedCluster() {
        return this.browser.getSelectedCluster();
    }

    public boolean isPopFileModeSelected() {
        return this.popPanel.fileButton.isSelected();
    }

    public boolean isPreloadedAnnotationSelected() {
        return this.popPanel.preloadedAnnotationButton.isSelected();
    }

    public int getMethod() {
        if (this.hclPanel.ALC.isSelected()) {
            return 0;
        }
        if (this.hclPanel.CLC.isSelected()) {
            return 1;
        }
        return -1;
    }

    public int getDistanceMetric() {
        return this.hclPanel.metricPanel.getMetricIndex();
    }

    public boolean getAbsoluteSelection() {
        return this.hclPanel.metricPanel.getAbsoluteSelection();
    }

    public String getPopulationFileName() {
        return this.popPanel.getPopFile();
    }

    public String getConverterFileName() {
        return this.easeParamPanel.getConverterFileName();
    }

    public int getMinClusterSize() {
        String value = this.easeParamPanel.minClusterSizeField.getText();
        try {
            int size = Integer.parseInt(value);
            return size;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getBaseFileLocation() {
        return this.configPanel.getBaseFileLocation();
    }

    public String getAnnotationKeyType() {
        return this.easeParamPanel.getAnnotationKeyType();
    }

    public String[] getAnnToGOFileList() {
        return this.easeParamPanel.getAnnToGOFileList();
    }

    public String getMaxNumber() {
        return this.hclPanel.maxField.getText();
    }

    public String getMinNumber() {
        return this.hclPanel.minField.getText();
    }

    public boolean isGeneTreeSelected() {
        return this.hclPanel.genes_box.isSelected();
    }

    public boolean isSampleTreeSelected() {
        return this.hclPanel.sample_box.isSelected();
    }

    public boolean isEaseScoreSelected() {
        return this.alphaPanel.easeBox.isSelected();
    }

    public boolean isCorrectPvaluesSelected() {
        return this.isBonferroniSelected() || this.isStepDownBonferroniSelected() || this.isSidakSelected();
    }

    public boolean isBonferroniSelected() {
        return this.alphaPanel.bonferroniBox.isSelected();
    }

    public boolean isStepDownBonferroniSelected() {
        return this.alphaPanel.bonferroniStepBox.isSelected();
    }

    public boolean isSidakSelected() {
        return this.alphaPanel.sidakBox.isSelected();
    }

    public boolean isPermutationAnalysisSelected() {
        return this.alphaPanel.permBox.isSelected();
    }

    public int getPermutationCount() {
        return Integer.parseInt(this.alphaPanel.permField.getText());
    }

    public String[] getTrimOptions() {
        String[] options = new String[2];
        if (this.alphaPanel.trimBox.isSelected()) {
            if (this.alphaPanel.trimPercentBox.isSelected()) {
                options[0] = "PERCENT_TRIM";
                options[1] = this.alphaPanel.trimPercentField.getText();
            } else {
                options[0] = "N_TRIM";
                options[1] = this.alphaPanel.trimNField.getText();
            }
        } else {
            options[0] = "NO_TRIM";
            options[1] = "0";
        }
        return options;
    }

    public static void main(String[] args) {
        String[] labels = new String[]{"TC#", "GB#", "Role"};
        EASEInitDialog eid = new EASEInitDialog((Frame)new JFrame(), labels);
        eid.showModal();
    }

    private class EventListener
    extends DialogListener
    implements ItemListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("use-converter-command")) {
                if (((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.useAnnBox.isSelected()) {
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.browserButton.setEnabled(true);
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.converterFileField.setEnabled(true);
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.converterFileField.setBackground(Color.white);
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.fileLabel.setEnabled(true);
                } else {
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.browserButton.setEnabled(false);
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.converterFileField.setEnabled(false);
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.converterFileField.setBackground(Color.lightGray);
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.fileLabel.setEnabled(false);
                }
            } else {
                if (command.equals("converter-file-browser-command")) {
                    File convertFile = new File(TEASEInitDialog.this.getBaseFileLocation() + TEASEInitDialog.this.sep + "Data" + TEASEInitDialog.this.sep + "Convert");
                    JFileChooser chooser = new JFileChooser(convertFile);
                    chooser.setDialogTitle("Annotation Converter Selection");
                    chooser.setMultiSelectionEnabled(false);
                    if (chooser.showOpenDialog(TEASEInitDialog.this.parent) == 0) {
                        TEASEInitDialog.this.easeParamPanel.updateConverterFileField(chooser.getSelectedFile().getPath());
                        if (TMEV.getSettingForOption((String)"last-tease-file-location") == null) {
                            TMEV.storeProperty((String)"last-tease-file-location", (String)chooser.getSelectedFile().getParentFile().getParentFile().getParent());
                        }
                    }
                    return;
                }
                if (command.equals("ann-file-browser-command")) {
                    File classFile = new File(TEASEInitDialog.this.getBaseFileLocation() + TEASEInitDialog.this.sep + "Data" + TEASEInitDialog.this.sep + "Class" + TEASEInitDialog.this.sep);
                    if (!classFile.canRead()) {
                        classFile = new File("." + TEASEInitDialog.this.sep + "data" + TEASEInitDialog.this.sep + "ease");
                    }
                    JFileChooser chooser = new JFileChooser(classFile);
                    chooser.setDialogTitle("Annotation --> GO Term, File(s) Selection");
                    chooser.setMultiSelectionEnabled(true);
                    if (chooser.showOpenDialog(TEASEInitDialog.this.parent) == 0) {
                        TEASEInitDialog.this.easeParamPanel.updateAnnFileList(chooser.getSelectedFiles());
                        ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.removeButton.setEnabled(true);
                        if (TMEV.getSettingForOption((String)"last-tease-file-location") == null) {
                            TMEV.storeProperty((String)"last-tease-file-location", (String)chooser.getSelectedFiles()[0].getParentFile().getParentFile().getParent());
                        }
                        TEASEInitDialog.this.okButton.setEnabled(true);
                    }
                } else if (command.equals("remove-ann-file-command")) {
                    TEASEInitDialog.this.easeParamPanel.removeSelectedFiles();
                } else if (command.equals("permutation-analysis-command")) {
                    TEASEInitDialog.this.alphaPanel.setEnablePermutations();
                } else if (command.equals("trim-result-command")) {
                    TEASEInitDialog.this.alphaPanel.validateTrimOptions();
                } else if (command.equals("select-file-base-command")) {
                    TEASEInitDialog.this.configPanel.browseForSupportFiles();
                } else if (command.equals("organism-selected-command")) {
                    TEASEInitDialog.this.configPanel.selectSpecies();
                    TEASEInitDialog.this.configPanel.updateSelection();
                } else if (command.equals("array-selected-command")) {
                    TEASEInitDialog.this.configPanel.updateSelection();
                } else if (command.equals("download-support-file-command")) {
                    TEASEInitDialog.this.configPanel.onDownloadSupportFile();
                } else if (command.equals("ok-command")) {
                    String fileName;
                    TEASEInitDialog.this.result = 0;
                    if (TEASEInitDialog.this.isClusterModeSelected() && ((TEASEInitDialog)TEASEInitDialog.this).popPanel.fileButton.isSelected() && ((fileName = ((TEASEInitDialog)TEASEInitDialog.this).popPanel.popField.getText()) == null || fileName.equals("") || fileName.equals(" "))) {
                        JOptionPane.showMessageDialog(TEASEInitDialog.this.parent, "You have selected to use a population file but have not entered a file name.  \nPlease enter a file or use the file browser to select a file.", "EASE Initialization: Missing Parameter", 2);
                        TEASEInitDialog.this.tabbedPane.setSelectedIndex(0);
                        ((TEASEInitDialog)TEASEInitDialog.this).popPanel.popField.grabFocus();
                        ((TEASEInitDialog)TEASEInitDialog.this).popPanel.popField.selectAll();
                        ((TEASEInitDialog)TEASEInitDialog.this).popPanel.popField.setCaretPosition(0);
                        return;
                    }
                    if (TEASEInitDialog.this.getAnnToGOFileList().length == 0 && !TEASEInitDialog.this.modePanel.hclOnlyButton.isSelected()) {
                        JOptionPane.showMessageDialog(TEASEInitDialog.this.parent, "You have not selected any gene annotation/gene ontology linking files. \nPlease enter files or use the browser to select files.", "EASE Initialization: Missing Parameter", 2);
                        TEASEInitDialog.this.tabbedPane.setSelectedIndex(1);
                        ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.browserButton.grabFocus();
                        return;
                    }
                    if (((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.useAnnBox.isSelected() && ((fileName = TEASEInitDialog.this.easeParamPanel.getConverterFileName()) == null || fileName.equals("") || fileName.equals(" "))) {
                        JOptionPane.showMessageDialog(TEASEInitDialog.this.parent, "You have selected to use an annotation conversion file but have not made a file selection.\nPlease enter a file name or browse to select a file.", "EASE Initialization: Missing Parameter", 2);
                        TEASEInitDialog.this.tabbedPane.setSelectedIndex(1);
                        ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.browserButton.grabFocus();
                        return;
                    }
                    TEASEInitDialog.this.dispose();
                } else if (command.equals("cancel-command")) {
                    TEASEInitDialog.this.result = 2;
                    TEASEInitDialog.this.dispose();
                } else {
                    if (command.equals("reset-command")) {
                        TEASEInitDialog.this.resetControls();
                        TEASEInitDialog.this.result = 2;
                        return;
                    }
                    if (command.equals("info-command")) {
                        HelpWindow.launchBrowser(TEASEInitDialog.this, "EASE Initialization Dialog");
                    }
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            TEASEInitDialog.this.result = -1;
            TEASEInitDialog.this.dispose();
        }
    }

    private class ColorBoundaryPanel
    extends ParameterPanel {
        private JTextField upperField;
        private JTextField lowerField;
        private JLabel upperLabel;
        private JLabel lowerLabel;

        public ColorBoundaryPanel() {
            super("Assign Color Gradient");
            this.setLayout(new GridBagLayout());
            this.upperLabel = new JLabel("Upper bound score (Blue -> not significant)");
            this.lowerLabel = new JLabel("Lower bound score (Red -> significant)");
            this.upperField = new JTextField("1.0E-1", 8);
            this.lowerField = new JTextField("1.0E-5", 8);
            this.add((Component)this.upperLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
            this.add((Component)this.upperField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this.lowerLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this.lowerField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        }

        public void setEnableControls(boolean enable) {
            this.upperLabel.setEnabled(enable);
            this.lowerLabel.setEnabled(enable);
            this.upperField.setEnabled(enable);
            this.lowerField.setEnabled(enable);
            this.setOpaque(enable);
        }
    }

    public class ConfigPanel
    extends ParameterPanel {
        private static final long serialVersionUID = -5298900627241870503L;
        JComboBox organismListBox;
        JComboBox arrayListBox;
        JLabel chooseOrg;
        JLabel chooseArray;
        JLabel browseLabel;
        JLabel statusLabel;
        JButton getEaseSupportFileButton;
        JButton browseSupportFileButton;
        JTextField supportFileLocationField;

        public ConfigPanel() {
            super("File Updates and Configuration");
            this.setLayout(new GridBagLayout());
            this.getEaseSupportFileButton = new JButton("Download");
            this.getEaseSupportFileButton.setActionCommand("download-support-file-command");
            this.getEaseSupportFileButton.addActionListener(TEASEInitDialog.this.listener);
            this.getEaseSupportFileButton.setToolTipText("<html>Downloads EASE annotation files<br>for a selected species and array type.</html>");
            this.browseSupportFileButton = new JButton("Browse");
            this.browseSupportFileButton.setActionCommand("select-file-base-command");
            this.browseSupportFileButton.addActionListener(TEASEInitDialog.this.listener);
            this.supportFileLocationField = new JTextField(TEASEInitDialog.this.getDefaultBaseFileLocation().getAbsolutePath(), 25);
            this.supportFileLocationField.setEditable(true);
            this.chooseOrg = new JLabel("Organism");
            this.chooseArray = new JLabel("Array Platform");
            this.browseLabel = new JLabel("or Browse for another Ease data file system:");
            this.statusLabel = new JLabel("Click to download");
            if (TEASEInitDialog.this.speciestoarrays == null || TEASEInitDialog.this.speciestoarrays.size() == 0) {
                this.organismListBox = new JComboBox();
                this.organismListBox.addItem("No organisms listed");
                this.organismListBox.setEnabled(false);
                this.arrayListBox = new JComboBox();
                this.arrayListBox.addItem("No species listed");
                this.arrayListBox.setEnabled(false);
            } else {
                if (TEASEInitDialog.this.speciestoarrays.size() > 0) {
                    this.organismListBox = new JComboBox<String>(new Vector<String>(TEASEInitDialog.this.speciestoarrays.keySet()));
                    try {
                        this.organismListBox.setSelectedItem(TEASEInitDialog.this.speciesName);
                    }
                    catch (NullPointerException npe) {
                        this.organismListBox.setSelectedIndex(0);
                    }
                    this.arrayListBox = this.organismListBox.getSelectedItem() == null ? new JComboBox() : new JComboBox<String>(TEASEInitDialog.this.speciestoarrays.get(this.organismListBox.getSelectedItem()));
                    try {
                        this.arrayListBox.setSelectedItem(TEASEInitDialog.this.arrayName);
                    }
                    catch (NullPointerException npe) {
                        this.arrayListBox.setSelectedIndex(0);
                    }
                }
                this.arrayListBox.setEnabled(true);
            }
            this.arrayListBox.addActionListener(TEASEInitDialog.this.listener);
            this.arrayListBox.setActionCommand("array-selected-command");
            this.organismListBox.addActionListener(TEASEInitDialog.this.listener);
            this.organismListBox.setActionCommand("organism-selected-command");
            this.add((Component)this.chooseOrg, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.chooseArray, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.organismListBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.arrayListBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.statusLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 25, 0, 20), 0, 0));
            this.add((Component)this.getEaseSupportFileButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 25, 0, 20), 0, 0));
            this.add((Component)this.browseLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(10, 30, 0, 0), 0, 0));
            this.add((Component)this.supportFileLocationField, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 1, new Insets(10, 30, 5, 0), 0, 0));
            this.add((Component)this.browseSupportFileButton, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 25, 5, 20), 0, 0));
            try {
                boolean b = TEASEInitDialog.this.resourceManager.fileIsInRepository((ISupportFileDefinition)new EASEEntrezSupportDataFile(this.organismListBox.getSelectedItem().toString(), this.arrayListBox.getSelectedItem().toString()));
                if (b) {
                    this.getEaseSupportFileButton.setText("Select This");
                } else {
                    this.getEaseSupportFileButton.setText("Download");
                }
            }
            catch (NullPointerException npe) {
                this.getEaseSupportFileButton.setText("Download");
            }
            this.updateSelection();
        }

        private void onDownloadSupportFile() {
            try {
                String species = this.organismListBox.getSelectedItem().toString();
                String array = this.arrayListBox.getSelectedItem().toString();
                File f = TEASEInitDialog.this.resourceManager.getSupportFile((ISupportFileDefinition)new EASEEntrezSupportDataFile(species, array), true);
                this.supportFileLocationField.setText(f.getAbsolutePath());
                this.getEaseSupportFileButton.setText("Select This");
                this.statusLabel.setText("Selected");
                this.getEaseSupportFileButton.setEnabled(false);
            }
            catch (SupportFileAccessError sfae) {
                this.statusLabel.setText("Failure");
                sfae.printStackTrace();
            }
            catch (NullPointerException npe) {
                this.statusLabel.setText("Failure");
            }
        }

        public void browseForSupportFiles() {
            File file;
            String startDir = TMEV.getSettingForOption((String)"last-ease-file-location");
            if (startDir == null) {
                startDir = this.supportFileLocationField.getText();
            }
            if (!(file = new File(startDir)).exists()) {
                file = TMEV.getFile((String)"data/ease");
                if (file == null) {
                    file = new File(System.getProperty("user.dir"));
                }
                TMEV.storeProperty((String)"last-ease-file-location", (String)file.toString());
            }
            JFileChooser chooser = new JFileChooser(file);
            chooser.setFileSelectionMode(1);
            if (chooser.showOpenDialog(TEASEInitDialog.this) == 0) {
                this.supportFileLocationField.setText(chooser.getSelectedFile().getAbsolutePath());
                TMEV.storeProperty((String)"last-ease-file-location", (String)this.supportFileLocationField.getText());
            }
        }

        public String getBaseFileLocation() {
            return this.supportFileLocationField.getText();
        }

        public void selectSpecies() {
            this.arrayListBox.removeAllItems();
            Vector<String> arraysForThisSpecies = TEASEInitDialog.this.speciestoarrays.get(this.organismListBox.getSelectedItem());
            for (int i = 0; i < arraysForThisSpecies.size(); ++i) {
                this.arrayListBox.addItem(arraysForThisSpecies.elementAt(i));
            }
        }

        public void updateSelection() {
            if (this.arrayListBox.getSelectedItem() == null) {
                return;
            }
            String selectedOrganism = this.organismListBox.getSelectedItem().toString();
            String selectedArray = this.arrayListBox.getSelectedItem().toString();
            if (selectedOrganism != null && selectedArray != null) {
                if (TEASEInitDialog.this.resourceManager.fileIsInRepository((ISupportFileDefinition)new EASEEntrezSupportDataFile(selectedOrganism, selectedArray))) {
                    this.statusLabel.setText("Click to Select");
                    this.getEaseSupportFileButton.setText("Select");
                } else {
                    this.statusLabel.setText("Click to Download");
                    this.getEaseSupportFileButton.setText("Download");
                }
                this.getEaseSupportFileButton.setEnabled(true);
                try {
                    ResourcererAnnotationFileDefinition def = new ResourcererAnnotationFileDefinition(TEASEInitDialog.this.speciesName, TEASEInitDialog.this.arrayName);
                    TEASEInitDialog.this.annotationFile = TEASEInitDialog.this.resourceManager.getSupportFile((ISupportFileDefinition)def, false);
                }
                catch (SupportFileAccessError sfae) {
                    TEASEInitDialog.this.useLoadedAnnotationFile = false;
                    ((TEASEInitDialog)TEASEInitDialog.this).popPanel.fileButton.setSelected(true);
                    ((TEASEInitDialog)TEASEInitDialog.this).popPanel.preloadedAnnotationButton.setSelected(false);
                    ((TEASEInitDialog)TEASEInitDialog.this).popPanel.preloadedAnnotationButton.setEnabled(false);
                }
            } else {
                this.getEaseSupportFileButton.setEnabled(false);
            }
        }
    }

    private class AlphaPanel
    extends JPanel {
        private JCheckBox fisherBox;
        private JCheckBox easeBox;
        private JCheckBox bonferroniBox;
        private JCheckBox sidakBox;
        private JCheckBox bonferroniStepBox;
        private JCheckBox permBox;
        private JTextField permField;
        private JLabel permLabel;
        private JCheckBox trimBox;
        private JCheckBox trimNBox;
        private JLabel trimNLabel;
        private JTextField trimNField;
        private JCheckBox trimPercentBox;
        private JLabel trimPercentLabel;
        private JTextField trimPercentField;

        public AlphaPanel() {
            super(new GridBagLayout());
            this.setBackground(Color.white);
            JPanel statPanel = new JPanel(new GridBagLayout());
            statPanel.setBackground(Color.white);
            statPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Reported Statistic", 0, 0, TEASEInitDialog.this.font, Color.black));
            ButtonGroup bg = new ButtonGroup();
            this.fisherBox = new JCheckBox("Fisher Exact Probability", true);
            this.fisherBox.setBackground(Color.white);
            this.fisherBox.setFocusPainted(false);
            bg.add(this.fisherBox);
            this.easeBox = new JCheckBox("EASE Score", false);
            this.easeBox.setBackground(Color.white);
            this.easeBox.setFocusPainted(false);
            bg.add(this.easeBox);
            statPanel.add((Component)this.fisherBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            statPanel.add((Component)this.easeBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            JPanel correctionPanel = new JPanel(new GridBagLayout());
            correctionPanel.setBackground(Color.white);
            correctionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Multiplicity Corrections", 0, 0, TEASEInitDialog.this.font, Color.black));
            this.bonferroniBox = new JCheckBox("Bonferroni Correction", false);
            this.bonferroniBox.setBackground(Color.white);
            this.bonferroniBox.setFocusPainted(false);
            this.bonferroniStepBox = new JCheckBox("Bonferroni Step Down Correction", false);
            this.bonferroniStepBox.setBackground(Color.white);
            this.bonferroniStepBox.setFocusPainted(false);
            this.sidakBox = new JCheckBox("Sidak Method", false);
            this.sidakBox.setBackground(Color.white);
            this.sidakBox.setFocusPainted(false);
            this.permBox = new JCheckBox("Resampling Probability Analysis", false);
            this.permBox.setActionCommand("permutation-analysis-command");
            this.permBox.setBackground(Color.white);
            this.permBox.setFocusPainted(false);
            this.permBox.addActionListener(TEASEInitDialog.this.listener);
            this.permField = new JTextField("1000", 10);
            this.permField.setBackground(Color.white);
            this.permField.setEnabled(false);
            this.permLabel = new JLabel("Number of Permutations");
            this.permLabel.setBackground(Color.white);
            this.permLabel.setEnabled(false);
            correctionPanel.add((Component)this.bonferroniBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
            correctionPanel.add((Component)this.sidakBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            correctionPanel.add((Component)this.bonferroniStepBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 10, 0), 0, 0));
            correctionPanel.add((Component)this.permBox, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            correctionPanel.add((Component)this.permLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 0), 0, 0));
            correctionPanel.add((Component)this.permField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 15, 0), 0, 0));
            JPanel trimPanel = new JPanel(new GridBagLayout());
            trimPanel.setBackground(Color.white);
            trimPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Trim Parameters", 0, 0, TEASEInitDialog.this.font, Color.black));
            this.trimBox = new JCheckBox("Trim Resulting Groups", false);
            this.trimBox.setActionCommand("trim-result-command");
            this.trimBox.addActionListener(TEASEInitDialog.this.listener);
            this.trimBox.setBackground(Color.white);
            this.trimBox.setHorizontalAlignment(0);
            this.trimBox.setFocusPainted(false);
            bg = new ButtonGroup();
            this.trimNBox = new JCheckBox("Select Minimum Hit Number", true);
            this.trimNBox.setActionCommand("trim-result-command");
            this.trimNBox.addActionListener(TEASEInitDialog.this.listener);
            this.trimNBox.setEnabled(false);
            this.trimNBox.setBackground(Color.white);
            this.trimNBox.setFocusPainted(false);
            bg.add(this.trimNBox);
            this.trimNLabel = new JLabel("Min. Hits");
            this.trimNLabel.setBackground(Color.white);
            this.trimNLabel.setEnabled(false);
            this.trimNField = new JTextField("5", 10);
            this.trimNField.setEnabled(false);
            this.trimPercentBox = new JCheckBox("Select Minimum Hit Percentage", false);
            this.trimPercentBox.setActionCommand("trim-result-command");
            this.trimPercentBox.addActionListener(TEASEInitDialog.this.listener);
            this.trimPercentBox.setEnabled(false);
            this.trimPercentBox.setBackground(Color.white);
            this.trimPercentBox.setFocusPainted(false);
            bg.add(this.trimPercentBox);
            this.trimPercentLabel = new JLabel("Percent Hits");
            this.trimPercentLabel.setBackground(Color.white);
            this.trimPercentLabel.setEnabled(false);
            this.trimPercentField = new JTextField("5", 10);
            this.trimPercentField.setEnabled(false);
            trimPanel.add((Component)this.trimBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
            trimPanel.add((Component)this.trimNBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            trimPanel.add((Component)this.trimNLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 20, 0, 15), 0, 0));
            trimPanel.add((Component)this.trimNField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            trimPanel.add((Component)this.trimPercentBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            trimPanel.add((Component)this.trimPercentLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(10, 20, 0, 15), 0, 0));
            trimPanel.add((Component)this.trimPercentField, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)statPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)correctionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)trimPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void setEnableControls(boolean enable) {
            this.setOpaque(enable);
            TEASEInitDialog.this.tabbedPane.setEnabledAt(3, enable);
        }

        public boolean performPermutations() {
            return this.permBox.isSelected();
        }

        public void setEnablePermutations() {
            this.permLabel.setEnabled(this.permBox.isSelected());
            this.permField.setEnabled(this.permBox.isSelected());
        }

        public void validateTrimOptions() {
            if (this.trimBox.isSelected()) {
                this.trimNBox.setEnabled(true);
                this.trimPercentBox.setEnabled(true);
                this.trimNLabel.setEnabled(this.trimNBox.isSelected());
                this.trimNField.setEnabled(this.trimNBox.isSelected());
                this.trimPercentLabel.setEnabled(!this.trimNBox.isSelected());
                this.trimPercentField.setEnabled(!this.trimNBox.isSelected());
            } else {
                this.trimNBox.setEnabled(false);
                this.trimPercentBox.setEnabled(false);
                this.trimNLabel.setEnabled(false);
                this.trimNField.setEnabled(false);
                this.trimPercentLabel.setEnabled(false);
                this.trimPercentField.setEnabled(false);
            }
        }
    }

    private class HCLSelectionPanel
    extends JPanel {
        private JRadioButton ALC;
        private JRadioButton CLC;
        private JRadioButton SLC;
        private JTextField maxField;
        private JTextField minField;
        private JCheckBox genes_box;
        private JCheckBox sample_box;
        private DistanceMetricPanel metricPanel;
        private JPanel treeSelectionPanel;

        public HCLSelectionPanel(String globalMetricName, boolean globalAbsoluteDistance, boolean showDistancePanel) {
            super(new GridBagLayout());
            this.setBackground(Color.white);
            this.metricPanel = new DistanceMetricPanel(globalMetricName, globalAbsoluteDistance, "Pearson Correlation", "HCL", true, true);
            this.metricPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Distance Metric Selection", 0, 0, TEASEInitDialog.this.font, Color.black));
            JPanel numberPanel = new JPanel(new GridBagLayout());
            numberPanel.setBackground(Color.white);
            numberPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Cluster size Specification", 0, 0, TEASEInitDialog.this.font, Color.black));
            this.maxField = new JTextField("100", 6);
            this.maxField.setBackground(Color.white);
            this.minField = new JTextField("10", 6);
            this.minField.setBackground(Color.white);
            JLabel maxLabel = new JLabel("Max");
            maxLabel.setBackground(Color.white);
            JLabel minLabel = new JLabel("Min");
            minLabel.setBackground(Color.white);
            numberPanel.add((Component)maxLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
            numberPanel.add((Component)this.maxField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            numberPanel.add((Component)minLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            numberPanel.add((Component)this.minField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.treeSelectionPanel = new JPanel(new GridBagLayout());
            this.treeSelectionPanel.setBackground(Color.white);
            this.treeSelectionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Tree Selection", 0, 0, TEASEInitDialog.this.font, Color.black));
            this.genes_box = new JCheckBox("Gene Tree");
            this.genes_box.setSelected(true);
            this.genes_box.setFocusPainted(false);
            this.genes_box.setBackground(Color.white);
            this.genes_box.setForeground(UIManager.getColor("Label.foreground"));
            this.genes_box.addItemListener(TEASEInitDialog.this.listener);
            this.sample_box = new JCheckBox("Sample Tree");
            this.sample_box.setSelected(false);
            this.sample_box.setFocusPainted(false);
            this.sample_box.setBackground(Color.white);
            this.sample_box.setForeground(UIManager.getColor("Label.foreground"));
            this.sample_box.addItemListener(TEASEInitDialog.this.listener);
            this.treeSelectionPanel.add((Component)this.genes_box, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 20), 0, 0));
            this.treeSelectionPanel.add((Component)this.sample_box, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 5, 0), 0, 0));
            ParameterPanel linkageMethodPanel = new ParameterPanel("Linkage Method Selection");
            linkageMethodPanel.setLayout(new GridBagLayout());
            linkageMethodPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Linkage Method Selection", 0, 0, TEASEInitDialog.this.font, Color.black));
            this.ALC = new JRadioButton("Average linkage clustering");
            this.ALC.setBackground(Color.white);
            this.ALC.setFocusPainted(false);
            this.ALC.setForeground(UIManager.getColor("Label.foreground"));
            this.ALC.setMnemonic(65);
            this.ALC.setSelected(true);
            this.CLC = new JRadioButton("Complete linkage clustering");
            this.CLC.setBackground(Color.white);
            this.CLC.setFocusPainted(false);
            this.CLC.setForeground(UIManager.getColor("Label.foreground"));
            this.CLC.setMnemonic(67);
            this.SLC = new JRadioButton("Single linkage clustering");
            this.SLC.setBackground(Color.white);
            this.SLC.setFocusPainted(false);
            this.SLC.setForeground(UIManager.getColor("Label.foreground"));
            this.SLC.setMnemonic(83);
            linkageMethodPanel.add((Component)this.ALC, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
            linkageMethodPanel.add((Component)this.CLC, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            linkageMethodPanel.add((Component)this.SLC, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            ButtonGroup group = new ButtonGroup();
            group.add(this.ALC);
            group.add(this.CLC);
            group.add(this.SLC);
            if (showDistancePanel) {
                this.add((Component)this.treeSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.metricPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)linkageMethodPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)numberPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this.add((Component)this.treeSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)linkageMethodPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)numberPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            TEASEInitDialog.this.setActionListeners(TEASEInitDialog.this.listener);
        }

        public void setTreeSelectionControls(boolean show) {
            this.treeSelectionPanel.setEnabled(show);
            this.genes_box.setEnabled(show);
            this.sample_box.setEnabled(show);
        }
    }

    private class EaseParameterPanel
    extends JPanel {
        JTextField converterFileField;
        JList fileList;
        JButton browserButton;
        JTextField minClusterSizeField;
        JComboBox fieldNamesBox;
        JList annFileList;
        Vector annVector;
        JButton removeButton;
        JCheckBox useAnnBox;
        JLabel fileLabel;

        public EaseParameterPanel(String[] fieldNames) {
            JPanel convPanel = new JPanel(new GridBagLayout());
            convPanel.setBackground(Color.white);
            convPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Annotation Conversion File", 0, 0, TEASEInitDialog.this.font, Color.black));
            this.useAnnBox = new JCheckBox("use annotation converter", false);
            this.useAnnBox.setActionCommand("use-converter-command");
            this.useAnnBox.addActionListener(TEASEInitDialog.this.listener);
            this.useAnnBox.setBackground(Color.white);
            this.useAnnBox.setFocusPainted(false);
            this.useAnnBox.setEnabled(!TEASEInitDialog.this.useLoadedAnnotationFile);
            this.converterFileField = new JTextField(30);
            this.converterFileField.setBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.gray));
            this.converterFileField.setEnabled(this.useAnnBox.isEnabled());
            this.converterFileField.setBackground(Color.lightGray);
            this.browserButton = new JButton("File Browser");
            this.browserButton.setActionCommand("converter-file-browser-command");
            this.browserButton.setFocusPainted(false);
            this.browserButton.setPreferredSize(new Dimension(150, 25));
            this.browserButton.setSize(150, 25);
            this.browserButton.addActionListener(TEASEInitDialog.this.listener);
            this.browserButton.setEnabled(this.useAnnBox.isEnabled());
            this.fileLabel = new JLabel("File :");
            this.fileLabel.setEnabled(false);
            convPanel.add((Component)this.useAnnBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 15, 15, 0), 0, 0));
            convPanel.add((Component)this.fileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 15, 0), 0, 0));
            convPanel.add((Component)this.browserButton, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 3, new Insets(0, 15, 0, 0), 0, 0));
            convPanel.add((Component)this.converterFileField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 15, 0), 0, 0));
            JPanel annPanel = new JPanel(new GridBagLayout());
            annPanel.setBackground(Color.white);
            annPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Gene Annotation / Gene Ontology Linking Files", 0, 0, TEASEInitDialog.this.font, Color.black));
            this.annFileList = new JList(new DefaultListModel());
            this.annFileList.setCellRenderer(new ListRenderer());
            this.annFileList.setBorder(BorderFactory.createBevelBorder(1));
            JScrollPane annPane = new JScrollPane(this.annFileList);
            JButton annButton = new JButton("Add Files");
            annButton.setActionCommand("ann-file-browser-command");
            annButton.addActionListener(TEASEInitDialog.this.listener);
            annButton.setFocusPainted(false);
            annButton.setPreferredSize(new Dimension(150, 25));
            annButton.setSize(150, 25);
            this.removeButton = new JButton("Remove Selected");
            this.removeButton.setActionCommand("remove-ann-file-command");
            this.removeButton.addActionListener(TEASEInitDialog.this.listener);
            this.removeButton.setFocusPainted(false);
            this.removeButton.setPreferredSize(new Dimension(150, 25));
            this.removeButton.setSize(150, 25);
            this.removeButton.setEnabled(false);
            JPanel fillPanel = new JPanel();
            fillPanel.setBackground(Color.white);
            annPanel.add((Component)fillPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            annPanel.add((Component)annButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 10, 5), 0, 0));
            annPanel.add((Component)this.removeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 10, 0), 0, 0));
            annPanel.add((Component)new JLabel("Files: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            annPanel.add((Component)annPane, new GridBagConstraints(1, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            TEASEInitDialog.this.sep = System.getProperty("file.separator");
            File file = new File(TEASEInitDialog.this.getBaseFileLocation());
            String tempPath = file.getPath();
            Vector<String> fileVector = new Vector<String>();
            this.fileList = new JList(fileVector);
            if (file.exists()) {
                String[] listFileNames = file.list();
                for (int i = 0; i < listFileNames.length; ++i) {
                    File tempFile = new File(tempPath + TEASEInitDialog.this.sep + listFileNames[i]);
                    if (!tempFile.isFile()) continue;
                    fileVector.add(listFileNames[i]);
                }
                if (fileVector.size() > 0) {
                    this.converterFileField.setText(tempPath + TEASEInitDialog.this.sep + (String)fileVector.elementAt(0));
                }
            }
            this.converterFileField.setText("");
            this.fieldNamesBox = new JComboBox<String>(fieldNames);
            this.fieldNamesBox.setEditable(false);
            this.fieldNamesBox.setEnabled(!TEASEInitDialog.this.useLoadedAnnotationFile);
            this.fieldNamesBox.setSelectedItem(ANNOTATION_LINK);
            this.minClusterSizeField = new JTextField(5);
            this.minClusterSizeField.setText("5");
            JPanel contentPanel = new JPanel(new GridBagLayout());
            JPanel easeFilePanel = new JPanel(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            JPanel annotKeyPanel = new JPanel(new GridBagLayout());
            annotKeyPanel.setBackground(Color.white);
            annotKeyPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "MeV Annotation Key  (\"Unique ID\")", 0, 0, TEASEInitDialog.this.font, Color.black));
            annotKeyPanel.add((Component)new JLabel("Annotation Key:  "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            annotKeyPanel.add((Component)this.fieldNamesBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)annotKeyPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)convPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)annPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void updateFileDirectoryField() {
            File file = new File((String)this.fileList.getSelectedValue());
            if (file == null) {
                return;
            }
            String tempPath = file.getParent();
            int fileIndex = this.fileList.getSelectedIndex();
            String fileName = (String)this.fileList.getModel().getElementAt(this.fileList.getSelectedIndex());
            this.converterFileField.setText(tempPath + TEASEInitDialog.this.sep + fileName);
        }

        private void setEnableControls(boolean enable) {
            this.setOpaque(enable);
            TEASEInitDialog.this.tabbedPane.setEnabledAt(2, enable);
            this.converterFileField.setEnabled(enable);
            this.fileList.setEnabled(enable);
            this.browserButton.setEnabled(enable);
            this.minClusterSizeField.setEnabled(enable);
            this.fieldNamesBox.setEnabled(enable);
            this.annFileList.setEnabled(enable);
            this.removeButton.setEnabled(enable);
            this.useAnnBox.setEnabled(enable);
            this.fileLabel.setEnabled(enable);
        }

        protected void updateAnnFileList(File[] files) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (((DefaultListModel)this.annFileList.getModel()).contains(file)) continue;
                ((DefaultListModel)this.annFileList.getModel()).addElement(file);
            }
            this.annFileList.validate();
        }

        public String getConverterFileName() {
            if (this.useAnnBox.isSelected()) {
                return this.converterFileField.getText();
            }
            return null;
        }

        public String getAnnotationKeyType() {
            return (String)this.fieldNamesBox.getSelectedItem();
        }

        protected void updateConverterFileField(String field) {
            this.converterFileField.setText(field);
        }

        public String[] getAnnToGOFileList() {
            String[] fileNames = new String[((DefaultListModel)this.annFileList.getModel()).size()];
            for (int i = 0; i < fileNames.length; ++i) {
                fileNames[i] = ((File)((DefaultListModel)this.annFileList.getModel()).elementAt(i)).getPath();
            }
            return fileNames;
        }

        public void removeSelectedFiles() {
            int[] indices = this.annFileList.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                ((DefaultListModel)this.annFileList.getModel()).removeElementAt(indices[i]);
            }
            if (this.annFileList.getModel().getSize() < 1) {
                this.removeButton.setEnabled(false);
                TEASEInitDialog.this.okButton.setEnabled(false);
            }
            this.annFileList.validate();
        }

        protected class ListRenderer
        extends DefaultListCellRenderer {
            protected ListRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                File file = (File)value;
                this.setText(file.getName());
                return this;
            }
        }

        protected class EaseListListener
        implements ListSelectionListener {
            protected EaseListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EaseParameterPanel.this.updateFileDirectoryField();
            }
        }
    }

    private class PopSelectionPanel
    extends ParameterPanel {
        JRadioButton preloadedAnnotationButton;
        JRadioButton fileButton;
        JRadioButton dataButton;
        JTextField popField;
        JButton browseButton;
        JLabel fileLabel;

        public PopSelectionPanel() {
            super("Population Selection");
            this.setLayout(new GridBagLayout());
            ButtonGroup bg = new ButtonGroup();
            if (TEASEInitDialog.this.useLoadedAnnotationFile) {
                this.preloadedAnnotationButton = new JRadioButton("Use loaded array population as background", true);
            } else {
                this.preloadedAnnotationButton = new JRadioButton("Use loaded array population as background (annotation not loaded)", false);
                this.preloadedAnnotationButton.setEnabled(false);
            }
            this.preloadedAnnotationButton.setBackground(Color.white);
            this.preloadedAnnotationButton.setFocusPainted(false);
            bg.add(this.preloadedAnnotationButton);
            this.preloadedAnnotationButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.fieldNamesBox.setSelectedItem(ANNOTATION_LINK);
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.fieldNamesBox.setEnabled(!PopSelectionPanel.this.preloadedAnnotationButton.isSelected());
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.useAnnBox.setEnabled(!PopSelectionPanel.this.preloadedAnnotationButton.isSelected());
                    PopSelectionPanel.this.browseButton.setEnabled(!PopSelectionPanel.this.preloadedAnnotationButton.isSelected());
                    PopSelectionPanel.this.popField.setEnabled(!PopSelectionPanel.this.preloadedAnnotationButton.isSelected());
                    PopSelectionPanel.this.popField.setBackground(Color.lightGray);
                    PopSelectionPanel.this.fileLabel.setEnabled(!PopSelectionPanel.this.preloadedAnnotationButton.isSelected());
                }
            });
            this.fileButton = new JRadioButton("Select Background Population from File");
            this.fileButton.setBackground(Color.white);
            this.fileButton.setFocusPainted(false);
            bg.add(this.fileButton);
            this.fileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.fieldNamesBox.setEnabled(!PopSelectionPanel.this.preloadedAnnotationButton.isSelected());
                    ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.useAnnBox.setEnabled(!PopSelectionPanel.this.preloadedAnnotationButton.isSelected());
                    PopSelectionPanel.this.browseButton.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                    PopSelectionPanel.this.popField.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                    PopSelectionPanel.this.popField.setBackground(Color.white);
                    PopSelectionPanel.this.fileLabel.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                }
            });
            this.dataButton = new JRadioButton("Select Background Population from Current Viewer");
            this.dataButton.setBackground(Color.white);
            this.dataButton.setFocusPainted(false);
            bg.add(this.dataButton);
            this.dataButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PopSelectionPanel.this.browseButton.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                    PopSelectionPanel.this.popField.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                    PopSelectionPanel.this.popField.setBackground(Color.lightGray);
                    PopSelectionPanel.this.fileLabel.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                }
            });
            this.browseButton = new JButton("File Browser");
            this.browseButton.setFocusPainted(false);
            this.browseButton.setPreferredSize(new Dimension(150, 25));
            this.browseButton.setSize(150, 25);
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JFileChooser chooser = new JFileChooser(new File(TEASEInitDialog.this.getBaseFileLocation(), "Lists"));
                    chooser.setDialogTitle("Population File Selection");
                    chooser.setMultiSelectionEnabled(false);
                    if (chooser.showOpenDialog(TEASEInitDialog.this.parent) == 0) {
                        PopSelectionPanel.this.updatePopField(chooser.getSelectedFile().getPath());
                        if (TMEV.getSettingForOption((String)"last-tease-file-location") == null) {
                            TMEV.storeProperty((String)"last-tease-file-location", (String)chooser.getSelectedFile().getParentFile().getParentFile().getParentFile().getParent());
                        }
                    }
                }
            });
            this.fileLabel = new JLabel("File: ");
            this.popField = new JTextField(25);
            this.fileButton.setSelected(!TEASEInitDialog.this.useLoadedAnnotationFile);
            this.preloadedAnnotationButton.setSelected(TEASEInitDialog.this.useLoadedAnnotationFile);
            this.preloadedAnnotationButton.setEnabled(TEASEInitDialog.this.useLoadedAnnotationFile);
            this.browseButton.setEnabled(this.fileButton.isSelected());
            this.popField.setEnabled(this.fileButton.isSelected());
            this.fileLabel.setEnabled(this.fileButton.isSelected());
            if (this.fileButton.isSelected()) {
                this.popField.setBackground(Color.white);
            } else {
                this.popField.setBackground(Color.lightGray);
            }
            this.add((Component)this.preloadedAnnotationButton, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 1, new Insets(10, 30, 0, 0), 0, 0));
            this.add((Component)this.fileButton, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 1, new Insets(10, 30, 0, 0), 0, 0));
            this.add((Component)this.fileLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.popField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 0, 0), 0, 0));
            this.add((Component)this.browseButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 25, 0, 20), 0, 0));
            this.add((Component)this.dataButton, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 1, new Insets(15, 30, 20, 0), 0, 0));
        }

        protected void setEnableControls(boolean enable) {
            this.preloadedAnnotationButton.setEnabled(enable && TEASEInitDialog.this.useLoadedAnnotationFile);
            ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.fieldNamesBox.setEnabled(!this.preloadedAnnotationButton.isSelected());
            ((TEASEInitDialog)TEASEInitDialog.this).easeParamPanel.useAnnBox.setEnabled(!this.preloadedAnnotationButton.isSelected());
            this.fileButton.setEnabled(enable);
            this.dataButton.setEnabled(enable);
            this.popField.setEnabled(enable);
            this.browseButton.setEnabled(enable);
            this.fileLabel.setEnabled(enable);
            this.setOpaque(enable);
            TEASEInitDialog.this.tabbedPane.setEnabledAt(0, enable);
        }

        protected void updatePopField(String file) {
            this.popField.setText(file);
        }

        protected String getPopFile() {
            return this.popField.getText();
        }
    }

    private class ModePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JRadioButton clusterAnalysisButton;
        private JRadioButton slideSurveyButton;
        private JRadioButton hclOnlyButton;

        public ModePanel() {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Mode Selection", 0, 0, TEASEInitDialog.this.font, Color.black));
            ButtonGroup bg = new ButtonGroup();
            this.clusterAnalysisButton = new JRadioButton("Cluster Analysis");
            this.clusterAnalysisButton.setFocusPainted(false);
            this.clusterAnalysisButton.setBackground(Color.white);
            this.clusterAnalysisButton.setHorizontalAlignment(0);
            this.clusterAnalysisButton.setSelected(true);
            this.clusterAnalysisButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TEASEInitDialog.this.popPanel.setEnableControls(true);
                    TEASEInitDialog.this.colorPanel.setEnableControls(true);
                    TEASEInitDialog.this.easeParamPanel.setEnableControls(true);
                    TEASEInitDialog.this.alphaPanel.setEnableControls(true);
                }
            });
            bg.add(this.clusterAnalysisButton);
            this.slideSurveyButton = new JRadioButton("Annotation Survey");
            this.slideSurveyButton.setToolTipText("Surveys annotation loaded in the CURRENT viewer.");
            this.slideSurveyButton.setFocusPainted(false);
            this.slideSurveyButton.setBackground(Color.white);
            this.slideSurveyButton.setHorizontalAlignment(0);
            this.slideSurveyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TEASEInitDialog.this.popPanel.setEnableControls(false);
                    TEASEInitDialog.this.colorPanel.setEnableControls(false);
                    TEASEInitDialog.this.easeParamPanel.setEnableControls(true);
                    TEASEInitDialog.this.alphaPanel.setEnableControls(true);
                    TEASEInitDialog.this.hclPanel.setTreeSelectionControls(false);
                }
            });
            bg.add(this.slideSurveyButton);
            this.hclOnlyButton = new JRadioButton("HCL Only");
            this.hclOnlyButton.setToolTipText("Clustering without searching");
            this.hclOnlyButton.setFocusPainted(false);
            this.hclOnlyButton.setBackground(Color.white);
            this.hclOnlyButton.setHorizontalAlignment(0);
            this.hclOnlyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TEASEInitDialog.this.popPanel.setEnableControls(false);
                    TEASEInitDialog.this.colorPanel.setEnableControls(false);
                    TEASEInitDialog.this.easeParamPanel.setEnableControls(false);
                    TEASEInitDialog.this.alphaPanel.setEnableControls(false);
                    TEASEInitDialog.this.hclPanel.setTreeSelectionControls(true);
                }
            });
            bg.add(this.hclOnlyButton);
            this.add((Component)this.hclOnlyButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.clusterAnalysisButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.slideSurveyButton, new GridBagConstraints(2, 0, 0, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }
}

