/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tease;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JLabel;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;

public class TEASEInfoBox
extends JLabel {
    public final int SIZE = 8;
    public static final int displayLimit = 5;
    public static final double defaultUpperBoundary = 0.1;
    public static final double defaultLowerBoundary = 1.0E-5;
    private int stepSize;
    private float yPos;
    public int x;
    public int y;
    public int rootNode;
    private double upperBound;
    private double lowerBound;
    private boolean isCluster;
    private Color color;
    private String[][] matrix;

    public TEASEInfoBox() {
    }

    public TEASEInfoBox(float x, float y, AlgorithmData data, int rootNode) {
        this.yPos = y;
        this.x = (int)x;
        this.rootNode = rootNode;
        if (data == null) {
            return;
        }
        AlgorithmParameters param = data.getParams();
        this.matrix = (String[][])data.getObjectMatrix("result-matrix");
        this.upperBound = param.getDouble("upper-boundary");
        this.lowerBound = param.getDouble("lower-boundary");
        if (this.matrix != null && this.matrix.length > 1) {
            this.isCluster = this.matrix[1] != null ? Double.valueOf(this.matrix[1][this.matrix[1].length - 1]) <= 1.1 : false;
        }
        this.setColor();
    }

    public String getInfoText() {
        if (this.matrix == null) {
            return "";
        }
        String text = "<html><body bgcolor = #ffffcc><table cellspacing = 10>";
        int midpoint = this.isCluster ? this.matrix[0].length - 6 : this.matrix[0].length - 3;
        for (int i = 0; i < 5; ++i) {
            text = text + "<tr>";
            for (int j = 1; j < midpoint; ++j) {
                text = text + "<td align = left>" + this.matrix[i][j] + "</td>";
            }
            text = text + "<td align = left><em>" + this.matrix[i][midpoint] + "</em></td>";
            text = this.isCluster ? text + "<td align = right>" + this.matrix[i][this.matrix[i].length - 1] + "</td>" : text + "<td align = right>" + this.matrix[i][midpoint + 1] + "\t" + this.matrix[i][midpoint + 2] + "</td>";
            text = text + "</tr>";
        }
        return text;
    }

    public void setColor() {
        if (this.matrix == null) {
            this.color = Color.BLACK;
        } else if (this.isCluster) {
            double upperLog = Math.log(this.upperBound);
            double lowerLog = Math.log(this.lowerBound);
            double score = Math.log(Double.valueOf(this.matrix[1][this.matrix[1].length - 1]));
            double middle = (upperLog + lowerLog) / 2.0;
            if (score < lowerLog) {
                this.color = new Color(255, 20, 0);
            } else if (score > upperLog) {
                this.color = new Color(0, 20, 255);
            } else if (score <= upperLog && score > middle) {
                int distance = (int)((upperLog - score) / (upperLog - middle) * 255.0);
                this.color = new Color(distance, 20, 255);
            } else {
                int distance = (int)((middle - score) / (middle - lowerLog) * 255.0);
                this.color = new Color(255, 20, 255 - distance);
            }
        } else {
            this.color = new Color(234, 72, 173);
        }
    }

    public void render(Graphics g) {
        this.y = (int)(this.yPos * (float)this.stepSize + (float)(this.stepSize / 2));
        g.setColor(this.color);
        g.fillOval(this.x - 4, this.y - 4, 8, 8);
    }

    public void updateSize(Dimension elementSize) {
        if (this.stepSize == elementSize.height) {
            return;
        }
        this.stepSize = elementSize.height;
    }

    public void resetX(int x) {
        this.x = x;
    }

    public void setColorBoundary(double upper, double lower) {
        this.upperBound = upper;
        this.lowerBound = lower;
        this.setColor();
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public String toString() {
        String text = "";
        text = text + "x = " + this.x + "  y = " + this.y;
        return text;
    }

    @Override
    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(int stepSize) {
        this.stepSize = stepSize;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isCluster() {
        return this.isCluster;
    }

    public void setCluster(boolean isCluster) {
        this.isCluster = isCluster;
    }

    public String[][] getMatrix() {
        return this.matrix;
    }

    public void setMatrix(String[][] matrix) {
        this.matrix = matrix;
    }

    public int getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(int rootNode) {
        this.rootNode = rootNode;
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public float getYPos() {
        return this.yPos;
    }

    public void setYPos(float pos) {
        this.yPos = pos;
    }
}

