/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tease;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEEntrezSupportDataFile;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEImpliesAndURLDataFile;
import org.tigr.microarray.mev.cluster.gui.impl.tease.HCLNodeHeightGraph;
import org.tigr.microarray.mev.cluster.gui.impl.tease.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.tease.TEASEInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.tease.TEASEViewer;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.PipelinedAnnotationsFileDefinition;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class TEASEGUI
implements IClusterGUI {
    String sep = System.getProperty("file.separator");
    public static final String LAST_TEASE_FILE_LOCATION = "last-tease-file-location";
    private Algorithm algorithm;
    private JFrame frame;
    private GeneralInfo info = new GeneralInfo();
    private Experiment experiment;
    private Progress progress;
    private Logger logger;
    private boolean stop;
    private boolean hclOnly;
    private boolean clusterGeneTree;
    private boolean clusterSampleTree;
    private String baseFileSystem;
    private String baseImpliesFileLocation;
    private String baseTagFileLocation;

    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        long time;
        AlgorithmData data = new AlgorithmData();
        AlgorithmData resultData = new AlgorithmData();
        this.frame = framework.getJFrame();
        this.experiment = framework.getData().getExperiment();
        AlgorithmFactory factory = framework.getAlgorithmFactory();
        this.algorithm = factory.getAlgorithm("TEASE");
        Listener listener = new Listener();
        this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
        this.logger = new Logger(framework.getFrame(), "TEASE Analysis", listener);
        this.progress = new Progress(framework.getFrame(), "", listener);
        long start = System.currentTimeMillis();
        data = this.TEASEInterface(framework, data);
        if (data == null) {
            return null;
        }
        if (this.hclOnly) {
            long time2;
            AlgorithmData genes_result = null;
            if (this.clusterGeneTree) {
                data.addParam("calculate-genes", String.valueOf(true));
                genes_result = this.algorithm.execute(data);
                this.validate(genes_result);
            }
            AlgorithmData samples_result = null;
            if (this.clusterSampleTree) {
                data.addParam("calculate-genes", String.valueOf(false));
                samples_result = this.algorithm.execute(data);
                this.validate(samples_result);
            }
            this.logger.append("Creating Result Viewers\n");
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.logger != null) {
                this.logger.dispose();
            }
            this.info.time = time2 = System.currentTimeMillis() - start;
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
            return this.createResultTree(this.experiment, genes_result, samples_result, this.info);
        }
        resultData = this.algorithm.execute(data);
        this.validate(resultData);
        this.logger.append("Creating Result Viewers\n");
        if (this.algorithm != null) {
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.logger != null) {
            this.logger.dispose();
        }
        this.info.time = time = System.currentTimeMillis() - start;
        if (this.algorithm != null) {
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return this.createResultTree(this.experiment, resultData, this.info);
    }

    private AlgorithmData TEASEInterface(IFramework framework, AlgorithmData data) throws AlgorithmException {
        String[] populationKeys;
        boolean isClusterAnalysis;
        String[] annotationFileList;
        String converterFileName;
        TEASEInitDialog dialog;
        block23: {
            IDistanceMenu menu = framework.getDistanceMenu();
            int function = menu.getDistanceFunction();
            if (function == 0) {
                function = 1;
            }
            String speciesName = null;
            Hashtable speciestoarrays = null;
            Vector<ISupportFileDefinition> defs = new Vector<ISupportFileDefinition>();
            EASEEntrezSupportDataFile edf = null;
            String chipType = null;
            File defaultTEASEDirectory = null;
            if (framework.getData().isAnnotationLoaded()) {
                chipType = framework.getData().getChipAnnotation().getChipType();
                String filename = framework.getData().getChipAnnotation().getAnnFileName();
                String species = framework.getData().getChipAnnotation().getSpeciesName();
                edf = new EASEEntrezSupportDataFile(species, chipType);
                defs.add(edf);
                File annotationFile = new File(filename);
                if (annotationFile.canRead()) {
                    defaultTEASEDirectory = new File("./data/ease/ease_" + chipType);
                } else {
                    annotationFile = new File("./data/Annotation/" + chipType + ".txt");
                    defaultTEASEDirectory = new File("./data/ease/ease_" + chipType);
                    if (!annotationFile.canRead()) {
                        defaultTEASEDirectory = null;
                    }
                }
            }
            PipelinedAnnotationsFileDefinition aafd = new PipelinedAnnotationsFileDefinition();
            defs.add((ISupportFileDefinition)aafd);
            EASEImpliesAndURLDataFile eiudf = new EASEImpliesAndURLDataFile();
            defs.add(eiudf);
            if (framework.getData().isAnnotationLoaded()) {
                chipType = framework.getData().getChipAnnotation().getChipType();
                speciesName = framework.getData().getChipAnnotation().getSpeciesName();
                edf = new EASEEntrezSupportDataFile(speciesName, chipType);
                defs.add(edf);
            }
            try {
                Hashtable supportFiles = framework.getSupportFiles(defs, true);
                File impliesFile = (File)supportFiles.get((Object)eiudf);
                this.baseImpliesFileLocation = eiudf.getImpliesLocation(impliesFile);
                this.baseTagFileLocation = eiudf.getTagsLocation(impliesFile);
                File speciesarraymapping = (File)supportFiles.get(aafd);
                try {
                    speciestoarrays = aafd.parseAnnotationListFile(speciesarraymapping);
                }
                catch (IOException ioe) {
                    speciestoarrays = null;
                }
                defaultTEASEDirectory = edf != null || framework.getData().isAnnotationLoaded() ? new File(((File)supportFiles.get((Object)edf)).getAbsolutePath()) : new File("./data/ease/ease_" + chipType);
            }
            catch (SupportFileAccessError sfae) {
                defaultTEASEDirectory = new File("./data/ease/ease_" + chipType);
            }
            dialog = new TEASEInitDialog(framework.getFrame(), framework.getData().getAllFilledAnnotationFields(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true, defaultTEASEDirectory, framework.getResourceManager(), speciesName, chipType, speciestoarrays, framework.getData().isAnnotationLoaded());
            if (dialog.showModal() != 0) {
                return null;
            }
            this.baseFileSystem = dialog.getBaseFileLocation();
            if (!dialog.isPreloadedAnnotationSelected()) {
                data.addParam("implies-location-list", this.baseFileSystem + this.sep + "Data" + this.sep + "Class" + this.sep + "Implies");
                data.addParam("tags-location-list", this.baseFileSystem + this.sep + "Data" + this.sep + "Class" + this.sep + "URL data" + this.sep + "Tags");
            }
            if (data.getParams().getString("implies-location-list") == null || !new File(data.getParams().getString("implies-location-list")).exists() || !new File(data.getParams().getString("implies-location-list")).isDirectory()) {
                data.addParam("implies-location-list", this.baseImpliesFileLocation);
            }
            if (data.getParams().getString("tags-location-list") == null || !new File(data.getParams().getString("tags-location-list")).exists() || !new File(data.getParams().getString("tags-location-list")).isDirectory()) {
                data.addParam("tags-location-list", this.baseTagFileLocation);
            }
            int method = dialog.getMethod();
            function = dialog.getDistanceMetric();
            data.addParam("hcl-only", dialog.isHCLOnly());
            data.addMatrix("experiment", this.experiment.getMatrix());
            data.addParam("hcl-distance-function", String.valueOf(function));
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("hcl-distance-absolute", String.valueOf(dialog.getAbsoluteSelection()));
            data.addParam("method-linkage", String.valueOf(method));
            this.progress.setTitle("Clustering by Genes");
            this.info.method = method;
            this.info.function = menu.getFunctionName(function);
            this.logger.show();
            this.hclOnly = Boolean.valueOf(dialog.isHCLOnly());
            if (this.hclOnly) {
                this.clusterGeneTree = dialog.isGeneTreeSelected();
                this.clusterSampleTree = dialog.isSampleTreeSelected();
                data.addParam("hcl-only", String.valueOf(true));
                return data;
            }
            data.addParam("maximum-genes", dialog.getMaxNumber());
            data.addParam("minimum-genes", dialog.getMinNumber());
            data.addParam("upper-boundary", dialog.getUpperBoundary());
            data.addParam("lower-boundary", dialog.getLowerBoundary());
            this.info.max = dialog.getMaxNumber();
            this.info.min = dialog.getMinNumber();
            String baseFileSystem = dialog.getBaseFileLocation();
            converterFileName = dialog.getConverterFileName();
            String annotationKeyType = dialog.getAnnotationKeyType();
            annotationFileList = dialog.getAnnToGOFileList();
            isClusterAnalysis = dialog.isClusterModeSelected();
            data.addParam("base-file-system", baseFileSystem);
            if (isClusterAnalysis) {
                data.addParam("report-ease-score", String.valueOf(dialog.isEaseScoreSelected()));
                boolean isPvalueCorrectionSelected = dialog.isCorrectPvaluesSelected();
                data.addParam("p-value-corrections", String.valueOf(isPvalueCorrectionSelected));
                if (isPvalueCorrectionSelected) {
                    data.addParam("bonferroni-correction", String.valueOf(dialog.isBonferroniSelected()));
                    data.addParam("bonferroni-step-down-correction", String.valueOf(dialog.isStepDownBonferroniSelected()));
                    data.addParam("sidak-correction", String.valueOf(dialog.isSidakSelected()));
                }
                data.addParam("run-permutation-analysis", String.valueOf(dialog.isPermutationAnalysisSelected()));
                if (dialog.isPermutationAnalysisSelected()) {
                    data.addParam("permutation-count", String.valueOf(dialog.getPermutationCount()));
                }
                this.logger.append("Extracting Annotation Key Lists\n");
            }
            String[] clusterKeys = framework.getData().getAnnotationList(annotationKeyType);
            data.addStringArray("name-list", framework.getData().getAnnotationList("Title"));
            data.addStringArray("annotation-list", clusterKeys);
            if (isClusterAnalysis && dialog.isPopFileModeSelected()) {
                try {
                    populationKeys = this.getPopulationKeysFromFile(dialog.getPopulationFileName());
                    data.addParam("population-file-name", dialog.getPopulationFileName());
                    if (populationKeys == null) {
                        return null;
                    }
                    break block23;
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(framework.getFrame(), "Error loading population file.", "Population File Load Error", 0);
                    return null;
                }
            }
            populationKeys = framework.getData().getAnnotationList(annotationKeyType, framework.getData().getExperiment().getRowMappingArrayCopy());
        }
        data.addParam("perform-cluster-analysis", String.valueOf(isClusterAnalysis));
        data.addStringArray("population-list", populationKeys);
        if (converterFileName != null) {
            data.addParam("converter-file-name", converterFileName);
        }
        data.addStringArray("annotation-file-list", annotationFileList);
        String[] trimOptions = dialog.getTrimOptions();
        data.addParam("trim-option", trimOptions[0]);
        data.addParam("trim-value", trimOptions[1]);
        return data;
    }

    private String[] getPopulationKeysFromFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            String key;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            Vector<String> ann = new Vector<String>();
            while ((key = reader.readLine()) != null) {
                ann.add(key);
            }
            String[] annot = new String[ann.size()];
            for (int i = 0; i < annot.length; ++i) {
                annot[i] = (String)ann.elementAt(i);
            }
            return annot;
        }
        return null;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private DefaultMutableTreeNode createResultTree(Experiment experiment, AlgorithmData genes_result, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("TEASE");
        root.add(new DefaultMutableTreeNode(new LeafInfo("TEASE Tree", this.createHCLViewer(experiment, genes_result, null, root))));
        if (genes_result != null) {
            root.add(new DefaultMutableTreeNode(new LeafInfo("Gene Node Height Plot", (IViewer)new HCLNodeHeightGraph(this.getHCLTreeData(genes_result), true))));
        }
        this.addGeneralInfo(root, info);
        return root;
    }

    private DefaultMutableTreeNode createResultTree(Experiment experiment, AlgorithmData genes_result, AlgorithmData samples_result, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("TEASE");
        root.add(new DefaultMutableTreeNode(new LeafInfo("HCL Tree", this.createHCLViewer(experiment, genes_result, samples_result, root))));
        if (genes_result != null) {
            root.add(new DefaultMutableTreeNode(new LeafInfo("Gene Node Height Plot", (IViewer)new HCLNodeHeightGraph(this.getHCLTreeData(genes_result), true))));
        }
        if (samples_result != null) {
            root.add(new DefaultMutableTreeNode(new LeafInfo("Sample Node Height Plot", (IViewer)new HCLNodeHeightGraph(this.getHCLTreeData(samples_result), false))));
        }
        this.addGeneralInfo(root, info);
        return root;
    }

    private HCLTreeData getHCLTreeData(AlgorithmData result) {
        if (result == null) {
            return null;
        }
        HCLTreeData data = new HCLTreeData();
        data.child_1_array = result.getIntArray("child-1-array");
        data.child_2_array = result.getIntArray("child-2-array");
        data.node_order = result.getIntArray("node-order");
        data.node_list = result.getIntArray("node-list");
        data.height = result.getMatrix("height").getRowPackedCopy();
        return data;
    }

    private IViewer createHCLViewer(Experiment experiment, AlgorithmData genes_result, AlgorithmData samples_result, DefaultMutableTreeNode root) {
        return new TEASEViewer(this.frame, experiment, null, this.getHCLTreeData(genes_result), this.getHCLTreeData(samples_result), root, this.hclOnly, genes_result);
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Linkage Method: " + info.getMethodName()));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        node.add(new DefaultMutableTreeNode("Cluster Size: " + info.getSize()));
        node.add(new DefaultMutableTreeNode(info.function));
        root.add(node);
    }

    public static class GeneralInfo {
        public long time;
        public int method;
        public String function;
        public String max;
        public String min;
        private static String[] methods = new String[]{"average linkage", "complete linkage", "single linkage"};

        public String getMethodName() {
            return GeneralInfo.getMethodName(this.method);
        }

        public static String getMethodName(int method) {
            method = method == -1 ? 2 : method;
            return methods[method];
        }

        public String getSize() {
            return this.min + " - " + this.max;
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        String eventDescription;

        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                System.out.println("abort execution");
                TEASEGUI.this.stop = true;
                TEASEGUI.this.algorithm.abort();
                TEASEGUI.this.progress.dispose();
                TEASEGUI.this.logger.dispose();
            }
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 3: {
                    TEASEGUI.this.logger.append(event.getDescription());
                    break;
                }
                case 1: {
                    TEASEGUI.this.progress.setDescription("Resampling Analysis Iterations");
                    TEASEGUI.this.progress.setValue(0);
                    TEASEGUI.this.progress.setUnits(event.getIntValue());
                    TEASEGUI.this.progress.show();
                    Point p = TEASEGUI.this.progress.getLocation();
                    Point loggerP = TEASEGUI.this.logger.getLocation();
                    TEASEGUI.this.progress.setLocation(p.x, loggerP.y - TEASEGUI.this.progress.getHeight());
                    break;
                }
                case 2: {
                    TEASEGUI.this.progress.setValue(event.getIntValue());
                    TEASEGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 5: {
                    TEASEGUI.this.progress.setValue(event.getIntValue());
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            TEASEGUI.this.algorithm.abort();
            TEASEGUI.this.progress.dispose();
        }
    }
}

