/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tease;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.tease.HCLTree;
import org.tigr.microarray.mev.cluster.gui.impl.tease.TEASEViewer;

public class TEASEConfigDialog
extends AlgorithmDialog {
    private int result;
    private JTextField zeroTextField;
    private JTextField minTextField;
    private JTextField maxTextField;
    private JTextField numTerminalsField;
    private float zThr;
    private int minPixDist;
    private int maxPixDist;
    private float origZThr;
    private int origMinPixDist;
    private int origMaxPixDist;
    private float minDist;
    private float maxDist;
    private float distRange;
    private JButton applyButton;
    private JCheckBox createClusterViewsBox;
    private JSlider slider;
    private HCLTree tree;
    private TEASEViewer viewer;

    public TEASEConfigDialog(Frame parent, TEASEViewer viewer, float zeroThreshold, int minPixelDistance, int maxPixelDistance, float minDist, float maxDist) {
        super(parent, "Tree Configuration", true);
        this.viewer = viewer;
        this.zThr = zeroThreshold;
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.origZThr = zeroThreshold;
        this.origMinPixDist = minPixelDistance;
        this.origMaxPixDist = maxPixelDistance;
        this.distRange = maxDist - minDist;
        this.minPixDist = minPixelDistance;
        this.maxPixDist = maxPixelDistance;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel cutOffPanel = new JPanel(new GridBagLayout());
        cutOffPanel.setBackground(Color.white);
        cutOffPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Distance Treshold Adjustment", 0, 0, new Font("Dialog", 1, 12), Color.black));
        cutOffPanel.add((Component)new JLabel("Distance threshold"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        String z = String.valueOf(zeroThreshold);
        z = z.substring(0, Math.min(5, z.length()));
        this.zeroTextField = new JTextField(z, 4);
        cutOffPanel.add((Component)this.zeroTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.slider = new JSlider(0, 0, 1000, 0);
        this.slider.setBackground(Color.white);
        this.slider.setValue((int)(1000.0f * ((this.zThr - this.minDist) / (this.maxDist - this.minDist))));
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("Min"));
        labelTable.put(new Integer(500), new JLabel("(Distance Range)"));
        labelTable.put(new Integer(1000), new JLabel("Max"));
        this.slider.setLabelTable(labelTable);
        this.slider.setPaintLabels(true);
        cutOffPanel.add((Component)this.slider, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
        cutOffPanel.add((Component)new JSeparator(1), new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        cutOffPanel.add((Component)new JLabel("# of Terminal Nodes:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.numTerminalsField = new JTextField(6);
        this.numTerminalsField.setEditable(false);
        this.numTerminalsField.setSize(90, 25);
        this.numTerminalsField.setPreferredSize(new Dimension(90, 25));
        cutOffPanel.add((Component)this.numTerminalsField, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.createClusterViewsBox = new JCheckBox("Create Cluster Viewers", false);
        this.createClusterViewsBox.setFocusPainted(false);
        this.createClusterViewsBox.setBackground(Color.white);
        this.createClusterViewsBox.setForeground(UIManager.getColor("Label.foreground"));
        cutOffPanel.add((Component)this.createClusterViewsBox, new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel treeDimPanel = new JPanel(new GridBagLayout());
        treeDimPanel.setBackground(Color.white);
        treeDimPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Tree Dimension Parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
        treeDimPanel.add((Component)new JLabel("Minimum pixel height"), new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 20, 0, 10), 0, 0));
        treeDimPanel.add((Component)new JLabel("Maximum pixel height"), new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 20, 0, 10), 0, 0));
        this.minTextField = new JTextField(String.valueOf(minPixelDistance), 4);
        treeDimPanel.add((Component)this.minTextField, new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.maxTextField = new JTextField(String.valueOf(maxPixelDistance), 4);
        treeDimPanel.add((Component)this.maxTextField, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.applyButton = new JButton("Apply Dimensions");
        this.applyButton.setActionCommand("apply-tree-dimensions-command");
        this.applyButton.setFocusPainted(false);
        this.applyButton.setMargin(new Insets(5, 15, 5, 15));
        this.applyButton.setSize(110, 30);
        this.applyButton.setPreferredSize(new Dimension(120, 30));
        this.applyButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.gray));
        treeDimPanel.add((Component)this.applyButton, new GridBagConstraints(2, 0, 1, 2, 0.8, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.setForeground(Color.white);
        panel3.setBorder(BorderFactory.createLineBorder(Color.gray));
        panel3.setBackground(Color.white);
        panel3.add((Component)cutOffPanel, "North");
        panel3.add((Component)treeDimPanel, "Center");
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)panel3, "Center");
        this.addContent(panel1);
        this.slider.addChangeListener(listener);
        this.zeroTextField.addKeyListener(listener);
        this.applyButton.addActionListener(listener);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public void setTree(HCLTree tree) {
        this.tree = tree;
        this.numTerminalsField.setText(String.valueOf(this.tree.getNumberOfTerminalNodes()));
    }

    public float getZeroThreshold() {
        float value = Float.parseFloat(this.zeroTextField.getText());
        if (value <= this.minDist) {
            return this.minDist;
        }
        if (value >= this.maxDist) {
            return this.maxDist;
        }
        return value;
    }

    public int getMinDistance() {
        return Integer.parseInt(this.minTextField.getText());
    }

    public int getMaxDistance() {
        return Integer.parseInt(this.maxTextField.getText());
    }

    public boolean isCreateClusterViews() {
        return this.createClusterViewsBox.isSelected();
    }

    public static void main(String[] args) {
    }

    private class Listener
    extends DialogListener
    implements ChangeListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    TEASEConfigDialog.this.zThr = Float.parseFloat(TEASEConfigDialog.this.zeroTextField.getText());
                    TEASEConfigDialog.this.minPixDist = Integer.parseInt(TEASEConfigDialog.this.minTextField.getText());
                    TEASEConfigDialog.this.maxPixDist = Integer.parseInt(TEASEConfigDialog.this.maxTextField.getText());
                    TEASEConfigDialog.this.tree.setProperties(TEASEConfigDialog.this.zThr, TEASEConfigDialog.this.minPixDist, TEASEConfigDialog.this.maxPixDist);
                    TEASEConfigDialog.this.viewer.revalidateViewer();
                    TEASEConfigDialog.this.viewer.repaint();
                    TEASEConfigDialog.this.result = 0;
                    TEASEConfigDialog.this.dispose();
                }
                catch (Exception exc) {
                    TEASEConfigDialog.this.result = 2;
                    TEASEConfigDialog.this.dispose();
                }
            } else if (command.equals("apply-tree-dimensions-command")) {
                try {
                    TEASEConfigDialog.this.minPixDist = Integer.parseInt(TEASEConfigDialog.this.minTextField.getText());
                    TEASEConfigDialog.this.maxPixDist = Integer.parseInt(TEASEConfigDialog.this.maxTextField.getText());
                    TEASEConfigDialog.this.tree.setPixelHeightLimits(TEASEConfigDialog.this.minPixDist, TEASEConfigDialog.this.maxPixDist);
                    TEASEConfigDialog.this.viewer.revalidateViewer();
                    TEASEConfigDialog.this.viewer.repaint();
                }
                catch (NumberFormatException e1) {
                    TEASEConfigDialog.this.result = 2;
                    TEASEConfigDialog.this.dispose();
                }
            } else if (command.equals("cancel-command")) {
                TEASEConfigDialog.this.tree.setProperties(TEASEConfigDialog.this.origZThr, TEASEConfigDialog.this.origMinPixDist, TEASEConfigDialog.this.origMaxPixDist);
                TEASEConfigDialog.this.viewer.revalidateViewer();
                TEASEConfigDialog.this.viewer.repaint();
                TEASEConfigDialog.this.result = 2;
                TEASEConfigDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                TEASEConfigDialog.this.zeroTextField.setText(String.valueOf(TEASEConfigDialog.this.origZThr));
                TEASEConfigDialog.this.minTextField.setText(String.valueOf(TEASEConfigDialog.this.origMinPixDist));
                TEASEConfigDialog.this.maxTextField.setText(String.valueOf(TEASEConfigDialog.this.origMaxPixDist));
                TEASEConfigDialog.this.tree.setProperties(TEASEConfigDialog.this.origZThr, TEASEConfigDialog.this.origMinPixDist, TEASEConfigDialog.this.origMaxPixDist);
                TEASEConfigDialog.this.slider.setValue(0);
                TEASEConfigDialog.this.createClusterViewsBox.setSelected(false);
                TEASEConfigDialog.this.viewer.revalidateViewer();
                TEASEConfigDialog.this.viewer.repaint();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(TEASEConfigDialog.this, "HCL Tree Properties");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            TEASEConfigDialog.this.result = -1;
            TEASEConfigDialog.this.dispose();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == TEASEConfigDialog.this.slider) {
                float value = TEASEConfigDialog.this.distRange * ((float)TEASEConfigDialog.this.slider.getValue() / 1000.0f) + TEASEConfigDialog.this.minDist;
                if (TEASEConfigDialog.this.tree != null) {
                    TEASEConfigDialog.this.zThr = value;
                    TEASEConfigDialog.this.tree.setZeroThreshold(value);
                    TEASEConfigDialog.this.zeroTextField.setText(String.valueOf(value));
                    TEASEConfigDialog.this.numTerminalsField.setText(String.valueOf(TEASEConfigDialog.this.tree.getNumberOfTerminalNodes()));
                    TEASEConfigDialog.this.tree.repaint();
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getSource() == TEASEConfigDialog.this.zeroTextField) {
                try {
                    float value = Float.parseFloat(TEASEConfigDialog.this.zeroTextField.getText());
                    TEASEConfigDialog.this.zThr = value;
                    TEASEConfigDialog.this.tree.setZeroThreshold(value);
                    TEASEConfigDialog.this.numTerminalsField.setText(String.valueOf(TEASEConfigDialog.this.tree.getNumberOfTerminalNodes()));
                    TEASEConfigDialog.this.tree.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

