/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tease;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;

public class ScoreBoundaryDialog
extends AlgorithmDialog {
    private int result;
    private JTextField upperField;
    private JTextField lowerField;

    public ScoreBoundaryDialog(Frame frame, double upperBound, double lowerBound) {
        super(frame, "Score Boundary", true);
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel upperLabel = new JLabel("Upper bound score (Blue -> not significant)");
        JLabel lowerLabel = new JLabel("Lower bound score (Red -> significant)");
        this.upperField = new JTextField(String.valueOf(upperBound), 8);
        this.lowerField = new JTextField(String.valueOf(lowerBound), 8);
        panel.add((Component)upperLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        panel.add((Component)this.upperField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)lowerLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)this.lowerField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.addContent(panel);
        this.setActionListeners(new Listener());
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getUpperBound() {
        return this.upperField.getText();
    }

    public String getLowerBound() {
        return this.lowerField.getText();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == "ok-command") {
                ScoreBoundaryDialog.this.result = 0;
                ScoreBoundaryDialog.this.dispose();
            }
            if (e.getActionCommand() == "cancel-command") {
                ScoreBoundaryDialog.this.result = 2;
                ScoreBoundaryDialog.this.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ScoreBoundaryDialog.this.result = -1;
            ScoreBoundaryDialog.this.dispose();
        }
    }
}

