/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tease;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class NewickFileOutputDialog
extends AlgorithmDialog {
    private int result = 2;
    private boolean isGeneTree = false;
    private JComboBox annBox;
    private JTextField fileField;

    public NewickFileOutputDialog(Frame parent, String[] annotationKeys, int orientation) {
        super(parent, "Newick File Output Dialog", true);
        if (orientation == 0) {
            this.isGeneTree = true;
        }
        JLabel annSelectionLabel = this.isGeneTree ? new JLabel("Select a Gene Label:") : new JLabel("Select a Sample Label:");
        this.annBox = new JComboBox<String>(annotationKeys);
        this.annBox.setSelectedIndex(0);
        JLabel fileLabel = new JLabel("Output File:");
        this.fileField = new JTextField(50);
        this.fileField.setMargin(new Insets(0, 3, 0, 3));
        this.fileField.setHorizontalAlignment(11);
        this.fileField.setText(TMEV.getFile((String)"data").getAbsolutePath() + System.getProperty("file.separator") + "newick_output.txt");
        JButton browseButton = new JButton("Select Output File");
        browseButton.setActionCommand("browse-command");
        browseButton.setFocusPainted(false);
        ParameterPanel panel = new ParameterPanel("Output Parameters");
        panel.setLayout(new GridBagLayout());
        panel.add((Component)annSelectionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 20, 5, 0), 0, 0));
        panel.add((Component)this.annBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 30, 0), 0, 0));
        panel.add((Component)fileLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 5, 0), 0, 0));
        panel.add((Component)this.fileField, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 20, 20, 0), 0, 0));
        panel.add((Component)browseButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 20, 20), 0, 0));
        this.addContent(panel);
        Listener listener = new Listener();
        browseButton.addActionListener(listener);
        this.setActionListeners(listener);
        this.setSize(470, 300);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private boolean validateOutputFile() {
        File outFile = new File(this.fileField.getText());
        File parent = outFile.getParentFile();
        return parent.exists() && parent.isDirectory();
    }

    private void resetControls() {
        this.annBox.setSelectedIndex(0);
        this.fileField.setText(TMEV.getFile((String)"data").getAbsolutePath() + System.getProperty("file.separator") + "newick_output.txt");
    }

    public File getOutputFile() {
        return new File(this.fileField.getText());
    }

    public String getAnnotationKey() {
        return (String)this.annBox.getSelectedItem();
    }

    public static void main(String[] args) {
        String[] names = new String[]{"TC", "GenBank", "Putative Role (Guess)"};
        NewickFileOutputDialog d = new NewickFileOutputDialog(new Frame(), names, 0);
        d.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                if (!NewickFileOutputDialog.this.validateOutputFile()) {
                    JOptionPane.showMessageDialog(NewickFileOutputDialog.this, "The directory specified for file output does not exist.<BR>Please select again.", "Newick Output File Error", 2);
                    return;
                }
                NewickFileOutputDialog.this.result = 0;
                NewickFileOutputDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                NewickFileOutputDialog.this.result = 2;
                NewickFileOutputDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    NewickFileOutputDialog.this.resetControls();
                    NewickFileOutputDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(NewickFileOutputDialog.this, "Newick File Output Dialog");
                } else if (command.equals("browse-command")) {
                    JFileChooser chooser = new JFileChooser(TMEV.getFile((String)"data"));
                    chooser.setFileSelectionMode(0);
                    if (chooser.showSaveDialog(NewickFileOutputDialog.this) == 0) {
                        NewickFileOutputDialog.this.fileField.setText(chooser.getSelectedFile().getAbsolutePath());
                        NewickFileOutputDialog.this.validate();
                    }
                    return;
                }
            }
            NewickFileOutputDialog.this.dispose();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            NewickFileOutputDialog.this.result = -1;
            NewickFileOutputDialog.this.dispose();
        }
    }
}

