/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tease;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.tease.HCLTreeData;

public class HCLNodeHeightGraph
extends JPanel
implements IViewer {
    GraphViewer viewer;
    HCLTreeData treeData;
    float minX;
    float maxX;
    float minY;
    float maxY;
    boolean firstView = true;
    DecimalFormat format;

    public HCLNodeHeightGraph(HCLTreeData data, boolean gene) {
        this.treeData = data;
        this.initializeViewer();
    }

    public HCLNodeHeightGraph(HCLTreeData data) {
        this(data, false);
    }

    public HCLNodeHeightGraph() {
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.treeData});
    }

    private void initializeViewer() {
        this.minX = this.findMinDistance();
        this.maxX = this.findMaxDistance();
        this.minY = 0.0f;
        this.maxY = this.treeData.node_order.length;
        this.viewer = new GraphViewer(null, (int)this.minX, (int)this.maxX, (int)this.minY, (int)this.maxY, (double)this.minX, (double)this.maxX, (double)this.minY, (double)this.maxY, 50, 50, 50, 50, "Node Heights", "Distance", "Number of Terminal Nodes");
        this.viewer.setYAxisValue((double)this.minX);
        this.viewer.setXAxisValue((double)this.minY);
        this.viewer.setShowCoordinates(true);
        this.enterGraphData();
    }

    private float findMinDistance() {
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.treeData.height.length; ++i) {
            min = Math.min(min, this.treeData.height[i]);
        }
        return min;
    }

    private float findMaxDistance() {
        float max = Float.MIN_VALUE;
        for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            max = Math.max(max, this.treeData.height[this.treeData.node_order[i]]);
        }
        return max;
    }

    private void enterGraphData() {
        int i;
        int[] nodeOrder = this.treeData.node_order;
        float[] height = this.treeData.height;
        double nodeHeight = 0.0;
        double terminalNodes = nodeOrder.length;
        int numberOfNodes = (int)terminalNodes;
        if (nodeOrder.length > 1) {
            this.viewer.addGraphElement((GraphElement)new GraphLine((double)this.minX, terminalNodes, (double)height[nodeOrder[0]], terminalNodes, Color.black));
            this.viewer.addGraphElement((GraphElement)new GraphLine((double)height[nodeOrder[0]], terminalNodes, (double)height[nodeOrder[0]], terminalNodes - 1.0, Color.blue));
        }
        for (i = 0; i < nodeOrder.length; ++i) {
            if (nodeOrder[i] <= -1) continue;
            nodeHeight = height[nodeOrder[i]];
            this.viewer.addGraphElement((GraphElement)new GraphPoint(nodeHeight, terminalNodes -= 1.0, Color.blue, 2));
            if (i + 1 >= nodeOrder.length || nodeOrder[i + 1] <= -1) continue;
            this.viewer.addGraphElement((GraphElement)new GraphLine(nodeHeight, terminalNodes, (double)height[nodeOrder[i + 1]], terminalNodes, Color.black));
            this.viewer.addGraphElement((GraphElement)new GraphLine((double)height[nodeOrder[i + 1]], terminalNodes, (double)height[nodeOrder[i + 1]], terminalNodes - 1.0, Color.blue));
        }
        this.format = new DecimalFormat();
        this.format.setMaximumFractionDigits(2);
        for (i = 0; i < 10; ++i) {
            if (this.minX >= 0.0f) {
                this.viewer.addGraphElement((GraphElement)new GraphTick((double)((this.maxX - this.minX) / 10.0f * (float)i), 5, Color.black, 0, 0, String.valueOf(this.format.format((this.maxX - this.minX) / 10.0f * (float)i)), Color.black));
            } else {
                this.viewer.addGraphElement((GraphElement)new GraphTick((double)(this.minX + (this.maxX - this.minX) / 10.0f * (float)i), 5, Color.black, 0, 0, String.valueOf(this.format.format(this.minX + (this.maxX - this.minX) / 10.0f * (float)i)), Color.black));
            }
            this.viewer.addGraphElement((GraphElement)new GraphTick((double)(nodeOrder.length / 10 * i), 5, Color.black, 1, 0, String.valueOf(nodeOrder.length / 10 * i), Color.black));
        }
    }

    public void onDeselected() {
    }

    public void onDataChanged(IData data) {
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this.viewer;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework framework) {
        if (this.firstView && this.viewer.isVisible()) {
            Graphics g = this.viewer.getGraphics();
            FontMetrics metrics = g.getFontMetrics(new Font("SansSerif", 1, 10));
            int preX = metrics.stringWidth(String.valueOf(this.format.format(this.maxX)));
            int preY = metrics.stringWidth(String.valueOf(this.format.format(this.maxY)));
            metrics = g.getFontMetrics(new Font("SansSerif", 1, 12));
            this.viewer.setPreXSpacing((preY += metrics.getHeight()) + 10);
            this.viewer.setPostYSpacing((preX += metrics.getHeight()) + 20);
            this.firstView = false;
        }
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public void setViewer(GraphViewer val) {
        this.viewer = val;
    }

    public GraphViewer getViewer() {
        return this.viewer;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperimentID(int id) {
    }

    public int getViewerType() {
        return -1;
    }
}

