/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMGUI;

public class SVMTrain_ClassifierSelectDialog
extends JDialog {
    int result = 2;
    private JRadioButton trainOnlyButton;
    private JPanel jPanel4;
    private JRadioButton trainAndClassifyButton;
    private JButton continueButton;
    private JPanel jPanel3;
    private JCheckBox calcHCLCheckBox;
    private ButtonGroup processSelection;
    private JPanel jPanel2;
    private JRadioButton runExperiments;
    private JRadioButton classifyOnlyButton;
    private ButtonGroup sampleSelection;
    private JButton cancelButton;
    private JRadioButton runGenes;
    private JPanel jPanel1;

    public SVMTrain_ClassifierSelectDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Listener listener = new Listener();
        this.continueButton.addActionListener(listener);
        this.continueButton.setActionCommand("ok-command");
        this.cancelButton.addActionListener(listener);
        this.cancelButton.setActionCommand("cancel-command");
    }

    private void initComponents() {
        this.sampleSelection = new ButtonGroup();
        this.processSelection = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.runGenes = new JRadioButton();
        this.runExperiments = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.trainAndClassifyButton = new JRadioButton();
        this.trainOnlyButton = new JRadioButton();
        this.classifyOnlyButton = new JRadioButton();
        this.jPanel4 = new JPanel();
        this.continueButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel3 = new JPanel();
        this.calcHCLCheckBox = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("SVM Sample and Process Selection");
        this.setBackground(Color.lightGray);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SVMTrain_ClassifierSelectDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setBorder(new TitledBorder(new EtchedBorder(0), "Evaluation Selection", 0, 0, new Font("Dialog", 1, 14)));
        this.runGenes.setBackground(Color.white);
        this.runGenes.setSelected(true);
        this.runGenes.setText("Classify Genes");
        this.runGenes.setToolTipText("");
        this.sampleSelection.add(this.runGenes);
        this.runGenes.setFocusPainted(false);
        this.jPanel1.add(this.runGenes);
        this.runExperiments.setBackground(Color.white);
        this.runExperiments.setText("Classify Experiments");
        this.sampleSelection.add(this.runExperiments);
        this.runExperiments.setFocusPainted(false);
        this.jPanel1.add(this.runExperiments);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBackground(Color.white);
        this.jPanel2.setBorder(new TitledBorder(new EtchedBorder(0), "SVM Process Selection", 0, 0, new Font("Dialog", 1, 14)));
        this.trainAndClassifyButton.setBackground(Color.white);
        this.trainAndClassifyButton.setSelected(true);
        this.trainAndClassifyButton.setText("Train SVM then Classify");
        this.trainAndClassifyButton.setToolTipText("Train SMV then immediately classify");
        this.processSelection.add(this.trainAndClassifyButton);
        this.trainAndClassifyButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.jPanel2.add((Component)this.trainAndClassifyButton, gridBagConstraints);
        this.trainOnlyButton.setBackground(Color.white);
        this.trainOnlyButton.setText("Train SVM (skip classify)");
        this.trainOnlyButton.setToolTipText("Train SVM only... output are result SVM weights");
        this.processSelection.add(this.trainOnlyButton);
        this.trainOnlyButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.jPanel2.add((Component)this.trainOnlyButton, gridBagConstraints);
        this.classifyOnlyButton.setBackground(Color.white);
        this.classifyOnlyButton.setText("Classify using existing SVM file");
        this.classifyOnlyButton.setToolTipText("Trains current data using and SVM file of weights");
        this.processSelection.add(this.classifyOnlyButton);
        this.classifyOnlyButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.jPanel2.add((Component)this.classifyOnlyButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.continueButton.setText("Continue");
        this.jPanel4.add(this.continueButton);
        this.cancelButton.setText("Cancel");
        this.jPanel4.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel3.setBackground(Color.white);
        this.jPanel3.setBorder(new TitledBorder(new EtchedBorder(), "Hierarchical Clustering", 0, 0, new Font("Dialog", 1, 14)));
        this.jPanel3.setMinimumSize(new Dimension(310, 55));
        this.jPanel3.setPreferredSize(new Dimension(310, 55));
        this.calcHCLCheckBox.setBackground(Color.white);
        this.calcHCLCheckBox.setText("Calculate Hierarchical Clustering on SVM Results");
        this.calcHCLCheckBox.setBorder(new CompoundBorder());
        this.calcHCLCheckBox.setFocusPainted(false);
        this.jPanel3.add(this.calcHCLCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isEvaluateGenesSelected() {
        return this.runGenes.isSelected();
    }

    public int getSVMProcessSelection() {
        if (this.trainAndClassifyButton.isSelected()) {
            return SVMGUI.TRAIN_AND_CLASSIFY;
        }
        if (this.trainOnlyButton.isSelected()) {
            return SVMGUI.TRAIN_ONLY;
        }
        return SVMGUI.CLASSIFY_ONLY;
    }

    public boolean getHCLSelection() {
        return this.calcHCLCheckBox.isSelected();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public static void main(String[] args) {
        new SVMTrain_ClassifierSelectDialog((Frame)new JFrame(), true).show();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    SVMTrain_ClassifierSelectDialog.this.result = 0;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    SVMTrain_ClassifierSelectDialog.this.result = 2;
                }
                SVMTrain_ClassifierSelectDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                SVMTrain_ClassifierSelectDialog.this.result = 2;
                SVMTrain_ClassifierSelectDialog.this.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SVMTrain_ClassifierSelectDialog.this.result = -1;
            SVMTrain_ClassifierSelectDialog.this.dispose();
        }
    }
}

