/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.Expression;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.svm.GeneralInfo;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMData;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMFileFilter;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMFileView;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMResultViewer;

public class SVMTrainViewer
extends SVMResultViewer {
    private float[] weights;
    private Experiment experiment;
    private SVMData data;
    private GeneralInfo info;
    private boolean classifyGenes;
    TrainViewerTableModel cvtm;
    DecimalFormat floatFormat;

    public SVMTrainViewer(Experiment expt, float[] weights, boolean classifyGenes, SVMData data) {
        super(expt);
        this.init(weights, classifyGenes, data);
    }

    public SVMTrainViewer(Experiment experiment, float[] weights, Boolean classifyGenes, SVMData data) {
        this(experiment, weights, (boolean)classifyGenes, data);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{super.getExpression().getArguments()[0], this.weights, new Boolean(this.classifyGenes), this.data});
    }

    private void init(float[] weights, boolean classifyGenes, SVMData data) {
        this.weights = weights;
        this.classifyGenes = classifyGenes;
        this.data = data;
        this.floatFormat = new DecimalFormat();
        this.floatFormat.setMaximumFractionDigits(4);
        this.floatFormat.setMinimumFractionDigits(4);
        this.floatFormat.setGroupingUsed(false);
        this.setBackground(Color.white);
        this.cvtm = new TrainViewerTableModel();
        this.resultTable = new JTable(this.cvtm);
        this.add((Component)new JScrollPane(this.resultTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        SVMResultViewer.MyListener listener = new SVMResultViewer.MyListener();
        this.resultTable.addMouseListener(listener);
        this.resultTable.addMouseMotionListener(listener);
    }

    @Override
    public void setExperiment(Experiment e) {
        super.setExperiment(e);
        this.experiment = e;
    }

    @Override
    public void onSelected(IFramework frm) {
        super.onSelected(frm);
        this.onMenuChanged(frm.getDisplayMenu());
    }

    @Override
    protected void displayData() {
        if (this.weights == null) {
            return;
        }
        this.displayResult(this.classifyGenes);
    }

    private void displayResult(boolean genes) {
    }

    @Override
    protected void onSaveResult() {
        JFileChooser fc = new JFileChooser(TMEV.getFile((String)"data/"));
        fc.addChoosableFileFilter(new SVMFileFilter());
        fc.setFileView(new SVMFileView());
        int returnVal = fc.showSaveDialog(JOptionPane.getFrameForComponent(this));
        if (returnVal != 0) {
            return;
        }
        File SVMFile = fc.getSelectedFile();
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(SVMFile)));
            if (this.data.classificationFile != null) {
                out.write("Classification file: " + this.data.classificationFile.getPath() + "\n");
            } else {
                out.write("Classification file: None (SVM classification editor was used)\n");
            }
            out.write("Constant : " + Float.toString(this.data.constant) + "\n");
            out.write("Coefficient : " + Float.toString(this.data.coefficient) + "\n");
            out.write("Power : " + Float.toString(this.data.power) + "\n");
            out.write("Diagonal factor : " + Float.toString(this.data.diagonalFactor) + "\n");
            out.write("Convergence threshold : " + Float.toString(this.data.convergenceThreshold) + "\n");
            out.write("Radial : " + this.data.radial + "\n");
            out.write("Width factor : " + Float.toString(this.data.widthFactor) + "\n");
            out.write("Use Constraint : " + this.data.constrainWeights + "\n");
            out.write("Positive Constraint : " + Float.toString(this.data.positiveConstraint) + "\n");
            out.write("Negative Constraint : " + Float.toString(this.data.negativeConstraint) + "\n");
            out.write("Seed : " + Float.toString(this.data.seed) + "\n");
            out.write("Objective : " + Float.toString(this.data.objective1) + "\n\n");
            out.write("Weights\tGB#\n");
            for (int row = 0; row < this.cvtm.getRowCount(); ++row) {
                for (int col = 1; col < this.cvtm.getColumnCount(); ++col) {
                    out.write(this.cvtm.getValueAt(row, col).toString() + '\t');
                }
                out.write(10);
            }
            out.flush();
            out.close();
            out = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error writing to file " + SVMFile.getPath() + "!", "Error", 0);
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    @Override
    protected Dimension updateSize() {
        FontMetrics fm = this.getFontMetrics(new Font("monospaced", 0, 14));
        int len = 0;
        return new Dimension(len + 10, this.getHeight());
    }

    class TrainViewerTableModel
    extends AbstractTableModel {
        String[] header;

        public TrainViewerTableModel() {
            this.header = new String[]{"Index", "Weight", SVMTrainViewer.this.annotationLabel};
        }

        @Override
        public String getColumnName(int col) {
            return this.header[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return new Integer(row + 1);
            }
            if (col == 1) {
                return SVMTrainViewer.this.floatFormat.format(SVMTrainViewer.this.weights[row]).toString();
            }
            if (col == 2) {
                try {
                    if (SVMTrainViewer.this.classifyGenes) {
                        new Integer(SVMTrainViewer.this.labelIndex);
                        SVMTrainViewer.this.getMultipleArrayDataRow(row);
                        SVMTrainViewer.this.iData.toString();
                        return SVMTrainViewer.this.iData.getElementAttribute(SVMTrainViewer.this.getMultipleArrayDataRow(row), SVMTrainViewer.this.labelIndex);
                    }
                    return SVMTrainViewer.this.iData.getFullSampleName(row);
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                    return "";
                }
            }
            return new String("");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.header.length;
        }

        @Override
        public int getRowCount() {
            return SVMTrainViewer.this.weights.length;
        }
    }
}

