/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

abstract class SVMResultViewer
extends JPanel
implements IViewer {
    private JPopupMenu MyPopup;
    private JMenuItem menuItem1;
    protected int labelIndex;
    protected IFramework framework;
    protected IData iData;
    private Experiment experiment;
    protected String[] fieldNames;
    protected String annotationLabel = "";
    private int exptID = 0;
    JTable resultTable;
    JScrollPane jsp;

    public SVMResultViewer(Experiment e) {
        this.experiment = e;
        this.exptID = this.experiment.getId();
        this.setAutoscrolls(true);
        this.setLayout(new GridBagLayout());
        this.resultTable = new JTable();
        this.resultTable.setPreferredScrollableViewportSize(new Dimension(700, 500));
        this.resultTable.setAutoResizeMode(3);
        this.resultTable.setFont(new Font("monospaced", 0, 12));
        this.MyPopup = new JPopupMenu();
        this.menuItem1 = new JMenuItem("Save classification...", GUIFactory.getIcon("save_as16.gif"));
        this.menuItem1.setActionCommand("save-result-command");
        this.menuItem1.addActionListener(new Listener());
        MyListener listener = new MyListener();
        this.resultTable.addMouseListener(listener);
        this.resultTable.addMouseMotionListener(listener);
        this.MyPopup.add(this.menuItem1);
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment});
    }

    public void setExperimentID(int i) {
        this.exptID = i;
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void onSelected(IFramework frm) {
        this.framework = frm;
        this.iData = frm.getData();
        this.annotationLabel = this.framework.getData().getFieldNames()[this.framework.getDisplayMenu().getLabelIndex()];
    }

    protected abstract void displayData();

    protected abstract void onSaveResult();

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onDataChanged(IData data) {
    }

    public void onMenuChanged(IDisplayMenu menu) {
        try {
            this.annotationLabel = this.framework.getData().getFieldNames()[this.framework.getDisplayMenu().getLabelIndex()];
            this.labelIndex = this.framework.getDisplayMenu().getLabelIndex();
        }
        catch (NullPointerException npe) {
            this.labelIndex = 0;
            this.annotationLabel = "";
        }
        this.displayData();
        this.updateSize();
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    protected abstract Dimension updateSize();

    protected int getMultipleArrayDataRow(int row) {
        return this.experiment.getGeneIndexMappedToData(row);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public int getViewerType() {
        return -1;
    }

    class Listener
    implements ActionListener {
        Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton source = (AbstractButton)e.getSource();
            if (source.getActionCommand().equals("save-result-command")) {
                SVMResultViewer.this.onSaveResult();
            }
        }
    }

    class MyListener
    extends MouseInputAdapter {
        MyListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SVMResultViewer.this.MyPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

