/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.Expression;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.AbstractTableModel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMResultViewer;
import org.tigr.util.FloatMatrix;

public class SVMOneOutViewer
extends SVMResultViewer {
    private FloatMatrix discriminant;
    private boolean classifyGenes;
    float[] classes;
    float[] discr;
    int[] initClasses;
    float[] classMatch;
    int[] elementScores;
    int[] iterationScores;
    int nonNeuts;
    DecimalFormat floatFormat;
    DecimalFormat intFormat;
    DecimalFormat indexFormat;
    OneOutViewerTableModel ovtm;

    public SVMOneOutViewer(Experiment experiment, FloatMatrix discriminant, boolean classifyGenes, int[] initClasses, int[] elementScores, int[] iterationScores, int nonNeuts) {
        super(experiment);
        this.discriminant = discriminant;
        FloatMatrix M = discriminant.transpose();
        this.init(M.A[0], M.A[1], classifyGenes, initClasses, elementScores, iterationScores, nonNeuts);
    }

    public SVMOneOutViewer(Experiment experiment, FloatMatrix discriminant, Boolean classifyGenes, int[] initClasses, int[] elementScores, int[] iterationScores, Integer nonNeuts) {
        this(experiment, discriminant, (boolean)classifyGenes, initClasses, elementScores, iterationScores, (int)nonNeuts);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{super.getExpression().getArguments()[0], this.discriminant, new Boolean(this.classifyGenes), this.initClasses, this.elementScores, this.iterationScores, new Integer(this.nonNeuts)});
    }

    private void init(float[] classes, float[] discr, boolean classifyGenes, int[] initClasses, int[] elementScores, int[] iterationScores, int nonNeuts) {
        this.classes = classes;
        this.discr = discr;
        this.classifyGenes = classifyGenes;
        this.initClasses = initClasses;
        this.elementScores = elementScores;
        this.iterationScores = iterationScores;
        this.nonNeuts = nonNeuts;
        this.floatFormat = new DecimalFormat();
        this.floatFormat.setMaximumFractionDigits(4);
        this.floatFormat.setMinimumFractionDigits(4);
        this.floatFormat.setGroupingUsed(false);
        this.intFormat = new DecimalFormat();
        this.intFormat.setMinimumFractionDigits(0);
        this.intFormat.setMaximumFractionDigits(0);
        this.intFormat.setGroupingUsed(false);
        this.indexFormat = new DecimalFormat();
        this.indexFormat = new DecimalFormat();
        this.indexFormat.setMinimumFractionDigits(0);
        this.indexFormat.setMaximumFractionDigits(0);
        this.ovtm = new OneOutViewerTableModel();
        this.resultTable = new JTable(this.ovtm);
        this.add((Component)new JScrollPane(this.resultTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        SVMResultViewer.MyListener listener = new SVMResultViewer.MyListener(this);
        this.resultTable.addMouseListener(listener);
        this.resultTable.addMouseMotionListener(listener);
    }

    @Override
    public void onSelected(IFramework frm) {
        super.onSelected(frm);
        this.framework = frm;
        this.onMenuChanged(frm.getDisplayMenu());
    }

    @Override
    protected void displayData() {
        this.displayResult(this.classifyGenes);
    }

    private void displayResult(boolean genes) {
    }

    @Override
    protected void onSaveResult() {
        JFileChooser fc = new JFileChooser(TMEV.getFile((String)"data/"));
        fc.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        fc.setFileView((FileView)new ExpressionFileView());
        int returnVal = fc.showSaveDialog(JOptionPane.getFrameForComponent(this));
        if (returnVal != 0) {
            return;
        }
        File SVMFile = fc.getSelectedFile();
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(SVMFile)));
            for (int row = 0; row < this.ovtm.getRowCount(); ++row) {
                for (int col = 0; col < this.ovtm.getColumnCount(); ++col) {
                    out.write(this.ovtm.getValueAt(row, col).toString() + '\t');
                }
                out.write(10);
            }
            out.flush();
            out.close();
            out = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error writing to file " + SVMFile.getPath() + "!", "Error", 0);
        }
    }

    @Override
    protected Dimension updateSize() {
        return new Dimension(120, this.getHeight());
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public boolean isClassifyGenes() {
        return this.classifyGenes;
    }

    public float[] getDiscr() {
        return this.discr;
    }

    public int getNonNeuts() {
        return this.nonNeuts;
    }

    public int[] getElementScores() {
        return this.elementScores;
    }

    public int[] getIterationScores() {
        return this.iterationScores;
    }

    public int[] getInitClasses() {
        return this.initClasses;
    }

    public float[] getClasses() {
        return this.classes;
    }

    class OneOutViewerTableModel
    extends AbstractTableModel {
        String[] header;

        public OneOutViewerTableModel() {
            this.header = new String[]{"Index", "Init", "Class", "Discriminant", "Element Score", "%", "Iteration Score", "%", SVMOneOutViewer.this.annotationLabel};
        }

        @Override
        public String getColumnName(int col) {
            return this.header[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return SVMOneOutViewer.this.indexFormat.format(row + 1);
            }
            if (col == 1) {
                if ((float)SVMOneOutViewer.this.initClasses[row] == -1.0f) {
                    return "none";
                }
                return SVMOneOutViewer.this.intFormat.format(SVMOneOutViewer.this.initClasses[row]);
            }
            if (col == 2) {
                if (SVMOneOutViewer.this.classes[row] == -1.0f) {
                    return "none";
                }
                return SVMOneOutViewer.this.intFormat.format(SVMOneOutViewer.this.classes[row]).toString();
            }
            if (col == 3) {
                return SVMOneOutViewer.this.floatFormat.format(SVMOneOutViewer.this.discr[row]);
            }
            if (col == 4) {
                return (SVMOneOutViewer.this.intFormat.format(SVMOneOutViewer.this.elementScores[row]) + "/" + SVMOneOutViewer.this.intFormat.format(SVMOneOutViewer.this.elementScores.length)).toString();
            }
            if (col == 5) {
                return SVMOneOutViewer.this.intFormat.format(SVMOneOutViewer.this.elementScores[row] / SVMOneOutViewer.this.elementScores.length * 100);
            }
            if (col == 6) {
                return (SVMOneOutViewer.this.intFormat.format(SVMOneOutViewer.this.iterationScores[row]) + "/" + SVMOneOutViewer.this.intFormat.format(SVMOneOutViewer.this.iterationScores.length)).toString();
            }
            if (col == 7) {
                return SVMOneOutViewer.this.intFormat.format(SVMOneOutViewer.this.iterationScores[row] / SVMOneOutViewer.this.iterationScores.length * 100);
            }
            if (col == 8) {
                try {
                    if (SVMOneOutViewer.this.classifyGenes) {
                        return SVMOneOutViewer.this.iData.getElementAttribute(SVMOneOutViewer.this.getMultipleArrayDataRow(row), SVMOneOutViewer.this.labelIndex);
                    }
                    return SVMOneOutViewer.this.iData.getSampleName(row);
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                    return "";
                }
            }
            return new String("");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.header.length;
        }

        @Override
        public int getRowCount() {
            return SVMOneOutViewer.this.classes.length;
        }
    }
}

