/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.svm.ClassificationFileFilter;
import org.tigr.microarray.mev.cluster.gui.impl.svm.ClassificationFileView;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMData;

public class SVMInitDialog
extends AlgorithmDialog {
    public JPanel panel1 = new JPanel();
    public JPanel panel3 = new JPanel();
    public JPanel panel4 = new JPanel();
    public JPanel Parameters1 = new JPanel();
    public JPanel Parameters2 = new JPanel();
    public JPanel Parameters3 = new JPanel();
    public JPanel ClassFilePanel = new JPanel();
    public JPanel insetsPanel = new JPanel();
    public JLabel label1 = new JLabel();
    public JLabel label2 = new JLabel();
    public JLabel chooseFileLabel;
    public JTextField textField1;
    public JTextField textField2;
    public JTextField textField3;
    public JTextField textField4;
    public JTextField textField5;
    public JTextField textField6;
    public JTextField textField7;
    public JTextField textField8;
    public JTextField textField9;
    public JComboBox List1;
    public JComboBox List2;
    public JComboBox List3;
    public BorderLayout borderLayout1 = new BorderLayout();
    public BorderLayout borderLayout2 = new BorderLayout();
    public BorderLayout borderLayout3 = new BorderLayout();
    public BorderLayout borderLayout4 = new BorderLayout();
    public BorderLayout borderLayout5 = new BorderLayout();
    public BorderLayout borderLayout6 = new BorderLayout();
    public GridLayout gridLayout = new GridLayout();
    private JButton ChooseFileButton;
    public JCheckBox editorCheckBox;
    public JCheckBox CheckBox1;
    public JCheckBox CheckBox2;
    public JCheckBox CheckBox3;
    private JLabel Label1;
    private JLabel Label2;
    private JLabel Label3;
    private int result;
    private SVMData origData;
    private SVMData resultData;

    public SVMInitDialog(Frame MyParent, SVMData data) {
        super(MyParent, "SVM Initialization", true);
        this.origData = new SVMData(data);
        this.resultData = data;
        this.enableEvents(64L);
        this.setResizable(false);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.panel1.setLayout(this.borderLayout1);
        this.panel3.setLayout(this.borderLayout3);
        this.panel4.setLayout(this.borderLayout4);
        this.insetsPanel.setLayout(this.gridLayout);
        this.panel3.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.Parameters1.setBorder(new TitledBorder(new EtchedBorder(), "Classification Input", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.Parameters1.setName("Classification Input");
        this.Parameters1.setBackground(Color.white);
        this.Parameters1.setForeground(Color.black);
        this.Parameters1.setLayout(new GridBagLayout());
        this.borderLayout5.setHgap(10);
        this.borderLayout6.setHgap(10);
        this.editorCheckBox = new JCheckBox("Use SVM Classification Editor", true);
        this.editorCheckBox.setBackground(Color.white);
        this.editorCheckBox.setForeground(UIManager.getColor("Label.foreground"));
        this.editorCheckBox.setFocusPainted(false);
        this.editorCheckBox.setActionCommand("use-editor-command");
        this.Parameters1.add((Component)this.editorCheckBox, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.chooseFileLabel = new JLabel("Use Classification File:");
        this.Parameters1.add((Component)this.chooseFileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.ChooseFileButton = new JButton("Choose");
        this.ChooseFileButton.setActionCommand("choose-file-command");
        this.ChooseFileButton.addActionListener(listener);
        this.ChooseFileButton.setFocusPainted(false);
        this.Parameters1.add((Component)this.ChooseFileButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.textField1 = new JTextField();
        this.textField1.setActionCommand("choose-file-command");
        this.textField1.addActionListener(listener);
        this.Parameters1.add((Component)this.textField1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.disableFileSelection();
        this.editorCheckBox.addActionListener(listener);
        this.Parameters2.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 10));
        this.Parameters2.setName("Training Parameters");
        this.Parameters2.setBackground(Color.white);
        this.Parameters2.setForeground(Color.black);
        this.Parameters2.setLayout(new GridLayout(0, 2, 10, 10));
        this.Parameters2.add(new JLabel("Constant"));
        this.textField2 = new JTextField(Float.toString(data.constant), 7);
        this.Parameters2.add(this.textField2);
        this.Parameters2.add(new JLabel("Coefficient  "));
        this.textField3 = new JTextField(Float.toString(data.coefficient), 7);
        this.Parameters2.add(this.textField3);
        this.Parameters2.add(new JLabel("Power  "));
        this.textField4 = new JTextField(Float.toString(data.power), 7);
        this.Parameters2.add(this.textField4);
        this.Parameters2.add(new JLabel("Diag. factor"));
        this.textField8 = new JTextField(Float.toString(data.diagonalFactor), 7);
        this.Parameters2.add(this.textField8);
        this.Parameters2.add(new JLabel("Threshold"));
        this.textField9 = new JTextField(Float.toString(data.convergenceThreshold), 7);
        this.Parameters2.add(this.textField9);
        this.Parameters3.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 20));
        this.Parameters3.setBackground(Color.white);
        this.Parameters3.setForeground(Color.black);
        this.Parameters3.setLayout(new GridLayout(0, 2, 10, 10));
        CheckBoxListener MyListener2 = new CheckBoxListener();
        this.CheckBox1 = new JCheckBox("Radial");
        if (data.radial) {
            this.CheckBox1.setSelected(true);
        } else {
            this.CheckBox1.setSelected(false);
        }
        this.CheckBox1.setFocusPainted(false);
        this.CheckBox1.setBackground(Color.white);
        this.CheckBox1.setForeground(UIManager.getColor("Label.foreground"));
        this.CheckBox1.addItemListener(MyListener2);
        this.Parameters3.add(this.CheckBox1);
        this.CheckBox2 = new JCheckBox("Normalize");
        if (data.normalize) {
            this.CheckBox2.setSelected(true);
        } else {
            this.CheckBox2.setSelected(false);
        }
        this.CheckBox2.setFocusPainted(false);
        this.CheckBox2.setBackground(Color.white);
        this.CheckBox2.setForeground(UIManager.getColor("Label.foreground"));
        this.CheckBox2.addItemListener(MyListener2);
        this.CheckBox2.setVisible(false);
        this.CheckBox2.setEnabled(false);
        this.Parameters3.add(this.CheckBox2);
        this.Label1 = new JLabel("Width factor");
        this.textField5 = new JTextField(Float.toString(data.widthFactor), 7);
        if (data.radial) {
            this.Label1.setEnabled(true);
            this.textField5.setEnabled(true);
        } else {
            this.Label1.setEnabled(false);
            this.textField5.setEnabled(false);
        }
        this.Parameters3.add(this.Label1);
        this.Parameters3.add(this.textField5);
        this.CheckBox3 = new JCheckBox("Constraints");
        if (data.constrainWeights) {
            this.CheckBox3.setSelected(true);
        } else {
            this.CheckBox3.setSelected(false);
        }
        this.CheckBox3.setFocusPainted(false);
        this.CheckBox3.setBackground(Color.white);
        this.CheckBox3.setForeground(Color.black);
        this.CheckBox3.addItemListener(MyListener2);
        this.Parameters3.add(this.CheckBox3);
        this.Parameters3.add(new JLabel(""));
        this.Label2 = new JLabel("Pos. constraint");
        this.Label2.setEnabled(false);
        this.textField6 = new JTextField(Float.toString(1.0f), 7);
        this.textField6.setEnabled(false);
        this.Label3 = new JLabel("Neg. constraint");
        this.Label3.setEnabled(false);
        this.Parameters3.add(this.Label3);
        this.textField7 = new JTextField(Float.toString(1.0f), 7);
        this.textField7.setEnabled(false);
        if (data.constrainWeights) {
            this.Label2.setEnabled(true);
            this.Label3.setEnabled(true);
            this.textField6.setEnabled(true);
            this.textField7.setEnabled(true);
        } else {
            this.Label2.setEnabled(false);
            this.Label3.setEnabled(false);
            this.textField6.setEnabled(false);
            this.textField7.setEnabled(false);
        }
        this.Parameters3.add(this.Label2);
        this.Parameters3.add(this.textField6);
        this.Parameters3.add(this.Label3);
        this.Parameters3.add(this.textField7);
        this.gridLayout.setRows(2);
        this.gridLayout.setColumns(1);
        this.panel1.add((Component)this.panel3, "North");
        this.panel3.add((Component)this.panel4, "Center");
        this.panel4.add((Component)this.Parameters1, "North");
        JPanel trainingPanel = new JPanel();
        trainingPanel.setBorder(new TitledBorder(new EtchedBorder(), "Training Parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
        trainingPanel.setBackground(Color.white);
        trainingPanel.setLayout(new BorderLayout());
        trainingPanel.add((Component)this.Parameters2, "West");
        trainingPanel.add((Component)this.Parameters3, "Center");
        this.panel4.add((Component)trainingPanel, "South");
        this.addContent(this.panel1);
        this.setActionListeners(listener);
        this.pack();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(e);
    }

    protected void onChooseFile() {
        JFileChooser fc = new JFileChooser(TMEV.getFile((String)"data/"));
        fc.setCurrentDirectory(new File("Data"));
        fc.addChoosableFileFilter(new ClassificationFileFilter());
        fc.setFileView(new ClassificationFileView());
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            this.resultData.classificationFile = fc.getSelectedFile();
            this.textField1.setText(this.resultData.classificationFile.getName());
        }
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public SVMData getData() {
        return this.resultData;
    }

    private void disableFileSelection() {
        this.chooseFileLabel.setEnabled(false);
        this.textField1.setEnabled(false);
        this.ChooseFileButton.setEnabled(false);
    }

    private void enableFileSelection() {
        this.chooseFileLabel.setEnabled(true);
        this.textField1.setEnabled(true);
        this.ChooseFileButton.setEnabled(true);
    }

    protected boolean parseData() {
        try {
            this.resultData.constant = Float.parseFloat(this.textField2.getText());
            this.resultData.coefficient = Float.parseFloat(this.textField3.getText());
            this.resultData.power = Float.parseFloat(this.textField4.getText());
            this.resultData.diagonalFactor = Float.parseFloat(this.textField8.getText());
            this.resultData.convergenceThreshold = Float.parseFloat(this.textField9.getText());
            this.resultData.widthFactor = Float.parseFloat(this.textField5.getText());
            this.resultData.positiveConstraint = Float.parseFloat(this.textField6.getText());
            this.resultData.negativeConstraint = Float.parseFloat(this.textField7.getText());
            this.resultData.radial = this.CheckBox1.isSelected();
            this.resultData.normalize = false;
            this.resultData.constrainWeights = this.CheckBox3.isSelected();
            this.resultData.useEditor = this.editorCheckBox.isSelected();
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Entry format error. " + e.getMessage() + " is not valid input.  Please try again.", "Error", 0);
            return false;
        }
        return this.resultData.validate(this);
    }

    public void resetControls() {
        this.editorCheckBox.setSelected(this.origData.useEditor);
        if (!this.origData.useEditor && this.origData.classificationFile != null) {
            this.textField1.setText(this.origData.classificationFile.getPath());
        } else {
            this.textField1.setText("");
        }
        this.textField2.setText(Float.toString(this.origData.constant));
        this.textField3.setText(Float.toString(this.origData.coefficient));
        this.textField4.setText(Float.toString(this.origData.power));
        this.textField8.setText(Float.toString(this.origData.diagonalFactor));
        this.textField9.setText(Float.toString(this.origData.convergenceThreshold));
        this.textField5.setText(Float.toString(this.origData.widthFactor));
        this.textField6.setText(Float.toString(this.origData.positiveConstraint));
        this.textField7.setText(Float.toString(this.origData.negativeConstraint));
        this.CheckBox1.setSelected(this.origData.radial);
        this.CheckBox2.setSelected(false);
        this.CheckBox3.setSelected(this.origData.constrainWeights);
        this.editorCheckBox.setSelected(this.origData.useEditor);
    }

    public static void main(String[] args) {
        SVMInitDialog dialog = new SVMInitDialog(new Frame(), new SVMData());
        dialog.show();
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    if (!SVMInitDialog.this.parseData()) {
                        return;
                    }
                    SVMInitDialog.this.result = 0;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    SVMInitDialog.this.result = 2;
                }
                SVMInitDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                SVMInitDialog.this.result = 2;
                SVMInitDialog.this.dispose();
            } else if (command.equals("choose-file-command")) {
                SVMInitDialog.this.onChooseFile();
            } else if (command.equals("use-editor-command")) {
                if (SVMInitDialog.this.editorCheckBox.isSelected()) {
                    SVMInitDialog.this.disableFileSelection();
                } else {
                    SVMInitDialog.this.enableFileSelection();
                }
            } else if (command.equals("reset-command")) {
                SVMInitDialog.this.resetControls();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(SVMInitDialog.this, "SVM Training Initialization Dialog");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SVMInitDialog.this.result = -1;
            SVMInitDialog.this.dispose();
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            if (source == SVMInitDialog.this.CheckBox1) {
                if (SVMInitDialog.this.CheckBox1.isSelected()) {
                    SVMInitDialog.this.Label1.setEnabled(true);
                    SVMInitDialog.this.textField5.setEnabled(true);
                } else {
                    SVMInitDialog.this.Label1.setEnabled(false);
                    SVMInitDialog.this.textField5.setEnabled(false);
                }
            } else if (source == SVMInitDialog.this.CheckBox3) {
                if (SVMInitDialog.this.CheckBox3.isSelected()) {
                    SVMInitDialog.this.Label2.setEnabled(true);
                    SVMInitDialog.this.Label3.setEnabled(true);
                    SVMInitDialog.this.textField6.setEnabled(true);
                    SVMInitDialog.this.textField7.setEnabled(true);
                } else {
                    SVMInitDialog.this.Label2.setEnabled(false);
                    SVMInitDialog.this.Label3.setEnabled(false);
                    SVMInitDialog.this.textField6.setEnabled(false);
                    SVMInitDialog.this.textField7.setEnabled(false);
                }
            }
        }
    }
}

