/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Monitor;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.GeneralInfo;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMClassificationEditor;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMClassifyViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMData;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMDiscriminantExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMExperimentClusterCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMExperimentClusterCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMFileFilter;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMFileView;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMOneOutViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMProcessInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMTrainViewer;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class SVMGUI
implements IClusterGUI,
IScriptGUI {
    protected Frame parentFrame;
    private IFramework framework;
    protected IDistanceMenu menu;
    protected Logger logger;
    protected Monitor monitor;
    protected Listener listener;
    protected IData experiment;
    protected Algorithm algorithm;
    protected SVMData data = new SVMData();
    protected GeneralInfo info = new GeneralInfo();
    protected Experiment experimentMap;
    private File SVMFile;
    private float[] Weights;
    private FloatMatrix trainingMatrix;
    private FloatMatrix kernelMatrix;
    private int[] classes;
    public static int TRAIN_AND_CLASSIFY = 0;
    public static int TRAIN_ONLY = 1;
    public static int CLASSIFY_ONLY = 2;
    public static int ONE_OUT_VALIDATION = 3;
    private int SVMMode = 0;
    private boolean classifyGenes;
    private FloatMatrix discriminantMatrix;
    private boolean stop = false;
    private boolean scripting = false;

    protected void createAlgorithm(AlgorithmFactory factory) throws AlgorithmException {
        this.listener = new Listener();
        this.algorithm = factory.getAlgorithm("SVM");
        this.algorithm.addAlgorithmListener((AlgorithmListener)this.listener);
    }

    protected void bindParams(AlgorithmData data) {
        if (!this.scripting) {
            FloatMatrix matrix = this.experiment.getExperiment().getMatrix();
            if (!this.data.classifyGenes) {
                matrix = matrix.transpose();
            }
            data.addMatrix("experiment", matrix);
        }
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("hcl-distance-absolute", String.valueOf(this.data.absoluteDistance));
        data.addParam("hcl-distance-function", String.valueOf(this.data.distanceFunction));
        data.addParam("constant", String.valueOf(this.data.constant));
        data.addParam("coefficient", String.valueOf(this.data.coefficient));
        data.addParam("power", String.valueOf(this.data.power));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.parentFrame = framework.getFrame();
        this.experiment = framework.getData();
        this.experimentMap = this.experiment.getExperiment();
        this.menu = framework.getDistanceMenu();
        this.framework = framework;
        DefaultMutableTreeNode svmNode = null;
        try {
            this.createAlgorithm(framework.getAlgorithmFactory());
            AlgorithmData data = new AlgorithmData();
            if (!this.selectSVMProcedure()) {
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                return defaultMutableTreeNode;
            }
            if (this.SVMMode == TRAIN_AND_CLASSIFY) {
                if (!this.initTrainingParams()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = null;
                    return defaultMutableTreeNode;
                }
                this.bindTrainingParams(data);
                long start = System.currentTimeMillis();
                AlgorithmData trainingResult = this.algorithm.execute(data);
                long time = System.currentTimeMillis() - start;
                this.getTrainingResults(trainingResult);
                svmNode = this.classifyGenes ? new DefaultMutableTreeNode("SVM - genes") : new DefaultMutableTreeNode("SVM - samples");
                svmNode.add(this.createTrainingGUIResult());
                this.createAlgorithm(framework.getAlgorithmFactory());
                this.bindClassificationParams(data);
                start = System.currentTimeMillis();
                AlgorithmData classificationResult = this.algorithm.execute(data);
                this.getClassificationResults(classificationResult);
                this.info.time = time += System.currentTimeMillis() - start;
                this.info.function = this.menu.getFunctionName(this.data.distanceFunction);
                svmNode.add(this.createClassificationGUIResult());
                svmNode.add(this.createSVMExpressionViews(classificationResult, this.classes));
                if (this.data.calculateHCL) {
                    svmNode.add(this.createHierarchicalTreeViews(classificationResult.getCluster("cluster"), classificationResult));
                }
                this.createSVMCentroidViews(classificationResult, svmNode);
                this.createInfoView(classificationResult, svmNode);
                this.addSVMParameterNode(svmNode);
            } else if (this.SVMMode == TRAIN_ONLY) {
                if (!this.initTrainingParams()) {
                    DefaultMutableTreeNode start = null;
                    return start;
                }
                this.bindTrainingParams(data);
                long start = System.currentTimeMillis();
                AlgorithmData trainingResult = this.algorithm.execute(data);
                long time = System.currentTimeMillis() - start;
                this.getTrainingResults(trainingResult);
                svmNode = this.classifyGenes ? new DefaultMutableTreeNode("SVM - genes") : new DefaultMutableTreeNode("SVM - samples");
                svmNode.add(this.createTrainingGUIResult());
                this.info.time = time;
                int function = this.data.distanceFunction;
                this.info.function = this.menu.getFunctionName(function);
                this.addSVMParameterNode(svmNode);
            } else if (this.SVMMode == CLASSIFY_ONLY) {
                if (!this.initClassificationParams()) {
                    DefaultMutableTreeNode start = null;
                    return start;
                }
                this.bindClassificationParams(data);
                long start = System.currentTimeMillis();
                AlgorithmData classificationResult = this.algorithm.execute(data);
                long time = System.currentTimeMillis() - start;
                this.getClassificationResults(classificationResult);
                svmNode = this.classifyGenes ? new DefaultMutableTreeNode("SVM - genes") : new DefaultMutableTreeNode("SVM - samples");
                this.info.time = time;
                int function = this.data.distanceFunction;
                this.info.function = this.menu.getFunctionName(function);
                svmNode.add(this.createClassificationGUIResult());
                svmNode.add(this.createViewers(classificationResult));
                if (this.data.calculateHCL) {
                    svmNode.add(this.createHierarchicalTreeViews(classificationResult.getCluster("cluster"), classificationResult));
                }
                this.createSVMCentroidViews(classificationResult, svmNode);
                this.createInfoView(classificationResult, svmNode);
                this.addSVMParameterNode(svmNode);
            } else if (this.SVMMode == ONE_OUT_VALIDATION) {
                if (!this.initTrainingParams()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = null;
                    return defaultMutableTreeNode;
                }
                int n = this.classifyGenes ? this.experimentMap.getNumberOfGenes() : this.experimentMap.getNumberOfSamples();
                FloatMatrix cumDiscriminantMatrix = new FloatMatrix(n, 2);
                int numberOfNonNeutrals = this.getNumberOfNonNeutrals();
                int[] iterationScores = new int[n];
                int[] elementScores = new int[n];
                for (int i = 0; i < n; ++i) {
                    elementScores[i] = 0;
                }
                svmNode = this.classifyGenes ? new DefaultMutableTreeNode("SVM Val. - genes") : new DefaultMutableTreeNode("SVM Val. - samples");
                for (int iter = 0; iter < n; ++iter) {
                    int initClass = this.classes[iter];
                    this.classes[iter] = 0;
                    this.bindTrainingParams(data);
                    long start = System.currentTimeMillis();
                    AlgorithmData trainingResult = this.algorithm.execute(data);
                    long time = System.currentTimeMillis() - start;
                    this.getTrainingResults(trainingResult);
                    this.createAlgorithm(framework.getAlgorithmFactory());
                    this.bindClassificationParams(data);
                    start = System.currentTimeMillis();
                    AlgorithmData classificationResult = this.algorithm.execute(data);
                    time += System.currentTimeMillis() - start;
                    this.getClassificationResults(classificationResult);
                    this.accumulateResult(cumDiscriminantMatrix, iter);
                    this.classes[iter] = initClass;
                    this.getNumberOfCorrectPlacements(iterationScores, elementScores, iter);
                }
                DefaultMutableTreeNode root = new DefaultMutableTreeNode(new LeafInfo("SVM One-out Validation", (IViewer)new SVMOneOutViewer(this.experiment.getExperiment(), cumDiscriminantMatrix, this.data.classifyGenes, this.classes, elementScores, iterationScores, numberOfNonNeutrals)));
                svmNode.add(root);
                AlgorithmData cumulativeData = this.constructCumulativeResult(cumDiscriminantMatrix);
                svmNode.add(this.createSVMExpressionViews(cumulativeData, this.classes));
                if (this.data.calculateHCL) {
                    try {
                        this.calculateHCL(cumulativeData, cumDiscriminantMatrix);
                        svmNode.add(this.createHierarchicalTreeViews(cumulativeData.getCluster("cluster"), cumulativeData));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.createSVMCentroidViews(cumulativeData, svmNode);
                this.createInfoView(cumulativeData, svmNode);
                this.addSVMParameterNode(svmNode);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = svmNode;
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)this.listener);
            }
            if (this.monitor != null) {
                this.monitor.dispose();
            }
            if (this.logger != null) {
                this.logger.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        this.scripting = true;
        this.parentFrame = framework.getFrame();
        this.experiment = framework.getData();
        this.experimentMap = this.experiment.getExperiment();
        this.menu = framework.getDistanceMenu();
        this.framework = framework;
        AlgorithmData data = new AlgorithmData();
        if (!this.selectSVMProcedure()) {
            return null;
        }
        if (this.SVMMode == TRAIN_AND_CLASSIFY) {
            if (!this.initTrainingParams()) {
                return null;
            }
            this.bindTrainingParams(data);
            this.bindClassificationParams(data);
            data.addParam("mode", String.valueOf(TRAIN_AND_CLASSIFY));
            data.addParam("name", "SVM");
            if (this.classifyGenes) {
                data.addParam("alg-type", "cluster-genes");
            } else {
                data.addParam("alg-type", "cluster-experiments");
            }
            data.addParam("output-class", "partition-output");
            String[] outputNodes = new String[]{"Positives", "Negatives"};
            data.addStringArray("output-nodes", outputNodes);
            return data;
        }
        if (this.SVMMode == TRAIN_ONLY) {
            if (!this.initTrainingParams()) {
                return null;
            }
            this.bindTrainingParams(data);
            data.addParam("mode", String.valueOf(TRAIN_ONLY));
            data.addParam("name", "SVM");
            if (this.classifyGenes) {
                data.addParam("alg-type", "cluster-genes");
            } else {
                data.addParam("alg-type", "cluster-experiments");
            }
            data.addParam("output-class", "partition-output");
            String[] outputNodes = new String[]{"Training Weights Output"};
            data.addStringArray("output-nodes", outputNodes);
            return data;
        }
        if (this.SVMMode == CLASSIFY_ONLY) {
            if (!this.initClassificationParams()) {
                return null;
            }
            this.bindClassificationParams(data);
            data.addParam("mode", String.valueOf(CLASSIFY_ONLY));
            data.addParam("name", "SVM");
            if (this.classifyGenes) {
                data.addParam("alg-type", "cluster-genes");
            } else {
                data.addParam("alg-type", "cluster-experiments");
            }
            data.addParam("output-class", "partition-output");
            String[] outputNodes = new String[]{"Positives", "Negatives"};
            data.addStringArray("output-nodes", outputNodes);
            return data;
        }
        if (this.SVMMode == ONE_OUT_VALIDATION) {
            if (!this.initTrainingParams()) {
                return null;
            }
            this.bindTrainingParams(data);
            this.bindClassificationParams(data);
            data.addParam("mode", String.valueOf(ONE_OUT_VALIDATION));
            data.addParam("name", "SVM");
            if (this.classifyGenes) {
                data.addParam("alg-type", "cluster-genes");
            } else {
                data.addParam("alg-type", "cluster-experiments");
            }
            data.addParam("output-class", "partition-output");
            String[] outputNodes = new String[]{"Positives", "Negatives"};
            data.addStringArray("output-nodes", outputNodes);
            return data;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        this.SVMMode = algData.getParams().getInt("mode");
        this.rebuildSVMData(algData);
        this.parentFrame = framework.getFrame();
        this.experiment = framework.getData();
        this.experimentMap = experiment;
        this.menu = framework.getDistanceMenu();
        this.framework = framework;
        this.classifyGenes = this.data.classifyGenes = algData.getParams().getBoolean("classify-genes");
        this.trainingMatrix = experiment.getMatrix();
        if (this.data.classifyGenes) {
            algData.addMatrix("training", this.trainingMatrix);
        } else {
            algData.addMatrix("training", this.trainingMatrix.transpose());
        }
        FloatMatrix matrix = experiment.getMatrix();
        if (!this.data.classifyGenes) {
            matrix = matrix.transpose();
        }
        algData.addMatrix("experiment", matrix);
        this.classes = algData.getIntArray("classes");
        DefaultMutableTreeNode svmNode = null;
        this.showLogger("SVM Log Window");
        try {
            this.createAlgorithm(framework.getAlgorithmFactory());
            if (this.SVMMode == TRAIN_AND_CLASSIFY) {
                this.bindParams(algData);
                algData.addParam("is-classify", String.valueOf(false));
                long start = System.currentTimeMillis();
                AlgorithmData trainingResult = this.algorithm.execute(algData);
                long time = System.currentTimeMillis() - start;
                this.getTrainingResults(trainingResult);
                svmNode = this.classifyGenes ? new DefaultMutableTreeNode("SVM - genes") : new DefaultMutableTreeNode("SVM - samples");
                svmNode.add(this.createTrainingGUIResult());
                this.createAlgorithm(framework.getAlgorithmFactory());
                this.bindClassificationParams(algData);
                algData.addParam("is-classify", String.valueOf(true));
                start = System.currentTimeMillis();
                AlgorithmData classificationResult = this.algorithm.execute(algData);
                this.getClassificationResults(classificationResult);
                this.info.time = time += System.currentTimeMillis() - start;
                this.info.function = framework.getDistanceMenu().getFunctionName(this.data.distanceFunction);
                svmNode.add(this.createClassificationGUIResult());
                svmNode.add(this.createSVMExpressionViews(classificationResult, this.classes));
                if (this.data.calculateHCL) {
                    svmNode.add(this.createHierarchicalTreeViews(classificationResult.getCluster("cluster"), classificationResult));
                }
                this.createSVMCentroidViews(classificationResult, svmNode);
                this.createInfoView(classificationResult, svmNode);
                this.addSVMParameterNode(svmNode);
            } else if (this.SVMMode == TRAIN_ONLY) {
                this.bindParams(algData);
                algData.addParam("is-classify", String.valueOf(false));
                long start = System.currentTimeMillis();
                AlgorithmData trainingResult = this.algorithm.execute(algData);
                long time = System.currentTimeMillis() - start;
                this.getTrainingResults(trainingResult);
                svmNode = this.classifyGenes ? new DefaultMutableTreeNode("SVM - genes") : new DefaultMutableTreeNode("SVM - samples");
                svmNode.add(this.createTrainingGUIResult());
                this.info.time = time;
                int function = this.menu.getDistanceFunction();
                this.info.function = this.menu.getFunctionName(function);
                this.addSVMParameterNode(svmNode);
            } else if (this.SVMMode == CLASSIFY_ONLY) {
                this.Weights = algData.getMatrix((String)"weights").A[0];
                this.bindClassificationParams(algData);
                long start = System.currentTimeMillis();
                AlgorithmData classificationResult = this.algorithm.execute(algData);
                long time = System.currentTimeMillis() - start;
                this.getClassificationResults(classificationResult);
                svmNode = this.classifyGenes ? new DefaultMutableTreeNode("SVM - genes") : new DefaultMutableTreeNode("SVM - samples");
                this.info.time = time;
                int function = this.menu.getDistanceFunction();
                this.info.function = this.menu.getFunctionName(function);
                svmNode.add(this.createClassificationGUIResult());
                svmNode.add(this.createViewers(classificationResult));
                if (this.data.calculateHCL) {
                    svmNode.add(this.createHierarchicalTreeViews(classificationResult.getCluster("cluster"), classificationResult));
                }
                this.createSVMCentroidViews(classificationResult, svmNode);
                this.createInfoView(classificationResult, svmNode);
                this.addSVMParameterNode(svmNode);
            } else if (this.SVMMode == ONE_OUT_VALIDATION) {
                if (!this.initTrainingParams()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = null;
                    return defaultMutableTreeNode;
                }
                int n = this.classifyGenes ? this.experimentMap.getNumberOfGenes() : this.experimentMap.getNumberOfSamples();
                FloatMatrix cumDiscriminantMatrix = new FloatMatrix(n, 2);
                int numberOfNonNeutrals = this.getNumberOfNonNeutrals();
                int[] iterationScores = new int[n];
                int[] elementScores = new int[n];
                for (int i = 0; i < n; ++i) {
                    elementScores[i] = 0;
                }
                svmNode = this.classifyGenes ? new DefaultMutableTreeNode("SVM Val. - genes") : new DefaultMutableTreeNode("SVM Val. - samples");
                for (int iter = 0; iter < n; ++iter) {
                    int initClass = this.classes[iter];
                    this.classes[iter] = 0;
                    this.bindTrainingParams(algData);
                    long start = System.currentTimeMillis();
                    AlgorithmData trainingResult = this.algorithm.execute(algData);
                    long time = System.currentTimeMillis() - start;
                    this.getTrainingResults(trainingResult);
                    this.createAlgorithm(framework.getAlgorithmFactory());
                    this.bindClassificationParams(algData);
                    start = System.currentTimeMillis();
                    AlgorithmData classificationResult = this.algorithm.execute(algData);
                    time += System.currentTimeMillis() - start;
                    this.getClassificationResults(classificationResult);
                    this.accumulateResult(cumDiscriminantMatrix, iter);
                    this.classes[iter] = initClass;
                    this.getNumberOfCorrectPlacements(iterationScores, elementScores, iter);
                }
                DefaultMutableTreeNode root = new DefaultMutableTreeNode(new LeafInfo("SVM One-out Validation", (IViewer)new SVMOneOutViewer(this.experiment.getExperiment(), cumDiscriminantMatrix, this.data.classifyGenes, this.classes, elementScores, iterationScores, numberOfNonNeutrals)));
                svmNode.add(root);
                AlgorithmData cumulativeData = this.constructCumulativeResult(cumDiscriminantMatrix);
                svmNode.add(this.createSVMExpressionViews(cumulativeData, this.classes));
                if (this.data.calculateHCL) {
                    try {
                        this.calculateHCL(cumulativeData, cumDiscriminantMatrix);
                        svmNode.add(this.createHierarchicalTreeViews(cumulativeData.getCluster("cluster"), cumulativeData));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.createSVMCentroidViews(cumulativeData, svmNode);
                this.createInfoView(cumulativeData, svmNode);
                this.addSVMParameterNode(svmNode);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = svmNode;
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)this.listener);
            }
            if (this.monitor != null) {
                this.monitor.dispose();
            }
            if (this.logger != null) {
                this.logger.dispose();
            }
        }
    }

    private void rebuildSVMData(AlgorithmData algData) {
        String fileName;
        AlgorithmParameters params = algData.getParams();
        this.data.constant = params.getFloat("constant");
        this.data.coefficient = params.getFloat("coefficient");
        this.data.power = params.getFloat("power");
        if (this.SVMMode != CLASSIFY_ONLY) {
            this.data.diagonalFactor = params.getFloat("diagonal-factor");
            this.data.convergenceThreshold = params.getFloat("convergence-threshold");
            this.data.radial = params.getBoolean("radial");
            this.data.normalize = params.getBoolean("normalize");
            this.data.widthFactor = params.getFloat("width-factor");
            this.data.constrainWeights = params.getBoolean("constrain-weights");
            this.data.positiveConstraint = params.getFloat("positive-constraint");
            this.data.negativeConstraint = params.getFloat("negative-constraint");
        }
        this.data.useEditor = params.getBoolean("used-classification-editor");
        if (!this.data.useEditor && (fileName = params.getString("classification-file-name")) != null) {
            this.data.classificationFile = new File(fileName);
        }
        this.data.classifyGenes = params.getBoolean("classify-genes");
        this.data.calculateHCL = params.getBoolean("calculate-hcl");
        if (this.data.calculateHCL) {
            this.data.calcSampleHCL = params.getBoolean("calculate-samples-hcl");
            this.data.calcGeneHCL = params.getBoolean("calculate-genes-hcl");
            this.data.hclMethod = params.getInt("linkage-method");
        }
        this.data.distanceFunction = params.getInt("hcl-distance-function");
        this.data.absoluteDistance = params.getBoolean("hcl-absolute-distance");
    }

    private AlgorithmData constructCumulativeResult(FloatMatrix discriminantMatrix) {
        AlgorithmData result = new AlgorithmData();
        result.addMatrix("experiment", this.experimentMap.getMatrix());
        result.addMatrix("discriminant", discriminantMatrix);
        result.addIntArray("positives", this.getPositives(discriminantMatrix));
        result.addIntArray("negatives", this.getNegatives(discriminantMatrix));
        FloatMatrix means = this.getMeans(discriminantMatrix);
        result.addMatrix("means", means);
        result.addMatrix("variances", this.getVariance(discriminantMatrix, means));
        return result;
    }

    private void getNumberOfCorrectPlacements(int[] placements, int[] elementAccuracy, int index) {
        int n = 0;
        for (int i = 0; i < this.discriminantMatrix.getRowDimension(); ++i) {
            int clazz = (int)this.discriminantMatrix.get(i, 0);
            if (clazz != this.classes[i]) continue;
            int n2 = i;
            elementAccuracy[n2] = elementAccuracy[n2] + 1;
            ++n;
        }
        placements[index] = n;
    }

    private boolean selectSVMProcedure() {
        SVMProcessInitDialog dialog = new SVMProcessInitDialog(this.parentFrame, true);
        if (dialog.showModal() != 0) {
            return false;
        }
        this.data.classifyGenes = this.classifyGenes = dialog.isEvaluateGenesSelected();
        this.SVMMode = dialog.getSVMProcessSelection();
        this.data.calculateHCL = dialog.getHCLSelection();
        if (this.data.calculateHCL) {
            IDistanceMenu menu = this.framework.getDistanceMenu();
            HCLInitDialog hcl_dialog = new HCLInitDialog(this.framework.getFrame(), menu.getFunctionName(menu.getDistanceFunction()), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() == 0) {
                this.data.hclMethod = hcl_dialog.getMethod();
                this.data.calcSampleHCL = hcl_dialog.isClusterExperiments();
                this.data.calcGeneHCL = hcl_dialog.isClusterGenes();
                this.data.distanceFunction = hcl_dialog.getDistanceMetric();
                this.data.absoluteDistance = hcl_dialog.getAbsoluteSelection();
            } else {
                this.data.calculateHCL = false;
            }
        }
        return true;
    }

    protected boolean initTrainingParams() {
        this.trainingMatrix = this.experiment.getExperiment().getMatrix();
        this.kernelMatrix = null;
        SVMInitDialog dialog = new SVMInitDialog(this.parentFrame, this.data);
        if (dialog.showModal() != 0) {
            return false;
        }
        this.data = dialog.getData();
        this.classes = this.classifyGenes ? new int[this.trainingMatrix.getRowDimension()] : new int[this.trainingMatrix.getColumnDimension()];
        if (!this.scripting) {
            this.showLogger("SVM Log Window");
        }
        if (this.data.useEditor) {
            SVMClassificationEditor editor = new SVMClassificationEditor(this.framework, this.data.classifyGenes);
            if (!this.scripting) {
                this.logger.append("Using Classification Editor\n");
            }
            editor.setVisible(true);
            if (editor.formCanceled()) {
                System.out.println("form canceled!!!");
                return false;
            }
            this.classes = editor.getClassification();
        } else {
            this.logger.append("Reading classification file\n");
            this.loadTableSVC();
        }
        return true;
    }

    private void loadTableSVC() {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.data.classificationFile.getPath())));
            Vector<String> data = new Vector<String>();
            while ((line = br.readLine()) != null) {
                data.add(line.trim());
            }
            br.close();
            Vector<String> groupNames = new Vector<String>();
            Vector<Integer> sampleIndices = new Vector<Integer>();
            Vector<String> sampleNames = new Vector<String>();
            Vector<String> groupAssignments = new Vector<String>();
            for (int row = 0; row < data.size(); ++row) {
                line = (String)data.get(row);
                if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                String[] lineArray = line.split("\t");
                if (lineArray[0].startsWith("Module:")) {
                    if (lineArray[1].equals("SVM")) continue;
                    Object[] optionst = new Object[]{"Continue", "Cancel"};
                    if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                    return;
                }
                if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                    groupNames.add(lineArray[1]);
                    continue;
                }
                try {
                    Integer.parseInt(lineArray[0]);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                sampleIndices.add(new Integer(lineArray[0]));
                sampleNames.add(lineArray[1]);
                groupAssignments.add(lineArray[2]);
            }
            int numRows = this.classifyGenes ? this.experimentMap.getNumberOfGenes() : this.experimentMap.getNumberOfSamples();
            if (numRows != sampleNames.size()) {
                System.out.println(numRows + "  " + sampleNames.size());
                System.out.println(numRows + " s length " + sampleNames.size());
                JOptionPane.showMessageDialog(null, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + numRows + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                return;
            }
            int fileSampleIndex = 0;
            int groupIndex = 0;
            for (int sample = 0; sample < numRows; ++sample) {
                boolean doIndex = false;
                for (int i = 0; i < numRows; ++i) {
                    if (i == sample || !this.framework.getData().getSampleAnnotation(i, this.framework.getData().getCurrentSampleLabelKey()).equals(this.framework.getData().getSampleAnnotation(sample, this.framework.getData().getCurrentSampleLabelKey()))) continue;
                    doIndex = true;
                }
                fileSampleIndex = sampleNames.indexOf(this.framework.getData().getSampleAnnotation(sample, this.framework.getData().getCurrentSampleLabelKey()));
                if (fileSampleIndex == -1) {
                    doIndex = true;
                }
                if (doIndex) {
                    this.setStateBasedOnIndex(groupAssignments, groupNames);
                    break;
                }
                String groupName = (String)groupAssignments.get(fileSampleIndex);
                groupIndex = groupNames.indexOf(groupName);
                this.classes[sample] = -1;
                try {
                    if (groupIndex == 0) {
                        this.classes[sample] = -1;
                    }
                    if (groupIndex == 1) {
                        this.classes[sample] = 1;
                    }
                    if (groupIndex != 2 && groupIndex != -1) continue;
                    this.classes[sample] = 0;
                    continue;
                }
                catch (Exception e) {
                    this.classes[sample] = 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
        }
    }

    private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
        Object[] optionst = new Object[]{"Continue", "Cancel"};
        if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
            return;
        }
        int numRows = this.classifyGenes ? this.experimentMap.getNumberOfGenes() : this.experimentMap.getNumberOfSamples();
        for (int sample = 0; sample < numRows; ++sample) {
            try {
                if (groupNames.indexOf(groupAssignments.get(sample)) == 0) {
                    this.classes[sample] = -1;
                }
                if (groupNames.indexOf(groupAssignments.get(sample)) == 1) {
                    this.classes[sample] = 1;
                }
                if (groupNames.indexOf(groupAssignments.get(sample)) != 2 && groupNames.indexOf(groupAssignments.get(sample)) != -1) continue;
                this.classes[sample] = 0;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.classes[sample] = 0;
            }
        }
    }

    private boolean readSVCFile() {
        String WorkString = "";
        int Position2 = 0;
        boolean ReturnValue = false;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(this.data.classificationFile.getPath())));
            String Dummy = in.readLine();
            if (Dummy != null) {
                WorkString = Dummy;
                Position2 = WorkString.indexOf(9);
                String string = WorkString = WorkString.substring(Position2 + 1, WorkString.length());
            }
            int CurrentGene = 0;
            Dummy = in.readLine();
            while (Dummy != null) {
                WorkString = Dummy;
                WorkString = WorkString.substring(WorkString.indexOf(9) + 1);
                Position2 = WorkString.indexOf(9);
                String Value = WorkString.substring(0, Position2);
                WorkString = WorkString.substring(Position2 + 1, WorkString.length());
                ++CurrentGene;
                if (Value.compareTo("1") * Value.compareTo("-1") != 0) {
                    JOptionPane.showMessageDialog(this.parentFrame, "Value not Element of [1,-1] in line " + CurrentGene, "Error", 0);
                    break;
                }
                this.classes[CurrentGene - 1] = Integer.parseInt(Value);
                Dummy = in.readLine();
            }
            if (this.classifyGenes && CurrentGene != this.experimentMap.getNumberOfGenes()) {
                JOptionPane.showMessageDialog(this.parentFrame, "Number of Genes to classify does not match current data set!", "Error", 0);
            } else if (!this.classifyGenes && CurrentGene != this.experimentMap.getNumberOfSamples()) {
                JOptionPane.showMessageDialog(this.parentFrame, "Number of Experiments, " + CurrentGene + ", to classify does not match current data set, " + this.experimentMap.getNumberOfSamples() + "!", "Error", 0);
            } else {
                ReturnValue = true;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parentFrame, "Can not read file " + this.data.classificationFile.getPath() + "!", "Error", 0);
        }
        return ReturnValue;
    }

    protected void bindTrainingParams(AlgorithmData data) {
        this.bindParams(data);
        data.addParam("is-classify", String.valueOf(false));
        data.addParam("hcl-distance-function", String.valueOf(this.data.distanceFunction));
        data.addIntArray("classes", this.classes);
        data.addParam("seed", String.valueOf(this.data.seed));
        data.addParam("normalize", String.valueOf(this.data.normalize));
        data.addParam("radial", String.valueOf(this.data.radial));
        data.addParam("width-factor", String.valueOf(this.data.widthFactor));
        data.addParam("positive-diagonal", String.valueOf(this.data.positiveDiagonal));
        data.addParam("negative-diagonal", String.valueOf(this.data.negativeDiagonal));
        data.addParam("diagonal-factor", String.valueOf(this.data.diagonalFactor));
        data.addParam("positive-constraint", String.valueOf(this.data.positiveConstraint));
        data.addParam("negative-constraint", String.valueOf(this.data.negativeConstraint));
        data.addParam("convergence-threshold", String.valueOf(this.data.convergenceThreshold));
        data.addParam("constrain-weights", String.valueOf(this.data.constrainWeights));
        data.addParam("used-classification-editor", String.valueOf(this.data.useEditor));
        if (!this.data.useEditor && this.data.classificationFile != null) {
            data.addParam("classification-file-name", this.data.classificationFile.getName());
        }
        data.addParam("classify-genes", String.valueOf(this.classifyGenes));
    }

    protected void getTrainingResults(AlgorithmData result) {
        FloatMatrix weightsMatrix = result.getMatrix("weights");
        this.Weights = weightsMatrix.getColumnPackedCopy();
    }

    protected DefaultMutableTreeNode createTrainingGUIResult() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new LeafInfo("SVM Training Result", (IViewer)new SVMTrainViewer(this.experiment.getExperiment(), this.Weights, this.data.classifyGenes, this.data)));
        return root;
    }

    protected boolean initClassificationParams() {
        JFileChooser fc = new JFileChooser(TMEV.getFile((String)"data/svm"));
        fc.addChoosableFileFilter(new SVMFileFilter());
        fc.setFileView(new SVMFileView());
        int returnVal = fc.showOpenDialog(this.parentFrame);
        if (returnVal == 0) {
            this.SVMFile = fc.getSelectedFile();
            if (!this.scripting) {
                this.showLogger("SVM Classify Log Window");
            }
        } else {
            return false;
        }
        if (!this.scripting) {
            this.logger.append("Reading SVM file\n");
        }
        try {
            if (!this.ReadSVMFile()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean ReadSVMFile() throws Exception {
        String Dummy = new String();
        String WorkString = new String();
        String Value = new String();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(this.SVMFile)));
            int NumberOfGenes = this.experimentMap.getNumberOfGenes();
            int NumberOfSamples = this.experimentMap.getNumberOfSamples();
            in.readLine();
            Dummy = in.readLine();
            int Position2 = Dummy.indexOf(":");
            Value = Dummy.substring(Position2 + 2, Dummy.length());
            this.data.constant = Float.valueOf(Value).floatValue();
            Dummy = in.readLine();
            Position2 = Dummy.indexOf(":");
            Value = Dummy.substring(Position2 + 2, Dummy.length());
            this.data.coefficient = Float.valueOf(Value).floatValue();
            Dummy = in.readLine();
            Position2 = Dummy.indexOf(":");
            Value = Dummy.substring(Position2 + 2, Dummy.length());
            this.data.power = Float.valueOf(Value).floatValue();
            Dummy = in.readLine();
            Position2 = Dummy.indexOf(":");
            Value = Dummy.substring(Position2 + 2, Dummy.length());
            this.data.diagonalFactor = Float.valueOf(Value).floatValue();
            Dummy = in.readLine();
            Position2 = Dummy.indexOf(":");
            Value = Dummy.substring(Position2 + 2, Dummy.length());
            this.data.convergenceThreshold = Float.valueOf(Value).floatValue();
            Dummy = in.readLine();
            Position2 = Dummy.indexOf(":");
            Value = Dummy.substring(Position2 + 2, Dummy.length());
            this.data.radial = Boolean.valueOf(Value);
            Dummy = in.readLine();
            Position2 = Dummy.indexOf(":");
            Value = Dummy.substring(Position2 + 2, Dummy.length());
            this.data.widthFactor = Float.valueOf(Value).floatValue();
            Dummy = in.readLine();
            Position2 = Dummy.indexOf(":");
            Value = Dummy.substring(Position2 + 2, Dummy.length());
            this.data.constrainWeights = Boolean.valueOf(Value);
            Dummy = in.readLine();
            Position2 = Dummy.indexOf(":");
            Value = Dummy.substring(Position2 + 2, Dummy.length());
            this.data.positiveConstraint = Float.valueOf(Value).floatValue();
            Dummy = in.readLine();
            Position2 = Dummy.indexOf(":");
            Value = Dummy.substring(Position2 + 2, Dummy.length());
            this.data.negativeConstraint = Float.valueOf(Value).floatValue();
            in.readLine();
            Dummy = in.readLine();
            Position2 = Dummy.indexOf(":");
            Value = Dummy.substring(Position2 + 2, Dummy.length());
            this.data.objective1 = Float.valueOf(Value).floatValue();
            in.readLine();
            in.readLine();
            this.Weights = this.classifyGenes ? new float[NumberOfGenes] : new float[NumberOfSamples];
            for (int i = 0; i < this.Weights.length; ++i) {
                WorkString = Dummy = in.readLine();
                Position2 = WorkString.indexOf(9);
                Value = WorkString.substring(0, Position2);
                this.Weights[i] = Float.valueOf(Value).floatValue();
            }
            if (in.readLine() != null) {
                JOptionPane.showMessageDialog(this.parentFrame, this.SVMFile.getPath() + " has an incorrect number of weight values for current data set.", "Error", 0);
                return false;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            JOptionPane.showMessageDialog(this.parentFrame, "Can not read file " + this.SVMFile.getPath() + "!", "Error", 0);
            throw e2;
        }
        return true;
    }

    protected void bindClassificationParams(AlgorithmData data) {
        this.bindParams(data);
        data.addParam("is-classify", String.valueOf(true));
        if (!this.scripting) {
            if (this.SVMMode == CLASSIFY_ONLY) {
                this.trainingMatrix = this.experiment.getExperiment().getMatrix();
            }
            if (this.data.classifyGenes) {
                data.addMatrix("training", this.trainingMatrix);
            } else {
                data.addMatrix("training", this.trainingMatrix.transpose());
            }
        }
        if (this.Weights != null) {
            data.addMatrix("weights", new FloatMatrix(this.Weights, 1));
        }
        data.addParam("classify-genes", String.valueOf(this.classifyGenes));
        if (this.data.calculateHCL) {
            data.addParam("calculate-hcl", String.valueOf(this.data.calculateHCL));
            data.addParam("calculate-genes-hcl", String.valueOf(this.data.calcGeneHCL));
            data.addParam("calculate-samples-hcl", String.valueOf(this.data.calcSampleHCL));
            data.addParam("linkage-method", String.valueOf(this.data.hclMethod));
            data.addParam("hcl-distance-fucntion", String.valueOf(this.data.distanceFunction));
            data.addParam("hcl-absolute-distance", String.valueOf(this.data.absoluteDistance));
        }
    }

    protected void getClassificationResults(AlgorithmData result) {
        this.discriminantMatrix = result.getMatrix("discriminant");
    }

    protected DefaultMutableTreeNode createClassificationGUIResult() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new LeafInfo("SVM Classification Result", (IViewer)new SVMClassifyViewer(this.experiment.getExperiment(), this.discriminantMatrix, this.data.classifyGenes)));
        return root;
    }

    protected DefaultMutableTreeNode createViewers(AlgorithmData result) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        int[][] classIndices = this.getClassificationIndices(result.getIntArray("positives"), result.getIntArray("negatives"));
        Object expViewer = this.classifyGenes ? new SVMExperimentViewer(this.experimentMap, classIndices) : new SVMExperimentClusterViewer(this.experimentMap, classIndices);
        node.add(new DefaultMutableTreeNode(new LeafInfo("Positives", (IViewer)expViewer, (Object)new Integer(0))));
        node.add(new DefaultMutableTreeNode(new LeafInfo("Negatives", (IViewer)expViewer, (Object)new Integer(1))));
        return node;
    }

    protected DefaultMutableTreeNode createSVMExpressionViews(AlgorithmData result, int[] classification) {
        int[] pos = result.getIntArray("positives");
        int[] neg = result.getIntArray("negatives");
        int[][] truePositives = this.getTruePositives(pos, classification);
        int[][] falseNegatives = this.getFalseNegatives(pos, classification);
        int[][] falsePositives = this.getFalsePositives(neg, classification);
        int[][] trueNegatives = this.getTrueNegatives(neg, classification);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        if (this.classifyGenes) {
            SVMDiscriminantExperimentViewer viewer = new SVMDiscriminantExperimentViewer(this.experimentMap, this.getOrderedClassIndices(truePositives[0], falseNegatives[0], falsePositives[0], trueNegatives[0]), truePositives != null ? truePositives[0].length : 0, falsePositives != null ? falsePositives[0].length : 0, this.getDiscriminants(pos, neg), null, this.classifyGenes);
            node.add(new DefaultMutableTreeNode(new LeafInfo("Positives", (IViewer)viewer, (Object)new Integer(0))));
            node.add(new DefaultMutableTreeNode(new LeafInfo("Negatives", (IViewer)viewer, (Object)new Integer(1))));
        } else {
            int[] posSamplesOrder = result.getIntArray("positve-samples-order");
            int[] negSamplesOrder = result.getIntArray("negative-samples-order");
            SVMExperimentClusterViewer viewer = new SVMExperimentClusterViewer(this.experimentMap, this.getClassificationIndices(pos, neg));
            node.add(new DefaultMutableTreeNode(new LeafInfo("Positive Experiments", (IViewer)viewer, (Object)new Integer(0))));
            node.add(new DefaultMutableTreeNode(new LeafInfo("Negative Experiments", (IViewer)viewer, (Object)new Integer(1))));
        }
        return node;
    }

    protected void createInfoView(AlgorithmData result, DefaultMutableTreeNode node) {
        SVMInfoViewer viewer;
        int[] pos = result.getIntArray("positives");
        int[] neg = result.getIntArray("negatives");
        if (this.SVMMode == CLASSIFY_ONLY) {
            viewer = new SVMInfoViewer(pos.length, neg.length, this.classifyGenes, this.SVMMode);
        } else {
            int numNegExamples;
            int[][] truePositives = this.getTruePositives(pos, this.classes);
            int[][] falseNegatives = this.getFalseNegatives(pos, this.classes);
            int[][] falsePositives = this.getFalsePositives(neg, this.classes);
            int[][] trueNegatives = this.getTrueNegatives(neg, this.classes);
            int numPosRecruitedFromNeutrals = 0;
            int numNegRecruitedFromNeutrals = 0;
            int numPosExamples = this.getNumberOfPositiveExamples(this.classes);
            if (this.classes.length - numPosExamples - (numNegExamples = this.getNumberOfNegativeExamples(this.classes)) > 0) {
                numPosRecruitedFromNeutrals = this.getNumPosRecFromNeutrals(pos, this.classes);
                numNegRecruitedFromNeutrals = this.getNumNegRecFromNeutrals(neg, this.classes);
            }
            viewer = new SVMInfoViewer(numPosExamples, numNegExamples, this.classes.length - numPosExamples - numNegExamples, pos.length, truePositives[0].length, falseNegatives[0].length, neg.length, trueNegatives[0].length, falsePositives[0].length, numPosRecruitedFromNeutrals, numNegRecruitedFromNeutrals, this.classifyGenes, this.SVMMode);
        }
        node.add(new DefaultMutableTreeNode(new LeafInfo("Classification Information", (IViewer)viewer)));
    }

    private DefaultMutableTreeNode createSVMCentroidViews(AlgorithmData result, DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expNode = new DefaultMutableTreeNode("Expression Graphs");
        int[][] clusters = this.getClassificationIndices(result.getIntArray("positives"), result.getIntArray("negatives"));
        if (this.classifyGenes) {
            SVMCentroidViewer viewer = new SVMCentroidViewer(this.experimentMap, clusters);
            float[][] means = result.getMatrix((String)"means").A;
            float[][] vars = result.getMatrix((String)"variances").A;
            viewer.setMeans(means);
            viewer.setVariances(vars);
            SVMCentroidsViewer multiviewer = new SVMCentroidsViewer(this.experimentMap, clusters);
            multiviewer.setMeans(means);
            multiviewer.setVariances(vars);
            expNode.add(new DefaultMutableTreeNode(new LeafInfo("Positives", (IViewer)viewer, (Object)new CentroidUserObject(0, 1))));
            expNode.add(new DefaultMutableTreeNode(new LeafInfo("Negatives", (IViewer)viewer, (Object)new CentroidUserObject(1, 1))));
            expNode.add(new DefaultMutableTreeNode(new LeafInfo("Both Groups", (IViewer)multiviewer, (Object)new Integer(1))));
            centNode.add(new DefaultMutableTreeNode(new LeafInfo("Positives", (IViewer)viewer, (Object)new CentroidUserObject(0, 0))));
            centNode.add(new DefaultMutableTreeNode(new LeafInfo("Negatives", (IViewer)viewer, (Object)new CentroidUserObject(1, 0))));
            centNode.add(new DefaultMutableTreeNode(new LeafInfo("Both Groups", (IViewer)multiviewer, (Object)new Integer(0))));
            root.add(centNode);
            root.add(expNode);
            return root;
        }
        SVMExperimentClusterCentroidViewer viewer = new SVMExperimentClusterCentroidViewer(this.experimentMap, clusters);
        float[][] means = result.getMatrix((String)"means").A;
        float[][] vars = result.getMatrix((String)"variances").A;
        viewer.setMeans(means);
        viewer.setVariances(vars);
        SVMExperimentClusterCentroidsViewer multiviewer = new SVMExperimentClusterCentroidsViewer(this.experimentMap, clusters);
        multiviewer.setMeans(means);
        multiviewer.setVariances(vars);
        expNode.add(new DefaultMutableTreeNode(new LeafInfo("Positives", (IViewer)viewer, (Object)new CentroidUserObject(0, 1))));
        expNode.add(new DefaultMutableTreeNode(new LeafInfo("Negatives", (IViewer)viewer, (Object)new CentroidUserObject(1, 1))));
        expNode.add(new DefaultMutableTreeNode(new LeafInfo("Both Groups", (IViewer)multiviewer, (Object)new Integer(1))));
        centNode.add(new DefaultMutableTreeNode(new LeafInfo("Positives", (IViewer)viewer, (Object)new CentroidUserObject(0, 0))));
        centNode.add(new DefaultMutableTreeNode(new LeafInfo("Negatives", (IViewer)viewer, (Object)new CentroidUserObject(1, 0))));
        centNode.add(new DefaultMutableTreeNode(new LeafInfo("Both Groups", (IViewer)multiviewer, (Object)new Integer(0))));
        root.add(centNode);
        root.add(expNode);
        return root;
    }

    private DefaultMutableTreeNode createHierarchicalTreeViews(Cluster result_cluster, AlgorithmData result) {
        if (!this.data.calculateHCL) {
            return null;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        String nodeString = "Positives";
        int[][] classIndices = null;
        if (!this.classifyGenes) {
            classIndices = this.getClassificationIndices(result.getIntArray("positives"), result.getIntArray("negatives"));
            if (this.data.calcSampleHCL) {
                classIndices = this.getOrderedIndices(nodeList, classIndices, this.data.calcGeneHCL);
            }
        }
        for (int i = 0; i < nodeList.getSize(); ++i) {
            if (i > 0) {
                nodeString = "Negatives";
            }
            if (this.classifyGenes) {
                node.add(new DefaultMutableTreeNode(new LeafInfo(nodeString, this.createHCLViewer(nodeList.getNode(i), result, classIndices))));
                continue;
            }
            node.add(new DefaultMutableTreeNode(new LeafInfo(nodeString, this.createHCLViewer(nodeList.getNode(i), result, classIndices), (Object)new Integer(i))));
        }
        return node;
    }

    private IViewer createHCLViewer(Node clusterNode, AlgorithmData result, int[][] classIndices) {
        HCLTreeData samples_result;
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = this.data.calcGeneHCL ? this.getResult(clusterNode, 0) : null;
        HCLTreeData hCLTreeData2 = this.data.calcSampleHCL ? this.getResult(clusterNode, this.data.calcGeneHCL ? 4 : 0) : (samples_result = null);
        if (this.classifyGenes) {
            return new HCLViewer(this.experimentMap, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
        }
        return new HCLViewer(this.experimentMap, clusterNode.getFeaturesIndexes(), genes_result, samples_result, classIndices, true);
    }

    private HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    private void addSVMParameterNode(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode childNode;
        DefaultMutableTreeNode genInfo = new DefaultMutableTreeNode("General Information");
        String value = this.SVMMode == TRAIN_ONLY ? "Train SVM Only" : (this.SVMMode == CLASSIFY_ONLY ? "Classify Only" : (this.SVMMode == TRAIN_AND_CLASSIFY ? "Train SVM and Classify" : "One-out Validation"));
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("SVM Mode: " + value);
        genInfo.add(node);
        node = new DefaultMutableTreeNode("Kernel Parameters");
        node.add(new DefaultMutableTreeNode("Metric: Dot Product on Normalized Vectors"));
        if (!this.data.radial) {
            childNode = new DefaultMutableTreeNode("Kernel Function: Polynomial");
            childNode.add(new DefaultMutableTreeNode("Constant: " + String.valueOf(this.data.constant)));
            childNode.add(new DefaultMutableTreeNode("Coefficient: " + String.valueOf(this.data.coefficient)));
            childNode.add(new DefaultMutableTreeNode("Power: " + String.valueOf(this.data.power)));
            node.add(childNode);
        } else {
            childNode = new DefaultMutableTreeNode("Kernel Function: Radial Basis (Gausian)");
            childNode.add(new DefaultMutableTreeNode("Width Factor: " + String.valueOf(this.data.widthFactor)));
            node.add(childNode);
        }
        genInfo.add(node);
        node = new DefaultMutableTreeNode("Training Parameters");
        childNode = new DefaultMutableTreeNode("Constrain Weights: " + String.valueOf(this.data.constrainWeights));
        if (this.data.constrainWeights) {
            childNode.add(new DefaultMutableTreeNode("Positive Constraint: " + String.valueOf(this.data.positiveConstraint)));
            childNode.add(new DefaultMutableTreeNode("Negative Constraint: " + String.valueOf(this.data.negativeConstraint)));
        }
        node.add(childNode);
        node.add(new DefaultMutableTreeNode("Diagonal Factor: " + String.valueOf(this.data.diagonalFactor)));
        node.add(new DefaultMutableTreeNode("Threshold: " + String.valueOf(this.data.convergenceThreshold)));
        genInfo.add(node);
        if (this.data.calculateHCL) {
            node = new DefaultMutableTreeNode("HCL Parameters");
            value = AbstractAlgorithm.getDistanceName((int)this.data.distanceFunction);
            node.add(new DefaultMutableTreeNode("HCL distance metric: " + value));
            String method = this.data.hclMethod == 0 ? "Average Linkage" : (this.data.hclMethod == 1 ? "Complete Linkage" : "Single Linkage");
            node.add(new DefaultMutableTreeNode("Linkage Method: " + method));
            genInfo.add(node);
        }
        root.add(genInfo);
    }

    private int[][] getDefaultGeneCluster() {
        int n = this.experimentMap.getNumberOfGenes();
        int[][] c = new int[1][n];
        for (int i = 0; i < n; ++i) {
            c[0][i] = i;
        }
        return c;
    }

    private float[][] getDiscriminants(int[] pos, int[] neg) {
        int i;
        int n = this.discriminantMatrix.getRowDimension();
        float[][] A = this.discriminantMatrix.A;
        float[] disc = new float[n];
        for (int i2 = 0; i2 < n; ++i2) {
            disc[i2] = A[i2][1];
        }
        float[][] result = new float[][]{new float[pos.length], new float[neg.length]};
        for (i = 0; i < pos.length; ++i) {
            result[0][i] = disc[pos[i]];
        }
        for (i = 0; i < neg.length; ++i) {
            result[1][i] = disc[neg[i]];
        }
        return result;
    }

    private int[][] getOrderedClassIndices(int[] a, int[] b, int[] c, int[] d) {
        int[][] result = new int[][]{new int[a.length + b.length], new int[c.length + d.length]};
        System.arraycopy(a, 0, result[0], 0, a.length);
        System.arraycopy(b, 0, result[0], a.length, b.length);
        System.arraycopy(c, 0, result[1], 0, c.length);
        System.arraycopy(d, 0, result[1], c.length, d.length);
        return result;
    }

    private int[][] getTruePositives(int[] pos, int[] classification) {
        int i;
        int[][] result = null;
        Vector<Integer> pVector = new Vector<Integer>();
        for (i = 0; i < pos.length; ++i) {
            if (classification[pos[i]] != 1) continue;
            pVector.add(new Integer(pos[i]));
        }
        result = new int[1][pVector.size()];
        for (i = 0; i < result[0].length; ++i) {
            result[0][i] = (Integer)pVector.elementAt(i);
        }
        return result;
    }

    private int[][] getFalseNegatives(int[] pos, int[] classification) {
        int i;
        int[][] result = null;
        Vector<Integer> pVector = new Vector<Integer>();
        for (i = 0; i < pos.length; ++i) {
            if (classification[pos[i]] > 0) continue;
            pVector.add(new Integer(pos[i]));
        }
        result = new int[1][pVector.size()];
        for (i = 0; i < result[0].length; ++i) {
            result[0][i] = (Integer)pVector.elementAt(i);
        }
        return result;
    }

    private int[][] getFalsePositives(int[] neg, int[] classification) {
        int i;
        int[][] result = null;
        Vector<Integer> pVector = new Vector<Integer>();
        for (i = 0; i < neg.length; ++i) {
            if (classification[neg[i]] != 1) continue;
            pVector.add(new Integer(neg[i]));
        }
        result = new int[1][pVector.size()];
        for (i = 0; i < result[0].length; ++i) {
            result[0][i] = (Integer)pVector.elementAt(i);
        }
        return result;
    }

    private int[][] getTrueNegatives(int[] neg, int[] classification) {
        int i;
        int[][] result = null;
        Vector<Integer> pVector = new Vector<Integer>();
        for (i = 0; i < neg.length; ++i) {
            if (classification[neg[i]] > 0) continue;
            pVector.add(new Integer(neg[i]));
        }
        result = new int[1][pVector.size()];
        for (i = 0; i < result[0].length; ++i) {
            result[0][i] = (Integer)pVector.elementAt(i);
        }
        return result;
    }

    private int getNumberOfPositiveExamples(int[] c) {
        int cnt = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != 1) continue;
            ++cnt;
        }
        return cnt;
    }

    private int getNumberOfNegativeExamples(int[] c) {
        int cnt = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != -1) continue;
            ++cnt;
        }
        return cnt;
    }

    private int getNumPosRecFromNeutrals(int[] pos, int[] c) {
        int cnt = 0;
        for (int i = 0; i < pos.length; ++i) {
            if (c[pos[i]] != 0) continue;
            ++cnt;
        }
        return cnt;
    }

    private int getNumNegRecFromNeutrals(int[] neg, int[] c) {
        int cnt = 0;
        for (int i = 0; i < neg.length; ++i) {
            if (c[neg[i]] != 0) continue;
            ++cnt;
        }
        return cnt;
    }

    private int[][] getClassificationIndices(int[] pos, int[] neg) {
        int[][] results = new int[][]{pos, neg};
        return results;
    }

    private void accumulateResult(FloatMatrix cumMatrix, int index) {
        for (int i = 0; i < this.discriminantMatrix.getColumnDimension(); ++i) {
            cumMatrix.set(index, i, this.discriminantMatrix.get(index, i));
        }
    }

    private float[] toFloatArray(int[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    private int getNumberOfNonNeutrals() {
        int n = 0;
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i] == 0) continue;
            ++n;
        }
        return n;
    }

    protected void showLogger(String caption) {
        if (this.logger == null) {
            this.logger = new Logger(this.parentFrame, caption, this.listener);
            this.logger.show();
        }
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] sampleClusters, boolean calcGeneHCL) {
        for (int i = 0; i < sampleClusters.length; ++i) {
            if (sampleClusters[i].length <= 0) continue;
            HCLTreeData result = this.getResult(nodeList.getNode(i), calcGeneHCL ? 4 : 0);
            sampleClusters[i] = this.getSampleOrder(result, sampleClusters[i]);
        }
        return sampleClusters;
    }

    private int[] getSampleOrder(HCLTreeData result, int[] indices) {
        return this.getLeafOrder(result.node_order, result.child_1_array, result.child_2_array, indices);
    }

    private int[] getLeafOrder(int[] nodeOrder, int[] child1, int[] child2, int[] indices) {
        int[] leafOrder = new int[nodeOrder.length];
        Arrays.fill(leafOrder, -1);
        this.fillLeafOrder(leafOrder, child1, child2, 0, child1.length - 2, indices);
        return leafOrder;
    }

    private int fillLeafOrder(int[] leafOrder, int[] child1, int[] child2, int pos, int index, int[] indices) {
        if (child1[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child1[index], indices);
        }
        if (child2[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child2[index], indices);
        } else {
            leafOrder[pos] = indices == null ? index : indices[index];
            ++pos;
        }
        return pos;
    }

    private int[] getPositives(FloatMatrix matrix) {
        int cnt = 0;
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            if ((double)matrix.get(i, 0) != 1.0) continue;
            ++cnt;
        }
        int[] pos = new int[cnt];
        cnt = 0;
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            if ((double)matrix.get(i, 0) != 1.0) continue;
            pos[cnt] = i;
            ++cnt;
        }
        return pos;
    }

    private int[] getNegatives(FloatMatrix matrix) {
        int cnt = 0;
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            if (!(matrix.get(i, 0) <= 0.0f)) continue;
            ++cnt;
        }
        int[] neg = new int[cnt];
        cnt = 0;
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            if (!(matrix.get(i, 0) <= 0.0f)) continue;
            neg[cnt] = i;
            ++cnt;
        }
        return neg;
    }

    private FloatMatrix getMeans(FloatMatrix discMatrix) {
        FloatMatrix expMatrix = this.experiment.getExperiment().getMatrix();
        if (!this.classifyGenes) {
            expMatrix = expMatrix.transpose();
        }
        int numSamples = expMatrix.getColumnDimension();
        int numGenes = expMatrix.getRowDimension();
        FloatMatrix means = new FloatMatrix(2, numSamples);
        float posMean = 0.0f;
        float negMean = 0.0f;
        int posCnt = 0;
        int negCnt = 0;
        for (int j = 0; j < numSamples; ++j) {
            for (int i = 0; i < numGenes; ++i) {
                float value;
                float c = discMatrix.get(i, 0);
                if (c == 1.0f) {
                    value = expMatrix.get(i, j);
                    if (Float.isNaN(value)) continue;
                    ++posCnt;
                    posMean += value;
                    continue;
                }
                value = expMatrix.get(i, j);
                if (Float.isNaN(value)) continue;
                ++negCnt;
                negMean += value;
            }
            means.set(0, j, posCnt != 0 ? posMean / (float)posCnt : 0.0f);
            means.set(1, j, negCnt != 0 ? negMean / (float)negCnt : 0.0f);
            posCnt = 0;
            negCnt = 0;
            posMean = 0.0f;
            negMean = 0.0f;
        }
        return means;
    }

    private FloatMatrix getVariance(FloatMatrix discMatrix, FloatMatrix means) {
        FloatMatrix expMatrix = this.experiment.getExperiment().getMatrix();
        if (!this.classifyGenes) {
            expMatrix = expMatrix.transpose();
        }
        int numSamples = expMatrix.getColumnDimension();
        int numGenes = expMatrix.getRowDimension();
        FloatMatrix vars = new FloatMatrix(2, numSamples);
        float ssePos = 0.0f;
        int posCnt = 0;
        float sseNeg = 0.0f;
        int negCnt = 0;
        for (int i = 0; i < numSamples; ++i) {
            for (int j = 0; j < numGenes; ++j) {
                float value;
                float c = discMatrix.get(j, 0);
                if (c == 1.0f) {
                    value = expMatrix.get(j, i);
                    if (Float.isNaN(value)) continue;
                    ssePos = (float)((double)ssePos + Math.pow(value - means.get(0, i), 2.0));
                    ++posCnt;
                    continue;
                }
                value = expMatrix.get(j, i);
                if (Float.isNaN(value)) continue;
                sseNeg = (float)((double)sseNeg + Math.pow(value - means.get(1, i), 2.0));
                ++negCnt;
            }
            vars.set(0, i, (float)(posCnt > 1 ? Math.sqrt(ssePos / (float)(posCnt - 1)) : 0.0));
            vars.set(1, i, (float)(negCnt > 1 ? Math.sqrt(sseNeg / (float)(negCnt - 1)) : 0.0));
            posCnt = 0;
            negCnt = 0;
            ssePos = 0.0f;
            sseNeg = 0.0f;
        }
        return vars;
    }

    private void calculateHCL(AlgorithmData data, FloatMatrix discriminantMatrix) throws AbortException, AlgorithmException {
        int[][] clusters = new int[][]{this.getPositives(discriminantMatrix), this.getNegatives(discriminantMatrix)};
        if (this.data.calculateHCL) {
            Cluster result_cluster = new Cluster();
            NodeList nodeList = result_cluster.getNodeList();
            for (int i = 0; i < clusters.length; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                int[] features = clusters[i];
                Node node = new Node(features);
                nodeList.addNode(node);
                node.setValues(this.calculateHierarchicalTree(features, this.data.hclMethod, this.data.calcGeneHCL, this.data.calcSampleHCL));
            }
            data.addCluster("cluster", result_cluster);
        }
    }

    private NodeValueList calculateHierarchicalTree(int[] features, int method, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        FloatMatrix experiment;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix expMatrix = this.experimentMap.getMatrix();
        if (this.data.classifyGenes) {
            experiment = this.getSubExperiment(expMatrix, features);
        } else {
            expMatrix = expMatrix.transpose();
            experiment = this.getSubExperimentReducedCols(expMatrix, features);
        }
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(this.data.distanceFunction));
        data.addParam("hcl-distance-absolute", String.valueOf(this.data.absoluteDistance));
        data.addParam("method-linkage", String.valueOf(this.data.hclMethod));
        Algorithm hcl = this.framework.getAlgorithmFactory().getAlgorithm("HCL");
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            int[] nodes = result.getIntArray("node-order");
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix experiment, int[] features) {
        FloatMatrix copyMatrix = experiment.copy();
        FloatMatrix subExperiment = new FloatMatrix(features.length, copyMatrix.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = copyMatrix.A[features[i]];
        }
        subExperiment = subExperiment.transpose();
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(ArrayList source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (int)((Float)source.get(i)).floatValue();
        }
        return int_matrix;
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            int id = event.getId();
            switch (id) {
                case 1: {
                    break;
                }
                case 2: {
                    SVMGUI.this.logger.append(event.getDescription());
                    break;
                }
                case 3: {
                    if (SVMGUI.this.monitor == null) {
                        SVMGUI.this.monitor = new Monitor(SVMGUI.this.parentFrame, "Convergence", 75, 125, 0.1 / (double)SVMGUI.this.data.convergenceThreshold);
                        SVMGUI.this.monitor.show();
                        break;
                    }
                    SVMGUI.this.monitor.update(event.getFloatValue());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                SVMGUI.this.algorithm.abort();
                if (SVMGUI.this.monitor != null) {
                    SVMGUI.this.monitor.dispose();
                }
                if (SVMGUI.this.logger != null) {
                    SVMGUI.this.logger.dispose();
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SVMGUI.this.algorithm.abort();
            if (SVMGUI.this.monitor != null) {
                SVMGUI.this.monitor.dispose();
            }
            if (SVMGUI.this.logger != null) {
                SVMGUI.this.logger.dispose();
            }
        }
    }
}

