/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.text.DecimalFormat;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class SVMDiscriminantExperimentViewer
extends JPanel
implements IViewer {
    private int numRetainedPos;
    private int numRecruitedNeg;
    private Color RecruitColor = Color.red;
    private boolean classifyGenes = true;
    private ExperimentHeader header;
    private Experiment experiment;
    private IFramework framework;
    private IData data;
    protected int clusterIndex;
    private int[][] clusters;
    private float[][] discriminants;
    protected int[] samplesOrder;
    protected Dimension elementSize = new Dimension(20, 5);
    protected int labelIndex = -1;
    protected boolean isAntiAliasing = true;
    protected boolean isDrawBorders = true;
    protected boolean isDrawAnnotations = true;
    public static Color missingColor = new Color(128, 128, 128);
    public static Color maskColor = new Color(255, 255, 255, 128);
    private float maxValue = 3.0f;
    private float minValue = -3.0f;
    private float midValue = 0.0f;
    protected int firstSelectedRow = -1;
    protected int lastSelectedRow = -1;
    public BufferedImage posColorImage = this.createGradientImage(Color.red, Color.black);
    public BufferedImage negColorImage = this.createGradientImage(Color.black, Color.green);
    private int annotationWidth;
    private Insets insets = new Insets(0, 10, 0, 0);
    private static final int RECT_HEIGHT = 15;
    private static final float INITIAL_MAX_VALUE = 3.0f;
    private static final float INITIAL_MIN_VALUE = -3.0f;
    private static final String NO_GENES_STR = "No Genes in Cluster!";
    private static final String NO_EXPERIMENTS_STR = "No Experiments In Cluster!";
    private static final Font ERROR_FONT = new Font("monospaced", 1, 20);
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private boolean haveColorBar;
    private boolean useDoubleGradient = true;
    private JPopupMenu popup;
    private int exptID;

    public SVMDiscriminantExperimentViewer(Experiment experiment, int[][] clusters, Integer NumRetainedPos, Integer NumRecruitedNeg, float[][] discriminants, int[] samplesOrder, Boolean classifyGenes) {
        this(experiment, clusters, (int)NumRetainedPos, (int)NumRecruitedNeg, discriminants, samplesOrder, (boolean)classifyGenes);
    }

    public SVMDiscriminantExperimentViewer(Experiment experiment, int[][] clusters, int NumRetainedPos, int NumRecruitedNeg, float[][] discriminants, int[] samplesOrder, boolean classifyGenes) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.clusters = clusters == null ? SVMDiscriminantExperimentViewer.defGenesOrder(experiment.getNumberOfGenes()) : clusters;
        this.discriminants = discriminants;
        this.samplesOrder = samplesOrder == null ? SVMDiscriminantExperimentViewer.defSamplesOrder(experiment.getNumberOfSamples()) : samplesOrder;
        this.classifyGenes = classifyGenes;
        this.isDrawAnnotations = true;
        this.header = new ExperimentHeader(this.experiment, this.clusters, this.samplesOrder);
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        SVMExperimentActionListener actionListener = new SVMExperimentActionListener();
        this.addMouseListener(actionListener);
        this.popup = this.createJPopupMenu(actionListener);
        this.numRetainedPos = NumRetainedPos;
        this.numRecruitedNeg = NumRecruitedNeg;
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, this.clusters, new Integer(this.numRetainedPos), new Integer(this.numRecruitedNeg), this.discriminants, this.samplesOrder, new Boolean(this.classifyGenes)});
    }

    private JPopupMenu createJPopupMenu(SVMExperimentActionListener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Store cluster", GUIFactory.getIcon("new16.gif"));
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("analysis16.gif"));
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon("delete16.gif"));
        menuItem.setActionCommand(SET_DEF_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon("save16.gif"));
        menuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private static int[] defSamplesOrder(int size) {
        int[] order = new int[size];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        return order;
    }

    private static int[][] defGenesOrder(int size) {
        int[][] order = new int[1][size];
        for (int i = 0; i < order[0].length; ++i) {
            order[0][i] = i;
        }
        return order;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    public Color getMissingColor() {
        return missingColor;
    }

    public void selectRows(int start, int end) {
        this.firstSelectedRow = start;
        this.lastSelectedRow = end;
        this.repaint();
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        IDisplayMenu menu = framework.getDisplayMenu();
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        Integer userObject = (Integer)framework.getUserObject();
        this.setClusterIndex(userObject == null ? 0 : userObject);
        this.labelIndex = menu.getLabelIndex();
        this.maxValue = menu.getMaxRatioScale();
        this.minValue = menu.getMinRatioScale();
        this.midValue = menu.getMidRatioValue();
        this.setElementSize(menu.getElementSize());
        this.setAntialiasing(menu.isAntiAliasing());
        this.setDrawBorders(menu.isDrawingBorder());
        this.updateSize();
        this.header.setData(this.data);
        this.onMenuChanged(menu);
        this.header.setClusterIndex(this.clusterIndex);
        this.header.setValues(this.minValue, this.midValue, this.maxValue);
        this.header.setAntiAliasing(menu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        this.setDrawBorders(menu.isDrawingBorder());
        this.maxValue = menu.getMaxRatioScale();
        this.minValue = menu.getMinRatioScale();
        this.midValue = menu.getMidRatioValue();
        this.negColorImage = menu.getNegativeGradientImage();
        this.posColorImage = menu.getPositiveGradientImage();
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.header.setValues(this.minValue, this.midValue, this.maxValue);
        if (this.elementSize.equals(menu.getElementSize()) && this.labelIndex == menu.getLabelIndex() && this.isAntiAliasing == menu.isAntiAliasing()) {
            return;
        }
        this.setElementSize(menu.getElementSize());
        this.setAntialiasing(menu.isAntiAliasing());
        this.labelIndex = menu.getLabelIndex();
        this.haveColorBar = this.areProbesColored();
        this.updateSize();
        this.header.setAntiAliasing(menu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
    }

    public void onDataChanged(IData data) {
        this.data = data;
        this.haveColorBar = this.areProbesColored();
        this.header.setData(data);
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public void setClusterIndex(int clusterIndex) {
        this.clusterIndex = clusterIndex;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    protected int getMultipleArrayDataRow(int clusterArrayRow) {
        return this.experiment.getGeneIndexMappedToData(this.clusters[this.clusterIndex][clusterArrayRow]);
    }

    private int[] getIDataRowIndices(int[] expIndices) {
        int[] dataIndices = new int[expIndices.length];
        for (int i = 0; i < expIndices.length; ++i) {
            dataIndices[i] = this.getMultipleArrayDataRow(i);
        }
        return dataIndices;
    }

    protected int getExperimentRow(int row) {
        return this.clusters[this.clusterIndex][row];
    }

    private int getColumn(int column) {
        return this.samplesOrder[column];
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    protected IData getData() {
        return this.data;
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getIDataRowIndices(this.getCluster()), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            this.framework.removeCluster(this.getIDataRowIndices(this.getCluster()), this.experiment, 0);
        }
    }

    public void storeCluster() {
        this.framework.storeCluster(this.getIDataRowIndices(this.getCluster()), this.experiment, 0);
        this.onDataChanged(this.data);
        this.updateSize();
    }

    public void saveClusters(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveExperiment((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[][])this.getClusters());
    }

    public void saveCluster(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveExperiment((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[])this.getCluster());
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveClusters(frame);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveCluster(frame);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color newColor = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (newColor != null) {
            this.setClusterColor(newColor);
        }
    }

    private void setElementSize(Dimension elementSize) {
        this.elementSize = new Dimension(elementSize);
    }

    private void setAntialiasing(boolean value) {
        this.isAntiAliasing = value;
    }

    private void setDrawBorders(boolean value) {
        this.isDrawBorders = value;
    }

    public BufferedImage createGradientImage(Color color1, Color color2) {
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics = image.createGraphics();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 255.0f, 0.0f, color2);
        graphics.setPaint(gp);
        graphics.drawRect(0, 0, 255, 1);
        return image;
    }

    protected boolean areProbesColored() {
        int[] indices = this.getCluster();
        for (int i = 0; i < indices.length; ++i) {
            if (this.data.getProbeColor(this.getMultipleArrayDataRow(i)) == null) continue;
            return true;
        }
        return false;
    }

    private void updateSize() {
        if (this.clusters == null || this.getCluster().length == 0) {
            this.setFont(ERROR_FONT);
            Graphics2D g = (Graphics2D)this.getGraphics();
            FontMetrics metrics = g.getFontMetrics();
            int width = metrics.stringWidth(NO_GENES_STR) + 10;
            int height = metrics.getHeight() + 30;
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
            return;
        }
        this.setFont(new Font("monospaced", 0, this.elementSize.height));
        Graphics2D g = (Graphics2D)this.getGraphics();
        int width = this.elementSize.width * this.samplesOrder.length;
        if (this.isDrawAnnotations) {
            this.annotationWidth = this.getMaxWidth(g);
            width += 20 + this.annotationWidth;
        }
        if (this.haveColorBar) {
            width += this.elementSize.width + 10;
        }
        int height = this.elementSize.height * this.getCluster().length + 1;
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
    }

    private int getMaxWidth(Graphics2D g) {
        if (g == null || this.data == null || this.getCluster() == null) {
            return 0;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        int max = 0;
        for (int i = 0; i < this.getCluster().length; ++i) {
            String str = this.data.getElementAttribute(this.getMultipleArrayDataRow(i), this.labelIndex);
            max = Math.max(max, fm.stringWidth(str));
        }
        return max;
    }

    private Color getColor(float value) {
        int rgb;
        if (Float.isNaN(value)) {
            return missingColor;
        }
        if (this.useDoubleGradient) {
            float maximum = value < this.midValue ? this.minValue : this.maxValue;
            int colorIndex = (int)(255.0f * (value - this.midValue) / (maximum - this.midValue));
            if (colorIndex < 0) {
                colorIndex = -colorIndex;
            }
            colorIndex = colorIndex > 255 ? 255 : colorIndex;
            rgb = value < this.midValue ? this.negColorImage.getRGB(255 - colorIndex, 0) : this.posColorImage.getRGB(colorIndex, 0);
        } else {
            float span = this.maxValue - this.minValue;
            int colorIndex = value <= this.minValue ? 0 : (value >= this.maxValue ? 255 : (int)((value - this.minValue) / span * 255.0f));
            rgb = this.posColorImage.getRGB(colorIndex, 0);
        }
        return new Color(rgb);
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.data == null) {
            return;
        }
        this.setBackground(Color.white);
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(4);
        format.setMaximumFractionDigits(4);
        format.setPositivePrefix("+");
        int samples = this.samplesOrder.length;
        if (this.clusters == null || this.getCluster().length == 0) {
            g.setColor(new Color(0, 0, 128));
            g.setFont(ERROR_FONT);
            g.drawString(NO_GENES_STR, 10, 30);
            return;
        }
        if (this.samplesOrder.length == 0) {
            g.setColor(new Color(0, 0, 128));
            g.setFont(ERROR_FONT);
            g.drawString(NO_EXPERIMENTS_STR, 10, 30);
            return;
        }
        Rectangle bounds = g.getClipBounds();
        int top = this.getTopIndex(bounds.y);
        int bottom = this.getBottomIndex(bounds.y + bounds.height, this.getCluster().length);
        int left = this.getLeftIndex(bounds.x);
        int right = this.getRightIndex(bounds.x + bounds.width, samples);
        for (int column = left; column < right; ++column) {
            for (int row = top; row < bottom; ++row) {
                this.fillRectAt(g, row, column);
            }
        }
        if (this.haveColorBar) {
            for (int row = top; row < bottom; ++row) {
                this.fillClusterRectAt(g, row, samples * this.elementSize.width + 5);
            }
        }
        if (this.isDrawAnnotations) {
            if (this.isAntiAliasing) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (right >= samples) {
                String label = "";
                g.setColor(Color.black);
                int breakPoint = this.clusterIndex == 0 ? this.numRetainedPos : this.numRecruitedNeg;
                int uniqX = this.elementSize.width * samples + 10;
                for (int row = top; row < bottom; ++row) {
                    if (this.labelIndex >= 0) {
                        if (this.classifyGenes && (this.clusterIndex == 0 && row >= breakPoint || this.clusterIndex == 1 && row < breakPoint)) {
                            g.setColor(this.RecruitColor);
                        } else {
                            g.setColor(Color.black);
                        }
                        label = this.data.getElementAttribute(this.getMultipleArrayDataRow(row), this.labelIndex);
                    }
                    int annY = (row + 1) * this.elementSize.height;
                    if (this.discriminants.length >= this.getCluster().length) {
                        g.drawString(format.format(this.discriminants[this.clusterIndex][row]) + "   " + label, uniqX + this.insets.left, annY);
                        continue;
                    }
                    g.drawString(label, uniqX + this.insets.left, annY);
                }
            }
        }
        g.setColor(Color.black);
    }

    private void fillRectAt(Graphics g, int row, int column) {
        int x = column * this.elementSize.width + this.insets.left;
        int y = row * this.elementSize.height;
        boolean mask = this.firstSelectedRow >= 0 && this.lastSelectedRow >= 0 && (row < this.firstSelectedRow || row > this.lastSelectedRow);
        g.setColor(this.getColor(this.experiment.get(this.getExperimentRow(row), this.getColumn(column))));
        g.fillRect(x, y, this.elementSize.width, this.elementSize.height);
        if (mask) {
            g.setColor(maskColor);
            g.fillRect(x, y, this.elementSize.width, this.elementSize.height);
        }
        if (this.isDrawBorders) {
            g.setColor(Color.black);
            g.drawRect(x, y, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private void drawRectAt(Graphics g, int row, int column, Color color) {
        g.setColor(color);
        g.drawRect(column * this.elementSize.width + this.insets.left, row * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    private void fillClusterRectAt(Graphics g, int row, int xLoc) {
        Color geneColor = this.data.getProbeColor(this.getMultipleArrayDataRow(row));
        if (geneColor == null) {
            geneColor = Color.white;
        }
        g.setColor(geneColor);
        g.fillRect(xLoc + this.insets.left, row * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height);
    }

    private int getTopIndex(int top) {
        if (top < 0) {
            return 0;
        }
        return top / this.elementSize.height;
    }

    private int getLeftIndex(int left) {
        if (left < this.insets.left) {
            return 0;
        }
        return (left - this.insets.left) / this.elementSize.width;
    }

    private int getRightIndex(int right, int limit) {
        if (right < 0) {
            return 0;
        }
        int result = right / this.elementSize.width + 1;
        return result > limit ? limit : result;
    }

    private int getBottomIndex(int bottom, int limit) {
        if (bottom < 0) {
            return 0;
        }
        int result = bottom / this.elementSize.height + 1;
        return result > limit ? limit : result;
    }

    private int findColumn(int targetx) {
        int xSize = this.samplesOrder.length * this.elementSize.width;
        if (targetx >= xSize + this.insets.left || targetx < this.insets.left) {
            return -1;
        }
        return (targetx - this.insets.left) / this.elementSize.width;
    }

    private int findRow(int targety) {
        int ySize = this.getCluster().length * this.elementSize.height;
        if (targety >= ySize || targety < 0) {
            return -1;
        }
        return targety / this.elementSize.height;
    }

    private boolean isLegalPosition(int row, int column) {
        return this.isLegalRow(row) && this.isLegalColumn(column);
    }

    private boolean isLegalColumn(int column) {
        return column >= 0 && column <= this.samplesOrder.length - 1;
    }

    private boolean isLegalRow(int row) {
        return row >= 0 && row <= this.getCluster().length - 1;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int getViewerType() {
        if (this.classifyGenes) {
            return 0;
        }
        return 1;
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
        this.header.setExperiment(e);
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    private class SVMExperimentActionListener
    extends MouseAdapter
    implements ActionListener {
        private SVMExperimentActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(SVMDiscriminantExperimentViewer.SAVE_CLUSTER_CMD)) {
                SVMDiscriminantExperimentViewer.this.onSaveCluster();
            } else if (command.equals(SVMDiscriminantExperimentViewer.SAVE_ALL_CLUSTERS_CMD)) {
                SVMDiscriminantExperimentViewer.this.onSaveClusters();
            } else if (command.equals(SVMDiscriminantExperimentViewer.SET_DEF_COLOR_CMD)) {
                SVMDiscriminantExperimentViewer.this.onSetDefaultColor();
            } else if (command.equals(SVMDiscriminantExperimentViewer.STORE_CLUSTER_CMD)) {
                SVMDiscriminantExperimentViewer.this.storeCluster();
            } else if (command.equals(SVMDiscriminantExperimentViewer.LAUNCH_NEW_SESSION_CMD)) {
                SVMDiscriminantExperimentViewer.this.launchNewSession();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || SVMDiscriminantExperimentViewer.this.getCluster() == null || SVMDiscriminantExperimentViewer.this.getCluster().length == 0) {
                return;
            }
            SVMDiscriminantExperimentViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private String oldStatusText;
        private int oldRow = -1;
        private int oldColumn = -1;

        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            int column = SVMDiscriminantExperimentViewer.this.findColumn(event.getX());
            int row = SVMDiscriminantExperimentViewer.this.findRow(event.getY());
            if (!SVMDiscriminantExperimentViewer.this.isLegalPosition(row, column)) {
                return;
            }
            if (!event.isShiftDown()) {
                SVMDiscriminantExperimentViewer.this.framework.displaySlideElementInfo(SVMDiscriminantExperimentViewer.this.experiment.getSampleIndex(SVMDiscriminantExperimentViewer.this.getColumn(column)), SVMDiscriminantExperimentViewer.this.getMultipleArrayDataRow(row));
                return;
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (SVMDiscriminantExperimentViewer.this.experiment.getNumberOfSamples() == 0 || event.isShiftDown()) {
                return;
            }
            int column = SVMDiscriminantExperimentViewer.this.findColumn(event.getX());
            int row = SVMDiscriminantExperimentViewer.this.findRow(event.getY());
            if (this.isCurrentPosition(row, column)) {
                return;
            }
            Graphics g = null;
            if (SVMDiscriminantExperimentViewer.this.isLegalPosition(row, column)) {
                g = SVMDiscriminantExperimentViewer.this.getGraphics();
                SVMDiscriminantExperimentViewer.this.drawRectAt(g, row, column, Color.white);
                SVMDiscriminantExperimentViewer.this.framework.setStatusText("Gene: " + SVMDiscriminantExperimentViewer.this.data.getUniqueId(SVMDiscriminantExperimentViewer.this.getMultipleArrayDataRow(row)) + " Sample: " + SVMDiscriminantExperimentViewer.this.data.getSampleName(SVMDiscriminantExperimentViewer.this.experiment.getSampleIndex(SVMDiscriminantExperimentViewer.this.getColumn(column))) + " Value: " + SVMDiscriminantExperimentViewer.this.experiment.get(SVMDiscriminantExperimentViewer.this.getExperimentRow(row), SVMDiscriminantExperimentViewer.this.getColumn(column)));
            } else {
                SVMDiscriminantExperimentViewer.this.framework.setStatusText(this.oldStatusText);
            }
            if (SVMDiscriminantExperimentViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                g = g != null ? g : SVMDiscriminantExperimentViewer.this.getGraphics();
                SVMDiscriminantExperimentViewer.this.fillRectAt(g, this.oldRow, this.oldColumn);
            }
            this.setOldPosition(row, column);
            if (g != null) {
                g.dispose();
            }
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.oldStatusText = SVMDiscriminantExperimentViewer.this.framework.getStatusText();
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (SVMDiscriminantExperimentViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                Graphics g = SVMDiscriminantExperimentViewer.this.getGraphics();
                SVMDiscriminantExperimentViewer.this.fillRectAt(g, this.oldRow, this.oldColumn);
                g.dispose();
            }
            this.setOldPosition(-1, -1);
            SVMDiscriminantExperimentViewer.this.framework.setStatusText(this.oldStatusText);
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        private void setOldPosition(int row, int column) {
            this.oldColumn = column;
            this.oldRow = row;
        }

        private boolean isCurrentPosition(int row, int column) {
            return row == this.oldRow && column == this.oldColumn;
        }
    }
}

