/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.io.File;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class SVMData {
    public float constant;
    public float coefficient;
    public float power;
    public float diagonalFactor;
    public float convergenceThreshold;
    public boolean radial;
    public boolean normalize;
    public float widthFactor;
    public float positiveConstraint;
    public float negativeConstraint;
    public boolean constrainWeights;
    public File classificationFile;
    public boolean useEditor;
    public int distanceFunction;
    public boolean absoluteDistance;
    public float positiveDiagonal;
    public float negativeDiagonal;
    public long seed = 0L;
    public float objective1;
    public float twoSquaredWidth;
    public boolean classifyGenes;
    public boolean calculateHCL;
    public boolean calcGeneHCL;
    public boolean calcSampleHCL;
    public int hclMethod;

    public SVMData() {
        this.constant = 1.0f;
        this.coefficient = 1.0f;
        this.power = 1.0f;
        this.diagonalFactor = 1.0f;
        this.convergenceThreshold = 1.0E-5f;
        this.radial = false;
        this.normalize = false;
        this.widthFactor = 1.0f;
        this.constrainWeights = true;
        this.positiveConstraint = 1.0f;
        this.negativeConstraint = 1.0f;
        this.positiveDiagonal = 0.0f;
        this.negativeDiagonal = 0.0f;
        this.classificationFile = null;
        this.classifyGenes = true;
        this.calculateHCL = false;
        this.calcSampleHCL = false;
        this.calcGeneHCL = false;
        this.hclMethod = 0;
        this.distanceFunction = 4;
        this.useEditor = true;
    }

    public SVMData(SVMData data) {
        this.constant = data.constant;
        this.coefficient = data.coefficient;
        this.power = data.power;
        this.diagonalFactor = data.diagonalFactor;
        this.convergenceThreshold = data.convergenceThreshold;
        this.radial = data.radial;
        this.normalize = data.normalize;
        this.widthFactor = data.widthFactor;
        this.constrainWeights = data.constrainWeights;
        this.positiveConstraint = data.positiveConstraint;
        this.negativeConstraint = data.negativeConstraint;
        this.positiveDiagonal = data.positiveDiagonal;
        this.negativeDiagonal = data.negativeDiagonal;
        this.classificationFile = data.classificationFile;
        this.classifyGenes = data.classifyGenes;
        this.calculateHCL = data.calculateHCL;
        this.calcSampleHCL = data.calcSampleHCL;
        this.calcGeneHCL = data.calcGeneHCL;
        this.hclMethod = data.hclMethod;
        this.distanceFunction = data.distanceFunction;
        this.useEditor = data.useEditor;
        this.seed = data.seed;
        this.objective1 = data.objective1;
        this.twoSquaredWidth = data.twoSquaredWidth;
    }

    public boolean validate(JDialog parent) {
        if (this.diagonalFactor < 0.0f) {
            JOptionPane.showMessageDialog(parent, "Diagonal Factor must be >= 0", "Error", 0);
            return false;
        }
        if (this.radial && this.widthFactor < 0.0f) {
            JOptionPane.showMessageDialog(parent, "Width Factor must be >= 0", "Error", 0);
            return false;
        }
        if (this.convergenceThreshold <= 0.0f) {
            JOptionPane.showMessageDialog(parent, "Threshold must be > 0", "Error", 0);
            return false;
        }
        return true;
    }
}

