/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.Expression;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.AbstractTableModel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.microarray.mev.cluster.gui.impl.svm.GeneralInfo;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMData;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMResultViewer;
import org.tigr.util.FloatMatrix;

public class SVMClassifyViewer
extends SVMResultViewer {
    private FloatMatrix discriminant;
    private SVMData data;
    private GeneralInfo info;
    private boolean classifyGenes;
    float[] classes;
    float[] discr;
    DecimalFormat floatFormat;
    DecimalFormat intFormat;
    DecimalFormat indexFormat;
    int indexLength = 1;
    int lineHeight = 20;
    String[] spacerStrings;
    ClassifyViewerTableModel cvtm;

    public SVMClassifyViewer(Experiment expt, FloatMatrix discriminant, boolean classifyGenes) {
        super(expt);
        FloatMatrix M = discriminant.transpose();
        this.init(M.A[1], M.A[0], classifyGenes);
    }

    public SVMClassifyViewer(Experiment e, float[] discr, float[] classes, Boolean classifyGenes) {
        super(e);
        this.init(discr, classes, classifyGenes);
    }

    @Override
    public Expression getExpression() {
        Object[] superExpressionArgs = super.getExpression().getArguments();
        return new Expression(this, this.getClass(), "new", new Object[]{superExpressionArgs[0], this.discr, this.classes, new Boolean(this.classifyGenes)});
    }

    private void init(float[] discr, float[] classes, boolean classifyGenes) {
        this.floatFormat = new DecimalFormat();
        this.floatFormat.setMaximumFractionDigits(4);
        this.floatFormat.setMinimumFractionDigits(4);
        this.floatFormat.setGroupingUsed(false);
        this.intFormat = new DecimalFormat();
        this.intFormat.setMinimumFractionDigits(0);
        this.intFormat.setMaximumFractionDigits(0);
        this.intFormat.setGroupingUsed(false);
        this.indexFormat = new DecimalFormat();
        this.indexFormat = new DecimalFormat();
        this.indexFormat.setMinimumFractionDigits(0);
        this.indexFormat.setMaximumFractionDigits(0);
        this.indexLength = String.valueOf(classes.length).length();
        this.indexFormat.setMinimumIntegerDigits(this.indexLength);
        this.indexFormat.setGroupingUsed(false);
        this.classes = classes;
        this.discr = discr;
        this.classifyGenes = classifyGenes;
        this.cvtm = new ClassifyViewerTableModel();
        this.resultTable = new JTable(this.cvtm);
        this.setBackground(Color.white);
        this.add((Component)new JScrollPane(this.resultTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        SVMResultViewer.MyListener listener = new SVMResultViewer.MyListener(this);
        this.resultTable.addMouseListener(listener);
        this.resultTable.addMouseMotionListener(listener);
    }

    @Override
    public void setExperiment(Experiment e) {
        super.setExperiment(e);
    }

    @Override
    public void onSelected(IFramework frm) {
        super.onSelected(frm);
        this.onMenuChanged(frm.getDisplayMenu());
    }

    @Override
    protected void displayData() {
        this.displayResult(this.classifyGenes);
    }

    private void displayResult(boolean genes) {
    }

    @Override
    protected void onSaveResult() {
        JFileChooser fc = new JFileChooser(TMEV.getFile((String)"data/"));
        fc.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        fc.setFileView((FileView)new ExpressionFileView());
        fc.setCurrentDirectory(new File("Data"));
        int returnVal = fc.showSaveDialog(JOptionPane.getFrameForComponent(this));
        if (returnVal != 0) {
            return;
        }
        File SVMFile = fc.getSelectedFile();
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(SVMFile)));
            for (int row = 0; row < this.cvtm.getRowCount(); ++row) {
                for (int col = 0; col < this.cvtm.getColumnCount(); ++col) {
                    out.write(this.cvtm.getValueAt(row, col).toString() + '\t');
                }
                out.write(10);
            }
            out.flush();
            out.close();
            out = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error writing to file " + SVMFile.getPath() + "!", "Error", 0);
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public void setSize() {
        Dimension d = this.updateSize();
        this.setSize(d.width, this.classes.length * this.lineHeight + 10);
        this.setPreferredSize(new Dimension(d.width, this.classes.length * this.lineHeight + 5));
    }

    private boolean isLegalIndex(int i) {
        return i >= 0 && i < this.classes.length;
    }

    private int getTopIndex(int top) {
        if (top < 0) {
            return 0;
        }
        return top / this.lineHeight;
    }

    private int getBottomIndex(int bottom, int limit) {
        if (bottom < 0) {
            return 0;
        }
        int result = bottom / this.lineHeight + 1;
        return result > limit ? limit : result;
    }

    protected String[] getSpacerStrings(int indexLength, String clas, String discr) {
        int i;
        String[] s = new String[3];
        s[2] = "";
        s[1] = "";
        s[0] = "";
        for (i = indexLength; i < 10; ++i) {
            s[0] = s[0] + " ";
        }
        if (clas.length() == 1) {
            s[0] = s[0] + " ";
        }
        s[1] = "     ";
        int s2_length = 13 - discr.length();
        for (i = 0; i < s2_length; ++i) {
            s[2] = s[2] + " ";
        }
        return s;
    }

    @Override
    protected Dimension updateSize() {
        boolean len = false;
        return new Dimension(120, this.getHeight());
    }

    class ClassifyViewerTableModel
    extends AbstractTableModel {
        String[] header;
        FloatMatrix data;

        public ClassifyViewerTableModel() {
            this.header = new String[]{"Index", "Class", "Discriminant", SVMClassifyViewer.this.annotationLabel};
        }

        @Override
        public String getColumnName(int col) {
            return this.header[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return new Integer(row + 1);
            }
            if (col == 1) {
                if (SVMClassifyViewer.this.classes[row] == -1.0f) {
                    return "none";
                }
                return SVMClassifyViewer.this.intFormat.format(SVMClassifyViewer.this.classes[row]).toString();
            }
            if (col == 2) {
                return SVMClassifyViewer.this.floatFormat.format(SVMClassifyViewer.this.discr[row]).toString();
            }
            if (col == 3) {
                try {
                    if (SVMClassifyViewer.this.classifyGenes) {
                        return SVMClassifyViewer.this.iData.getElementAttribute(SVMClassifyViewer.this.getMultipleArrayDataRow(row), SVMClassifyViewer.this.labelIndex);
                    }
                    return SVMClassifyViewer.this.iData.getSampleName(row);
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                    return "";
                }
            }
            return new String("");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.header.length;
        }

        @Override
        public int getRowCount() {
            return SVMClassifyViewer.this.classes.length;
        }
    }
}

