/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMSearchDialog;

public class SVMClassificationEditor
extends JDialog {
    IFramework framework;
    IData data;
    Experiment experiment;
    String[] fieldNames;
    File currentFile;
    SVMSearchDialog searchDialog;
    SortListener sorter;
    SVMTableModel svmTableModel;
    boolean classifyGenes;
    boolean cancelForm = false;
    private JTable table;
    private JButton searchButton;
    private JSeparator jSeparator2;
    private JScrollPane jScrollPane1;
    private JMenuBar jMenuBar2;
    private JMenu fileMenu;
    private JButton inClassButton;
    private JMenuItem indexSortMenuItem;
    private JButton outClassButton;
    private JMenuItem svcApplyMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem loadMenuItem;
    private JMenu sortByMenu;
    private JButton runButton;
    private JToolBar jToolBar1;
    private JMenuItem classSortMenuItem;
    private JButton neutralButton;
    private JMenu editMenu;
    private JMenuItem storedClusterMenuItem;
    private JMenu toolsMenu;
    private JMenuItem tcListMenuItem;
    private JMenuItem closeMenuItem;
    private JMenuItem selectAllMenuItem;
    private JSeparator jSeparator3;
    private JMenuItem searchMenuItem;

    public SVMClassificationEditor(IFramework Framework, boolean classifyGenes) {
        super(new JFrame(), "SVM Classification Editor", true);
        this.classifyGenes = classifyGenes;
        this.initComponents();
        this.editMenu.remove(2);
        this.editMenu.remove(1);
        this.editMenu.validate();
        this.inClassButton.setIcon(GUIFactory.getIcon("in_class.gif"));
        this.outClassButton.setIcon(GUIFactory.getIcon("out_class.gif"));
        this.neutralButton.setIcon(GUIFactory.getIcon("neutral_class.gif"));
        this.searchButton.setIcon(GUIFactory.getIcon("search.gif"));
        this.runButton.setIcon(GUIFactory.getIcon("go.gif"));
        this.svcApplyMenuItem.setIcon(GUIFactory.getIcon("svcfileicon.gif"));
        this.saveAsMenuItem.setIcon(GUIFactory.getIcon("svcfileicon.gif"));
        this.loadMenuItem.setIcon(GUIFactory.getIcon("svcfileicon.gif"));
        this.tcListMenuItem.setIcon(null);
        this.currentFile = null;
        this.framework = Framework;
        this.data = this.framework.getData();
        this.experiment = this.data.getExperiment();
        this.table.setAutoResizeMode(0);
        TableColumnModel tcm = this.table.getColumnModel();
        this.jScrollPane1.setBackground(Color.black);
        this.loadTable();
        this.searchDialog = new SVMSearchDialog((Frame)new JFrame(), this.table, false);
        this.sorter = new SortListener(this.svmTableModel);
        this.indexSortMenuItem.addActionListener(this.sorter);
        this.classSortMenuItem.addActionListener(this.sorter);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            JMenuItem item = new JMenuItem(this.fieldNames[i]);
            item.addActionListener(this.sorter);
            this.sortByMenu.add(item);
        }
    }

    private void loadTable() {
        int row;
        if (this.data == null) {
            return;
        }
        int numGenes = this.experiment.getNumberOfGenes();
        int numSamples = this.experiment.getNumberOfSamples();
        if (this.classifyGenes) {
            this.fieldNames = this.data.getFieldNames();
        } else {
            this.fieldNames = new String[1];
            this.fieldNames[0] = "Sample/Experiment Name";
        }
        Object[] headerNames = new String[this.fieldNames.length + 4];
        headerNames[0] = "Index";
        headerNames[1] = "In Class";
        headerNames[2] = "Out of Class";
        headerNames[3] = "Neutral";
        for (int i = 4; i < this.fieldNames.length + 4; ++i) {
            headerNames[i] = this.fieldNames[i - 4];
        }
        DefaultTableModel model = this.classifyGenes ? new DefaultTableModel(new Object[numGenes][this.fieldNames.length + 4], headerNames) : new DefaultTableModel(new Object[numSamples][this.fieldNames.length + 4], headerNames);
        this.svmTableModel = new SVMTableModel((String[])headerNames, model);
        this.table.setModel(this.svmTableModel);
        if (this.classifyGenes) {
            for (row = 0; row < numGenes; ++row) {
                this.table.setValueAt(new Integer(row), row, 0);
                this.table.setValueAt(new Boolean(false), row, 1);
                this.table.setValueAt(new Boolean(true), row, 2);
                this.table.setValueAt(new Boolean(false), row, 3);
                for (int j = 4; j < headerNames.length; ++j) {
                    String annot = this.data.getElementAttribute(row, j - 4);
                    this.table.setValueAt(annot, row, j);
                }
            }
        } else {
            for (row = 0; row < numSamples; ++row) {
                this.table.setValueAt(new Integer(row), row, 0);
                this.table.setValueAt(new Boolean(false), row, 1);
                this.table.setValueAt(new Boolean(true), row, 2);
                this.table.setValueAt(new Boolean(false), row, 3);
                this.table.setValueAt(this.data.getFullSampleName(this.experiment.getSampleIndex(row)), row, 4);
            }
        }
        int W = 75;
        TableColumn col = this.table.getColumn("In Class");
        this.setWidth(col, W, true);
        col = this.table.getColumn("Out of Class");
        this.setWidth(col, W, true);
        col = this.table.getColumn("Neutral");
        this.setWidth(col, W, true);
        col = this.table.getColumn("Index");
        W = this.getIndexColumnWidth();
        this.setWidth(col, W, true);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            col = this.table.getColumn(this.fieldNames[i]);
            W = this.getColumnTextWidth(i + 4);
            W = Math.min(W, 300);
            this.setWidth(col, W, false);
        }
        this.table.getModel().addTableModelListener(new ClassSelectionListener());
        this.table.setColumnModel(new SVMTableColumnModel(this.table.getColumnModel()));
    }

    private int getColumnTextWidth(int col) {
        Graphics g = this.table.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        int columnWidth = fm.stringWidth(this.table.getColumnName(col));
        int numRows = this.table.getRowCount();
        for (int i = 0; i < numRows; ++i) {
            if (fm.stringWidth((String)this.table.getValueAt(i, col)) <= columnWidth) continue;
            columnWidth = fm.stringWidth((String)this.table.getValueAt(i, col));
        }
        return columnWidth + 10;
    }

    private int getIndexColumnWidth() {
        Graphics g = this.table.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        int columnWidth = fm.stringWidth("Index");
        int numRows = this.table.getRowCount();
        for (int i = 0; i < numRows; ++i) {
            if (fm.stringWidth(((Integer)this.table.getValueAt(i, 0)).toString()) <= columnWidth) continue;
            columnWidth = fm.stringWidth(((Integer)this.table.getValueAt(i, 0)).toString());
        }
        return columnWidth + 10;
    }

    private void setWidth(TableColumn col, int width, boolean setAll) {
        col.setWidth(width);
        col.setPreferredWidth(width);
        if (setAll) {
            col.setMaxWidth(width);
            col.setMinWidth(width);
        }
    }

    private void applySVCFile() {
        File inputFile = null;
        JFileChooser fc = new JFileChooser(TMEV.getFile((String)"data/svm"));
        fc.setFileFilter(new SVCFileFilter());
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            inputFile = fc.getSelectedFile();
        }
        this.readAndApplyFile(inputFile);
    }

    private void readAndApplyFile(File inputFile) {
        if (inputFile == null) {
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(inputFile));
            String line = new String();
            boolean currClass = false;
            Vector<String> values = new Vector<String>();
            br.readLine();
            while ((line = br.readLine()) != null) {
                StringTokenizer stok = new StringTokenizer(line, "\t");
                if (stok.hasMoreTokens()) {
                    stok.nextToken();
                }
                if (!stok.hasMoreElements()) continue;
                values.add(stok.nextToken());
            }
            if (values.size() != this.table.getRowCount()) {
                if (this.classifyGenes) {
                    JOptionPane.showMessageDialog(this.framework.getFrame(), "Number of classification indices provided does not match the number of genes in the data set!", "Classification Input Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this.framework.getFrame(), "Number of classification indices provided does not match the number of experiments in the data set!", "Classification Input Error", 0);
                }
                return;
            }
            this.applyClassArrayToTable(values);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Classification file not found.", "Classification Input Error", 0);
            return;
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "File Input Error, please check format.", "Classification Input Error", 0);
            return;
        }
        catch (NumberFormatException e2) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "File Input Error, please check number format format.", "Classification Input Error", 0);
            return;
        }
    }

    public void applyClassArrayToTable(Vector values) throws NumberFormatException {
        if (values == null) {
            return;
        }
        this.svmTableModel.sort(0);
        int n = values.size();
        int classification = 0;
        for (int i = 0; i < n; ++i) {
            if (((Boolean)this.table.getValueAt(i, 1)).booleanValue()) continue;
            classification = Integer.parseInt((String)values.elementAt(i));
            if (classification == 1) {
                this.table.setValueAt(new Boolean(true), i, 1);
                continue;
            }
            if (classification == -1) {
                this.table.setValueAt(new Boolean(true), i, 2);
                continue;
            }
            this.table.setValueAt(new Boolean(true), i, 3);
        }
    }

    private void applyStoredCluster() {
    }

    private void sortBy(int col) {
    }

    private void setClassificationForRange(int startRow, int endRow, int col) {
        for (int row = startRow; row <= endRow; ++row) {
            this.table.setValueAt(new Boolean(true), row, col);
        }
        this.table.repaint();
    }

    private void setClassificationForSet(int[] indices, int col) {
        for (int row = 0; row < indices.length; ++row) {
            this.table.setValueAt(new Boolean(true), indices[row], col);
        }
        this.table.repaint();
    }

    private void loadTableSVC() throws IOException {
        JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
        if (fileChooser.showOpenDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                Vector<String> data = new Vector<String>();
                while ((line = br.readLine()) != null) {
                    data.add(line.trim());
                }
                br.close();
                Vector<String> groupNames = new Vector<String>();
                Vector<Integer> sampleIndices = new Vector<Integer>();
                Vector<String> sampleNames = new Vector<String>();
                Vector<String> groupAssignments = new Vector<String>();
                for (int row = 0; row < data.size(); ++row) {
                    line = (String)data.get(row);
                    if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                    String[] lineArray = line.split("\t");
                    if (lineArray[0].startsWith("Module:")) {
                        if (lineArray[1].equals("SVM")) continue;
                        Object[] optionst = new Object[]{"Continue", "Cancel"};
                        if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                        return;
                    }
                    if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                        groupNames.add(lineArray[1]);
                        continue;
                    }
                    try {
                        Integer.parseInt(lineArray[0]);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                    sampleIndices.add(new Integer(lineArray[0]));
                    sampleNames.add(lineArray[1]);
                    groupAssignments.add(lineArray[2]);
                }
                int numRows = this.table.getRowCount();
                if (numRows != sampleNames.size()) {
                    System.out.println(numRows + "  " + sampleNames.size());
                    System.out.println(numRows + " s length " + sampleNames.size());
                    JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + numRows + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                    return;
                }
                int fileSampleIndex = 0;
                int groupIndex = 0;
                for (int sample = 0; sample < numRows; ++sample) {
                    boolean doIndex = false;
                    for (int i = 0; i < numRows; ++i) {
                        if (i == sample || !this.getRowAnnotationString(i).equals(this.getRowAnnotationString(sample))) continue;
                        doIndex = true;
                    }
                    fileSampleIndex = sampleNames.indexOf((String)this.table.getValueAt(sample, 4));
                    if (fileSampleIndex == -1) {
                        doIndex = true;
                    }
                    if (doIndex) {
                        this.setStateBasedOnIndex(groupAssignments, groupNames);
                        break;
                    }
                    String groupName = (String)groupAssignments.get(fileSampleIndex);
                    groupIndex = groupNames.indexOf(groupName);
                    try {
                        if (groupIndex == 0) {
                            this.table.setValueAt(new Boolean(true), sample, 2);
                        }
                        if (groupIndex == 1) {
                            this.table.setValueAt(new Boolean(true), sample, 1);
                        }
                        if (groupIndex != 2 && groupIndex != -1) continue;
                        this.table.setValueAt(new Boolean(true), sample, 3);
                        continue;
                    }
                    catch (Exception e) {
                        this.table.setValueAt(new Boolean(true), sample, 3);
                    }
                }
                this.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
            }
        }
    }

    private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
        Object[] optionst = new Object[]{"Continue", "Cancel"};
        if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
            return;
        }
        int numRows = this.table.getRowCount();
        for (int sample = 0; sample < numRows; ++sample) {
            try {
                if (groupNames.indexOf(groupAssignments.get(sample)) == 0) {
                    this.table.setValueAt(new Boolean(true), sample, 2);
                }
                if (groupNames.indexOf(groupAssignments.get(sample)) == 1) {
                    this.table.setValueAt(new Boolean(true), sample, 1);
                }
                if (groupNames.indexOf(groupAssignments.get(sample)) != 2 && groupNames.indexOf(groupAssignments.get(sample)) != -1) continue;
                this.table.setValueAt(new Boolean(true), sample, 3);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.table.setValueAt(new Boolean(true), sample, 3);
            }
        }
    }

    private void saveTableAsSVC() throws IOException {
        this.saveAssignments(true);
        this.saveMenuItem.setEnabled(true);
    }

    private void saveAssignments(boolean saveas) {
        JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
        if (saveas) {
            if (fileChooser.showSaveDialog(this) == 0) {
                File file;
                this.currentFile = file = fileChooser.getSelectedFile();
            } else {
                return;
            }
        }
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(this.currentFile));
            Date currDate = new Date(System.currentTimeMillis());
            String dateString = currDate.toString();
            String userName = System.getProperty("user.name");
            pw.println("# Assignment File");
            pw.println("# User: " + userName + " Save Date: " + dateString);
            pw.println("#");
            pw.print("Module:\t");
            pw.println("SVM");
            pw.print("Group 1 Label:\t");
            pw.println("-1");
            pw.print("Group 2 Label:\t");
            pw.println("1");
            pw.println("#");
            pw.println("Sample Index\tSample Name\tGroup Assignment");
            int numRows = this.table.getRowCount();
            for (int sample = 0; sample < numRows; ++sample) {
                pw.print(String.valueOf(sample + 1) + "\t");
                pw.print(this.table.getValueAt(sample, 4) + "\t");
                if (!this.getClassificationString(sample).equals(String.valueOf(0))) {
                    pw.println(this.getClassificationString(sample));
                    continue;
                }
                pw.println("Exclude");
            }
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void saveTableToCurrentSVC() throws IOException {
        if (this.currentFile != null) {
            this.saveAssignments(false);
        }
    }

    private String getClassificationString(int row) {
        if (((Boolean)this.table.getValueAt(row, 2)).booleanValue()) {
            return "-1";
        }
        if (((Boolean)this.table.getValueAt(row, 1)).booleanValue()) {
            return "1";
        }
        return "0";
    }

    private String getRowAnnotationString(int row) {
        String annot = new String("");
        int numCol = this.table.getColumnCount();
        String TAB = "\t";
        for (int col = 4; col < numCol; ++col) {
            annot = annot + (String)this.table.getValueAt(row, col);
            annot = annot + TAB;
        }
        return annot;
    }

    private void searchTable() {
        this.searchDialog.setVisible(true);
        this.searchDialog.toFront();
        this.searchDialog.setLocation(this.getLocation().x + 100, this.getLocation().y + 100);
    }

    public int[] getClassification() {
        if (this.classifyGenes) {
            return this.getGeneClassification();
        }
        return this.getSampleClassification();
    }

    private int[] getGeneClassification() {
        this.svmTableModel.sort(0);
        int numberOfExperimentRows = this.experiment.getNumberOfGenes();
        int numberOfClassificationRows = this.table.getRowCount();
        int experimentRowCnt = 0;
        int[] classification = new int[numberOfExperimentRows];
        int currentIndex = this.experiment.getGeneIndexMappedToData(experimentRowCnt);
        for (int row = 0; row < numberOfClassificationRows; ++row) {
            if (currentIndex != row) continue;
            classification[experimentRowCnt] = (Boolean)this.table.getValueAt(row, 1) != false ? 1 : ((Boolean)this.table.getValueAt(row, 2) != false ? -1 : 0);
            currentIndex = this.experiment.getGeneIndexMappedToData(++experimentRowCnt);
        }
        return classification;
    }

    private int[] getSampleClassification() {
        this.svmTableModel.sort(0);
        int numRows = this.table.getRowCount();
        int[] classification = new int[numRows];
        for (int row = 0; row < numRows; ++row) {
            classification[row] = (Boolean)this.table.getValueAt(row, 1) != false ? 1 : ((Boolean)this.table.getValueAt(row, 2) != false ? -1 : -1);
        }
        return classification;
    }

    public boolean formCanceled() {
        return this.cancelForm;
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.inClassButton = new JButton();
        this.outClassButton = new JButton();
        this.neutralButton = new JButton();
        this.searchButton = new JButton();
        this.runButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.jMenuBar2 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.loadMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.closeMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.svcApplyMenuItem = new JMenuItem();
        this.storedClusterMenuItem = new JMenuItem();
        this.tcListMenuItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.selectAllMenuItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.searchMenuItem = new JMenuItem();
        this.sortByMenu = new JMenu();
        this.indexSortMenuItem = new JMenuItem();
        this.classSortMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("SVM Classification Editor");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SVMClassificationEditor.this.exitForm(evt);
            }
        });
        this.jToolBar1.setAlignmentX(0.0f);
        this.jToolBar1.setMaximumSize(new Dimension(18, 50));
        this.jToolBar1.setMinimumSize(new Dimension(18, 35));
        this.jToolBar1.setPreferredSize(new Dimension(18, 35));
        this.inClassButton.setToolTipText(" move into class");
        this.inClassButton.setMaximumSize(new Dimension(32, 32));
        this.inClassButton.setMinimumSize(new Dimension(32, 32));
        this.inClassButton.setPreferredSize(new Dimension(32, 32));
        this.inClassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.inClassButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.inClassButton);
        this.outClassButton.setToolTipText("move out of class");
        this.outClassButton.setMaximumSize(new Dimension(32, 32));
        this.outClassButton.setMinimumSize(new Dimension(32, 32));
        this.outClassButton.setPreferredSize(new Dimension(32, 32));
        this.outClassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.outClassButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.outClassButton);
        this.neutralButton.setToolTipText("move to neutral status");
        this.neutralButton.setMaximumSize(new Dimension(32, 32));
        this.neutralButton.setMinimumSize(new Dimension(32, 32));
        this.neutralButton.setPreferredSize(new Dimension(32, 32));
        this.neutralButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.neutralButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.neutralButton);
        this.searchButton.setToolTipText("search (Ctrl - s)");
        this.searchButton.setMaximumSize(new Dimension(32, 32));
        this.searchButton.setMinimumSize(new Dimension(32, 32));
        this.searchButton.setPreferredSize(new Dimension(32, 32));
        this.jToolBar1.addSeparator(new Dimension(20, 32));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.searchButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.searchButton);
        this.runButton.setToolTipText("Run SVM on current classification...");
        this.runButton.setMaximumSize(new Dimension(32, 32));
        this.runButton.setMinimumSize(new Dimension(32, 32));
        this.runButton.setPreferredSize(new Dimension(32, 32));
        this.jToolBar1.addSeparator(new Dimension(20, 32));
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.runButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.runButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jToolBar1, gridBagConstraints);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.fileMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.fileMenuActionPerformed(evt);
            }
        });
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.setEnabled(false);
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadMenuItem);
        this.loadMenuItem.setText("Load File...");
        this.loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.loadMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText("Save as...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.closeMenuItem.setText("Run");
        this.closeMenuItem.setToolTipText("Applies current classification");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeMenuItem);
        this.jMenuBar2.add(this.fileMenu);
        this.editMenu.setMnemonic('E');
        this.editMenu.setText("Edit");
        this.svcApplyMenuItem.setText("Apply SVC File");
        this.svcApplyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.svcApplyMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.svcApplyMenuItem);
        this.storedClusterMenuItem.setText("Apply Stored Cluster");
        this.storedClusterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.storedClusterMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.storedClusterMenuItem);
        this.tcListMenuItem.setText("Apply Gene Index List");
        this.tcListMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.tcListMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.tcListMenuItem);
        this.editMenu.add(this.jSeparator3);
        this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.selectAllMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.selectAllMenuItem);
        this.jMenuBar2.add(this.editMenu);
        this.toolsMenu.setMnemonic('T');
        this.toolsMenu.setText("Tools");
        this.searchMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.searchMenuItem.setText("Search ");
        this.searchMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.searchMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.searchMenuItem);
        this.sortByMenu.setText("Sort by...");
        this.indexSortMenuItem.setText("index");
        this.indexSortMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.indexSortMenuItemActionPerformed(evt);
            }
        });
        this.sortByMenu.add(this.indexSortMenuItem);
        this.classSortMenuItem.setText("classification");
        this.classSortMenuItem.setToolTipText("in->out->neutral");
        this.classSortMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVMClassificationEditor.this.classSortMenuItemActionPerformed(evt);
            }
        });
        this.sortByMenu.add(this.classSortMenuItem);
        this.toolsMenu.add(this.sortByMenu);
        this.jMenuBar2.add(this.toolsMenu);
        this.setJMenuBar(this.jMenuBar2);
        this.pack();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void classSortMenuItemActionPerformed(ActionEvent evt) {
    }

    private void selectAllMenuItemActionPerformed(ActionEvent evt) {
        this.table.selectAll();
    }

    private void indexSortMenuItemActionPerformed(ActionEvent evt) {
    }

    private void svcApplyMenuItemActionPerformed(ActionEvent evt) {
        this.applySVCFile();
    }

    private void tcListMenuItemActionPerformed(ActionEvent evt) {
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.searchTable();
    }

    private void hideOutClassCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void searchMenuItemActionPerformed(ActionEvent evt) {
        this.searchTable();
    }

    private void neutralButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.table.getSelectedRows();
        this.setClassificationForSet(selectedRows, 3);
    }

    private void outClassButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.table.getSelectedRows();
        this.setClassificationForSet(selectedRows, 2);
    }

    private void inClassButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.table.getSelectedRows();
        this.setClassificationForSet(selectedRows, 1);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        try {
            this.saveTableToCurrentSVC();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        try {
            this.saveTableAsSVC();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadMenuItemActionPerformed(ActionEvent evt) {
        try {
            this.loadTableSVC();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void fileMenuActionPerformed(ActionEvent evt) {
    }

    private void storedClusterMenuItemActionPerformed(ActionEvent evt) {
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void exitForm(WindowEvent evt) {
        this.cancelForm = true;
        this.setVisible(false);
    }

    public class SVCFileView
    extends FileView {
        private Icon SVMIcon = GUIFactory.getIcon("svcfileicon.gif");

        @Override
        public String getName(File f) {
            return null;
        }

        @Override
        public String getDescription(File f) {
            return null;
        }

        @Override
        public Boolean isTraversable(File f) {
            return null;
        }

        @Override
        public String getTypeDescription(File f) {
            String extension = this.getExtension(f);
            String type = null;
            if (extension != null && extension.equals("svc")) {
                type = "SVC File";
            }
            return type;
        }

        @Override
        public Icon getIcon(File f) {
            String extension = this.getExtension(f);
            Icon icon = null;
            if (extension != null && extension.equals("svc")) {
                icon = this.SVMIcon;
            }
            return icon;
        }

        private String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }

    public class SVCFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase().endsWith(".svc") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "SVC File";
        }
    }

    public class SVMTableColumnModel
    implements TableColumnModel {
        TableColumnModel tcm;

        public SVMTableColumnModel(TableColumnModel TCM) {
            this.tcm = TCM;
        }

        @Override
        public int getColumnMargin() {
            return this.tcm.getColumnMargin();
        }

        @Override
        public int[] getSelectedColumns() {
            return this.tcm.getSelectedColumns();
        }

        @Override
        public int getColumnIndex(Object obj) {
            return this.tcm.getColumnIndex(obj);
        }

        @Override
        public void setColumnSelectionAllowed(boolean param) {
            this.tcm.setColumnSelectionAllowed(param);
        }

        @Override
        public ListSelectionModel getSelectionModel() {
            return this.tcm.getSelectionModel();
        }

        @Override
        public void moveColumn(int from, int to) {
            if (from < 4 || to < 4) {
                return;
            }
            this.tcm.moveColumn(from, to);
        }

        @Override
        public void setColumnMargin(int param) {
            this.tcm.setColumnMargin(param);
        }

        @Override
        public boolean getColumnSelectionAllowed() {
            return this.tcm.getColumnSelectionAllowed();
        }

        public Enumeration getColumns() {
            return this.tcm.getColumns();
        }

        @Override
        public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.tcm.removeColumnModelListener(tableColumnModelListener);
        }

        @Override
        public void removeColumn(TableColumn tableColumn) {
        }

        @Override
        public int getColumnIndexAtX(int param) {
            return this.tcm.getColumnIndexAtX(param);
        }

        @Override
        public int getSelectedColumnCount() {
            return this.tcm.getSelectedColumnCount();
        }

        @Override
        public int getTotalColumnWidth() {
            return this.tcm.getTotalColumnWidth();
        }

        @Override
        public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.tcm.addColumnModelListener(tableColumnModelListener);
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            this.tcm.addColumn(tableColumn);
        }

        @Override
        public void setSelectionModel(ListSelectionModel listSelectionModel) {
            this.tcm.setSelectionModel(listSelectionModel);
        }

        @Override
        public TableColumn getColumn(int param) {
            return this.tcm.getColumn(param);
        }

        @Override
        public int getColumnCount() {
            return this.tcm.getColumnCount();
        }
    }

    public class ClassSelectionListener
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent tme) {
            tme.getSource();
            int selectedCol = tme.getColumn();
            int selectedRow = tme.getFirstRow();
            if (selectedCol < 1 || selectedCol > 3) {
                return;
            }
            if (this.verifySelected(selectedRow, selectedCol)) {
                this.changeNeighbors(selectedRow, selectedCol);
            }
        }

        private void changeNeighbors(int first, int col) {
            if (col == 1) {
                SVMClassificationEditor.this.table.setValueAt(new Boolean(false), first, 2);
                SVMClassificationEditor.this.table.setValueAt(new Boolean(false), first, 3);
            } else if (col == 2) {
                SVMClassificationEditor.this.table.setValueAt(new Boolean(false), first, 1);
                SVMClassificationEditor.this.table.setValueAt(new Boolean(false), first, 3);
            } else if (col == 3) {
                SVMClassificationEditor.this.table.setValueAt(new Boolean(false), first, 1);
                SVMClassificationEditor.this.table.setValueAt(new Boolean(false), first, 2);
            }
        }

        private boolean verifySelected(int row, int col) {
            boolean selVal = (Boolean)SVMClassificationEditor.this.table.getValueAt(row, col);
            if (selVal) {
                return true;
            }
            if (col == 1) {
                boolean value1 = (Boolean)SVMClassificationEditor.this.table.getValueAt(row, 2);
                boolean value2 = (Boolean)SVMClassificationEditor.this.table.getValueAt(row, 3);
                if (!value1 && !value2) {
                    SVMClassificationEditor.this.table.setValueAt(new Boolean(true), row, col);
                }
            } else if (col == 2) {
                boolean value1 = (Boolean)SVMClassificationEditor.this.table.getValueAt(row, 1);
                boolean value2 = (Boolean)SVMClassificationEditor.this.table.getValueAt(row, 3);
                if (!value1 && !value2) {
                    SVMClassificationEditor.this.table.setValueAt(new Boolean(true), row, col);
                }
            } else if (col == 3) {
                boolean value1 = (Boolean)SVMClassificationEditor.this.table.getValueAt(row, 1);
                boolean value2 = (Boolean)SVMClassificationEditor.this.table.getValueAt(row, 2);
                if (!value1 && !value2) {
                    SVMClassificationEditor.this.table.setValueAt(new Boolean(true), row, col);
                }
            }
            return false;
        }
    }

    public class ClassificationCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private JRadioButton button = new JRadioButton();
        private Color selectionBackgroundColor;
        private Color selectionForegroundColor;

        public ClassificationCellRenderer(JTable table) {
            this.button.setBackground(Color.white);
            this.selectionBackgroundColor = table.getSelectionBackground();
            this.selectionForegroundColor = table.getForeground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean param, boolean param3, int row, int col) {
            this.button.setSelected((Boolean)obj);
            return this.button;
        }
    }

    public class SortListener
    implements ActionListener {
        private SVMTableModel model;

        public SortListener(TableModel Model) {
            this.model = (SVMTableModel)Model;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source instanceof JMenuItem) {
                String key = ((JMenuItem)source).getText();
                if (key.equals("index")) {
                    this.model.sort(0);
                } else if (key.equals("classification")) {
                    this.model.sort(1);
                } else {
                    this.model.sortBy(key);
                }
            }
        }
    }

    public class SVMTableModel
    extends AbstractTableModel {
        private Class[] types;
        private boolean[] canEdit;
        private TableModel tableModel;
        private Row[] rows;
        private int colToSort;
        private String[] headerNames;

        public SVMTableModel(String[] HeaderNames, TableModel Model) {
            int i;
            this.tableModel = Model;
            this.headerNames = HeaderNames;
            this.rows = new Row[this.tableModel.getRowCount()];
            for (i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
            this.types = new Class[this.headerNames.length];
            this.canEdit = new boolean[this.types.length];
            for (i = 0; i < this.types.length; ++i) {
                if (i == 1 || i == 2 || i == 3) {
                    this.types[i] = Boolean.class;
                    this.canEdit[i] = true;
                    continue;
                }
                this.types[i] = Object.class;
                this.canEdit[i] = false;
            }
        }

        public void sort(int c) {
            this.colToSort = c;
            Arrays.sort(this.rows);
            SVMClassificationEditor.this.table.repaint();
        }

        public void sortBy(String key) {
            int col = this.getColumnIndex(key);
            if (col >= 0) {
                this.sort(col);
                this.colToSort = col;
            }
        }

        private int getColumnIndex(String key) {
            int i;
            for (i = 0; i < this.headerNames.length && !this.headerNames[i].equals(key); ++i) {
            }
            if (i < this.headerNames.length) {
                return i;
            }
            return -1;
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.canEdit[columnIndex];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.tableModel.getValueAt(this.rows[row].index, col);
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            this.tableModel.setValueAt(obj, this.rows[row].index, col);
            this.fireTableChanged(new TableModelEvent(this, row, row, col));
        }

        @Override
        public int getRowCount() {
            return this.tableModel.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.tableModel.getColumnCount();
        }

        @Override
        public String getColumnName(int col) {
            return this.tableModel.getColumnName(col);
        }

        public int convertToViewerRow(int row) {
            if (row > -1 && row < this.rows.length) {
                return this.rows[row].index;
            }
            return -1;
        }

        private class Row
        implements Comparable {
            public int index;

            private Row() {
            }

            public int compareTo(Object other) {
                Row otherRow = (Row)other;
                Object myObject = SVMTableModel.this.tableModel.getValueAt(this.index, SVMTableModel.this.colToSort);
                Object otherObject = SVMTableModel.this.tableModel.getValueAt(otherRow.index, SVMTableModel.this.colToSort);
                if (myObject instanceof Comparable) {
                    return ((Comparable)myObject).compareTo(otherObject);
                }
                if (myObject instanceof Boolean) {
                    boolean myValue = (Boolean)myObject;
                    boolean otherValue = (Boolean)otherObject;
                    if (otherValue && !myValue) {
                        return 1;
                    }
                    if (!otherValue && myValue) {
                        return -1;
                    }
                    return 0;
                }
                return this.index - otherRow.index;
            }
        }
    }
}

