/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.surv;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.Expression;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.surv.SURVAlgorithmData;

public class SURVInfoViewer
extends ViewerAdapter
implements Serializable {
    private JComponent header;
    private JTextArea content;
    private SURVAlgorithmData resultData;

    public JTextArea getContent() {
        return this.content;
    }

    public SURVInfoViewer(SURVAlgorithmData data) {
        this.resultData = data;
        this.header = this.createHeader();
        this.content = this.createContent();
        this.setMaxWidth(this.content, this.header);
    }

    public SURVInfoViewer(JTextArea content) {
        this(content, true);
    }

    public SURVInfoViewer(JTextArea content, boolean clusterGenes) {
        this.header = this.createHeader();
        this.content = content;
        this.setMaxWidth(content, this.header);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.getContentComponent()});
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Survival Module Results</b></font></body></html>"), gbc);
        return panel;
    }

    private JTextArea createContent() {
        JTextArea area = new JTextArea(5, 80);
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer sb = new StringBuffer(92);
        if (this.resultData.isComparison()) {
            sb.append("\n\nKaplan-Meier Survival Comparison.\n");
            sb.append("\n");
            sb.append("Chi-squared: " + this.resultData.getChiSquare() + "\n");
            sb.append("p-value at 1 degree of freedom: " + this.resultData.getPValue() + "\n\n");
            if ((double)this.resultData.getPValue() < 0.05) {
                sb.append("Survival difference is significant at p-value cutoff of 0.05.\n");
            } else {
                sb.append("Survival difference is NOT significant at p-value cutoff of 0.05.\n");
            }
            if ((double)this.resultData.getPValue() < 0.01) {
                sb.append("Survival difference is significant at p-value cutoff of 0.01.\n");
            } else {
                sb.append("Survival difference is NOT significant at p-value cutoff of 0.01.\n");
            }
            sb.append("\n");
            sb.append("Cluster\tMedian\tSize\tObserved\tExpected\n");
            for (int i = 0; i < this.resultData.getExpected().size(); ++i) {
                sb.append(i + 1 + "\t" + this.resultData.getSizes().get(i) + "\t" + this.resultData.getMedians().get(i) + "\t" + this.resultData.getObserved().get(i) + "\t" + this.resultData.getExpected().get(i) + "\n");
            }
        } else {
            int nonzero = 0;
            Vector<Double> temp = this.resultData.getPenalizedCoefficients();
            for (int i = 0; i < temp.size(); ++i) {
                if (temp.get(i) == 0.0) continue;
                ++nonzero;
            }
            sb.append("\n\nCox Proportional Hazard Model. L1 Norm penalty applied for variable selection. \n");
            sb.append("\n");
            sb.append("Lambda Penalty:" + this.resultData.getL1penalty() + " at lambda = " + this.resultData.getLambda() + "\n");
            sb.append("Model log Likelihood:" + this.resultData.getlogLikelihood() + "\n");
            sb.append("Model log Likelihood, calculated by cross-validation:" + this.resultData.getCrossValLik() + "\n");
            sb.append("Coefficients calculated for " + temp.size() + " input genes. " + nonzero + " were non-zero.");
        }
        area.setText(sb.toString());
        area.setCaretPosition(0);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }
}

