/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.surv;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.KMGraphViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.surv.BasehazGraphViewer;
import org.tigr.microarray.mev.cluster.gui.impl.surv.SURVAlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.surv.SURVCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.surv.SURVCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.surv.SURVExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.surv.SURVExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.surv.SURVExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.surv.SURVExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.surv.SURVInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.surv.SURVInitBox;
import org.tigr.util.FloatMatrix;

public class SURVGUI
implements IClusterGUI {
    protected Algorithm algorithm;
    protected Progress progress;
    protected Experiment experiment;
    protected int[][] clusters;
    protected FloatMatrix means;
    protected FloatMatrix variances;
    protected float[][] geneGroupMeans;
    protected float[][] geneGroupSDs;
    protected boolean drawSigTreesOnly;
    Vector<String> exptNamesVector;
    protected int[] groupAssignments;
    protected IData data;
    protected int numGroups;
    protected int numFactorAGroups;
    protected int numFactorBGroups;
    protected boolean isHierarchicalTree;
    protected String[] auxTitles;
    protected Object[][] auxData;
    protected ArrayList<String> geneLabels;
    protected ArrayList<String> sampleLabels;
    Vector<Vector<Float>> timeses = new Vector();
    Vector<Vector<Boolean>> statuses = new Vector();
    Vector<Color> colors = new Vector();
    String statusAnnotationField;
    String eventAnnotationField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        IDistanceMenu menu;
        int function;
        if (this.sysMsg() != 0) {
            return null;
        }
        this.experiment = framework.getData().getExperiment();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int[] columnIndices = this.experiment.getColumnIndicesCopy();
        this.data = framework.getData();
        Vector sampleFieldNames = this.data.getSampleAnnotationFieldNames();
        this.exptNamesVector = new Vector();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(columnIndices[i]));
        }
        SURVInitBox survDialog = new SURVInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1), framework.getClusterRepository(0), this.data, sampleFieldNames);
        survDialog.setVisible(true);
        if (!survDialog.isOkPressed()) {
            return null;
        }
        this.isHierarchicalTree = survDialog.drawTrees();
        this.drawSigTreesOnly = true;
        if (this.isHierarchicalTree) {
            this.drawSigTreesOnly = survDialog.drawSigTreesOnly();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 4;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        boolean hcl_samples_ordered = false;
        boolean hcl_genes_ordered = false;
        if (this.isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
            hcl_genes_ordered = hcl_dialog.isGeneOrdering();
            hcl_samples_ordered = hcl_dialog.isSampleOrdering();
        }
        Listener listener = new Listener();
        try {
            int i;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("SURV");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Running Survival Analysis", listener);
            this.progress.setIndeterminate(true);
            this.progress.setIndeterminantString("Preparing Data");
            this.progress.show();
            SURVAlgorithmData algData = new SURVAlgorithmData();
            this.statusAnnotationField = survDialog.getCensoredField();
            this.eventAnnotationField = survDialog.getSurvivalField();
            Color[] colorlist = new Color[]{Color.red, Color.green, Color.blue};
            int designType = survDialog.getExperimentalDesign();
            boolean comparison = true;
            if (designType == 1) {
                comparison = false;
            }
            System.out.println("Comparison: " + comparison);
            algData.setComparison(comparison);
            if (algData.isComparison()) {
                this.progress.setIndeterminantString("Comparing Survival Profiles");
                this.numGroups = survDialog.getNumGroups();
                this.numFactorAGroups = survDialog.getNumFactorAGroups();
                this.numFactorBGroups = survDialog.getNumFactorBGroups();
                this.groupAssignments = survDialog.getGroupAssignments();
                if (this.groupAssignments == null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = null;
                    return defaultMutableTreeNode;
                }
                Hashtable temp = new Hashtable();
                for (int i2 = 0; i2 < this.groupAssignments.length; ++i2) {
                    if (!temp.containsKey(new Integer(this.groupAssignments[i2]))) {
                        temp.put(new Integer(this.groupAssignments[i2]), new Vector());
                    }
                    ((Vector)temp.get(new Integer(this.groupAssignments[i2]))).add(new Integer(i2));
                }
                Hashtable timeshash = new Hashtable();
                Hashtable statushash = new Hashtable();
                Hashtable origIndexeshash = new Hashtable();
                for (int i3 = 0; i3 < this.groupAssignments.length; ++i3) {
                    if (!timeshash.containsKey(this.groupAssignments[i3])) {
                        timeshash.put(this.groupAssignments[i3], new Vector());
                        statushash.put(this.groupAssignments[i3], new Vector());
                        origIndexeshash.put(this.groupAssignments[i3], new Vector());
                        this.colors.add(colorlist[this.groupAssignments[i3]]);
                    }
                    float thistime = this.parseEventTime(this.data.getSampleAnnotation(i3, this.eventAnnotationField));
                    boolean thisstatus = this.parseStatus(this.data.getSampleAnnotation(i3, this.statusAnnotationField));
                    ((Vector)timeshash.get(this.groupAssignments[i3])).add(Float.valueOf(thistime));
                    ((Vector)statushash.get(this.groupAssignments[i3])).add(thisstatus);
                    ((Vector)origIndexeshash.get(this.groupAssignments[i3])).add(new Integer(i3));
                }
                this.timeses = new Vector(timeshash.values());
                this.statuses = new Vector(statushash.values());
                Vector indexes = new Vector(origIndexeshash.values());
                algData.setGroup1Events(this.timeses.get(0));
                algData.setGroup2Events(this.timeses.get(1));
                algData.setGroup1Statuses(this.statuses.get(0));
                algData.setGroup2Statuses(this.statuses.get(1));
                algData.setGroup1OriginalIndexes((Vector)indexes.get(0));
                algData.setGroup2OriginalIndexes((Vector)indexes.get(1));
                this.clusters = new int[temp.size()][];
                for (int i4 = 0; i4 < temp.size(); ++i4) {
                    this.clusters[i4] = new int[((Vector)temp.get(i4)).size()];
                    for (int j = 0; j < this.clusters[i4].length; ++j) {
                        this.clusters[i4][j] = (Integer)((Vector)temp.get(i4)).get(j);
                    }
                }
            } else {
                this.progress.setIndeterminantString("Calclating Cox Proportional Hazards Model");
                Vector<Float> times = new Vector<Float>();
                Vector<Boolean> statuses = new Vector<Boolean>();
                Vector<Integer> indexes = new Vector<Integer>();
                for (int i5 = 0; i5 < this.data.getExperiment().getNumberOfSamples(); ++i5) {
                    times.add(Float.valueOf(this.parseEventTime(this.data.getSampleAnnotation(i5, this.eventAnnotationField))));
                    statuses.add(this.parseStatus(this.data.getSampleAnnotation(i5, this.statusAnnotationField)));
                    indexes.add(new Integer(i5));
                }
                algData.setGroup1Events(times);
                algData.setGroup1Statuses(statuses);
                algData.setGroup1OriginalIndexes(indexes);
                algData.setGroup2Events(new Vector<Float>());
                algData.setGroup2Statuses(new Vector<Boolean>());
                algData.setGroup2OriginalIndexes(new Vector<Integer>());
                algData.setSampleLabels(this.exptNamesVector.toArray(new String[this.exptNamesVector.size()]));
                Cluster selectedGenes = survDialog.getSelectedGeneCluster();
                if (selectedGenes == null) {
                    algData.setGeneIndices(this.experiment.getRows());
                    algData.setExpressionMatrix(this.experiment.getMatrix());
                } else {
                    algData.setGeneIndices(selectedGenes.getIndices());
                    algData.setExpressionMatrix(this.experiment.getMatrix().getMatrix(selectedGenes.getIndices(), this.experiment.getColumnIndicesCopy()));
                }
                System.out.println("Setting lambda " + survDialog.getLambda());
                algData.setLambda(survDialog.getLambda());
            }
            if (this.isHierarchicalTree) {
                algData.addParam("hierarchical-tree", String.valueOf(true));
                algData.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                algData.addParam("method-linkage", String.valueOf(hcl_method));
                algData.addParam("calculate-genes", String.valueOf(hcl_genes));
                algData.addParam("calculate-experiments", String.valueOf(hcl_samples));
                algData.addParam("hcl-distance-function", String.valueOf(hcl_function));
                algData.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
                algData.addParam("hcl-genes-ordered", String.valueOf(hcl_genes_ordered));
                algData.addParam("hcl-samples-ordered", String.valueOf(hcl_samples_ordered));
            }
            long start = System.currentTimeMillis();
            SURVAlgorithmData result = (SURVAlgorithmData)this.algorithm.execute((AlgorithmData)algData);
            long time = System.currentTimeMillis() - start;
            GeneralInfo info = new GeneralInfo();
            info.result = result;
            if (result.isEmptyResults()) {
                DefaultMutableTreeNode j = this.createEmptyResultNode(result, info, "No results found.");
                return j;
            }
            this.progress.setIndeterminantString("Retrieving Data");
            if (result.isComparison()) {
                this.auxTitles = new String[]{"Linear Predictors", "Residuals"};
                this.auxData = new Object[this.experiment.getNumberOfSamples()][this.auxTitles.length];
                for (int i6 = 0; i6 < this.auxData.length; ++i6) {
                    int j = result.getResidualsNames().indexOf(new Integer(i6).toString());
                    if (j >= 0) {
                        this.auxData[i6][0] = result.getLinearPredictors().get(j);
                        this.auxData[i6][1] = result.getResiduals().get(j);
                        continue;
                    }
                    this.auxData[i6][0] = "N/A";
                    this.auxData[i6][1] = "N/A";
                }
                info.chisquare = result.getChiSquare();
                info.pvalue = result.getPValue();
                Vector<Double> expected = result.getExpected();
                Vector<Double> observed = result.getObserved();
                Vector<Integer> sizes = result.getSizes();
                info.cluster1expected = expected.get(0).floatValue();
                info.cluster2expected = expected.get(1).floatValue();
                info.cluster1observed = observed.get(0).floatValue();
                info.cluster2observed = observed.get(1).floatValue();
                info.cluster1size = sizes.get(0);
                info.cluster2size = sizes.get(1);
                info.hcl = this.isHierarchicalTree;
                info.hcl_genes = hcl_genes;
                info.hcl_samples = hcl_samples;
                info.hcl_method = hcl_method;
                DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(info);
                return defaultMutableTreeNode;
            }
            Vector<Double> penalizedCoefficients = result.getPenalizedCoefficients();
            this.clusters = result.getResClusters();
            int[] penalizedCoefficientsIndexes = result.getPenalizedCoefficientIndexes();
            this.auxTitles = new String[]{"Coefficient", "Weights"};
            Vector<Double> weights = result.getWeights();
            this.auxData = new Object[this.experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i = 0; i < this.auxData.length; ++i) {
                this.auxData[i][0] = new Double(0.0);
                this.auxData[i][1] = "NA";
            }
            for (i = 0; i < penalizedCoefficientsIndexes.length; ++i) {
                this.auxData[penalizedCoefficientsIndexes[i]][0] = penalizedCoefficients.get(i);
            }
            int[] selectedIndices = algData.getGeneIndices();
            for (int i7 = 0; i7 < selectedIndices.length; ++i7) {
                this.auxData[selectedIndices[i7]][1] = weights.get(i7);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(info);
            return defaultMutableTreeNode;
        }
        catch (Exception e) {
            e.printStackTrace();
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    protected DefaultMutableTreeNode createEmptyResultNode(AlgorithmData result, GeneralInfo info, String label) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(label);
        root.add(new DefaultMutableTreeNode("No Results Found"));
        this.addGeneralInfo(root, info);
        return root;
    }

    private boolean parseStatus(String statusString) {
        if (statusString.equalsIgnoreCase("yes") || statusString.equalsIgnoreCase("y") || statusString.equalsIgnoreCase("censored")) {
            return true;
        }
        if (statusString.equalsIgnoreCase("no") || statusString.equalsIgnoreCase("n") || statusString.equalsIgnoreCase("dead") || statusString.equalsIgnoreCase("uncensored")) {
            return false;
        }
        return false;
    }

    private float parseEventTime(String eventString) {
        return new Float(eventString).floatValue();
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        IDistanceMenu menu;
        int function;
        this.experiment = framework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        Vector sampleFieldNames = this.data.getSampleAnnotationFieldNames();
        SURVInitBox SURVDialog = new SURVInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1), framework.getClusterRepository(0), this.data, sampleFieldNames);
        SURVDialog.setVisible(true);
        if (!SURVDialog.isOkPressed()) {
            return null;
        }
        int dataDesign = SURVDialog.getExperimentalDesign();
        this.numGroups = SURVDialog.getNumGroups();
        this.groupAssignments = SURVDialog.getGroupAssignments();
        if (this.groupAssignments == null) {
            return null;
        }
        boolean isHierarchicalTree = SURVDialog.drawTrees();
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = SURVDialog.drawSigTreesOnly();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 4;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        AlgorithmData data = new AlgorithmData();
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
        data.addParam("distance-function", String.valueOf(function));
        data.addIntArray("group_assignments", this.groupAssignments);
        data.addParam("alpha-value", String.valueOf(SURVDialog.mPanel.alpha));
        data.addParam("numGroups", String.valueOf(this.numGroups));
        if (isHierarchicalTree) {
            data.addParam("hierarchical-tree", String.valueOf(true));
            data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
            data.addParam("method-linkage", String.valueOf(hcl_method));
            data.addParam("calculate-genes", String.valueOf(hcl_genes));
            data.addParam("calculate-experiments", String.valueOf(hcl_samples));
            data.addParam("hcl-distance-function", String.valueOf(hcl_function));
            data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
        }
        data.addParam("name", "SURV");
        data.addParam("alg-type", "cluster-genes");
        data.addParam("output-class", "partition-output");
        String[] outputNodes = new String[]{"Group 1", "Group 2"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    public static void main(String[] args) {
    }

    protected String getNodeTitle(int ind, int x, int y) {
        if (ind == 0) {
            return "Neither group";
        }
        if (ind == 1) {
            return "Group 2 Samples";
        }
        if (ind == 2) {
            return "Group 1 Samples";
        }
        return "Neither group";
    }

    protected DefaultMutableTreeNode createResultTree(GeneralInfo info) {
        if (info.result.isComparison()) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Survival Comparison");
            this.addKMPlots(root);
            this.addSurvInfo(root, info);
            this.addExpressionImages(root);
            this.addExperimentCentroidViews(root);
            this.addExperimentTableViews(root);
            this.addGeneralInfo(root, info);
            return root;
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Survival Model");
        this.addSurvInfo(root, info);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        SURVExperimentViewer expViewer = new SURVExperimentViewer(this.experiment, this.clusters, (float[][])null, (float[][])null, null, null, null, null, null, null, null);
        node.add(new DefaultMutableTreeNode(new LeafInfo("Informative Genes", (IViewer)expViewer, (Object)new Integer(0))));
        node.add(new DefaultMutableTreeNode(new LeafInfo("Non-informative Genes", (IViewer)expViewer, (Object)new Integer(1))));
        root.add(node);
        this.addCentroidViews(root);
        this.addGeneTableViews(root);
        this.addBaseHazGraph(root, info);
        this.addGeneralInfo(root, info);
        return root;
    }

    protected void addBaseHazGraph(DefaultMutableTreeNode root, GeneralInfo info) {
        info.result.getBasehazplotx();
        info.result.getBasehazploty();
        BasehazGraphViewer centroidViewer = new BasehazGraphViewer(info.result.getBasehazplotx(), info.result.getBasehazploty(), this.eventAnnotationField);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Baseline Hazard Plot ", (IViewer)centroidViewer, (Object)new CentroidUserObject(1, 1))));
        Vector<Double> baselineSurvival = info.result.getBasesurvSurvival();
        Vector<Double> baselineSurvivalTime = info.result.getBasesurvTime();
        Vector<Float> times1 = new Vector<Float>();
        Vector<Float> times2 = new Vector<Float>();
        float[][] datapoints = new float[2][baselineSurvival.size()];
        for (int i = 0; i < baselineSurvival.size(); ++i) {
            datapoints[0][i] = new Float(baselineSurvivalTime.get(i)).floatValue();
            datapoints[1][i] = new Float(baselineSurvival.get(i)).floatValue();
            times1.add(new Float(baselineSurvivalTime.get(i)));
            times2.add(new Float(baselineSurvival.get(i)));
        }
        Vector<Vector<Float>> temp = new Vector<Vector<Float>>();
        temp.add(times1);
        temp.add(times2);
        Vector<Color> colors = new Vector<Color>();
        colors.add(Color.black);
        KMGraphViewer kmViewer = new KMGraphViewer(temp, colors, this.eventAnnotationField);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Kaplan-Meier Plot ", (IViewer)kmViewer, null)));
    }

    protected void addSurvInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        Vector<Float> expected = new Vector<Float>(2);
        expected.add(new Float(info.cluster1expected));
        expected.add(new Float(info.cluster2expected));
        Vector<Float> observed = new Vector<Float>(2);
        observed.add(new Float(info.cluster1observed));
        observed.add(new Float(info.cluster2observed));
        Vector<Integer> sizes = new Vector<Integer>(2);
        sizes.add(new Integer(info.cluster1size));
        sizes.add(new Integer(info.cluster2size));
        SURVInfoViewer survViewer = new SURVInfoViewer(info.result);
        String infonodeTitle = info.result.isComparison() ? "Differential Survival" : "Cox Proportional Hazard Model";
        root.add(new DefaultMutableTreeNode(new LeafInfo(infonodeTitle, (IViewer)survViewer)));
    }

    protected void addExperimentTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table Views");
        ExperimentClusterTableViewer tabViewer = new ExperimentClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i == 0) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Not in Group", (IViewer)tabViewer, (Object)new Integer(i))));
                continue;
            }
            node.add(new DefaultMutableTreeNode(new LeafInfo("Group " + i, (IViewer)tabViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    protected void addGeneTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table Views");
        ClusterTableViewer tabViewer = new ClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
        node.add(new DefaultMutableTreeNode(new LeafInfo("Informative Genes", (IViewer)tabViewer, (Object)new Integer(0))));
        node.add(new DefaultMutableTreeNode(new LeafInfo("Non-informative Genes", (IViewer)tabViewer, (Object)new Integer(1))));
        root.add(node);
    }

    protected void addKMPlots(DefaultMutableTreeNode root) {
        Vector<Vector<Float>> timeses = new Vector<Vector<Float>>();
        timeses.add(this.timeses.get(0));
        timeses.add(this.timeses.get(1));
        Vector<Vector<Boolean>> statuses = new Vector<Vector<Boolean>>();
        statuses.add(this.statuses.get(0));
        statuses.add(this.statuses.get(1));
        KMGraphViewer kmViewer = new KMGraphViewer(timeses, statuses, this.colors, this.eventAnnotationField);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Kaplan-Meier Plot", (IViewer)kmViewer)));
    }

    protected void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        SURVExperimentClusterViewer expViewer = new SURVExperimentClusterViewer(this.experiment, this.clusters);
        int x = 1;
        int y = 2;
        for (int i = 0; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo(this.getNodeTitle(i, x, y), (IViewer)expViewer, (Object)new Integer(i))));
            if (i % 2 == 1) {
                ++y;
            }
            if (y <= this.numGroups) continue;
            y = ++x + 1;
        }
        root.add(node);
    }

    protected IViewer createHCLViewer(Node clusterNode, GeneralInfo info) {
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData samples_result = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
    }

    protected HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    protected void addExperimentCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        SURVExperimentCentroidViewer centroidViewer = new SURVExperimentCentroidViewer(this.experiment, this.clusters);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i == 0) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Group 1 Samples ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Group 1 Samples ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                continue;
            }
            if (i != 1) continue;
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Group 2 Samples ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Group 2 Samples ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
        }
        SURVExperimentCentroidsViewer centroidsViewer = new SURVExperimentCentroidsViewer(this.experiment, this.clusters);
        centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Samples", (IViewer)centroidsViewer, (Object)new Integer(0))));
        expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Samples", (IViewer)centroidsViewer, (Object)new Integer(1))));
        root.add(centroidNode);
        root.add(expressionNode);
    }

    protected void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        SURVCentroidViewer centroidViewer = new SURVCentroidViewer(this.experiment, this.clusters);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i == 0) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Informative Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Informative Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                continue;
            }
            if (i != 1) continue;
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-informative Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-informative Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
        }
        SURVCentroidsViewer centroidsViewer = new SURVCentroidsViewer(this.experiment, this.clusters);
        centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(0))));
        expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(1))));
        root.add(centroidNode);
        root.add(expressionNode);
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        if (this.isHierarchicalTree) {
            node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        }
        if (info.result.isComparison()) {
            node.add(new DefaultMutableTreeNode("Kaplan-Meier Survival Comparison"));
            if (!info.result.isEmptyResults()) {
                node.add(new DefaultMutableTreeNode("Chi-square: " + info.chisquare));
                node.add(new DefaultMutableTreeNode("p-value: " + info.pvalue));
                node.add(new DefaultMutableTreeNode("Coefficient: " + info.result.getCoefficient()));
            }
            node.add(this.getGroupAssignmentInfo());
        } else {
            node.add(new DefaultMutableTreeNode("Cox Proportional Hazards Model"));
            if (!info.result.isEmptyResults()) {
                node.add(new DefaultMutableTreeNode("L1 Penalty: " + info.result.getL1penalty()));
                node.add(new DefaultMutableTreeNode("lambda start value: " + info.result.getLambda()));
            } else {
                node.add(new DefaultMutableTreeNode("No non-zero coefficients calculated."));
            }
        }
        root.add(node);
    }

    protected DefaultMutableTreeNode getGroupAssignmentInfo() {
        int i;
        DefaultMutableTreeNode groupAssignmentInfo = new DefaultMutableTreeNode("Group assignments ");
        DefaultMutableTreeNode notInGroups = new DefaultMutableTreeNode("Not in groups");
        DefaultMutableTreeNode[] groups = new DefaultMutableTreeNode[this.numGroups];
        for (i = 0; i < this.numGroups; ++i) {
            groups[i] = new DefaultMutableTreeNode("Group " + (i + 1));
        }
        for (i = 0; i < this.groupAssignments.length; ++i) {
            int currentGroup = this.groupAssignments[i];
            if (currentGroup == 0) {
                notInGroups.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                continue;
            }
            groups[currentGroup - 1].add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
        }
        for (i = 0; i < groups.length; ++i) {
            groupAssignmentInfo.add(groups[i]);
        }
        if (notInGroups.getChildCount() > 0) {
            groupAssignmentInfo.add(notInGroups);
        }
        return groupAssignmentInfo;
    }

    private int sysMsg() {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String ver = System.getProperty("os.version");
        String message = "System Config:\n";
        message = message + "OS: " + os + " | Architecture: " + arch + " | Version: " + ver + "\n";
        message = message + "Please note:\n";
        if (arch.toLowerCase().contains("64") && os.toLowerCase().contains("mac")) {
            message = message + "You need to have 32Bit JVM as default for LIMMA\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "You also need to have R 2.9.x installed for LIMMA\n";
            message = message + "Cancel if either is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (arch.toLowerCase().contains("64")) {
            message = message + "You need to have 32Bit JVM as default for LIMMA\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "Cancel if 32 Bit JVM is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (os.toLowerCase().contains("mac")) {
            message = message + "You need to have R 2.9.x installed for LIMMA\n";
            message = message + "Cancel if R is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        return 0;
    }

    protected class GeneralInfo {
        public SURVAlgorithmData result;
        public float cluster1observed;
        public float cluster2observed;
        public float cluster1expected;
        public float cluster2expected;
        public int cluster1size;
        public int cluster2size;
        public float chisquare;
        public float pvalue;
        protected boolean hcl;
        protected boolean usePerms;
        protected int hcl_method;
        protected int numPerms;
        protected boolean hcl_genes;
        protected boolean hcl_samples;

        protected GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        protected Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    SURVGUI.this.progress.setUnits(event.getIntValue());
                    SURVGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    SURVGUI.this.progress.setValue(event.getIntValue());
                    SURVGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                SURVGUI.this.algorithm.abort();
                SURVGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SURVGUI.this.algorithm.abort();
            SURVGUI.this.progress.dispose();
        }
    }
}

