/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.surv;

import java.util.Vector;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.util.FloatMatrix;

public class SURVAlgorithmData
extends AlgorithmData {
    private static final String CROSS_VALIDATION_LIKELIHOOD = "cross-validation-likelihood";
    private static final String LAMBDA_START = "lambda-start";
    private static final String IS_EMPTY = "is-empty";
    private static final String COEFFICIENT_INDICES = "zeroed-indices";
    private static final String IS_COMPARISON = "is-comparison";
    private static final String PENALIZED_COEFFICIENTS = "penalized-coefficients";
    private static final String UNPENALIZED_COEFFICIENTS = "unpenalized-coefficients";
    private static final String BASESURV_SURVIVAL = "basesurvSurvival";
    private static final String BASESURV_TIME = "basesurvTime";
    private static final String BASEHAZPLOTX = "basehazplotx";
    private static final String BASEHAZPLOTY = "basehazploty";
    private static final String FITTED_VALUES = "fittedValues";
    private static final String CURVESURVIVAL = "curvesurvival";
    private static final String CURVETIME = "curvetime";
    private static final String NAMES = "residualsNames";
    private static final String LOG_LIKELIHOOD = "logLikelihood";
    private static final String L1PENALTY = "l1penalty";
    private static final String L2PENALTY = "l2penalty";
    private static final String GENE_INDICES = "geneIndices";
    private static final String EXPERIMENT = "experiment";
    private static final String COEFFICIENT = "coefficient";
    private static final String VARIANCE = "variance";
    private static final String INITIALLOGLIK = "initialloglik";
    private static final String FINALLOGLIK = "finalloglik";
    private static final String NATIVEVAR = "nativevar";
    private static final String SCORE = "score";
    private static final String RSCORE = "rscore";
    private static final String WALDTEST = "waldtest";
    private static final String MEAN = "mean";
    private static final String NUMBER = "number";
    private static final String WEIGHTS = "weights";
    private static final String METHOD = "method";
    private static final String LINEAR_PREDICTORS = "linearPredictors";
    private static final String RESIDUALS = "residuals";
    private static final String RESIDUALS_NAMES = "residualsNames";
    private static final String ITERATION_COUNT = "iteration-count";
    private static final String P_VALUE = "p-value";
    private static final String CHI_SQUARED = "chi-squared";
    private static final String EXPECTED = "expected";
    private static final String OBSERVED = "observed";
    private static final String SIZES = "group-sizes";
    private static final String EVENT_TIMES1 = "event-times1";
    private static final String EVENT_TIMES2 = "event-times2";
    private static final String MED_SURVIVAL = "median-survival-times";
    private static final String EVENT_STATUSES1 = "event-statuses1";
    private static final String EVENT_STATUSES2 = "event-statuses2";
    private static final String SAMPLE_LABELS = "sample-labels";
    private static final String ORIGINAL_INDICES_1 = "original-indices-1";
    private static final String ORIGINAL_INDICES_2 = "original-indices-2";

    public void setPValue(float pvalue) {
        this.addParam(P_VALUE, new Float(pvalue).toString());
    }

    public float getPValue() {
        return this.getParams().getFloat(P_VALUE);
    }

    public float getChiSquare() {
        return this.getParams().getFloat(CHI_SQUARED);
    }

    public void setChiSquare(float chisq) {
        this.addParam(CHI_SQUARED, new Double(chisq).toString());
    }

    public void setExpected(double[] expected) {
        this.addVector(EXPECTED, this.doubleArrayToVector(expected));
    }

    public Vector<Double> getExpected() {
        return this.getVector(EXPECTED);
    }

    public void setObserved(double[] observed) {
        this.addVector(OBSERVED, this.doubleArrayToVector(observed));
    }

    public Vector<Double> getObserved() {
        return this.getVector(OBSERVED);
    }

    public void setSizes(int[] sizes) {
        Vector<Integer> sizesv = new Vector<Integer>();
        for (int i = 0; i < sizes.length; ++i) {
            sizesv.add(sizes[i]);
        }
        this.addVector(SIZES, sizesv);
    }

    public Vector<Integer> getSizes() {
        return this.getVector(SIZES);
    }

    public void setGroup1OriginalIndexes(Vector<Integer> indexes) {
        this.addVector(ORIGINAL_INDICES_1, indexes);
    }

    public Vector<Integer> getGroup1OriginalIndexes() {
        return this.getVector(ORIGINAL_INDICES_1);
    }

    public void setGroup2OriginalIndexes(Vector<Integer> indexes) {
        this.addVector(ORIGINAL_INDICES_2, indexes);
    }

    public Vector<Integer> getGroup2OriginalIndexes() {
        return this.getVector(ORIGINAL_INDICES_2);
    }

    public void setGroup1Events(Vector<Float> times) {
        this.addVector(EVENT_TIMES1, times);
    }

    public Vector<Float> getGroup1Events() {
        return this.getVector(EVENT_TIMES1);
    }

    public void setGroup2Events(Vector<Float> times) {
        this.addVector(EVENT_TIMES2, times);
    }

    public Vector<Float> getGroup2Events() {
        return this.getVector(EVENT_TIMES2);
    }

    public void setGroup1Statuses(Vector<Boolean> statuses) {
        this.addVector(EVENT_STATUSES1, statuses);
    }

    public Vector<Boolean> getGroup1Statuses() {
        return this.getVector(EVENT_STATUSES1);
    }

    public void setGroup2Statuses(Vector<Boolean> statuses) {
        this.addVector(EVENT_STATUSES2, statuses);
    }

    public Vector<Boolean> getGroup2Statuses() {
        return this.getVector(EVENT_STATUSES2);
    }

    public Double getCoefficient() {
        return new Double(this.getParams().getDouble(COEFFICIENT));
    }

    public void setCoefficient(double c) {
        this.getParams().setProperty(COEFFICIENT, new Double(c).toString());
    }

    public Double getVariance() {
        return new Double(this.getParams().getDouble(VARIANCE));
    }

    public void setVariance(double c) {
        this.getParams().setProperty(VARIANCE, new Double(c).toString());
    }

    public Double getInitialLogLik() {
        return new Double(this.getParams().getDouble(INITIALLOGLIK));
    }

    public void setInitialLogLik(double c) {
        this.getParams().setProperty(INITIALLOGLIK, new Double(c).toString());
    }

    public Double getFinalLogLik() {
        return new Double(this.getParams().getDouble(FINALLOGLIK));
    }

    public void setFinalLogLik(double c) {
        this.getParams().setProperty(FINALLOGLIK, new Double(c).toString());
    }

    public Double getNativeVar() {
        return new Double(this.getParams().getDouble(NATIVEVAR));
    }

    public void setNativeVar(double c) {
        this.getParams().setProperty(NATIVEVAR, new Double(c).toString());
    }

    public Double getScore() {
        return new Double(this.getParams().getDouble(SCORE));
    }

    public void setScore(double c) {
        this.getParams().setProperty(SCORE, new Double(c).toString());
    }

    public Double getRScore() {
        return new Double(this.getParams().getDouble(RSCORE));
    }

    public void setRScore(double c) {
        this.getParams().setProperty(RSCORE, new Double(c).toString());
    }

    public Double getWaldTest() {
        return new Double(this.getParams().getDouble(WALDTEST));
    }

    public void setWaldTest(double c) {
        this.getParams().setProperty(WALDTEST, new Double(c).toString());
    }

    public Double getMean() {
        return new Double(this.getParams().getDouble(MEAN));
    }

    public void setMean(double c) {
        this.getParams().setProperty(MEAN, new Double(c).toString());
    }

    public Double getNumber() {
        return new Double(this.getParams().getDouble(NUMBER));
    }

    public void setNumber(double c) {
        this.getParams().setProperty(NUMBER, new Double(c).toString());
    }

    public Vector<Double> getWeights() {
        return this.getVector(WEIGHTS);
    }

    public void setWeights(double[] c) {
        if (c != null) {
            this.addVector(WEIGHTS, this.doubleArrayToVector(c));
        }
    }

    public String getMethod() {
        return this.getParams().getString(METHOD);
    }

    public void setMethod(String c) {
        this.getParams().setProperty(METHOD, c);
    }

    public void setLinearPredictors(double[] linearPredictors) {
        this.addVector(LINEAR_PREDICTORS, this.doubleArrayToVector(linearPredictors));
    }

    public Vector<Double> getLinearPredictors() {
        return this.getVector(LINEAR_PREDICTORS);
    }

    public void setResiduals(double[] residuals) {
        this.addVector(RESIDUALS, this.doubleArrayToVector(residuals));
    }

    public Vector<Double> getResiduals() {
        return this.getVector(RESIDUALS);
    }

    public void setResidualsNames(String[] residuals) {
        this.addVector("residualsNames", this.stringArrayToVector(residuals));
    }

    public Vector<String> getResidualsNames() {
        return this.getVector("residualsNames");
    }

    public void setIterationCount(int iterationcount) {
        this.addParam(ITERATION_COUNT, new Integer(iterationcount).toString());
    }

    public float getIterationCount() {
        return this.getParams().getInt(ITERATION_COUNT);
    }

    public FloatMatrix getExpressionMatrix() {
        return this.getMatrix(EXPERIMENT);
    }

    public void setExpressionMatrix(FloatMatrix fm) {
        this.addMatrix(EXPERIMENT, fm);
    }

    public int[] getGeneIndices() {
        return this.getIntArray(GENE_INDICES);
    }

    public void setGeneIndices(int[] gl) {
        this.addIntArray(GENE_INDICES, gl);
    }

    public String[] getSampleLabels() {
        return this.getStringArray(SAMPLE_LABELS);
    }

    public void setSampleLabels(String[] gl) {
        this.addStringArray(SAMPLE_LABELS, gl);
    }

    public boolean isComparison() {
        return this.getParams().getBoolean(IS_COMPARISON);
    }

    public void setComparison(boolean b) {
        this.addParam(IS_COMPARISON, new Boolean(b).toString());
    }

    public void setPenalizedCoefficients(double[] pc) {
        this.addVector(PENALIZED_COEFFICIENTS, this.doubleArrayToVector(pc));
    }

    public Vector<Double> getPenalizedCoefficients() {
        return this.getVector(PENALIZED_COEFFICIENTS);
    }

    public void setUnpenalizedCoefficients(double[] pc) {
        this.addVector(UNPENALIZED_COEFFICIENTS, this.doubleArrayToVector(pc));
    }

    public Vector<Double> getUnpenalizedCoefficients() {
        return this.getVector(UNPENALIZED_COEFFICIENTS);
    }

    public void setBasesurvTime(double[] pc) {
        this.addVector(BASESURV_TIME, this.doubleArrayToVector(pc));
    }

    public Vector<Double> getBasesurvTime() {
        return this.getVector(BASESURV_TIME);
    }

    public void setBasesurvSurvival(double[] pc) {
        this.addVector(BASESURV_SURVIVAL, this.doubleArrayToVector(pc));
    }

    public Vector<Double> getBasesurvSurvival() {
        return this.getVector(BASESURV_SURVIVAL);
    }

    public void setBasehazplotx(double[] pc) {
        this.addVector(BASEHAZPLOTX, this.doubleArrayToVector(pc));
    }

    public Vector<Double> getBasehazplotx() {
        return this.getVector(BASEHAZPLOTX);
    }

    public void setBasehazploty(double[] pc) {
        this.addVector(BASEHAZPLOTY, this.doubleArrayToVector(pc));
    }

    public Vector<Double> getBasehazploty() {
        return this.getVector(BASEHAZPLOTY);
    }

    public void setFittedValues(double[] pc) {
        this.addVector(FITTED_VALUES, this.doubleArrayToVector(pc));
    }

    public Vector<Double> getFittedValues() {
        return this.getVector(FITTED_VALUES);
    }

    public void setCurvesurvival(double[] pc) {
        this.addVector(CURVESURVIVAL, this.doubleArrayToVector(pc));
    }

    public Vector<Double> getCurvesurvival() {
        return this.getVector(CURVESURVIVAL);
    }

    public void setCurvetime(double[] pc) {
        this.addVector(CURVETIME, this.doubleArrayToVector(pc));
    }

    public Vector<Double> getCurvetime() {
        return this.getVector(CURVETIME);
    }

    public void setresidualsNames(String[] pc) {
        this.addVector("residualsNames", this.stringArrayToVector(pc));
    }

    public Vector<String> getresidualsNames() {
        return this.getVector("residualsNames");
    }

    public void setlogLikelihood(double pc) {
        this.addParam(LOG_LIKELIHOOD, new Double(pc).toString());
    }

    public double getlogLikelihood() {
        return this.getParams().getDouble(LOG_LIKELIHOOD);
    }

    public void setL1penalty(double pc) {
        this.addParam(L1PENALTY, new Double(pc).toString());
    }

    public double getL1penalty() {
        return new Double(this.getParams().getString(L1PENALTY));
    }

    public void setL2penalty(double pc) {
        this.addParam(L2PENALTY, new Double(pc).toString());
    }

    public double getL2penalty() {
        return new Double(this.getParams().getString(L2PENALTY));
    }

    public void setResClusters(int[][] clusters) {
        if (clusters != null && clusters.length > 0) {
            this.addIntMatrix("clusters", clusters);
        } else {
            this.addIntMatrix("clusters", new int[0][]);
        }
    }

    public int[][] getResClusters() {
        return this.getIntMatrix("clusters");
    }

    public void setPenalizedCoefficientIndexes(int[] indexes) {
        if (indexes != null && indexes.length > 0) {
            this.addIntArray(COEFFICIENT_INDICES, indexes);
        } else {
            System.out.println("Zeroed Indexes is null");
            this.addIntArray(COEFFICIENT_INDICES, new int[0]);
        }
    }

    public int[] getPenalizedCoefficientIndexes() {
        return this.getIntArray(COEFFICIENT_INDICES);
    }

    public boolean isEmptyResults() {
        return this.getParams().getBoolean(IS_EMPTY);
    }

    public void setEmptyResults(boolean b) {
        this.addParam(IS_EMPTY, new Boolean(b).toString());
    }

    public double getCrossValLik() {
        return Double.parseDouble(this.getParams().getString(CROSS_VALIDATION_LIKELIHOOD));
    }

    public void setCrossValLik(double crossValLik) {
        this.addParam(CROSS_VALIDATION_LIKELIHOOD, new Double(crossValLik).toString());
    }

    public Vector<Float> getMedians() {
        return this.getVector(MED_SURVIVAL);
    }

    public void setMedians(Vector<Float> medSurv) {
        this.addVector(MED_SURVIVAL, medSurv);
    }

    public double getLambda() {
        return Double.parseDouble(this.getParams().getString(LAMBDA_START));
    }

    public void setLambda(double lambda1) {
        this.addParam(LAMBDA_START, new Double(lambda1).toString());
    }

    private Vector<Double> doubleArrayToVector(double[] inarray) {
        Vector<Double> outvector = new Vector<Double>();
        for (int i = 0; i < inarray.length; ++i) {
            outvector.add(inarray[i]);
        }
        return outvector;
    }

    private Vector<String> stringArrayToVector(String[] inarray) {
        Vector<String> outvector = new Vector<String>();
        for (int i = 0; i < inarray.length; ++i) {
            outvector.add(inarray[i]);
        }
        return outvector;
    }
}

