/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.surv;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;

public class BasehazGraphViewer
extends JPanel
implements IViewer {
    BasehazGraph viewer;
    float minX;
    float maxX;
    float minY;
    float maxY;
    boolean firstView = true;
    DecimalFormat format;
    Vector<Double> time;
    Vector<Double> hazards;
    String eventAnnLabel;

    public BasehazGraphViewer(Vector<Double> xhazards, Vector<Double> yhazards, String eventAnnLabel) {
        this.time = xhazards;
        this.hazards = yhazards;
        this.eventAnnLabel = eventAnnLabel;
        this.initializeViewer();
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.time, this.hazards, this.eventAnnLabel});
    }

    private void initializeViewer() {
        this.minY = this.findMinDistance(this.time);
        this.maxY = this.findMaxDistance(this.time);
        this.minX = this.findMinDistance(this.hazards);
        this.maxX = this.findMaxDistance(this.hazards);
        this.viewer = new BasehazGraph();
        this.viewer.setYAxisValue(this.minY);
        this.viewer.setXAxisValue(this.minX);
        this.viewer.setShowCoordinates(true);
        assert (this.hazards.size() == this.time.size());
        this.enterGraphData(this.hazards, this.time);
    }

    private float findMinDistance(Vector<Double> timeses) {
        double min = Double.POSITIVE_INFINITY;
        for (int j = 0; j < timeses.size(); ++j) {
            min = Math.min(min, timeses.get(j));
        }
        return new Float(min).floatValue();
    }

    private float findMaxDistance(Vector<Double> timeses) {
        double max = 0.0;
        for (int j = 0; j < timeses.size(); ++j) {
            max = Math.max(max, timeses.get(j));
        }
        return new Float(max).floatValue();
    }

    private void enterGraphData(Vector<Double> basehazx, Vector<Double> basehazy) {
        int i;
        int numEvents = basehazy.size();
        for (i = 0; i < numEvents; ++i) {
            GraphPoint gp = new GraphPoint(basehazx.get(i).doubleValue(), basehazy.get(i).doubleValue());
            gp.setPointSize(5);
            this.viewer.addGraphElement((GraphElement)gp);
        }
        this.format = new DecimalFormat();
        this.format.setMaximumFractionDigits(2);
        for (i = 0; i <= 10; ++i) {
            if (this.minX >= 0.0f) {
                this.viewer.addGraphElement((GraphElement)new GraphTick((double)((this.maxX - this.minX) / 10.0f * (float)i), 5, Color.black, 0, 0, String.valueOf(this.format.format((this.maxX - this.minX) / 10.0f * (float)i)), Color.black));
            } else {
                this.viewer.addGraphElement((GraphElement)new GraphTick((double)(this.minX + (this.maxX - this.minX) / 10.0f * (float)i), 5, Color.black, 0, 0, String.valueOf(this.format.format(this.minX + (this.maxX - this.minX) / 10.0f * (float)i)), Color.black));
            }
            String temp = NumberFormat.getInstance().format(this.maxY / 10.0f * (float)i);
            this.viewer.addGraphElement((GraphElement)new GraphTick((double)(this.maxY / 10.0f * (float)i), 5, Color.black, 1, 0, temp, Color.black));
        }
    }

    private void printGraphData() {
        for (int i = 0; i < this.time.size(); ++i) {
            System.out.println(this.time.get(i) + "\t" + this.hazards.get(i));
        }
    }

    private void onSaveGraphData() {
        JFileChooser chooser = new JFileChooser(TMEV.getDataPath());
        if (chooser.showSaveDialog(this) == 0) {
            try {
                PrintWriter bw = new PrintWriter(new FileWriter(chooser.getSelectedFile()));
                bw.println("Baseline Hazard X\tBaseline Hazard Y");
                for (int i = 0; i < this.time.size(); ++i) {
                    bw.println(this.time.get(i) + "\t" + this.hazards.get(i));
                }
                bw.flush();
                bw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void onDeselected() {
    }

    public void onDataChanged(IData data) {
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this.viewer;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework framework) {
        if (this.firstView && this.viewer.isVisible()) {
            Graphics g = this.viewer.getGraphics();
            FontMetrics metrics = g.getFontMetrics(new Font("SansSerif", 1, 10));
            int preX = metrics.stringWidth(String.valueOf(this.format.format(this.maxX)));
            int preY = metrics.stringWidth(String.valueOf(this.format.format(this.maxY)));
            metrics = g.getFontMetrics(new Font("SansSerif", 1, 12));
            this.viewer.setPreXSpacing((preY += metrics.getHeight()) + 10);
            this.viewer.setPostYSpacing((preX += metrics.getHeight()) + 20);
            this.firstView = false;
        }
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public void setViewer(BasehazGraph val) {
        this.viewer = val;
    }

    public GraphViewer getViewer() {
        return this.viewer;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperimentID(int id) {
    }

    public int getViewerType() {
        return -1;
    }

    public class BasehazGraph
    extends GraphViewer {
        public BasehazGraph() {
            super(null, (int)BasehazGraphViewer.this.minX, (int)BasehazGraphViewer.this.maxX, (int)BasehazGraphViewer.this.minY, (int)BasehazGraphViewer.this.maxY, (double)BasehazGraphViewer.this.minX, (double)BasehazGraphViewer.this.maxX, (double)BasehazGraphViewer.this.minY, (double)BasehazGraphViewer.this.maxY, 50, 50, 50, 50, "Base Hazard", "Baseline Hazard", "Time (" + BasehazGraphViewer.this.eventAnnLabel + ")");
            JMenuItem dataOutputItem = new JMenuItem("Output Graph Data");
            dataOutputItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    BasehazGraphViewer.this.printGraphData();
                    BasehazGraphViewer.this.onSaveGraphData();
                }
            });
            this.popup.addSeparator();
            this.popup.add(dataOutputItem);
        }
    }
}

