/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.st;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.st.HCLSupportViewer;
import org.tigr.microarray.mev.cluster.gui.impl.st.ResampleTreeInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class STGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    boolean drawGeneTree;
    boolean drawExptTree;
    boolean optimizeGeneOrdering;
    boolean optimizeSampleOrdering;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        ResampleTreeInitDialog dialog = new ResampleTreeInitDialog((JFrame)framework.getFrame(), true, menu.getFunctionName(function), menu.isAbsoluteDistance());
        dialog.setVisible(true);
        if (dialog.isCancelled()) {
            return null;
        }
        int method = dialog.getMethod();
        this.drawGeneTree = dialog.drawGeneTreeCheckBox.isSelected();
        this.drawExptTree = dialog.drawExptTreeCheckBox.isSelected();
        int geneTreeAnalysisOption = dialog.getGeneTreeAnalysisOption();
        int exptTreeAnalysisOption = dialog.getExptTreeAnalysisOption();
        int geneTreeIterations = Integer.parseInt(dialog.geneTreeIterationsTextField.getText());
        int exptTreeIterations = Integer.parseInt(dialog.exptTreeIterationsTextField.getText());
        this.optimizeGeneOrdering = dialog.isOptimizeGenes();
        this.optimizeSampleOrdering = dialog.isOptimizeSamples();
        Listener listener = new Listener();
        try {
            Experiment experiment = framework.getData().getExperiment();
            AlgorithmFactory factory = framework.getAlgorithmFactory();
            this.algorithm = factory.getAlgorithm("ST");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", experiment.getMatrix());
            function = dialog.getDistanceMetric();
            data.addParam("distance-function", String.valueOf(function));
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("distance-absolute", String.valueOf(dialog.isAbsoluteDistance()));
            data.addParam("method-linkage", String.valueOf(method));
            data.addParam("geneTreeIterations", String.valueOf(geneTreeIterations));
            data.addParam("exptTreeIterations", String.valueOf(exptTreeIterations));
            data.addParam("geneTreeAnalysisOption", String.valueOf(geneTreeAnalysisOption));
            data.addParam("exptTreeAnalysisOption", String.valueOf(exptTreeAnalysisOption));
            data.addParam("optimize-gene-ordering", String.valueOf(this.optimizeGeneOrdering));
            data.addParam("optimize-sample-ordering", String.valueOf(this.optimizeSampleOrdering));
            this.progress = new Progress(framework.getFrame(), "", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData samples_result = null;
            if (this.drawExptTree) {
                this.progress.setTitle("Resampling by Experiments");
                data.addParam("drawGeneTree", String.valueOf(false));
                data.addParam("drawExptTree", String.valueOf(true));
                samples_result = this.algorithm.execute(data);
                this.validate(samples_result);
            }
            AlgorithmData genes_result = null;
            if (this.drawGeneTree) {
                this.progress.setTitle("Resampling by Genes");
                data.addParam("drawGeneTree", String.valueOf(true));
                data.addParam("drawExptTree", String.valueOf(false));
                genes_result = this.algorithm.execute(data);
                this.validate(genes_result);
            }
            long time = System.currentTimeMillis() - start;
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.method = method;
            info.function = menu.getFunctionName(function);
            if (this.drawGeneTree) {
                info.drawGeneTree = true;
                info.geneTreeIterations = geneTreeIterations;
                info.geneTreeAnalysisOption = geneTreeAnalysisOption;
            }
            if (this.drawExptTree) {
                info.drawExptTree = true;
                info.exptTreeIterations = exptTreeIterations;
                info.exptTreeAnalysisOption = exptTreeAnalysisOption;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(experiment, genes_result, samples_result, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        ResampleTreeInitDialog dialog = new ResampleTreeInitDialog((JFrame)framework.getFrame(), true, menu.getFunctionName(function), menu.isAbsoluteDistance());
        dialog.setVisible(true);
        if (dialog.isCancelled()) {
            return null;
        }
        int method = dialog.getMethod();
        this.drawGeneTree = dialog.drawGeneTreeCheckBox.isSelected();
        this.drawExptTree = dialog.drawExptTreeCheckBox.isSelected();
        this.optimizeGeneOrdering = dialog.isOptimizeGenes();
        this.optimizeSampleOrdering = dialog.isOptimizeSamples();
        int geneTreeAnalysisOption = dialog.getGeneTreeAnalysisOption();
        int exptTreeAnalysisOption = dialog.getExptTreeAnalysisOption();
        int geneTreeIterations = Integer.parseInt(dialog.geneTreeIterationsTextField.getText());
        int exptTreeIterations = Integer.parseInt(dialog.exptTreeIterationsTextField.getText());
        AlgorithmData data = new AlgorithmData();
        function = dialog.getDistanceMetric();
        data.addParam("distance-function", String.valueOf(function));
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(dialog.isAbsoluteDistance()));
        data.addParam("method-linkage", String.valueOf(method));
        data.addParam("geneTreeIterations", String.valueOf(geneTreeIterations));
        data.addParam("exptTreeIterations", String.valueOf(exptTreeIterations));
        data.addParam("geneTreeAnalysisOption", String.valueOf(geneTreeAnalysisOption));
        data.addParam("exptTreeAnalysisOption", String.valueOf(exptTreeAnalysisOption));
        data.addParam("drawExptTree", String.valueOf(this.drawExptTree));
        data.addParam("drawGeneTree", String.valueOf(this.drawGeneTree));
        data.addParam("optimize-gene-ordering", String.valueOf(this.optimizeGeneOrdering));
        data.addParam("optimize-sample-ordering", String.valueOf(this.optimizeSampleOrdering));
        data.addParam("name", "ST");
        data.addParam("alg-type", "cluster");
        data.addParam("output-class", "single-output");
        String[] outputNodes = new String[]{"Single Ordered Output"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        AlgorithmParameters params = algData.getParams();
        this.drawExptTree = params.getBoolean("drawExptTree");
        this.drawGeneTree = params.getBoolean("drawGeneTree");
        Listener listener = new Listener();
        try {
            AlgorithmFactory factory = framework.getAlgorithmFactory();
            this.algorithm = factory.getAlgorithm("ST");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            algData.addMatrix("experiment", experiment.getMatrix());
            this.progress = new Progress(framework.getFrame(), "", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData samples_result = null;
            if (this.drawExptTree) {
                this.progress.setTitle("Resampling by Experiments");
                algData.addParam("drawGeneTree", String.valueOf(false));
                algData.addParam("drawExptTree", String.valueOf(true));
                algData.addParam("optimize-sample-ordering", String.valueOf(this.optimizeSampleOrdering));
                samples_result = this.algorithm.execute(algData);
                this.validate(samples_result);
            }
            AlgorithmData genes_result = null;
            if (this.drawGeneTree) {
                this.progress.setTitle("Resampling by Genes");
                algData.addParam("drawGeneTree", String.valueOf(true));
                algData.addParam("drawExptTree", String.valueOf(false));
                algData.addParam("optimize-gene-ordering", String.valueOf(this.optimizeGeneOrdering));
                genes_result = this.algorithm.execute(algData);
                this.validate(genes_result);
            }
            long time = System.currentTimeMillis() - start;
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.method = params.getInt("method-linkage");
            int function = params.getInt("distance-function");
            info.function = framework.getDistanceMenu().getFunctionName(function);
            if (this.drawGeneTree) {
                info.drawGeneTree = true;
                info.geneTreeIterations = params.getInt("geneTreeIterations");
                info.geneTreeAnalysisOption = params.getInt("geneTreeAnalysisOption");
            }
            if (this.drawExptTree) {
                info.drawExptTree = true;
                info.exptTreeIterations = params.getInt("exptTreeIterations");
                info.exptTreeAnalysisOption = params.getInt("exptTreeAnalysisOption");
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(experiment, genes_result, samples_result, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("orig-child-1-array") == null) {
            throw new AlgorithmException("parameter 'orig-child-1-array' is null");
        }
        if (result.getIntArray("orig-child-2-array") == null) {
            throw new AlgorithmException("parameter 'orig-child-2-array' is null");
        }
        if (result.getIntArray("orig-node-order") == null) {
            throw new AlgorithmException("parameter 'orig-node-order' is null");
        }
        if (result.getMatrix("orig-height") == null) {
            throw new AlgorithmException("parameter 'orig-height' is null");
        }
    }

    private DefaultMutableTreeNode createResultTree(Experiment experiment, AlgorithmData genes_result, AlgorithmData samples_result, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ST");
        root.add(new DefaultMutableTreeNode(new LeafInfo("Support Tree - " + info.getMethodName(), this.createHCLSupportViewer(experiment, genes_result, samples_result, root))));
        root.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        root.add(new DefaultMutableTreeNode(info.function));
        if (info.drawGeneTree) {
            DefaultMutableTreeNode geneTreeNode = new DefaultMutableTreeNode("Gene Tree Resampling");
            geneTreeNode.add(new DefaultMutableTreeNode("Resampling method: " + info.getGeneTreeAnalysisOptionName()));
            geneTreeNode.add(new DefaultMutableTreeNode("Iterations: " + info.geneTreeIterations));
            root.add(geneTreeNode);
        }
        if (info.drawExptTree) {
            DefaultMutableTreeNode exptTreeNode = new DefaultMutableTreeNode("Expt Tree Resampling");
            exptTreeNode.add(new DefaultMutableTreeNode("Resampling method: " + info.getExptTreeAnalysisOptionName()));
            exptTreeNode.add(new DefaultMutableTreeNode("Iterations: " + info.exptTreeIterations));
            root.add(exptTreeNode);
        }
        return root;
    }

    private HCLTreeData getHCLTreeData(AlgorithmData result) {
        if (result == null) {
            return null;
        }
        HCLTreeData data = new HCLTreeData();
        data.child_1_array = result.getIntArray("orig-child-1-array");
        data.child_2_array = result.getIntArray("orig-child-2-array");
        data.node_order = result.getIntArray("orig-node-order");
        data.height = result.getMatrix("orig-height").getRowPackedCopy();
        return data;
    }

    private IViewer createHCLSupportViewer(Experiment experiment, AlgorithmData genes_result, AlgorithmData samples_result, DefaultMutableTreeNode root) {
        return new HCLSupportViewer(experiment, (int[])null, this.getHCLTreeData(genes_result), this.getHCLTreeData(samples_result), this.getGeneTreeSupportVector(genes_result), this.getExptTreeSupportVector(samples_result), root);
    }

    private Vector getGeneTreeSupportVector(AlgorithmData result) {
        Vector<Float> geneTreeSupportVector = new Vector<Float>();
        if (this.drawGeneTree) {
            FloatMatrix geneTreeSupportMatrix = result.getMatrix("geneTreeSupportMatrix");
            for (int i = 0; i < geneTreeSupportMatrix.A[0].length; ++i) {
                geneTreeSupportVector.add(new Float(geneTreeSupportMatrix.A[0][i]));
            }
        } else {
            geneTreeSupportVector = null;
        }
        return geneTreeSupportVector;
    }

    private Vector getExptTreeSupportVector(AlgorithmData result) {
        Vector<Float> exptTreeSupportVector = new Vector<Float>();
        if (this.drawExptTree) {
            FloatMatrix exptTreeSupportMatrix = result.getMatrix("exptTreeSupportMatrix");
            for (int i = 0; i < exptTreeSupportMatrix.A[0].length; ++i) {
                exptTreeSupportVector.add(new Float(exptTreeSupportMatrix.A[0][i]));
            }
        } else {
            exptTreeSupportVector = null;
        }
        return exptTreeSupportVector;
    }

    public static class GeneralInfo {
        public long time;
        public int method;
        public String function;
        public boolean drawGeneTree = false;
        public boolean drawExptTree = false;
        public int geneTreeIterations;
        public int exptTreeIterations;
        public int geneTreeAnalysisOption;
        public int exptTreeAnalysisOption;
        private static String[] methods = new String[]{"average linkage", "complete linkage", "single linkage"};

        public String getGeneTreeAnalysisOptionName() {
            String optionName;
            switch (this.geneTreeAnalysisOption) {
                case 0: {
                    optionName = "No Resampling";
                    break;
                }
                case 1: {
                    optionName = "Bootstrap Experiments";
                    break;
                }
                case 2: {
                    optionName = "Bootstrap Genes";
                    break;
                }
                case 3: {
                    optionName = "Jackknife Experiments";
                    break;
                }
                case 4: {
                    optionName = "Jackknife Genes";
                    break;
                }
                default: {
                    optionName = "No Resampling";
                }
            }
            return optionName;
        }

        public String getExptTreeAnalysisOptionName() {
            String optionName;
            switch (this.exptTreeAnalysisOption) {
                case 0: {
                    optionName = "No Resampling";
                    break;
                }
                case 1: {
                    optionName = "Bootstrap Experiments";
                    break;
                }
                case 2: {
                    optionName = "Bootstrap Genes";
                    break;
                }
                case 3: {
                    optionName = "Jackknife Experiments";
                    break;
                }
                case 4: {
                    optionName = "Jackknife Genes";
                    break;
                }
                default: {
                    optionName = "No Resampling";
                }
            }
            return optionName;
        }

        public String getMethodName() {
            return GeneralInfo.getMethodName(this.method);
        }

        public static String getMethodName(int method) {
            method = method == -1 ? 2 : method;
            return methods[method];
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    STGUI.this.progress.setUnits(event.getIntValue());
                    STGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    STGUI.this.progress.setValue(event.getIntValue());
                    STGUI.this.progress.setDescription(event.getDescription());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                STGUI.this.algorithm.abort();
                STGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            STGUI.this.algorithm.abort();
            STGUI.this.progress.dispose();
        }
    }
}

