/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.st;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DistanceMetricPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.awt.GBA;

public class ResampleTreeInitDialog
extends AlgorithmDialog {
    protected GBA gba;
    protected EventListener eventListener;
    protected ItemStateListener itemListener;
    protected JPanel geneTreePanel;
    public JCheckBox drawGeneTreeCheckBox;
    public JCheckBox optimizeGeneCheckBox;
    protected JPanel geneTreeResamplingOptionsPanel;
    protected JRadioButton geneBootstrapExpts;
    protected JRadioButton geneJackknifeExpts;
    protected JRadioButton geneStandard;
    protected JPanel geneTreeIterationsPanel;
    protected JLabel geneTreeIterationsLabel;
    public JTextField geneTreeIterationsTextField;
    protected JPanel exptTreePanel;
    public JCheckBox drawExptTreeCheckBox;
    public JCheckBox optimizeSampleCheckBox;
    protected JPanel exptTreeResamplingOptionsPanel;
    protected JRadioButton exptBootstrapGenes;
    protected JRadioButton exptJackknifeGenes;
    protected JRadioButton exptStandard;
    protected JPanel exptTreeIterationsPanel;
    protected JLabel exptTreeIterationsLabel;
    public JTextField exptTreeIterationsTextField;
    protected JPanel linkagePanel;
    protected JRadioButton averageLinkage;
    protected JRadioButton completeLinkage;
    protected JRadioButton singleLinkage;
    protected JPanel topPanel;
    protected JPanel bottomPanel;
    protected ButtonGroup buttonGroup;
    protected int linkageStyle = 0;
    protected int geneTreeAnalysisOption = 0;
    protected int exptTreeAnalysisOption = 0;
    protected boolean cancelled = true;
    protected Color labelColor;
    public static final int NONE = 0;
    public static final int BOOT_EXPTS = 1;
    public static final int BOOT_GENES = 2;
    public static final int JACK_EXPTS = 3;
    public static final int JACK_GENES = 4;
    private DistanceMetricPanel metricPanel;
    private String globalMetricName;
    private boolean globalAbsoluteSetting;

    public ResampleTreeInitDialog(JFrame parent, boolean modal, String globalMetricName, boolean globalAbsoluteSetting) {
        super(parent, "ST: Support Trees", modal);
        this.globalMetricName = globalMetricName;
        this.globalAbsoluteSetting = globalAbsoluteSetting;
        this.initialize();
    }

    protected void initialize() {
        this.gba = new GBA();
        this.labelColor = UIManager.getColor("Label.foreground");
        this.itemListener = new ItemStateListener();
        this.eventListener = new EventListener();
        this.drawGeneTreeCheckBox = new JCheckBox("Draw Gene Tree", true);
        this.drawGeneTreeCheckBox.setFocusPainted(false);
        this.drawGeneTreeCheckBox.setBackground(Color.white);
        this.drawGeneTreeCheckBox.setForeground(this.labelColor);
        this.drawGeneTreeCheckBox.addItemListener(this.itemListener);
        this.optimizeGeneCheckBox = new JCheckBox("Optimize Gene Leaf Order");
        this.optimizeGeneCheckBox.setFocusPainted(false);
        this.optimizeGeneCheckBox.setBackground(Color.white);
        this.optimizeGeneCheckBox.setForeground(this.labelColor);
        this.optimizeGeneCheckBox.addItemListener(this.itemListener);
        this.buttonGroup = new ButtonGroup();
        this.geneBootstrapExpts = new JRadioButton("Bootstrap Samples", true);
        this.geneBootstrapExpts.setFocusPainted(false);
        this.geneBootstrapExpts.setBackground(Color.white);
        this.geneBootstrapExpts.setForeground(this.labelColor);
        this.buttonGroup.add(this.geneBootstrapExpts);
        this.geneJackknifeExpts = new JRadioButton("Jackknife Samples");
        this.geneJackknifeExpts.setFocusPainted(false);
        this.geneJackknifeExpts.setBackground(Color.white);
        this.geneJackknifeExpts.setForeground(this.labelColor);
        this.buttonGroup.add(this.geneJackknifeExpts);
        this.geneStandard = new JRadioButton("No resampling");
        this.geneStandard.setFocusPainted(false);
        this.geneStandard.setBackground(Color.white);
        this.geneStandard.setForeground(this.labelColor);
        this.buttonGroup.add(this.geneStandard);
        this.geneTreeIterationsLabel = new JLabel("Iterations");
        this.geneTreeIterationsTextField = new JTextField("100");
        this.geneTreeIterationsPanel = new JPanel();
        this.geneTreeIterationsPanel.setLayout(new GridBagLayout());
        this.geneTreeIterationsPanel.setBackground(Color.white);
        this.gba.add((Container)this.geneTreeIterationsPanel, (Component)this.geneTreeIterationsLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.geneTreeIterationsPanel, (Component)this.geneTreeIterationsTextField, 1, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.geneTreeResamplingOptionsPanel = new JPanel();
        this.geneTreeResamplingOptionsPanel.setLayout(new GridBagLayout());
        this.geneTreeResamplingOptionsPanel.setBackground(Color.white);
        this.geneTreeResamplingOptionsPanel.setBorder(new TitledBorder(new EtchedBorder(), "Resampling Options", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.gba.add((Container)this.geneTreeResamplingOptionsPanel, (Component)this.geneBootstrapExpts, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.geneTreeResamplingOptionsPanel, (Component)this.geneJackknifeExpts, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.geneTreeResamplingOptionsPanel, (Component)this.geneStandard, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.geneTreePanel = new JPanel();
        this.geneTreePanel.setLayout(new GridBagLayout());
        this.geneTreePanel.setBackground(Color.white);
        this.geneTreePanel.setBorder(new TitledBorder(new EtchedBorder(), "Gene Tree", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.gba.add((Container)this.geneTreePanel, (Component)this.drawGeneTreeCheckBox, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.geneTreePanel, (Component)this.optimizeGeneCheckBox, 0, 1, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.geneTreePanel, (Component)this.geneTreeResamplingOptionsPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.geneTreePanel, (Component)this.geneTreeIterationsPanel, 0, 3, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.drawExptTreeCheckBox = new JCheckBox("Draw Sample Tree", true);
        this.drawExptTreeCheckBox.setFocusPainted(false);
        this.drawExptTreeCheckBox.setBackground(Color.white);
        this.drawExptTreeCheckBox.setForeground(this.labelColor);
        this.drawExptTreeCheckBox.addItemListener(this.itemListener);
        this.optimizeSampleCheckBox = new JCheckBox("Optimize Sample Leaf Order");
        this.optimizeSampleCheckBox.setFocusPainted(false);
        this.optimizeSampleCheckBox.setBackground(Color.white);
        this.optimizeSampleCheckBox.setForeground(this.labelColor);
        this.optimizeSampleCheckBox.addItemListener(this.itemListener);
        this.buttonGroup = new ButtonGroup();
        this.exptBootstrapGenes = new JRadioButton("Bootstrap Genes", true);
        this.exptBootstrapGenes.setFocusPainted(false);
        this.exptBootstrapGenes.setBackground(Color.white);
        this.exptBootstrapGenes.setForeground(this.labelColor);
        this.buttonGroup.add(this.exptBootstrapGenes);
        this.exptJackknifeGenes = new JRadioButton("Jackknife Genes");
        this.exptJackknifeGenes.setFocusPainted(false);
        this.exptJackknifeGenes.setBackground(Color.white);
        this.exptJackknifeGenes.setForeground(this.labelColor);
        this.buttonGroup.add(this.exptJackknifeGenes);
        this.exptStandard = new JRadioButton("No resampling");
        this.exptStandard.setFocusPainted(false);
        this.exptStandard.setBackground(Color.white);
        this.exptStandard.setForeground(this.labelColor);
        this.buttonGroup.add(this.exptStandard);
        this.exptTreeIterationsLabel = new JLabel("Iterations");
        this.exptTreeIterationsTextField = new JTextField("100");
        this.exptTreeIterationsPanel = new JPanel();
        this.exptTreeIterationsPanel.setLayout(new GridBagLayout());
        this.exptTreeIterationsPanel.setBackground(Color.white);
        this.gba.add((Container)this.exptTreeIterationsPanel, (Component)this.exptTreeIterationsLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.exptTreeIterationsPanel, (Component)this.exptTreeIterationsTextField, 1, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.exptTreeResamplingOptionsPanel = new JPanel();
        this.exptTreeResamplingOptionsPanel.setLayout(new GridBagLayout());
        this.exptTreeResamplingOptionsPanel.setBackground(Color.white);
        this.exptTreeResamplingOptionsPanel.setBorder(new TitledBorder(new EtchedBorder(), "Resampling Options", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.gba.add((Container)this.exptTreeResamplingOptionsPanel, (Component)this.exptBootstrapGenes, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.exptTreeResamplingOptionsPanel, (Component)this.exptJackknifeGenes, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.exptTreeResamplingOptionsPanel, (Component)this.exptStandard, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.exptTreePanel = new JPanel();
        this.exptTreePanel.setLayout(new GridBagLayout());
        this.exptTreePanel.setBackground(Color.white);
        this.exptTreePanel.setBorder(new TitledBorder(new EtchedBorder(), "Sample Tree", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.gba.add((Container)this.exptTreePanel, (Component)this.drawExptTreeCheckBox, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.exptTreePanel, (Component)this.optimizeSampleCheckBox, 0, 1, 1, 1, 1, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.exptTreePanel, (Component)this.exptTreeResamplingOptionsPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.exptTreePanel, (Component)this.exptTreeIterationsPanel, 0, 3, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new GridBagLayout());
        this.topPanel.setBackground(Color.white);
        this.gba.add((Container)this.topPanel, (Component)this.geneTreePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.topPanel, (Component)this.exptTreePanel, 1, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.buttonGroup = new ButtonGroup();
        this.averageLinkage = new JRadioButton("Average Linkage", true);
        this.averageLinkage.setFocusPainted(false);
        this.averageLinkage.setBackground(Color.white);
        this.averageLinkage.setForeground(this.labelColor);
        this.buttonGroup.add(this.averageLinkage);
        this.completeLinkage = new JRadioButton("Complete Linkage", false);
        this.completeLinkage.setFocusPainted(false);
        this.completeLinkage.setBackground(Color.white);
        this.completeLinkage.setForeground(this.labelColor);
        this.buttonGroup.add(this.completeLinkage);
        this.singleLinkage = new JRadioButton("Single Linkage", false);
        this.singleLinkage.setFocusPainted(false);
        this.singleLinkage.setBackground(Color.white);
        this.singleLinkage.setForeground(this.labelColor);
        this.buttonGroup.add(this.singleLinkage);
        this.metricPanel = new DistanceMetricPanel(this.globalMetricName, this.globalAbsoluteSetting, "Pearson Correlation", "ST", true, true);
        this.linkagePanel = new JPanel();
        this.linkagePanel.setLayout(new GridBagLayout());
        this.linkagePanel.setBackground(Color.white);
        this.linkagePanel.setBorder(new TitledBorder(new EtchedBorder(), "Linkage Method", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.gba.add((Container)this.linkagePanel, (Component)this.averageLinkage, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.linkagePanel, (Component)this.completeLinkage, 1, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.linkagePanel, (Component)this.singleLinkage, 2, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridBagLayout());
        this.bottomPanel.setBackground(Color.white);
        this.gba.add((Container)this.bottomPanel, (Component)this.linkagePanel, 0, 0, 2, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBackground(Color.white);
        this.gba.add((Container)contentPane, (Component)this.topPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)contentPane, (Component)this.metricPanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)contentPane, (Component)this.bottomPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(0, 5, 5, 5), 0, 0);
        this.addContent(contentPane);
        this.setActionListeners(this.eventListener);
        this.setActionListeners(this.itemListener);
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    public int getMethod() {
        return this.linkageStyle;
    }

    public int getDistanceMetric() {
        return this.metricPanel.getMetricIndex();
    }

    public boolean isAbsoluteDistance() {
        return this.metricPanel.getAbsoluteSelection();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getGeneTreeAnalysisOption() {
        return this.geneTreeAnalysisOption;
    }

    public int getExptTreeAnalysisOption() {
        return this.exptTreeAnalysisOption;
    }

    public boolean isOptimizeGenes() {
        return this.optimizeGeneCheckBox.isSelected();
    }

    public boolean isOptimizeSamples() {
        return this.optimizeSampleCheckBox.isSelected();
    }

    protected void fireOkButtonEvent() {
        boolean drawGeneTree = this.drawGeneTreeCheckBox.isSelected();
        int geneTreeIterations = Integer.parseInt(this.geneTreeIterationsTextField.getText());
        boolean drawExptTree = this.drawExptTreeCheckBox.isSelected();
        int exptTreeIterations = Integer.parseInt(this.exptTreeIterationsTextField.getText());
        this.geneTreeAnalysisOption = this.geneBootstrapExpts.isSelected() ? 1 : (this.geneJackknifeExpts.isSelected() ? 3 : 0);
        this.exptTreeAnalysisOption = this.exptBootstrapGenes.isSelected() ? 2 : (this.exptJackknifeGenes.isSelected() ? 4 : 0);
        this.linkageStyle = this.completeLinkage.isSelected() ? 1 : (this.singleLinkage.isSelected() ? -1 : 0);
    }

    private void resetControls() {
        this.drawGeneTreeCheckBox.setSelected(true);
        this.optimizeGeneCheckBox.setSelected(false);
        this.drawExptTreeCheckBox.setSelected(true);
        this.optimizeSampleCheckBox.setSelected(false);
        this.geneStandard.setSelected(true);
        this.exptStandard.setSelected(true);
        this.averageLinkage.setSelected(true);
        this.geneTreeIterationsTextField.setText("100");
        this.exptTreeIterationsTextField.setText("100");
        this.metricPanel.reset();
    }

    public static void main(String[] args) {
        ResampleTreeInitDialog dialog = new ResampleTreeInitDialog(new JFrame(), true, "Euclidean Distance", false);
        dialog.show();
        System.exit(0);
    }

    private class ItemStateListener
    extends DialogListener
    implements ItemListener {
        private ItemStateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ResampleTreeInitDialog.this.okButton.setEnabled(ResampleTreeInitDialog.this.drawGeneTreeCheckBox.isSelected() || ResampleTreeInitDialog.this.drawExptTreeCheckBox.isSelected());
            if (!ResampleTreeInitDialog.this.drawGeneTreeCheckBox.isSelected()) {
                ResampleTreeInitDialog.this.optimizeGeneCheckBox.setEnabled(false);
                ResampleTreeInitDialog.this.optimizeGeneCheckBox.setSelected(false);
            }
            if (!ResampleTreeInitDialog.this.drawExptTreeCheckBox.isSelected()) {
                ResampleTreeInitDialog.this.optimizeSampleCheckBox.setEnabled(false);
                ResampleTreeInitDialog.this.optimizeSampleCheckBox.setSelected(false);
            }
            if (ResampleTreeInitDialog.this.drawExptTreeCheckBox.isSelected()) {
                ResampleTreeInitDialog.this.optimizeSampleCheckBox.setEnabled(true);
            }
            if (ResampleTreeInitDialog.this.drawGeneTreeCheckBox.isSelected()) {
                ResampleTreeInitDialog.this.optimizeGeneCheckBox.setEnabled(true);
            }
        }
    }

    protected class EventListener
    implements ActionListener {
        protected EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                if (ResampleTreeInitDialog.this.drawExptTreeCheckBox.isSelected()) {
                    try {
                        int exptIter = Integer.parseInt(ResampleTreeInitDialog.this.exptTreeIterationsTextField.getText());
                        if (exptIter < 1) {
                            ResampleTreeInitDialog.this.exptTreeIterationsTextField.requestFocus();
                            ResampleTreeInitDialog.this.exptTreeIterationsTextField.selectAll();
                            JOptionPane.showMessageDialog(ResampleTreeInitDialog.this, "Number of iterations must be > 0", "Error", 0);
                            return;
                        }
                    }
                    catch (NumberFormatException e1) {
                        ResampleTreeInitDialog.this.exptTreeIterationsTextField.requestFocus();
                        ResampleTreeInitDialog.this.exptTreeIterationsTextField.selectAll();
                        JOptionPane.showMessageDialog(ResampleTreeInitDialog.this, "Entry format error.", "Error", 0);
                        return;
                    }
                }
                if (ResampleTreeInitDialog.this.drawGeneTreeCheckBox.isSelected()) {
                    try {
                        int geneIter = Integer.parseInt(ResampleTreeInitDialog.this.geneTreeIterationsTextField.getText());
                        if (geneIter < 1) {
                            ResampleTreeInitDialog.this.geneTreeIterationsTextField.requestFocus();
                            ResampleTreeInitDialog.this.geneTreeIterationsTextField.selectAll();
                            JOptionPane.showMessageDialog(ResampleTreeInitDialog.this, "Number of iterations must be > 0", "Error", 0);
                            return;
                        }
                    }
                    catch (NumberFormatException e1) {
                        ResampleTreeInitDialog.this.geneTreeIterationsTextField.requestFocus();
                        ResampleTreeInitDialog.this.geneTreeIterationsTextField.selectAll();
                        JOptionPane.showMessageDialog(ResampleTreeInitDialog.this, "Entry format error.", "Error", 0);
                        return;
                    }
                }
                ResampleTreeInitDialog.this.fireOkButtonEvent();
                ResampleTreeInitDialog.this.cancelled = false;
            } else if (command.equals("cancel-command")) {
                ResampleTreeInitDialog.this.cancelled = true;
            } else {
                if (command.equals("reset-command")) {
                    ResampleTreeInitDialog.this.resetControls();
                    ResampleTreeInitDialog.this.cancelled = false;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(ResampleTreeInitDialog.this, "ST Initialization Dialog");
                }
            }
            ResampleTreeInitDialog.this.dispose();
        }
    }
}

