/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.st;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Expression;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTree;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeListener;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.st.HCLSupportTree;

public class HCLSupportViewer
extends HCLViewer {
    protected static final String SET_CLUSTER_CMD = "set-cluster-cmd";
    protected static final String SET_CLUSTER_TEXT_CMD = "set-cluster-text-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String DELETE_CLUSTER_CMD = "delete-cluster-cmd";
    protected static final String DELETE_ALL_CLUSTERS_CMD = "delete-all-clusters-cmd";
    protected static final String GENE_TREE_PROPERTIES_CMD = "gene-tree-properties-cmd";
    protected static final String SAMPLE_TREE_PROPERTIES_CMD = "sample-tree-properties-cmd";
    protected static final String SUPPORT_LEGEND_CMD = "support-legend-cmd";
    protected static final String SUPPORT_VALUES_CMD = "support-value-cmd";
    protected static final String TOGGLE_SUPPORT_COLORS_CMD = "support-color-cmd";
    Vector geneTreeSupportVector;
    Vector exptTreeSupportVector;

    public HCLSupportViewer(Experiment experiment, ClusterWrapper features, HCLTreeData genes_result, HCLTreeData samples_result, Vector geneTreeSupportVector, Vector exptTreeSupportVector, DefaultMutableTreeNode node) {
        this(experiment, features.getClusters()[0], genes_result, samples_result, geneTreeSupportVector, exptTreeSupportVector, node);
    }

    public HCLSupportViewer(Experiment experiment, int[] Features, HCLTreeData genes_result, HCLTreeData samples_result, Vector geneTreeSupportVector, Vector exptTreeSupportVector, DefaultMutableTreeNode node) {
        super(experiment, Features, genes_result, samples_result, node);
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.geneTreeSupportVector = geneTreeSupportVector;
        this.exptTreeSupportVector = exptTreeSupportVector;
        if (genes_result != null && experiment.getNumberOfGenes() > 1) {
            this.genesTree = new HCLSupportTree(genes_result, 0, geneTreeSupportVector, exptTreeSupportVector);
            this.genesTree.addMouseListener(this.listener);
            this.genesTree.setListener(this.listener);
        }
        if (samples_result != null && experiment.getNumberOfSamples() > 1) {
            this.sampleTree = new HCLSupportTree(samples_result, 1, geneTreeSupportVector, exptTreeSupportVector);
            if (genes_result == null) {
                this.offset = 10;
                this.sampleTree.setHorizontalOffset(this.offset);
            }
            this.sampleTree.setListener(this.listener);
            this.sampleTree.addMouseListener(this.listener);
        }
        super.removeAll();
        super.validate();
        this.addComponents(this.sampleTree, this.genesTree, this.expViewer.getContentComponent(), this.colorBar, this.annotationBar);
        this.addMouseListener(this.listener);
        this.addSTMenuItems(this.popup);
    }

    public HCLSupportViewer(Experiment e, int[] features, HCLTreeData genesResult, HCLTreeData samplesResult, int[][] sampleClusters, boolean isExperimentCluster, HCLTree genesTree, HCLTree sampleTree, Integer offset, ExperimentViewer expViewer, Vector geneTreeSupportVector, Vector exptTreeSupportVector) {
        super(e, features, genesResult, samplesResult, sampleClusters, (Boolean)isExperimentCluster, genesTree, sampleTree, offset, (IViewer)expViewer);
        this.geneTreeSupportVector = geneTreeSupportVector;
        this.exptTreeSupportVector = exptTreeSupportVector;
    }

    @Override
    public Expression getExpression() {
        if (this.features == null) {
            this.features = this.createDefaultFeatures(this.experiment);
        }
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, ClusterWrapper.wrapClusters((int[][])new int[][]{this.features}), this.genes_result, this.samples_result, this.geneTreeSupportVector, this.exptTreeSupportVector, this.node});
    }

    @Override
    public void setExperiment(Experiment e) {
        super.setExperiment(e);
    }

    private void addSTMenuItems(JPopupMenu menu) {
        Listener listener = new Listener();
        boolean haveResamplingData = true;
        if ((this.geneTreeSupportVector == null || this.geneTreeSupportVector.isEmpty()) && (this.exptTreeSupportVector == null || this.exptTreeSupportVector.isEmpty())) {
            haveResamplingData = false;
        }
        JMenuItem menuItem = new JMenuItem("Support tree legend...");
        menuItem.setActionCommand(SUPPORT_LEGEND_CMD);
        menuItem.addActionListener(listener);
        if (!haveResamplingData) {
            menuItem.setEnabled(false);
        }
        JCheckBoxMenuItem hideSupportColorsItem = new JCheckBoxMenuItem("Hide support colors...", false);
        hideSupportColorsItem.setActionCommand(TOGGLE_SUPPORT_COLORS_CMD);
        hideSupportColorsItem.addActionListener(listener);
        Component[] comps = menu.getComponents();
        menu.removeAll();
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JCheckBoxMenuItem("Show values...", false);
        menuItem.setActionCommand(SUPPORT_VALUES_CMD);
        menuItem.addActionListener(listener);
        if (!haveResamplingData) {
            menuItem.setEnabled(false);
        }
        menu.add(menuItem);
        menu.add(hideSupportColorsItem);
        menu.addSeparator();
        for (int i = 0; i < comps.length; ++i) {
            menu.add(comps[i]);
        }
    }

    protected void showPopup(MouseEvent e) {
        int node = this.selectedCluster == null ? -1 : this.selectedCluster.root;
        this.setEnableMenuItem(SET_CLUSTER_CMD, node >= 0);
        this.setEnableMenuItem(SET_CLUSTER_TEXT_CMD, this.doesClusterExist());
        this.setEnableMenuItem(DELETE_CLUSTER_CMD, this.doesClusterExist());
        this.setEnableMenuItem(DELETE_ALL_CLUSTERS_CMD, this.doesClusterExist());
        this.setEnableMenuItem(SAVE_CLUSTER_CMD, this.selectedCluster != null && this.selectedCluster.root != -1);
        this.popup.show(e.getComponent(), e.getX(), e.getY());
    }

    private void onShowSupportTreeLegend() {
        JDialog legendFrame = new JDialog(this.framework.getFrame(), "Support Tree Legend");
        JPanel legendPanel = HCLSupportTree.getColorLegendPanel();
        legendFrame.getContentPane().add(legendPanel);
        legendFrame.setSize(200, 300);
        legendFrame.setLocation(300, 100);
        legendFrame.setVisible(true);
    }

    private void onShowSupportValues(boolean showValues) {
        if (this.genesTree != null) {
            ((HCLSupportTree)this.genesTree).toggleShowSupportValues(showValues);
        }
        if (this.sampleTree != null) {
            ((HCLSupportTree)this.sampleTree).toggleShowSupportValues(showValues);
        }
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.onSelected(this.framework);
    }

    public void onHideSupportColors(boolean hideColors) {
        if (this.genesTree != null) {
            ((HCLSupportTree)this.genesTree).hideSupportColors(hideColors);
        }
        if (this.sampleTree != null) {
            ((HCLSupportTree)this.sampleTree).hideSupportColors(hideColors);
        }
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.onSelected(this.framework);
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
        super.onMenuChanged(menu);
        if (this.genesTree != null) {
            ((HCLSupportTree)this.genesTree).adjustPixelHeightsForValueDisplay();
            this.genesTree.onMenuChanged(menu);
        }
        if (this.sampleTree != null) {
            ((HCLSupportTree)this.sampleTree).adjustPixelHeightsForValueDisplay();
            this.sampleTree.onMenuChanged(menu);
        }
        this.onSelected(this.framework);
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    HCLTreeListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(HCLSupportViewer.SET_CLUSTER_CMD)) {
                HCLSupportViewer.this.onSetCluster();
            } else if (command.equals(HCLSupportViewer.SET_CLUSTER_TEXT_CMD)) {
                HCLSupportViewer.this.onSetClusterText();
            } else if (command.equals(HCLSupportViewer.SAVE_CLUSTER_CMD)) {
                HCLSupportViewer.this.onSaveCluster();
            } else if (command.equals(HCLSupportViewer.DELETE_CLUSTER_CMD)) {
                HCLSupportViewer.this.onDeleteCluster();
            } else if (command.equals(HCLSupportViewer.DELETE_ALL_CLUSTERS_CMD)) {
                HCLSupportViewer.this.onDeleteAllClusters();
            } else if (command.equals(HCLSupportViewer.GENE_TREE_PROPERTIES_CMD)) {
                HCLSupportViewer.this.onGeneTreeProperties();
            } else if (command.equals(HCLSupportViewer.SAMPLE_TREE_PROPERTIES_CMD)) {
                HCLSupportViewer.this.onSampleTreeProperties();
            } else if (command.equals(HCLSupportViewer.SUPPORT_LEGEND_CMD)) {
                HCLSupportViewer.this.onShowSupportTreeLegend();
            } else if (command.equals(HCLSupportViewer.SUPPORT_VALUES_CMD)) {
                HCLSupportViewer.this.onShowSupportValues(((JCheckBoxMenuItem)e.getSource()).isSelected());
            } else if (command.equals(HCLSupportViewer.TOGGLE_SUPPORT_COLORS_CMD)) {
                HCLSupportViewer.this.onHideSupportColors(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        }

        @Override
        public void valueChanged(HCLTree source, HCLCluster cluster) {
            HCLSupportViewer.this.valueChanged(source, cluster);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            this.deselect(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            HCLSupportViewer.this.showPopup(e);
        }

        private void deselect(MouseEvent e) {
            Object source = e.getSource();
            if (source instanceof HCLTree) {
                if (source == HCLSupportViewer.this.genesTree) {
                    ((ExperimentViewer)HCLSupportViewer.this.expViewer).selectColumns(-1, -1);
                    if (HCLSupportViewer.this.sampleTree != null) {
                        HCLSupportViewer.this.sampleTree.deselectAllNodes();
                    }
                    ((ExperimentViewer)HCLSupportViewer.this.expViewer).selectRows(-1, -1);
                    if (HCLSupportViewer.this.genesTree != null) {
                        HCLSupportViewer.this.genesTree.deselectAllNodes();
                    }
                    HCLSupportViewer.this.repaint();
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                if (!(source instanceof HCLViewer) && source != HCLSupportViewer.this.expViewer) {
                    this.deselectAllNodes();
                    HCLSupportViewer.this.repaint();
                } else if (source instanceof HCLViewer && HCLSupportViewer.this.sampleTree != null && y < HCLSupportViewer.this.sampleTree.getHeight()) {
                    this.deselectAllNodes();
                    HCLSupportViewer.this.repaint();
                } else if (source == HCLSupportViewer.this.expViewer) {
                    int numSamples = HCLSupportViewer.this.numberOfSamples;
                    if (x > ((HCLSupportViewer)HCLSupportViewer.this).elementSize.width * numSamples + HCLSupportViewer.this.offset || x < HCLSupportViewer.this.offset) {
                        this.deselectAllNodes();
                        HCLSupportViewer.this.repaint();
                    }
                } else if (source == HCLSupportViewer.this.expViewer && x < HCLSupportViewer.this.offset) {
                    this.deselectAllNodes();
                    HCLSupportViewer.this.repaint();
                }
            }
        }

        private void deselectAllNodes() {
            if (HCLSupportViewer.this.genesTree != null) {
                HCLSupportViewer.this.genesTree.deselectAllNodes();
            }
            if (HCLSupportViewer.this.sampleTree != null) {
                HCLSupportViewer.this.sampleTree.deselectAllNodes();
            }
            ((ExperimentViewer)HCLSupportViewer.this.expViewer).selectRows(-1, -1);
            ((ExperimentViewer)HCLSupportViewer.this.expViewer).selectColumns(-1, -1);
        }
    }
}

