/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.st;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTree;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;

public class HCLSupportTree
extends HCLTree {
    private Vector geneTreeSupportVector;
    private Vector exptTreeSupportVector;
    private boolean showSupportValues = false;
    private boolean hideSupportColors = false;
    private int MIN_VALUE_TIC_HEIGHT = 2;
    private FontMetrics fm;
    private DecimalFormat format;
    private String supportString;
    private int supportValueHeight;
    private int supportValueWidth;
    private int index;
    private Float supportPercentage;
    private Color currentColor;

    public HCLSupportTree(HCLTreeData treeData, int orientation, Vector geneTreeSupportVector, Vector exptTreeSupportVector) {
        super(treeData, orientation);
        this.geneTreeSupportVector = geneTreeSupportVector;
        this.exptTreeSupportVector = exptTreeSupportVector;
        this.format = new DecimalFormat();
        this.format.setMaximumFractionDigits(0);
    }

    public static PersistenceDelegate getPersistenceDelegate() {
        return new HCLSupportTreePersistenceDelegate();
    }

    @Override
    public void paint(Graphics g) {
        super.paintSubTree(g);
        Graphics2D g2 = (Graphics2D)g;
        Composite composite = g2.getComposite();
        g.setFont(new Font("mono-spaced", 0, this.stepSize <= 15 ? this.stepSize : 15));
        this.fm = g.getFontMetrics();
        this.supportValueHeight = this.fm.getHeight();
        if (this.treeData.node_order.length < 2) {
            return;
        }
        for (int i = 0; i < this.terminalNodes.length; ++i) {
            this.terminalNodes[i] = false;
        }
        int sign = 1;
        if (this.orientation == 1) {
            ((Graphics2D)g).rotate(-1.5707963267948966);
            sign = -1;
        }
        int max_node_height = this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]];
        for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            int node = this.treeData.node_order[i];
            int child_1 = this.treeData.child_1_array[node];
            int child_2 = this.treeData.child_2_array[node];
            int child_1_x1 = (max_node_height - this.pHeights[node]) * sign;
            int child_1_x2 = (max_node_height - this.pHeights[child_1]) * sign;
            int child_1_y = (int)(this.positions[child_1] * (float)this.stepSize) + this.stepSize / 2;
            int child_2_x1 = (max_node_height - this.pHeights[node]) * sign;
            int child_2_x2 = (max_node_height - this.pHeights[child_2]) * sign;
            int child_2_y = (int)(this.positions[child_2] * (float)this.stepSize) + this.stepSize / 2;
            if (this.geneTreeSupportVector != null || this.exptTreeSupportVector != null) {
                this.index = node - this.treeData.node_order.length;
                this.supportPercentage = null;
                try {
                    if (this.orientation == 0) {
                        if (this.geneTreeSupportVector != null) {
                            this.supportPercentage = (Float)this.geneTreeSupportVector.get(this.index);
                        }
                    } else if (this.exptTreeSupportVector != null) {
                        this.supportPercentage = (Float)this.exptTreeSupportVector.get(this.index);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                if (this.supportPercentage != null) {
                    g.setColor(this.getColorFromPercentage(this.supportPercentage.doubleValue()));
                    this.currentColor = g.getColor();
                }
            }
            if (this.treeData.height[node] >= this.zero_threshold) {
                this.terminalNodes[node] = false;
                if (this.pHeights[child_1] == 0) {
                    this.terminalNodes[child_1] = true;
                }
                if (this.pHeights[child_2] == 0) {
                    this.terminalNodes[child_2] = true;
                }
            } else {
                this.terminalNodes[node] = false;
                if (this.treeData.height[this.parentNodes[node]] >= this.zero_threshold) {
                    this.drawWedge(g, node, child_1_x1 + 10, child_2_x1 + 10, child_1_y, child_2_y);
                    this.terminalNodes[node] = true;
                    this.terminalNodes[child_1] = false;
                    this.terminalNodes[child_2] = false;
                }
            }
            this.selectedLineColor = Color.lightGray;
            if (this.selected[node]) {
                g.setColor(this.selectedLineColor);
            }
            if (!this.showSupportValues) {
                if (this.orientation == 0) {
                    g.drawLine(child_1_x1 + 10, child_1_y, child_1_x2 + 10, child_1_y);
                    g.drawLine(child_2_x1 + 10, child_2_y, child_2_x2 + 10, child_2_y);
                    g.drawLine(child_1_x1 + 10, child_1_y, child_2_x1 + 10, child_2_y);
                    continue;
                }
                g.drawLine(child_1_x1, child_1_y + this.horizontalOffset, child_1_x2, child_1_y + this.horizontalOffset);
                g.drawLine(child_2_x1, child_2_y + this.horizontalOffset, child_2_x2, child_2_y + this.horizontalOffset);
                g.drawLine(child_1_x1, child_1_y + this.horizontalOffset, child_2_x1, child_2_y + this.horizontalOffset);
                continue;
            }
            if (this.orientation == 0) {
                if (this.geneTreeSupportVector != null && !this.geneTreeSupportVector.isEmpty()) {
                    this.supportPercentage = (Float)this.geneTreeSupportVector.get(this.index);
                }
                g.drawLine(child_1_x1 + 10, child_1_y, child_1_x2 + 10, child_1_y);
                g.drawLine(child_2_x1 + 10, child_2_y, child_2_x2 + 10, child_2_y);
                g.drawLine(child_1_x1 + 10, child_1_y, child_2_x1 + 10, child_2_y);
                if (i == this.treeData.node_order.length - 2 || this.geneTreeSupportVector.isEmpty()) continue;
                this.supportString = this.format.format(Math.round(this.supportPercentage.floatValue()));
                this.supportValueWidth = this.fm.stringWidth(this.supportString);
                if (this.supportString.equals("0")) continue;
                g.setColor(new Color(192, 200, 228));
                g2.setComposite(composite);
                g.fillRect(child_1_x1 - this.supportValueWidth - 4 + 10, (child_2_y - child_1_y) / 2 + child_1_y - this.fm.getAscent() - 2, this.supportValueWidth + 4, this.fm.getAscent() + 2);
                g.setColor(Color.black);
                g.drawRect(child_1_x1 - this.supportValueWidth - 4 + 10, (child_2_y - child_1_y) / 2 + child_1_y - this.fm.getAscent() - 2, this.supportValueWidth + 4, this.fm.getAscent() + 2);
                g.drawString(this.supportString, child_1_x1 - this.supportValueWidth - 2 + 10, (child_2_y - child_1_y) / 2 + child_1_y - 2);
                g2.setComposite(composite);
                continue;
            }
            if (this.exptTreeSupportVector != null && !this.exptTreeSupportVector.isEmpty()) {
                this.supportPercentage = (Float)this.exptTreeSupportVector.get(this.index);
            }
            g.drawLine(child_1_x1, child_1_y + this.horizontalOffset, child_1_x2, child_1_y + this.horizontalOffset);
            g.drawLine(child_2_x1, child_2_y + this.horizontalOffset, child_2_x2, child_2_y + this.horizontalOffset);
            g.drawLine(child_1_x1, child_1_y + this.horizontalOffset, child_2_x1, child_2_y + this.horizontalOffset);
            if (i == this.treeData.node_order.length - 2 || this.exptTreeSupportVector.isEmpty()) continue;
            this.supportString = this.format.format(Math.round(this.supportPercentage.floatValue()));
            this.supportValueWidth = this.fm.stringWidth(this.supportString);
            this.supportString = this.format.format(Math.round(this.supportPercentage.floatValue()));
            this.supportValueWidth = this.fm.stringWidth(this.supportString);
            if (this.supportString.equals("0")) continue;
            if (node % 50 == 0) {
                System.out.println("support string width =" + this.supportValueWidth);
            }
            g.setColor(new Color(192, 200, 228));
            g2.setComposite(composite);
            g.fillRect(child_1_x1, (child_2_y - child_1_y) / 2 + child_1_y - this.fm.getAscent() - 2 + this.horizontalOffset, this.supportValueWidth + 4, this.fm.getAscent() + 2);
            g.setColor(Color.black);
            g.drawRect(child_1_x1, (child_2_y - child_1_y) / 2 + child_1_y - this.fm.getAscent() - 2 + this.horizontalOffset, this.supportValueWidth + 4, this.fm.getAscent() + 2);
            g.drawString(this.supportString, child_1_x1 + 2, (child_2_y - child_1_y) / 2 + child_1_y - 2 + this.horizontalOffset);
            g2.setComposite(composite);
        }
    }

    public void toggleShowSupportValues(boolean showValues) {
        this.showSupportValues = showValues;
        this.adjustPixelHeightsForValueDisplay();
    }

    public void hideSupportColors(boolean hideColors) {
        this.hideSupportColors = hideColors;
        this.repaint();
    }

    public void adjustPixelHeightsForValueDisplay() {
        if (this.showSupportValues) {
            Graphics g = this.getGraphics();
            if (g == null) {
                return;
            }
            g.setFont(new Font("mono-spaced", 0, this.stepSize <= 15 ? this.stepSize : 15));
            this.fm = g.getFontMetrics();
            int stringWidth = this.fm.stringWidth("000");
            if (this.orientation == 1) {
                if (this.min_pixels < stringWidth + this.MIN_VALUE_TIC_HEIGHT) {
                    this.setPixelHeightLimits(stringWidth + this.MIN_VALUE_TIC_HEIGHT + 4, this.max_pixels >= stringWidth + this.MIN_VALUE_TIC_HEIGHT + 4 ? this.max_pixels : stringWidth + this.MIN_VALUE_TIC_HEIGHT + 4);
                }
            } else if (this.min_pixels < stringWidth + this.MIN_VALUE_TIC_HEIGHT) {
                this.setPixelHeightLimits(stringWidth + this.MIN_VALUE_TIC_HEIGHT + 4, this.max_pixels >= stringWidth + this.MIN_VALUE_TIC_HEIGHT + 4 ? this.max_pixels : stringWidth + this.MIN_VALUE_TIC_HEIGHT + 4);
            }
        }
    }

    public static JPanel getColorLegendPanel() {
        JPanel legendPanel = new JPanel(){

            @Override
            public void paintComponent(Graphics g1D) {
                Graphics2D g = (Graphics2D)g1D;
                super.paintComponent(g);
                int width = this.getSize().width;
                int height = this.getSize().height;
                int blockWidth = width;
                int blockHeight = height / 9;
                Font font = new Font("monospaced", 0, 12);
                g.setFont(font);
                FontMetrics fm = g.getFontMetrics();
                int stringHeight = fm.getHeight();
                int stringWidth = 0;
                String labelString = null;
                labelString = "100% Support";
                g.setColor(Color.black);
                g.fillRect(0, blockHeight * 0, blockWidth, blockHeight);
                g.setColor(Color.white);
                stringWidth = fm.stringWidth(labelString);
                g.drawString(labelString, 0 + blockWidth / 2 - stringWidth / 2, blockHeight * 0 + blockHeight / 2 + stringHeight / 2);
                labelString = "90-100% Support";
                g.setColor(Color.darkGray);
                g.fillRect(0, blockHeight * 1, blockWidth, blockHeight);
                g.setColor(Color.white);
                stringWidth = fm.stringWidth(labelString);
                g.drawString(labelString, 0 + blockWidth / 2 - stringWidth / 2, blockHeight * 1 + blockHeight / 2 + stringHeight / 2);
                labelString = "80-90% Support";
                g.setColor(Color.blue);
                g.fillRect(0, blockHeight * 2, blockWidth, blockHeight);
                g.setColor(Color.white);
                stringWidth = fm.stringWidth(labelString);
                g.drawString(labelString, 0 + blockWidth / 2 - stringWidth / 2, blockHeight * 2 + blockHeight / 2 + stringHeight / 2);
                labelString = "70-80% Support";
                g.setColor(Color.green);
                g.fillRect(0, blockHeight * 3, blockWidth, blockHeight);
                g.setColor(Color.white);
                stringWidth = fm.stringWidth(labelString);
                g.drawString(labelString, 0 + blockWidth / 2 - stringWidth / 2, blockHeight * 3 + blockHeight / 2 + stringHeight / 2);
                labelString = "60-70% Support";
                g.setColor(Color.yellow);
                g.fillRect(0, blockHeight * 4, blockWidth, blockHeight);
                g.setColor(Color.white);
                stringWidth = fm.stringWidth(labelString);
                g.drawString(labelString, 0 + blockWidth / 2 - stringWidth / 2, blockHeight * 4 + blockHeight / 2 + stringHeight / 2);
                labelString = "50-60% Support";
                g.setColor(Color.orange);
                g.fillRect(0, blockHeight * 5, blockWidth, blockHeight);
                g.setColor(Color.white);
                stringWidth = fm.stringWidth(labelString);
                g.drawString(labelString, 0 + blockWidth / 2 - stringWidth / 2, blockHeight * 5 + blockHeight / 2 + stringHeight / 2);
                labelString = "0-50% Support";
                g.setColor(Color.magenta);
                g.fillRect(0, blockHeight * 6, blockWidth, blockHeight);
                g.setColor(Color.white);
                stringWidth = fm.stringWidth(labelString);
                g.drawString(labelString, 0 + blockWidth / 2 - stringWidth / 2, blockHeight * 6 + blockHeight / 2 + stringHeight / 2);
                labelString = "0% Support";
                g.setColor(Color.red);
                g.fillRect(0, blockHeight * 7, blockWidth, blockHeight);
                g.setColor(Color.white);
                stringWidth = fm.stringWidth(labelString);
                g.drawString(labelString, 0 + blockWidth / 2 - stringWidth / 2, blockHeight * 7 + blockHeight / 2 + stringHeight / 2);
                labelString = "Unrecovered Node";
                g.setColor(Color.pink);
                g.fillRect(0, blockHeight * 8, blockWidth, blockHeight);
                g.setColor(Color.white);
                stringWidth = fm.stringWidth(labelString);
                g.drawString(labelString, 0 + blockWidth / 2 - stringWidth / 2, blockHeight * 8 + blockHeight / 2 + stringHeight / 2);
            }
        };
        return legendPanel;
    }

    public Color getColorFromPercentage(double percent) {
        if (this.hideSupportColors) {
            return Color.black;
        }
        if (percent > 100.0) {
            return Color.gray;
        }
        if (percent == 100.0) {
            return Color.black;
        }
        if (percent < 100.0 && percent >= 90.0) {
            return Color.darkGray;
        }
        if (percent < 90.0 && percent >= 80.0) {
            return Color.blue;
        }
        if (percent < 80.0 && percent >= 70.0) {
            return Color.green;
        }
        if (percent < 70.0 && percent >= 60.0) {
            return Color.yellow;
        }
        if (percent < 60.0 && percent >= 50.0) {
            return Color.orange;
        }
        if (percent < 50.0 && percent > 0.0) {
            return Color.magenta;
        }
        if (percent == 0.0) {
            return Color.red;
        }
        return Color.pink;
    }

    private static class HCLSupportTreePersistenceDelegate
    extends PersistenceDelegate {
        private HCLSupportTreePersistenceDelegate() {
        }

        @Override
        public Expression instantiate(Object oldInstance, Encoder encoder) {
            HCLSupportTree aTree = (HCLSupportTree)oldInstance;
            return new Expression(aTree, aTree.getClass(), "new", new Object[]{aTree.treeData, new Integer(aTree.orientation), aTree.geneTreeSupportVector, aTree.exptTreeSupportVector});
        }
    }
}

