/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTATreeData;

public class SOTATree
extends JPanel {
    private int TREE_X_ORIGIN = 10;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int orientation = 0;
    protected Color lineColor = new Color(0, 0, 128);
    protected Color extenderColor = Color.lightGray;
    private int numberOfClusters;
    private double maxLeafToRootPath;
    private int treeHeight;
    int maxXPosition;
    private int maxNodeHeight;
    private int minNodeHeight;
    private int height;
    private int width;
    private int elementHeight = 10;
    private int elementWidth = 20;
    private int paintElementHeight;
    private int FACTOR = 20;
    private int origX;
    private int origY;
    private int utilCounter;
    private SOTATreeData sotaTreeData;
    protected IData data;
    int sign = 1;
    float[] nodeHeights;
    int[] leftChild;
    int[] rightChild;
    int[] nodePopulation;

    public boolean getGeneTree() {
        return this.orientation == 1;
    }

    public SOTATreeData getSotaTreeData() {
        return this.sotaTreeData;
    }

    public SOTATree(SOTATreeData sotaTreeData, Boolean geneTree) {
        this(sotaTreeData, (boolean)geneTree);
    }

    public SOTATree(SOTATreeData sotaTreeData, boolean geneTree) {
        this.sotaTreeData = sotaTreeData;
        this.setBackground(Color.white);
        if (!geneTree) {
            this.orientation = 1;
        }
        this.nodeHeights = sotaTreeData.nodeHeights;
        this.leftChild = sotaTreeData.leftChild;
        this.rightChild = sotaTreeData.rightChild;
        this.nodePopulation = sotaTreeData.nodePopulation;
        this.numberOfClusters = this.nodeHeights.length / 2;
        this.maxNodeHeight = 40;
        this.minNodeHeight = 5;
        this.width = this.getTreeHeight();
        this.height = this.getTreeWidth();
        if (this.orientation == 0) {
            this.setSizes(this.width, this.height);
        } else {
            this.setSizes(this.height, this.width);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.height = this.numberOfClusters * this.elementHeight;
        this.width = this.getTreeHeight();
        this.paintSotaTree(g);
    }

    private void paintSotaTree(Graphics g) {
        Color startColor = g.getColor();
        this.origX = this.TREE_X_ORIGIN;
        g.setColor(this.lineColor);
        this.paintElementHeight = this.elementHeight;
        if (this.orientation == 1) {
            ((Graphics2D)g).rotate(-1.5707963267948966);
            this.paintElementHeight = this.elementWidth;
            this.sign = -1;
            this.origY = this.getSubTreeSize(this.rightChild[0]) * this.elementWidth;
            this.paintSotaTree(g, 0, this.origX, this.origY + 10);
        } else {
            this.origY = this.getSubTreeSize(this.rightChild[0]) * this.elementHeight;
            this.paintSotaTree(g, 0, this.origX, this.origY);
        }
        g.setColor(startColor);
        this.sign = 1;
    }

    private void paintSotaTree(Graphics g, int index, int xPos, int yPosCenter) {
        int y2;
        if (this.nodePopulation[index] == 0) {
            return;
        }
        int xPosition = xPos;
        int y1 = y2 = yPosCenter;
        if (this.leftChild[index] == -1) {
            if ((xPosition = (int)((float)xPosition + (float)this.FACTOR * this.nodeHeights[index])) - xPos < this.minNodeHeight) {
                xPosition = xPos + this.minNodeHeight;
            } else if (xPosition - xPos > this.maxNodeHeight) {
                xPosition = xPos + this.maxNodeHeight;
            }
            g.drawLine(xPos * this.sign, yPosCenter, xPosition * this.sign, yPosCenter);
            g.setColor(this.extenderColor);
            g.drawLine(xPosition * this.sign, yPosCenter, this.maxXPosition * this.sign, yPosCenter);
            g.setColor(this.lineColor);
            return;
        }
        if (index == 0) {
            xPosition = xPos;
        } else {
            if ((xPosition = (int)((float)xPosition + (float)this.FACTOR * this.nodeHeights[index])) - xPos < this.minNodeHeight) {
                xPosition = xPos + this.minNodeHeight;
            } else if (xPosition - xPos > this.maxNodeHeight) {
                xPosition = xPos + this.maxNodeHeight;
            }
            this.maxXPosition = this.max(this.maxXPosition, xPosition);
            g.drawLine(xPos * this.sign, yPosCenter, xPosition * this.sign, yPosCenter);
        }
        int widthLeft = 1;
        int widthRight = 1;
        if (this.rightChild[this.leftChild[index]] != -1 && this.nodePopulation[this.rightChild[this.leftChild[index]]] != -1) {
            widthLeft = this.getSubTreeSize(this.rightChild[this.leftChild[index]]);
            y1 = yPosCenter + (widthLeft *= this.paintElementHeight);
        } else {
            y1 = yPosCenter + (int)((double)this.paintElementHeight / 2.0);
        }
        if (this.leftChild[this.rightChild[index]] != -1 && this.nodePopulation[this.leftChild[this.rightChild[index]]] != -1) {
            widthRight = this.getSubTreeSize(this.leftChild[this.rightChild[index]]);
            y2 = yPosCenter - (widthRight *= this.paintElementHeight);
        } else {
            y2 = yPosCenter - (int)((double)this.paintElementHeight / 2.0);
        }
        g.drawLine(xPosition * this.sign, yPosCenter, xPosition * this.sign, y1);
        this.paintSotaTree(g, this.leftChild[index], xPosition, y1);
        g.drawLine(xPosition * this.sign, yPosCenter, xPosition * this.sign, y2);
        this.paintSotaTree(g, this.rightChild[index], xPosition, y2);
    }

    private int getSubTreeSize(int index) {
        this.utilCounter = 0;
        this.getNumberOfSubtreeNodes(index);
        return this.utilCounter;
    }

    private void getNumberOfSubtreeNodes(int index) {
        if (this.leftChild[index] != -1) {
            this.getNumberOfSubtreeNodes(this.leftChild[index]);
        }
        if (this.rightChild[index] != -1) {
            this.getNumberOfSubtreeNodes(this.rightChild[index]);
        } else {
            ++this.utilCounter;
        }
    }

    private int max(int n, int m) {
        if (n > m) {
            return n;
        }
        return m;
    }

    public int getTreeWidth() {
        return this.elementHeight * this.numberOfClusters;
    }

    public int getTreeHeight() {
        this.maxXPosition = this.TREE_X_ORIGIN;
        this.getTreeHeight(0, this.TREE_X_ORIGIN);
        return this.maxXPosition;
    }

    private void getTreeHeight(int index, int xPos) {
        if (index < 0) {
            return;
        }
        int xPosition = xPos;
        if (this.leftChild[index] == -1) {
            if ((xPosition = (int)((float)xPosition + (float)this.FACTOR * this.nodeHeights[index])) - xPos < this.minNodeHeight) {
                xPosition = xPos + this.minNodeHeight;
            } else if (xPosition - xPos > this.maxNodeHeight) {
                xPosition = xPos + this.maxNodeHeight;
            }
            this.maxXPosition = this.max(this.maxXPosition, xPosition);
            return;
        }
        if (index == 0) {
            xPosition = xPos;
        } else {
            if ((xPosition = (int)((float)xPosition + (float)this.FACTOR * this.nodeHeights[index])) - xPos < this.minNodeHeight) {
                xPosition = xPos + this.minNodeHeight;
            } else if (xPosition - xPos > this.maxNodeHeight) {
                xPosition = xPos + this.maxNodeHeight;
            }
            this.maxXPosition = this.max(this.maxXPosition, xPosition);
        }
        this.getTreeHeight(this.leftChild[index], xPosition);
        this.getTreeHeight(this.rightChild[index], xPosition);
    }

    public void onSelected(IFramework framework) {
        this.data = framework.getData();
        this.updateSize(framework.getDisplayMenu().getElementSize());
        this.repaint();
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.updateSize(menu.getElementSize());
    }

    private void updateSize(Dimension elementSize) {
        this.elementHeight = elementSize.height;
        this.elementWidth = elementSize.width;
        switch (this.orientation) {
            case 0: {
                if (this.elementHeight == elementSize.height) {
                    return;
                }
                this.elementHeight = elementSize.height;
                this.setSizes(this.getTreeHeight(), this.elementHeight * this.numberOfClusters);
                break;
            }
            case 1: {
                if (this.elementWidth == elementSize.width) {
                    return;
                }
                this.elementWidth = elementSize.width;
                this.setSizes(this.elementWidth * this.numberOfClusters, this.getTreeHeight());
            }
        }
    }

    private void setSizes(int width, int height) {
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
    }

    public int getMinDistance() {
        return this.minNodeHeight;
    }

    public int getMaxDistance() {
        return this.maxNodeHeight;
    }

    public void setProperties(float zeroThreshold, int min, int max) {
        this.minNodeHeight = min;
        this.maxNodeHeight = max;
        this.treeHeight = this.getTreeHeight();
        if (this.orientation == 0) {
            this.setSizes(this.getTreeHeight(), this.getTreeWidth());
        } else {
            this.setSizes(this.getTreeWidth(), this.getTreeHeight());
        }
    }
}

