/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTree;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTACentroidExpressionViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAConfigDialog;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTATree;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTATreeData;
import org.tigr.util.FloatMatrix;

public class SOTAGeneTreeViewer
extends JPanel
implements IViewer {
    protected static String SET_CLUSTER_CMD = "set-cluster-cmd";
    protected static String SET_CLUSTER_TEXT_CMD = "set-cluster-text-cmd";
    protected static String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static String DELETE_CLUSTER_CMD = "delete-cluster-cmd";
    protected static String DELETE_ALL_CLUSTERS_CMD = "delete-all-clusters-cmd";
    protected static String SOTA_TREE_PROPERTIES_CMD = "gene-tree-properties-cmd";
    protected static String SAMPLE_TREE_PROPERTIES_CMD = "sample-tree-properties-cmd";
    private int numberOfCells;
    private int numberOfSamples;
    private Experiment centroidData;
    private SOTATree sotaTree;
    private FloatMatrix clusterDivFM;
    private int[] clusterPop;
    private int[][] clusterIndices;
    private ArrayList selectedClusterList = new ArrayList();
    private SOTACentroidExpressionViewer expViewer;
    private Dimension elementSize;
    private IFramework framework;
    private IData data;
    private Experiment experiment;
    private HCLExperimentHeader header;
    protected HCLTree sampleTree;
    private int elementHeight;
    private int elementWidth;
    private Listener listener;
    private int function;
    private int currClusterNum = -1;
    private DefaultMutableTreeNode expImageNode;
    private JPopupMenu popup;
    private int exptID = 0;
    private int[] samplesOrder = null;
    private Cluster hclSampleTree;

    public SOTAGeneTreeViewer(Experiment experiment, SOTATreeData sotaTreeData, Cluster hclSampleTree, int[][] clusters) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.listener = new Listener();
        this.clusterPop = sotaTreeData.clusterPopulation;
        this.clusterDivFM = sotaTreeData.clusterDiversity;
        this.clusterIndices = clusters;
        this.hclSampleTree = hclSampleTree;
        this.function = sotaTreeData.function;
        this.numberOfSamples = experiment.getNumberOfSamples();
        this.numberOfCells = sotaTreeData.clusterPopulation.length;
        this.sotaTree = new SOTATree(sotaTreeData, true);
        if (this.sotaTree != null) {
            this.sotaTree.addMouseListener(this.listener);
        }
        this.sampleTree = null;
        if (hclSampleTree != null) {
            Node sampleTreeNode = hclSampleTree.getNodeList().getNode(0);
            this.sampleTree = new HCLTree(this.getResult(sampleTreeNode, 0), 1);
            this.samplesOrder = this.getLeafOrder(this.getResult(sampleTreeNode, 0), null);
            this.sampleTree.addMouseListener(this.listener);
        }
        this.centroidData = new Experiment(sotaTreeData.centroidMatrix, this.samplesOrder != null ? this.samplesOrder : experiment.getColumnIndicesCopy());
        this.numberOfSamples = this.centroidData.getNumberOfSamples();
        this.expViewer = new SOTACentroidExpressionViewer(this.centroidData, null, this.samplesOrder, sotaTreeData.clusterPopulation, sotaTreeData.clusterDiversity, this.selectedClusterList);
        this.expViewer.addMouseListener(this.listener);
        this.header = new HCLExperimentHeader(this.expViewer.getHeaderComponent(), this.sampleTree);
        this.header.addMouseListener(this.listener);
        this.addComponents(this.sotaTree, this.expViewer, null);
        this.setLocation(0, 0);
        this.addMouseListener(this.listener);
        this.popup = this.createJPopupMenu(this.listener);
        this.experiment = experiment;
        this.exptID = experiment.getId();
    }

    public SOTAGeneTreeViewer(Integer exptID, SOTATreeData sotaTreeData, Cluster hclSampleTree, int[][] clusters) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.listener = new Listener();
        this.clusterPop = sotaTreeData.clusterPopulation;
        this.clusterDivFM = sotaTreeData.clusterDiversity;
        this.clusterIndices = clusters;
        this.function = sotaTreeData.function;
        this.numberOfCells = sotaTreeData.clusterPopulation.length;
        int[] samplesOrder = null;
        this.exptID = exptID;
        this.sotaTree = new SOTATree(sotaTreeData, true);
        if (this.sotaTree != null) {
            this.sotaTree.addMouseListener(this.listener);
        }
        this.sampleTree = null;
        if (hclSampleTree != null) {
            Node sampleTreeNode = hclSampleTree.getNodeList().getNode(0);
            this.sampleTree = new HCLTree(this.getResult(sampleTreeNode, 0), 1);
            samplesOrder = this.getLeafOrder(this.getResult(sampleTreeNode, 0), null);
            this.sampleTree.addMouseListener(this.listener);
        }
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, this.sotaTree.getSotaTreeData(), this.sampleTree, this.getClusters()});
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
        this.numberOfSamples = e.getNumberOfSamples();
        SOTATreeData sotaTreeData = this.sotaTree.getSotaTreeData();
        this.centroidData = new Experiment(sotaTreeData.centroidMatrix, this.samplesOrder != null ? this.samplesOrder : this.experiment.getColumnIndicesCopy());
        this.numberOfSamples = this.centroidData.getNumberOfSamples();
        this.expViewer = new SOTACentroidExpressionViewer(this.centroidData, null, this.samplesOrder, sotaTreeData.clusterPopulation, sotaTreeData.clusterDiversity, this.selectedClusterList);
        this.expViewer.addMouseListener(this.listener);
        this.header = new HCLExperimentHeader(this.expViewer.getHeaderComponent(), this.sampleTree);
        this.header.addMouseListener(this.listener);
        this.addComponents(this.sotaTree, this.expViewer, null);
        this.setLocation(0, 0);
        this.addMouseListener(this.listener);
        this.popup = this.createJPopupMenu(this.listener);
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int e) {
        this.exptID = e;
    }

    public void associateExpressionImageNode(DefaultMutableTreeNode ExpressionImageNode) {
        this.expImageNode = ExpressionImageNode;
    }

    private HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    int[] getSamplesOrder(int numSamples) {
        int[] order = new int[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            order[i] = i;
        }
        return order;
    }

    protected void addComponents(JComponent sotaTree, JComponent expViewer, JComponent sTree) {
        int rows = sTree == null ? 1 : 2;
        int cols = 2;
        if (sTree != null) {
            this.add((Component)sTree, new GridBagConstraints(1, rows - 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (sotaTree != null) {
            this.add((Component)sotaTree, new GridBagConstraints(0, rows - 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)expViewer, new GridBagConstraints(1, rows - 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.sotaTree.onMenuChanged(menu);
        this.expViewer.onMenuChanged(menu);
        if (this.sampleTree != null) {
            this.sampleTree.onMenuChanged(menu);
        }
        this.header.setHeaderPosition(this.sotaTree.getTreeHeight() - 10);
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
    }

    public void onDeselected() {
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        IDisplayMenu menu = framework.getDisplayMenu();
        this.elementSize = menu.getElementSize();
        if (this.expViewer.isVisible()) {
            this.expViewer.onSelected(framework);
        }
        if (this.sampleTree != null) {
            this.sampleTree.onSelected(framework);
        }
        this.sotaTree.onSelected(framework);
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.verifyClusterExistence(this.data);
        this.verifyClusterMembership(this.data);
        this.header.setHeaderPosition(this.sotaTree.getTreeHeight() - 10);
        if (this.expImageNode == null) {
            DefaultMutableTreeNode node = framework.getCurrentNode();
            if (node != null) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node != null) {
                node = (DefaultMutableTreeNode)node.getChildAt(1);
            }
            if (node != null) {
                this.expImageNode = node;
            }
        }
    }

    public int getCommonWidth() {
        int width = 0;
        if (this.sotaTree != null) {
            width += this.sotaTree.getTreeHeight();
        }
        return width += this.expViewer.getWidth();
    }

    public int getCommonHeight() {
        int height = 0;
        if (this.sotaTree != null) {
            height += this.sotaTree.getTreeWidth();
        }
        return height += this.header.getHeight();
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onDataChanged(IData data) {
        this.data = data;
        this.verifyClusterExistence(data);
    }

    private void verifyClusterExistence(IData data) {
        Color[] colors = data.getColors();
        if (colors.length == 0) {
            this.selectedClusterList.clear();
            this.expViewer.onDataChanged(data);
        }
    }

    private void verifyClusterMembership(IData data) {
        Color[] colors = data.getColors();
        Color currColor = null;
        boolean aMemberChanged = false;
        boolean membershipChanged = false;
        boolean[] alteredMembership = new boolean[this.selectedClusterList.size()];
        for (int c = 0; c < this.selectedClusterList.size(); ++c) {
            HCLCluster cluster = (HCLCluster)this.selectedClusterList.get(c);
            currColor = cluster.color;
            int index = cluster.root;
            membershipChanged = false;
            for (int exp = 0; exp < this.clusterIndices[index].length; ++exp) {
                if (currColor.equals(data.getProbeColor(this.clusterIndices[index][exp]))) continue;
                aMemberChanged = true;
                membershipChanged = true;
                break;
            }
            if (!membershipChanged) continue;
            alteredMembership[c] = true;
        }
        for (int i = this.selectedClusterList.size() - 1; i >= 0; --i) {
            if (!alteredMembership[i]) continue;
            this.selectedClusterList.remove(i);
        }
        if (aMemberChanged) {
            this.expViewer.onDataChanged(data);
        }
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private int[] getLeafOrder(HCLTreeData result, int[] indices) {
        if (result == null || result.node_order.length < 2) {
            return null;
        }
        return this.getLeafOrder(result.node_order, result.child_1_array, result.child_2_array, indices);
    }

    private int[] getLeafOrder(int[] nodeOrder, int[] child1, int[] child2, int[] indices) {
        int[] leafOrder = new int[nodeOrder.length];
        Arrays.fill(leafOrder, -1);
        this.fillLeafOrder(leafOrder, child1, child2, 0, child1.length - 2, indices);
        return leafOrder;
    }

    private int fillLeafOrder(int[] leafOrder, int[] child1, int[] child2, int pos, int index, int[] indices) {
        if (child1[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child1[index], indices);
        }
        if (child2[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child2[index], indices);
        } else {
            leafOrder[pos] = indices == null ? index : indices[index];
            ++pos;
        }
        return pos;
    }

    private Frame getFrame() {
        return JOptionPane.getFrameForComponent(this);
    }

    private void setSOTATreeProperties() {
        Frame frame = JOptionPane.getFrameForComponent(this);
        SOTAConfigDialog dialog = new SOTAConfigDialog(frame, 0.0f, this.sotaTree.getMinDistance(), this.sotaTree.getMaxDistance());
        if (dialog.showModal() == 0) {
            this.sotaTree.setProperties(dialog.getZeroThreshold(), dialog.getMinDistance(), dialog.getMaxDistance());
        }
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.header.setHeaderPosition(this.sotaTree.getTreeHeight() - 10);
        this.revalidate();
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    private void showClusterInfo(int clusterNumber) {
        int neighbor = this.getClosestCentroid(clusterNumber);
        if (neighbor == clusterNumber) {
            return;
        }
        float neighborDist = org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil.geneDistance((FloatMatrix)this.centroidData.getMatrix(), null, (int)clusterNumber, (int)neighbor, (int)this.function, (float)1.0f, (boolean)false);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.expImageNode.getChildAt(clusterNumber);
        if (this.framework != null) {
            this.framework.setTreeNode(node);
        }
    }

    private int getClosestCentroid(int centroidNum) {
        float minDist = Float.POSITIVE_INFINITY;
        int closestCentroid = centroidNum;
        for (int i = 0; i < this.numberOfCells; ++i) {
            float currDist = org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil.geneDistance((FloatMatrix)this.centroidData.getMatrix(), null, (int)centroidNum, (int)i, (int)this.function, (float)1.0f, (boolean)false);
            if (!(currDist < minDist) || i == centroidNum) continue;
            minDist = currDist;
            closestCentroid = i;
        }
        return closestCentroid;
    }

    private void onSaveCluster(int cNum) {
        try {
            ExperimentUtil.saveExperiment((Frame)this.getFrame(), (Experiment)this.experiment, (IData)this.data, (int[])this.clusterIndices[cNum]);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getFrame(), "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSetCluster(int currCluster) {
        Color newColor = JColorChooser.showDialog(this.getFrame(), "Choose color", new Color(128, 128, 128));
        if (newColor == null || currCluster == -1) {
            return;
        }
        HCLCluster cluster = new HCLCluster(currCluster, currCluster - 1, currCluster + 1);
        this.selectedClusterList.add(cluster);
        cluster.color = newColor;
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.revalidate();
        this.data.setProbesColor(this.getIDataRowIndices(this.clusterIndices[currCluster]), newColor);
        this.repaint();
    }

    private int[] getIDataRowIndices(int[] expIndices) {
        int[] dataIndices = new int[expIndices.length];
        for (int i = 0; i < expIndices.length; ++i) {
            dataIndices[i] = this.experiment.getGeneIndexMappedToData(expIndices[i]);
        }
        return dataIndices;
    }

    private void onDeleteCluster(int clusterIndex) {
        for (int i = 0; i < this.selectedClusterList.size(); ++i) {
            HCLCluster currCluster = (HCLCluster)this.selectedClusterList.get(i);
            if (currCluster.root != clusterIndex) continue;
            this.data.setProbesColor(this.clusterIndices[clusterIndex], null);
            this.selectedClusterList.remove(i);
        }
        this.repaint();
    }

    private void onDeleteAllClusters() {
        this.selectedClusterList.clear();
        this.data.deleteColors();
        this.repaint();
    }

    protected void addMenuItems(JPopupMenu menu, Listener listener) {
        JMenuItem menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save_as16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("SOTATree properties...", GUIFactory.getIcon("edit16.gif"));
        menuItem.setEnabled(this.sotaTree != null);
        menuItem.setActionCommand(SOTA_TREE_PROPERTIES_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    protected JMenuItem getJMenuItem(String command) {
        Component[] components = this.popup.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals(command)) continue;
            return (JMenuItem)components[i];
        }
        return null;
    }

    protected void setEnableMenuItem(String command, boolean enable) {
        JMenuItem item = this.getJMenuItem(command);
        if (item == null) {
            return;
        }
        item.setEnabled(enable);
    }

    private boolean isClusterSet(int clusterIndex) {
        for (int i = 0; i < this.selectedClusterList.size(); ++i) {
            HCLCluster currCluster = (HCLCluster)this.selectedClusterList.get(i);
            if (currCluster.root != clusterIndex) continue;
            return true;
        }
        return false;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String actionCmd = actionEvent.getActionCommand();
            if (actionCmd.equals(SOTA_TREE_PROPERTIES_CMD)) {
                SOTAGeneTreeViewer.this.setSOTATreeProperties();
            } else if (actionCmd.equals(SET_CLUSTER_CMD)) {
                if (SOTAGeneTreeViewer.this.currClusterNum != -1) {
                    SOTAGeneTreeViewer.this.onSetCluster(SOTAGeneTreeViewer.this.currClusterNum);
                }
            } else if (actionCmd.equals(SAVE_CLUSTER_CMD)) {
                if (SOTAGeneTreeViewer.this.currClusterNum != -1) {
                    SOTAGeneTreeViewer.this.onSaveCluster(SOTAGeneTreeViewer.this.currClusterNum);
                }
            } else if (actionCmd.equals(DELETE_CLUSTER_CMD)) {
                if (SOTAGeneTreeViewer.this.currClusterNum != -1) {
                    SOTAGeneTreeViewer.this.onDeleteCluster(SOTAGeneTreeViewer.this.currClusterNum);
                }
            } else if (actionCmd.equals(DELETE_ALL_CLUSTERS_CMD)) {
                SOTAGeneTreeViewer.this.onDeleteAllClusters();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (!this.maybeShowPopup(event) && SwingUtilities.isLeftMouseButton(event)) {
                SOTAGeneTreeViewer.this.currClusterNum = SOTAGeneTreeViewer.this.expViewer.getCurrentCentroidNumber();
                if (SOTAGeneTreeViewer.this.currClusterNum != -1) {
                    SOTAGeneTreeViewer.this.showClusterInfo(SOTAGeneTreeViewer.this.currClusterNum);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!this.maybeShowPopup(event) && SwingUtilities.isLeftMouseButton(event)) {
                SOTAGeneTreeViewer.this.currClusterNum = SOTAGeneTreeViewer.this.expViewer.getCurrentCentroidNumber();
                if (SOTAGeneTreeViewer.this.currClusterNum != -1) {
                    SOTAGeneTreeViewer.this.showClusterInfo(SOTAGeneTreeViewer.this.currClusterNum);
                }
            }
        }

        private boolean maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return false;
            }
            SOTAGeneTreeViewer.this.currClusterNum = SOTAGeneTreeViewer.this.expViewer.getCurrentCentroidNumber();
            SOTAGeneTreeViewer.this.setEnableMenuItem(SET_CLUSTER_CMD, SOTAGeneTreeViewer.this.currClusterNum != -1);
            SOTAGeneTreeViewer.this.setEnableMenuItem(DELETE_CLUSTER_CMD, SOTAGeneTreeViewer.this.currClusterNum != -1 && SOTAGeneTreeViewer.this.isClusterSet(SOTAGeneTreeViewer.this.currClusterNum));
            SOTAGeneTreeViewer.this.setEnableMenuItem(DELETE_ALL_CLUSTERS_CMD, !SOTAGeneTreeViewer.this.selectedClusterList.isEmpty());
            SOTAGeneTreeViewer.this.setEnableMenuItem(SAVE_CLUSTER_CMD, SOTAGeneTreeViewer.this.currClusterNum != -1);
            SOTAGeneTreeViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
            return true;
        }
    }
}

