/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Monitor;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTACentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTACentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTADiversityViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAExperimentTreeViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAGeneTreeViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTATreeData;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class SOTAGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private IData frameData;
    private AlgorithmData data;
    private AlgorithmData result;
    private SOTATreeData sotaTreeData;
    private Progress progress;
    private Monitor monitor;
    private Listener listener = new Listener();
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private IDistanceMenu menu;
    private boolean clusterGenes;
    private int k = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        boolean calcClusterHCL;
        boolean calcFullTreeSampleHCL;
        float maxClusterDiv;
        boolean setMaxClusterDiv;
        boolean runToMaxCycles;
        boolean useVariance;
        int maxCycles = 10;
        int maxEpochsPerCycle = 1000;
        float epochStopCriteria = 1.0E-4f;
        float maxTreeDiv = 0.01f;
        float migFactor_w = 0.01f;
        float migFactor_p = 0.005f;
        float migFactor_s = 0.001f;
        int neighborhoodLevel = 5;
        float pValue = 0.05f;
        this.frameData = framework.getData();
        this.menu = framework.getDistanceMenu();
        int function = this.menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        int distFactor = 1;
        distFactor = function == 1 || function == 6 || function == 7 || function == 2 || function == 3 || function == 5 || function == 9 || function == 10 ? -1 : 1;
        SOTAInitDialog sota_dialog = new SOTAInitDialog(framework.getFrame(), distFactor, this.menu.getFunctionName(function), this.menu.isAbsoluteDistance());
        if (sota_dialog.showModal() != 0) {
            return null;
        }
        try {
            this.clusterGenes = sota_dialog.getBoolean("clusterGenes");
            maxCycles = sota_dialog.getInt("maxCycles");
            maxEpochsPerCycle = sota_dialog.getInt("maxEpochsPerCycle");
            epochStopCriteria = sota_dialog.getFloat("epochStopCriteria");
            migFactor_w = sota_dialog.getFloat("migFactor_w");
            migFactor_p = sota_dialog.getFloat("migFactor_p");
            migFactor_s = sota_dialog.getFloat("migFactor_s");
            neighborhoodLevel = sota_dialog.getInt("neighborhood-level");
            useVariance = sota_dialog.getBoolean("useVariance");
            if (useVariance) {
                pValue = sota_dialog.getFloat("pValue");
            } else {
                maxTreeDiv = sota_dialog.getFloat("maxTreeDiv");
            }
            runToMaxCycles = sota_dialog.getBoolean("runToMaxCycles");
            setMaxClusterDiv = sota_dialog.getBoolean("setMaxClusterDiv");
            maxClusterDiv = sota_dialog.getFloat("maxClusterDiv");
            calcFullTreeSampleHCL = false;
            calcClusterHCL = sota_dialog.getBoolean("calcClusterHCL");
            if (migFactor_w <= 0.0f || migFactor_w <= 0.0f || migFactor_w <= 0.0f) {
                JOptionPane.showMessageDialog(framework.getFrame(), "Migration weights should be > 0", "Error", 0);
                return null;
            }
            if (pValue <= 0.0f) {
                JOptionPane.showMessageDialog(framework.getFrame(), "p-value should be > 0", "Error", 0);
                return null;
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Invalid input parameters!", "Error", 0);
            return null;
        }
        if (maxCycles < 1) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Number of cycles (number of clusters) must be greater than 0!", "Error", 0);
            return null;
        }
        if (maxEpochsPerCycle < 1) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Number of epochs per cycle must be greater than 0!", "Error", 0);
            return null;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = sota_dialog.getDistanceMetric();
        boolean hcl_absolute = sota_dialog.isAbsoluteDistance();
        if (calcClusterHCL || calcFullTreeSampleHCL) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), this.menu.getFunctionName(sota_dialog.getDistanceMetric()), sota_dialog.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        this.experiment = framework.getData().getExperiment();
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("SOTA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Calculating clusters", listener);
            this.progress.show();
            this.data = new AlgorithmData();
            FloatMatrix matrix = this.experiment.getMatrix();
            if (!this.clusterGenes) {
                matrix = matrix.transpose();
            }
            this.data.addMatrix("experiment", matrix);
            this.data.addParam("distance-absolute", String.valueOf(sota_dialog.isAbsoluteDistance()));
            function = sota_dialog.getDistanceMetric();
            this.data.addParam("distance-function", String.valueOf(function));
            this.data.addParam("sota-cluster-genes", String.valueOf(this.clusterGenes));
            this.data.addParam("max-number-of-cycles", String.valueOf(maxCycles));
            this.data.addParam("max-epochs-per-cycle", String.valueOf(maxEpochsPerCycle));
            this.data.addParam("epoch-improvement-cutoff", String.valueOf(epochStopCriteria));
            this.data.addParam("end-training-diversity", String.valueOf(maxTreeDiv));
            this.data.addParam("use-cluster-variance", String.valueOf(useVariance));
            this.data.addParam("pValue", String.valueOf(pValue));
            this.data.addParam("mig_w", String.valueOf(migFactor_w));
            this.data.addParam("mig_p", String.valueOf(migFactor_p));
            this.data.addParam("mig_s", String.valueOf(migFactor_s));
            this.data.addParam("neighborhood-level", String.valueOf(neighborhoodLevel));
            this.data.addParam("run-to-max-cycles", String.valueOf(runToMaxCycles));
            this.data.addParam("set-max-cluster-div", String.valueOf(setMaxClusterDiv));
            this.data.addParam("maxClusterDiv", String.valueOf(maxClusterDiv));
            this.data.addParam("calc-full-tree-hcl", String.valueOf(calcFullTreeSampleHCL));
            this.data.addParam("calc-cluster-hcl", String.valueOf(calcClusterHCL));
            if (calcClusterHCL || calcFullTreeSampleHCL) {
                this.data.addParam("calcClusterHCL", String.valueOf(calcClusterHCL));
                this.data.addParam("calcFullTreeHCL", String.valueOf(calcFullTreeSampleHCL));
                this.data.addParam("method-linkage", String.valueOf(hcl_method));
                this.data.addParam("calculate-genes", String.valueOf(hcl_genes));
                this.data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                this.data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                this.data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            long start = System.currentTimeMillis();
            this.result = this.algorithm.execute(this.data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = this.result.getCluster("cluster");
            Cluster hcl_clusters = this.result.getCluster("hcl-result-clusters");
            Cluster hcl_sample_tree = this.result.getCluster("full-tree-sample-HCL");
            NodeList nodeList = result_cluster.getNodeList();
            this.k = nodeList.getSize();
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getProbesIndexes();
            }
            this.means = this.result.getMatrix("centroid-matrix");
            this.variances = this.result.getMatrix("cluster-variances");
            GeneralInfo info = new GeneralInfo();
            info.iterations = this.result.getParams().getInt("cycles") - 1;
            info.clusters = info.iterations + 1;
            info.time = time;
            info.function = this.menu.getFunctionName(function);
            info.maxCycles = maxCycles;
            info.maxEpochsPerCycle = maxEpochsPerCycle;
            info.diversityCutoff = maxTreeDiv;
            info.epochStopCriteria = epochStopCriteria;
            info.runToMaxCycles = runToMaxCycles;
            info.migW = migFactor_w;
            info.migP = migFactor_p;
            info.migS = migFactor_s;
            info.neighborhoodLevel = neighborhoodLevel;
            info.useCellDiversity = !useVariance;
            info.useCellVariability = useVariance;
            if (useVariance) {
                info.pValue = pValue;
                info.computedVarCutoff = this.result.getParams().getFloat("computed-var-cutoff");
            }
            info.hcl_on_clusters = calcClusterHCL;
            info.hcl_on_samples_on_all_genes = calcFullTreeSampleHCL;
            info.hcl_genes_in_clusters = hcl_genes;
            info.hcl_samples_in_clusters = hcl_samples;
            info.hcl = info.hcl_on_clusters || info.hcl_on_samples_on_all_genes;
            info.hcl_method = hcl_method;
            this.loadSotaTreeData();
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(hcl_clusters, hcl_sample_tree, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        boolean calcClusterHCL;
        boolean calcFullTreeSampleHCL;
        float maxClusterDiv;
        boolean setMaxClusterDiv;
        boolean runToMaxCycles;
        boolean useVariance;
        int maxCycles = 10;
        int maxEpochsPerCycle = 1000;
        float epochStopCriteria = 1.0E-4f;
        float maxTreeDiv = 0.01f;
        float migFactor_w = 0.01f;
        float migFactor_p = 0.005f;
        float migFactor_s = 0.001f;
        int neighborhoodLevel = 5;
        float pValue = 0.05f;
        this.frameData = framework.getData();
        this.menu = framework.getDistanceMenu();
        int function = this.menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        int distFactor = 1;
        distFactor = function == 1 || function == 6 || function == 7 || function == 2 || function == 3 || function == 5 || function == 9 || function == 10 ? -1 : 1;
        SOTAInitDialog sota_dialog = new SOTAInitDialog(framework.getFrame(), distFactor, this.menu.getFunctionName(function), this.menu.isAbsoluteDistance());
        if (sota_dialog.showModal() != 0) {
            return null;
        }
        try {
            this.clusterGenes = sota_dialog.getBoolean("clusterGenes");
            maxCycles = sota_dialog.getInt("maxCycles");
            maxEpochsPerCycle = sota_dialog.getInt("maxEpochsPerCycle");
            epochStopCriteria = sota_dialog.getFloat("epochStopCriteria");
            migFactor_w = sota_dialog.getFloat("migFactor_w");
            migFactor_p = sota_dialog.getFloat("migFactor_p");
            migFactor_s = sota_dialog.getFloat("migFactor_s");
            neighborhoodLevel = sota_dialog.getInt("neighborhood-level");
            useVariance = sota_dialog.getBoolean("useVariance");
            if (useVariance) {
                pValue = sota_dialog.getFloat("pValue");
            } else {
                maxTreeDiv = sota_dialog.getFloat("maxTreeDiv");
            }
            runToMaxCycles = sota_dialog.getBoolean("runToMaxCycles");
            setMaxClusterDiv = sota_dialog.getBoolean("setMaxClusterDiv");
            maxClusterDiv = sota_dialog.getFloat("maxClusterDiv");
            calcFullTreeSampleHCL = false;
            calcClusterHCL = sota_dialog.getBoolean("calcClusterHCL");
            if (migFactor_w <= 0.0f || migFactor_w <= 0.0f || migFactor_w <= 0.0f) {
                JOptionPane.showMessageDialog(framework.getFrame(), "Migration weights should be > 0", "Error", 0);
                return null;
            }
            if (pValue <= 0.0f) {
                JOptionPane.showMessageDialog(framework.getFrame(), "p-value should be > 0", "Error", 0);
                return null;
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Invalid input parameters!", "Error", 0);
            return null;
        }
        if (maxCycles < 1) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Number of cycles (number of clusters) must be greater than 0!", "Error", 0);
            return null;
        }
        if (maxEpochsPerCycle < 1) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Number of epochs per cycle must be greater than 0!", "Error", 0);
            return null;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = sota_dialog.getDistanceMetric();
        boolean hcl_absolute = sota_dialog.isAbsoluteDistance();
        if (calcClusterHCL || calcFullTreeSampleHCL) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), this.menu.getFunctionName(sota_dialog.getDistanceMetric()), sota_dialog.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        this.experiment = framework.getData().getExperiment();
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("SOTA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.data = new AlgorithmData();
            this.data.addParam("distance-absolute", String.valueOf(sota_dialog.isAbsoluteDistance()));
            function = sota_dialog.getDistanceMetric();
            this.data.addParam("distance-function", String.valueOf(function));
            this.data.addParam("sota-cluster-genes", String.valueOf(this.clusterGenes));
            this.data.addParam("max-number-of-cycles", String.valueOf(maxCycles));
            this.data.addParam("max-epochs-per-cycle", String.valueOf(maxEpochsPerCycle));
            this.data.addParam("epoch-improvement-cutoff", String.valueOf(epochStopCriteria));
            this.data.addParam("end-training-diversity", String.valueOf(maxTreeDiv));
            this.data.addParam("use-cluster-variance", String.valueOf(useVariance));
            this.data.addParam("pValue", String.valueOf(pValue));
            this.data.addParam("mig_w", String.valueOf(migFactor_w));
            this.data.addParam("mig_p", String.valueOf(migFactor_p));
            this.data.addParam("mig_s", String.valueOf(migFactor_s));
            this.data.addParam("neighborhood-level", String.valueOf(neighborhoodLevel));
            this.data.addParam("run-to-max-cycles", String.valueOf(runToMaxCycles));
            this.data.addParam("set-max-cluster-div", String.valueOf(setMaxClusterDiv));
            this.data.addParam("maxClusterDiv", String.valueOf(maxClusterDiv));
            this.data.addParam("calc-full-tree-hcl", String.valueOf(calcFullTreeSampleHCL));
            this.data.addParam("calc-cluster-hcl", String.valueOf(calcClusterHCL));
            if (calcClusterHCL || calcFullTreeSampleHCL) {
                this.data.addParam("calcClusterHCL", String.valueOf(calcClusterHCL));
                this.data.addParam("calcFullTreeHCL", String.valueOf(calcFullTreeSampleHCL));
                this.data.addParam("method-linkage", String.valueOf(hcl_method));
                this.data.addParam("calculate-genes", String.valueOf(hcl_genes));
                this.data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                this.data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                this.data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            this.data.addParam("name", "SOTA");
            if (this.clusterGenes) {
                this.data.addParam("alg-type", "cluster-genes");
            } else {
                this.data.addParam("alg-type", "cluster-experiments");
            }
            if (this.clusterGenes) {
                this.data.addParam("output-class", "multi-gene-cluster-output");
            } else {
                this.data.addParam("output-class", "multi-experiment-cluster-output");
            }
            String[] outputNodes = new String[]{"Multi-cluster"};
            this.data.addStringArray("output-nodes", outputNodes);
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        this.experiment = experiment;
        this.frameData = framework.getData();
        this.clusterGenes = algData.getParams().getBoolean("sota-cluster-genes");
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("SOTA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            if (this.clusterGenes) {
                algData.addMatrix("experiment", experiment.getMatrix());
            } else {
                algData.addMatrix("experiment", experiment.getMatrix().transpose());
            }
            this.progress = new Progress(framework.getFrame(), "Calculating clusters", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            this.result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = this.result.getCluster("cluster");
            Cluster hcl_clusters = this.result.getCluster("hcl-result-clusters");
            Cluster hcl_sample_tree = this.result.getCluster("full-tree-sample-HCL");
            NodeList nodeList = result_cluster.getNodeList();
            this.k = nodeList.getSize();
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getProbesIndexes();
            }
            this.means = this.result.getMatrix("centroid-matrix");
            this.variances = this.result.getMatrix("cluster-variances");
            GeneralInfo info = new GeneralInfo();
            info.iterations = this.result.getParams().getInt("cycles") - 1;
            info.clusters = info.iterations + 1;
            info.time = time;
            AlgorithmParameters params = algData.getParams();
            info.function = framework.getDistanceMenu().getFunctionName(params.getInt("distance-function"));
            info.maxCycles = params.getInt("max-number-of-cycles");
            info.maxEpochsPerCycle = params.getInt("max-epochs-per-cycle");
            info.diversityCutoff = params.getFloat("end-training-diversity");
            info.epochStopCriteria = params.getFloat("epoch-improvement-cutoff");
            info.runToMaxCycles = params.getBoolean("run-to-max-cycles");
            info.migW = params.getFloat("mig_w");
            info.migP = params.getFloat("mig_p");
            info.migS = params.getFloat("mig_s");
            info.neighborhoodLevel = params.getInt("neighborhood-level");
            info.useCellDiversity = !params.getBoolean("use-cluster-variance");
            info.useCellVariability = params.getBoolean("use-cluster-variance");
            if (info.useCellVariability) {
                info.pValue = params.getFloat("pValue");
                info.computedVarCutoff = this.result.getParams().getFloat("computed-var-cutoff");
            }
            info.hcl_on_clusters = params.getBoolean("calc-cluster-hcl");
            info.hcl_on_samples_on_all_genes = params.getBoolean("calc-full-tree-hcl");
            info.hcl_genes_in_clusters = params.getBoolean("calculate-genes");
            info.hcl_samples_in_clusters = params.getBoolean("calculate-experiments");
            boolean bl = info.hcl = info.hcl_on_clusters || info.hcl_on_samples_on_all_genes;
            if (info.hcl) {
                info.hcl_method = params.getInt("method-linkage");
            }
            this.loadSotaTreeData();
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(hcl_clusters, hcl_sample_tree, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private void loadSotaTreeData() {
        this.sotaTreeData = new SOTATreeData();
        this.sotaTreeData.nodeHeights = this.result.getMatrix("node-heights").getRowPackedCopy();
        this.sotaTreeData.leftChild = this.result.getIntArray("left-child");
        this.sotaTreeData.rightChild = this.result.getIntArray("right-child");
        this.sotaTreeData.nodePopulation = this.result.getIntArray("node-population");
        this.sotaTreeData.centroidMatrix = this.result.getMatrix("centroid-matrix");
        this.sotaTreeData.clusterDiversity = this.result.getMatrix("cluster-diversity");
        this.sotaTreeData.clusterPopulation = this.result.getIntArray("cluster-population");
        this.sotaTreeData.function = this.result.getParams().getInt("distance-function");
        this.sotaTreeData.factor = this.result.getParams().getFloat("factor");
        this.sotaTreeData.absolute = this.result.getParams().getBoolean("distance-absolute", true);
    }

    private DefaultMutableTreeNode createResultTree(Cluster hcl_clusters, Cluster hcl_sample_tree, GeneralInfo info) {
        DefaultMutableTreeNode root = this.clusterGenes ? new DefaultMutableTreeNode("SOTA - genes") : new DefaultMutableTreeNode("SOTA - samples");
        this.addResultNodes(root, hcl_clusters, hcl_sample_tree, info);
        return root;
    }

    private void addResultNodes(DefaultMutableTreeNode root, Cluster hcl_clusters, Cluster hcl_sample_tree, GeneralInfo info) {
        SOTAGeneTreeViewer sotaViewer = null;
        DefaultMutableTreeNode expressionImageNode = null;
        if (this.clusterGenes) {
            sotaViewer = this.addSotaGeneViewer(root, hcl_sample_tree);
            expressionImageNode = this.addExpressionImages(root);
            sotaViewer.associateExpressionImageNode(expressionImageNode);
        } else {
            SOTAExperimentTreeViewer sotaExpViewer = this.addSotaExperimentViewer(root, hcl_sample_tree);
            expressionImageNode = this.addExpressionImages(root);
            sotaExpViewer.associateExpressionImageNode(expressionImageNode);
        }
        this.addHierarchicalTrees(root, hcl_clusters, info);
        this.addCentroidViews(root);
        this.addTableViews(root);
        this.addDiversityViewer(root);
        this.addClusterInfo(root);
        this.addGeneralInfo(root, info);
    }

    private void addTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table views");
        Object tabViewer = this.clusterGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.frameData) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.frameData);
        for (int i = 0; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    private SOTAGeneTreeViewer addSotaGeneViewer(DefaultMutableTreeNode root, Cluster hcl_sample_tree) {
        SOTAGeneTreeViewer viewer = new SOTAGeneTreeViewer(this.experiment, this.sotaTreeData, hcl_sample_tree, this.clusters);
        if (viewer != null) {
            root.add(new DefaultMutableTreeNode(new LeafInfo("SOTA Dendogram", (IViewer)viewer)));
        }
        return viewer;
    }

    private SOTAExperimentTreeViewer addSotaExperimentViewer(DefaultMutableTreeNode root, Cluster hcl_sample_tree) {
        SOTAExperimentTreeViewer viewer = new SOTAExperimentTreeViewer(this.experiment, this.sotaTreeData, this.clusters);
        if (viewer != null) {
            root.add(new DefaultMutableTreeNode(new LeafInfo("SOTA Dendogram", (IViewer)viewer)));
        }
        return viewer;
    }

    private void addDiversityViewer(DefaultMutableTreeNode root) {
        if (this.result != null) {
            root.add(new DefaultMutableTreeNode(new LeafInfo("SOTA Diversity History", (IViewer)new SOTADiversityViewer(this.result.getMatrix("cycle-diversity")))));
        }
    }

    private DefaultMutableTreeNode addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        SOTAExperimentViewer expViewer = this.clusterGenes ? new SOTAExperimentViewer(this.experiment, this.clusters, this.result.getMatrix("centroid-matrix"), this.result.getMatrix("cluster-diversity"), this.sotaTreeData) : new SOTAExperimentViewer(this.experiment, this.clusters, this.result.getMatrix("centroid-matrix"), this.result.getMatrix("cluster-diversity"), this.sotaTreeData, this.clusterGenes);
        for (int i = 0; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expViewer, (Object)new Integer(i))));
        }
        root.add(node);
        return node;
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        int i;
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        Object clusters = null;
        if (!this.clusterGenes) {
            clusters = new int[this.k][];
            for (i = 0; i < this.k; ++i) {
                clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            if (info.hcl_samples_in_clusters) {
                clusters = this.getOrderedIndices(nodeList, (int[][])clusters, info.hcl_genes_in_clusters);
            }
        }
        for (i = 0; i < nodeList.getSize(); ++i) {
            if (this.clusterGenes) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), info, null))));
                continue;
            }
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
        }
        root.add(node);
    }

    private IViewer createHCLViewer(Node clusterNode, GeneralInfo info, int[][] sampleClusters) {
        HCLTreeData samples_result;
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes_in_clusters ? this.getResult(clusterNode, 0) : null;
        HCLTreeData hCLTreeData2 = info.hcl_samples_in_clusters ? this.getResult(clusterNode, info.hcl_genes_in_clusters ? 4 : 0) : (samples_result = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
        }
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result, sampleClusters, true);
    }

    private HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    private void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", (IViewer)new SOTAInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Clusters (#,%)", (IViewer)new SOTAInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false))));
        }
        root.add(node);
    }

    private void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            SOTACentroidViewer centroidViewer = new SOTACentroidViewer(this.experiment, this.clusters);
            centroidViewer.setMeans(this.means.A);
            centroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            SOTACentroidsViewer centroidsViewer = new SOTACentroidsViewer(this.experiment, this.clusters);
            centroidsViewer.setMeans(this.means.A);
            centroidsViewer.setVariances(this.variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(1))));
        } else {
            SOTAExperimentCentroidViewer expCentroidViewer = new SOTAExperimentCentroidViewer(this.experiment, this.clusters);
            expCentroidViewer.setMeans(this.means.A);
            expCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            SOTAExperimentCentroidsViewer expCentroidsViewer = new SOTAExperimentCentroidsViewer(this.experiment, this.clusters);
            expCentroidsViewer.setMeans(this.means.A);
            expCentroidsViewer.setVariances(this.variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(1))));
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        DefaultMutableTreeNode gtc = new DefaultMutableTreeNode("Growth Termination Criteria");
        gtc.add(new DefaultMutableTreeNode("Max. cycles: " + String.valueOf(info.maxCycles)));
        gtc.add(new DefaultMutableTreeNode("Max. epochs/cycle: " + String.valueOf(info.maxEpochsPerCycle)));
        if (info.useCellDiversity) {
            gtc.add(new DefaultMutableTreeNode("Max. cell div: " + String.valueOf(info.diversityCutoff)));
        } else {
            gtc.add(new DefaultMutableTreeNode("Max. cell div: n/a (used variability and p value)"));
        }
        gtc.add(new DefaultMutableTreeNode("Min. epoch error change: " + String.valueOf(info.epochStopCriteria)));
        gtc.add(new DefaultMutableTreeNode("Run max. cycles (unrestricted): " + String.valueOf(info.runToMaxCycles)));
        DefaultMutableTreeNode mp = new DefaultMutableTreeNode("Migration Parameters");
        mp.add(new DefaultMutableTreeNode("Winning cell mig. factor: " + String.valueOf(info.migW)));
        mp.add(new DefaultMutableTreeNode("Parent cell mig. factor: " + String.valueOf(info.migP)));
        mp.add(new DefaultMutableTreeNode("Sister cell mig. factor: " + String.valueOf(info.migS)));
        mp.add(new DefaultMutableTreeNode("Neighborhood level: " + String.valueOf(info.neighborhoodLevel)));
        DefaultMutableTreeNode cdc = new DefaultMutableTreeNode("Cell Division Criteria");
        cdc.add(new DefaultMutableTreeNode("Diversity division criteria: " + String.valueOf(info.useCellDiversity)));
        cdc.add(new DefaultMutableTreeNode("Variability division criteria: " + String.valueOf(info.useCellVariability)));
        if (info.useCellVariability) {
            cdc.add(new DefaultMutableTreeNode("Variablity pValue: " + String.valueOf(info.pValue)));
            cdc.add(new DefaultMutableTreeNode("Computed Cell Var. Cutoff: " + String.valueOf(info.computedVarCutoff)));
        } else {
            cdc.add(new DefaultMutableTreeNode("Variablity pValue: n/a"));
            cdc.add(new DefaultMutableTreeNode("Computed cell var. cutoff: n/a"));
        }
        DefaultMutableTreeNode ho = new DefaultMutableTreeNode("HCL Options");
        if (info.hcl_on_samples_on_all_genes || info.hcl_on_clusters) {
            ho.add(new DefaultMutableTreeNode("HCL on samples (over all genes): " + String.valueOf(info.hcl_on_samples_on_all_genes)));
            ho.add(new DefaultMutableTreeNode("HCL on samples in clusters: " + String.valueOf(info.hcl_samples_in_clusters)));
            ho.add(new DefaultMutableTreeNode("HCL on genes in clusters: " + String.valueOf(info.hcl_genes_in_clusters)));
            ho.add(new DefaultMutableTreeNode("Tree - " + info.getMethodName()));
        }
        node.add(gtc);
        node.add(mp);
        node.add(cdc);
        if (info.hcl_on_samples_on_all_genes || info.hcl_on_clusters) {
            node.add(ho);
        }
        node.add(new DefaultMutableTreeNode("number of clusters: " + String.valueOf(info.clusters)));
        node.add(new DefaultMutableTreeNode("Cycles run: " + String.valueOf(info.iterations)));
        node.add(new DefaultMutableTreeNode(info.function));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        root.add(node);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] sampleClusters, boolean calcGeneHCL) {
        for (int i = 0; i < sampleClusters.length; ++i) {
            if (sampleClusters[i].length <= 0) continue;
            HCLTreeData result = this.getResult(nodeList.getNode(i), calcGeneHCL ? 4 : 0);
            sampleClusters[i] = this.getSampleOrder(result, sampleClusters[i]);
        }
        return sampleClusters;
    }

    private int[] getSampleOrder(HCLTreeData result, int[] indices) {
        return this.getLeafOrder(result.node_order, result.child_1_array, result.child_2_array, indices);
    }

    private int[] getLeafOrder(int[] nodeOrder, int[] child1, int[] child2, int[] indices) {
        int[] leafOrder = new int[nodeOrder.length];
        Arrays.fill(leafOrder, -1);
        this.fillLeafOrder(leafOrder, child1, child2, 0, child1.length - 2, indices);
        return leafOrder;
    }

    private int fillLeafOrder(int[] leafOrder, int[] child1, int[] child2, int pos, int index, int[] indices) {
        if (child1[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child1[index], indices);
        }
        if (child2[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child2[index], indices);
        } else {
            leafOrder[pos] = indices == null ? index : indices[index];
            ++pos;
        }
        return pos;
    }

    private class GeneralInfo {
        public int clusters;
        public int iterations;
        public long time;
        public String function;
        public int maxCycles;
        public int maxEpochsPerCycle;
        public float diversityCutoff;
        public float epochStopCriteria;
        public boolean runToMaxCycles;
        public float migW;
        public float migP;
        public float migS;
        public int neighborhoodLevel;
        public boolean useCellDiversity;
        public boolean useCellVariability;
        public float pValue;
        public float computedVarCutoff;
        public boolean hcl;
        public int hcl_method;
        public boolean hcl_on_clusters;
        public boolean hcl_on_samples_on_all_genes;
        public boolean hcl_genes_in_clusters;
        public boolean hcl_samples_in_clusters;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    SOTAGUI.this.progress.setUnits(event.getIntValue());
                    SOTAGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    SOTAGUI.this.progress.setValue(event.getIntValue());
                    SOTAGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value == -1) {
                        SOTAGUI.this.monitor.dispose();
                        break;
                    }
                    if (value >= 245) break;
                    SOTAGUI.this.monitor.update(value);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                SOTAGUI.this.algorithm.abort();
                SOTAGUI.this.progress.dispose();
                SOTAGUI.this.monitor.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SOTAGUI.this.algorithm.abort();
            SOTAGUI.this.progress.dispose();
            SOTAGUI.this.monitor.dispose();
        }
    }
}

