/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.LineBorder;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAInfoStats;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTATreeData;
import org.tigr.util.FloatMatrix;

public class SOTAExperimentViewer
extends ExperimentViewer
implements IViewer {
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    private static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    private static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    private static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private IViewer expViewer;
    private JComponent header;
    private InfoPanel infoPanel;
    private JPanel viewPanel;
    private int[][] clusters;
    private FloatMatrix clusterDivFM;
    private FloatMatrix centroidDataFM;
    private int numberOfCells;
    private float factor;
    private int function;
    private boolean geneClusterViewer = true;
    private boolean useDoubleGradient = true;
    private FloatMatrix codes;
    private SOTATreeData sotaTreeData;

    public SOTAExperimentViewer(Experiment experiment, int[][] clusters, FloatMatrix codes, FloatMatrix clusterDiv, SOTATreeData sotaTreeData) {
        this.setLayout(new GridBagLayout());
        Listener listener = new Listener();
        this.codes = codes;
        this.popup = this.createJPopupMenu(listener);
        this.clusters = clusters;
        this.clusterDivFM = clusterDiv;
        this.numberOfCells = 0;
        this.exptID = experiment.getId();
        if (this.clusterDivFM != null) {
            this.numberOfCells = this.clusterDivFM.getRowDimension();
        }
        this.centroidDataFM = codes;
        this.sotaTreeData = sotaTreeData;
        this.factor = sotaTreeData.factor;
        this.function = sotaTreeData.function;
        this.expViewer = new ExperimentViewer(experiment, clusters);
        this.expViewer.getContentComponent().addMouseListener(listener);
        this.setInsets(new Insets(0, 0, 0, 0));
        this.header = new CentroidExperimentHeader(this.expViewer.getHeaderComponent(), codes, clusters, "SOTA Centroid Vector");
        ((CentroidExperimentHeader)this.header).setNegAndPosColorImages(((ExperimentViewer)this.expViewer).getNegColorImage(), ((ExperimentViewer)this.expViewer).getPosColorImage());
        this.infoPanel = new InfoPanel();
        this.infoPanel.addMouseListener(listener);
        ((CentroidExperimentHeader)this.header).setNegAndPosColorImages(((ExperimentViewer)this.expViewer).getNegColorImage(), ((ExperimentViewer)this.expViewer).getPosColorImage());
        ((CentroidExperimentHeader)this.header).setMissingColor(((ExperimentViewer)this.expViewer).getMissingColor());
        ((CentroidExperimentHeader)this.header).addMouseListener((MouseListener)listener);
        this.viewPanel = new JPanel();
        this.viewPanel.setLayout(new GridBagLayout());
        this.viewPanel.add((Component)((JComponent)this.expViewer), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.viewPanel.add((Component)this.infoPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.viewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public SOTAExperimentViewer(Experiment experiment, ClusterWrapper clusters, FloatMatrix codes, FloatMatrix clusterDiv, SOTATreeData sotaTreeData, Boolean clusterGenes) {
        this(experiment, clusters.getClusters(), codes, clusterDiv, sotaTreeData, (boolean)clusterGenes);
    }

    public SOTAExperimentViewer(Experiment experiment, int[][] clusters, FloatMatrix codes, FloatMatrix clusterDiv, SOTATreeData sotaTreeData, Boolean clusterGenes) {
        this(experiment, clusters, codes, clusterDiv, sotaTreeData, (boolean)clusterGenes);
    }

    public SOTAExperimentViewer(Experiment experiment, int[][] clusters, FloatMatrix codes, FloatMatrix clusterDiv, SOTATreeData sotaTreeData, boolean clusterGenes) {
        this.setLayout(new GridBagLayout());
        this.codes = codes;
        this.geneClusterViewer = clusterGenes;
        this.exptID = experiment.getId();
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.clusters = clusters;
        this.clusterDivFM = clusterDiv;
        this.numberOfCells = 0;
        if (this.clusterDivFM != null) {
            this.numberOfCells = this.clusterDivFM.getRowDimension();
        }
        this.centroidDataFM = codes;
        this.sotaTreeData = sotaTreeData;
        this.factor = sotaTreeData.factor;
        this.function = sotaTreeData.function;
        if (!clusterGenes) {
            this.expViewer = new ExperimentClusterViewer(experiment, clusters, "Sota Centroid Vector", codes.getArrayCopy());
            this.header = (ExperimentClusterHeader)this.expViewer.getHeaderComponent();
        } else {
            this.expViewer = new ExperimentViewer(experiment, clusters);
            this.header = new CentroidExperimentHeader(this.expViewer.getHeaderComponent(), codes, this.clusters, "SOTA Centroid Vector");
        }
        this.expViewer.getContentComponent().addMouseListener(listener);
        this.infoPanel = new InfoPanel();
        this.infoPanel.addMouseListener(listener);
        this.setInsets(new Insets(0, 0, 0, 0));
        this.viewPanel = new JPanel();
        this.viewPanel.setLayout(new GridBagLayout());
        this.viewPanel.add((Component)((JComponent)this.expViewer), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.viewPanel.add((Component)this.infoPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.viewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public Expression getExpression() {
        return new Expression((Object)this, ((Object)((Object)this)).getClass(), "new", new Object[]{this.expViewer.getExperiment(), this.clusters, this.codes, this.clusterDivFM, this.sotaTreeData, new Boolean(this.geneClusterViewer)});
    }

    public SOTAExperimentViewer(IViewer exptViewer, Float factor, Integer function, Integer numberOfCells, Boolean geneClusterViewer, Boolean useDoubleGradient, FloatMatrix clusterDivFM, FloatMatrix centroidDataFM, int[][] clusters, JComponent header, Insets insets, Integer exptID, FloatMatrix codes, JPanel viewPanel) {
        this.setLayout(new GridBagLayout());
        this.expViewer = exptViewer;
        this.factor = factor.floatValue();
        this.function = function;
        this.numberOfCells = numberOfCells;
        this.geneClusterViewer = geneClusterViewer;
        this.useDoubleGradient = useDoubleGradient;
        this.clusterDivFM = clusterDivFM;
        this.centroidDataFM = centroidDataFM;
        this.clusters = clusters;
        this.header = header;
        this.setInsets(insets);
        this.exptID = exptID;
        this.codes = codes;
        this.viewPanel = viewPanel;
    }

    public void setExperiment(Experiment e) {
        super.setExperiment(e);
        this.expViewer.setExperiment(e);
        Listener listener = new Listener();
        this.expViewer.getContentComponent().addMouseListener(listener);
        this.infoPanel = new InfoPanel();
        this.infoPanel.addMouseListener(listener);
        this.header.addMouseListener(listener);
        this.popup = this.createJPopupMenu(listener);
        if (!this.geneClusterViewer) {
            this.header = (ExperimentClusterHeader)this.expViewer.getHeaderComponent();
            ((ExperimentClusterHeader)this.header).setExperiment(e);
        } else {
            this.header = new CentroidExperimentHeader(this.expViewer.getHeaderComponent(), this.codes, this.clusters, "SOTA Centroid Vector");
            ((CentroidExperimentHeader)this.header).setExperiment(e);
            ((CentroidExperimentHeader)this.header).setNegAndPosColorImages(((ExperimentViewer)this.expViewer).getNegColorImage(), ((ExperimentViewer)this.expViewer).getPosColorImage());
            ((CentroidExperimentHeader)this.header).setNegAndPosColorImages(((ExperimentViewer)this.expViewer).getNegColorImage(), ((ExperimentViewer)this.expViewer).getPosColorImage());
            ((CentroidExperimentHeader)this.header).setNegAndPosColorImages(((ExperimentViewer)this.expViewer).getNegColorImage(), ((ExperimentViewer)this.expViewer).getPosColorImage());
            ((CentroidExperimentHeader)this.header).setMissingColor(((ExperimentViewer)this.expViewer).getMissingColor());
        }
        this.viewPanel.add((Component)((JComponent)this.expViewer), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.viewPanel.add((Component)this.infoPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.viewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addComponents(JComponent header, ExperimentViewer expImageViewer, InfoPanel info) {
        this.add((Component)expImageViewer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.add(info, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return this.expViewer.getImage();
    }

    public void onSelected(IFramework framework) {
        this.setFramework(framework);
        if (this.geneClusterViewer) {
            ((ExperimentViewer)this.expViewer).onSelected(framework);
        } else {
            ((ExperimentClusterViewer)this.expViewer).onSelected(framework);
        }
        Integer userObject = (Integer)framework.getUserObject();
        this.infoPanel.setCurrentCluster(userObject == null ? 0 : userObject);
        this.infoPanel.onSelected();
        IDisplayMenu menu = framework.getDisplayMenu();
        this.useDoubleGradient = menu.getUseDoubleGradient();
        if (this.geneClusterViewer) {
            ((CentroidExperimentHeader)this.header).setCurrentCluster(userObject == null ? 0 : userObject);
            ((CentroidExperimentHeader)this.header).setNegAndPosColorImages(menu.getNegativeGradientImage(), menu.getPositiveGradientImage());
            ((CentroidExperimentHeader)this.header).setValues(menu.getMinRatioScale(), menu.getMidRatioValue(), menu.getMaxRatioScale());
            ((CentroidExperimentHeader)this.header).setAntiAliasing(menu.isAntiAliasing());
            ((CentroidExperimentHeader)this.header).setDrawBorders(menu.isDrawingBorder());
            ((CentroidExperimentHeader)this.header).updateSize(menu.getElementSize());
            ((CentroidExperimentHeader)this.header).setUseDoubleGradient(this.useDoubleGradient);
            int height = ((CentroidExperimentHeader)this.header).getCurrHeight();
            this.header.setSize(this.getContentWidth(), height);
            this.header.setPreferredSize(new Dimension(this.getContentWidth(), height));
        } else {
            ((ExperimentClusterHeader)this.header).updateSizes(this.getContentWidth(), menu.getElementSize().width);
            ((ExperimentClusterHeader)this.header).setUseDoubleGradient(this.useDoubleGradient);
            ((ExperimentClusterHeader)this.header).setValues(menu.getMinRatioScale(), menu.getMidRatioValue(), menu.getMaxRatioScale());
        }
        this.repaint();
    }

    public int getContentWidth() {
        int width = this.geneClusterViewer ? ((ExperimentViewer)this.expViewer).getContentWidth() : ((ExperimentClusterViewer)this.expViewer).getContentWidth();
        return width += this.infoPanel.INFO_PANEL_WIDTH;
    }

    public void onDataChanged(IData data) {
        this.expViewer.onDataChanged(data);
    }

    public void onMenuChanged(IDisplayMenu menu) {
        if (this.geneClusterViewer) {
            ((ExperimentViewer)this.expViewer).onMenuChanged(menu);
        } else {
            ((ExperimentClusterViewer)this.expViewer).onMenuChanged(menu);
        }
        this.useDoubleGradient = menu.getUseDoubleGradient();
        if (this.geneClusterViewer) {
            ((CentroidExperimentHeader)this.header).setNegAndPosColorImages(menu.getNegativeGradientImage(), menu.getPositiveGradientImage());
            ((CentroidExperimentHeader)this.header).setValues(-Math.abs(menu.getMinRatioScale()), Math.abs(menu.getMaxRatioScale()));
            ((CentroidExperimentHeader)this.header).setAntiAliasing(menu.isAntiAliasing());
            ((CentroidExperimentHeader)this.header).setDrawBorders(menu.isDrawingBorder());
            ((CentroidExperimentHeader)this.header).updateSize(menu.getElementSize());
            ((CentroidExperimentHeader)this.header).setUseDoubleGradient(this.useDoubleGradient);
            this.header.setSize(this.getContentWidth(), this.header.getHeight());
            this.header.setPreferredSize(new Dimension(this.getContentWidth(), this.header.getHeight()));
        } else {
            ((ExperimentClusterHeader)this.header).updateSizes(this.getContentWidth(), menu.getElementSize().width);
            ((ExperimentClusterHeader)this.header).setUseDoubleGradient(this.useDoubleGradient);
        }
        this.repaint();
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Store cluster", GUIFactory.getIcon("new16.gif"));
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("analysis16.gif"));
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon("delete16.gif"));
        menuItem.setActionCommand(SET_DEF_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon("save16.gif"));
        menuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Matrix to Gaggle", GUIFactory.getIcon("gaggle_icon_16.gif"));
        menuItem.setActionCommand("broadcast-matrix-to-gaggle");
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Gene List to Gaggle", GUIFactory.getIcon("gaggle_icon_16.gif"));
        menuItem.setActionCommand("broadcast-namelist-to-gaggle");
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            if (this.expViewer instanceof ExperimentViewer) {
                ((ExperimentViewer)this.expViewer).saveClusters(frame);
            } else {
                ((ExperimentClusterViewer)this.expViewer).saveClusters(frame);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            if (this.expViewer instanceof ExperimentViewer) {
                ((ExperimentViewer)this.expViewer).saveCluster(frame);
            } else {
                ((ExperimentClusterViewer)this.expViewer).saveCluster(frame);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color newColor = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (newColor != null) {
            if (this.expViewer instanceof ExperimentViewer) {
                ((ExperimentViewer)this.expViewer).setClusterColor(newColor);
            } else {
                ((ExperimentClusterViewer)this.expViewer).setClusterColor(newColor);
            }
        }
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            if (this.expViewer instanceof ExperimentViewer) {
                ((ExperimentViewer)this.expViewer).setClusterColor(null);
            } else {
                ((ExperimentClusterViewer)this.expViewer).setClusterColor(null);
            }
        }
    }

    public void launchNewSession() {
        if (this.expViewer instanceof ExperimentViewer) {
            ((ExperimentViewer)this.expViewer).launchNewSession();
        } else {
            ((ExperimentClusterViewer)this.expViewer).launchNewSession();
        }
    }

    public void storeCluster() {
        if (this.expViewer instanceof ExperimentViewer) {
            ((ExperimentViewer)this.expViewer).storeCluster();
        } else {
            ((ExperimentClusterViewer)this.expViewer).storeCluster();
        }
    }

    protected void onSetDefaultColor() {
        if (this.expViewer instanceof ExperimentViewer) {
            ((ExperimentViewer)this.expViewer).setClusterColor(null);
        } else {
            ((ExperimentClusterViewer)this.expViewer).setClusterColor(null);
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return this.expViewer.getClusters();
    }

    public Experiment getExperiment() {
        return this.expViewer.getExperiment();
    }

    public int getViewerType() {
        return this.expViewer.getViewerType();
    }

    public int[] getCluster() {
        if (this.expViewer instanceof ExperimentViewer) {
            return ((ExperimentViewer)this.expViewer).getCluster();
        }
        return ((ExperimentClusterViewer)this.expViewer).getCluster();
    }

    private class InfoPanel
    extends JPanel {
        private int currCluster;
        public int INFO_PANEL_WIDTH = 300;
        private JSplitPane jSplitPane1;
        private JScrollPane viewerPane;
        private JPanel infoPanel;
        private JLabel jLabel10;
        private JLabel jLabel11;
        private JLabel jLabel12;
        private JLabel jLabel13;
        private JLabel jLabel14;
        private JLabel jLabel15;
        private JLabel jLabel16;
        private JLabel jLabel17;
        private JLabel c1Label;
        private JLabel c1PopLabel;
        private JLabel c1DivLabel;
        private JLabel distLabel;
        private JLabel c2Label;
        private JLabel c2DivLabel;
        private JLabel c2PopLabel;
        private SOTAInfoStats infoStats = new SOTAInfoStats();

        private InfoPanel() {
            this.initComponents();
            this.currCluster = 0;
            this.setSize(this.INFO_PANEL_WIDTH, 350);
            this.setPreferredSize(new Dimension(this.INFO_PANEL_WIDTH, 350));
            this.setVisible(true);
            this.setBackground(Color.white);
            super.setBackground(Color.white);
        }

        private void initComponents() {
            this.jLabel10 = new JLabel();
            this.jLabel11 = new JLabel();
            this.jLabel12 = new JLabel();
            this.jLabel13 = new JLabel();
            this.jLabel14 = new JLabel();
            this.jLabel15 = new JLabel();
            this.jLabel16 = new JLabel();
            this.jLabel17 = new JLabel();
            this.c1Label = new JLabel();
            this.c1PopLabel = new JLabel();
            this.c1DivLabel = new JLabel();
            this.distLabel = new JLabel();
            this.c2Label = new JLabel();
            this.c2DivLabel = new JLabel();
            this.c2PopLabel = new JLabel();
            this.setBackground(Color.white);
            this.setLayout(null);
            this.setBackground(Color.white);
            super.setBackground(Color.white);
            this.setBorder(new LineBorder(Color.black, 1));
            this.setAlignmentY(1.0f);
            this.setAlignmentX(1.0f);
            this.setOpaque(false);
            this.jLabel10.setText("Cluster ID#:");
            this.jLabel10.setForeground(Color.black);
            this.add(this.jLabel10);
            this.jLabel10.setBounds(20, 30, 65, 17);
            this.jLabel11.setText("Cluster Population:");
            this.jLabel11.setForeground(Color.black);
            this.add(this.jLabel11);
            this.jLabel11.setBounds(20, 60, 107, 17);
            this.jLabel12.setText("Cluster Diversity:");
            this.jLabel12.setForeground(Color.black);
            this.add(this.jLabel12);
            this.jLabel12.setBounds(20, 90, 96, 17);
            this.jLabel13.setText("Distance to");
            this.jLabel13.setForeground(Color.black);
            this.add(this.jLabel13);
            this.jLabel13.setBounds(20, 130, 64, 17);
            this.jLabel14.setText("Closest Neighbor:");
            this.jLabel14.setForeground(Color.black);
            this.add(this.jLabel14);
            this.jLabel14.setBounds(20, 150, 100, 17);
            this.jLabel15.setText("Neighbor ID#:");
            this.jLabel15.setForeground(Color.black);
            this.add(this.jLabel15);
            this.jLabel15.setBounds(20, 190, 75, 17);
            this.jLabel16.setText("Neighbor Population:");
            this.jLabel16.setForeground(Color.black);
            this.add(this.jLabel16);
            this.jLabel16.setBounds(20, 220, 117, 17);
            this.jLabel17.setText("Neighbor Diversity:");
            this.jLabel17.setForeground(Color.black);
            this.add(this.jLabel17);
            this.jLabel17.setBounds(20, 250, 106, 17);
            this.c1Label.setForeground(Color.black);
            this.add(this.c1Label);
            this.c1Label.setBounds(150, 30, 70, 20);
            this.c1PopLabel.setForeground(Color.black);
            this.add(this.c1PopLabel);
            this.c1PopLabel.setBounds(150, 60, 70, 20);
            this.c1DivLabel.setForeground(Color.black);
            this.add(this.c1DivLabel);
            this.c1DivLabel.setBounds(150, 90, 110, 20);
            this.distLabel.setForeground(Color.black);
            this.add(this.distLabel);
            this.distLabel.setBounds(150, 150, 110, 20);
            this.c2Label.setForeground(Color.black);
            this.add(this.c2Label);
            this.c2Label.setBounds(150, 190, 70, 20);
            this.c2DivLabel.setForeground(Color.black);
            this.add(this.c2DivLabel);
            this.c2DivLabel.setBounds(150, 250, 110, 20);
            this.c2PopLabel.setForeground(Color.black);
            this.add(this.c2PopLabel);
            this.c2PopLabel.setBounds(150, 220, 70, 20);
        }

        private void setData1(SOTAInfoStats infoStats) {
            this.infoStats = infoStats;
            this.c1Label.setText(String.valueOf(infoStats.getC1() + 1));
            this.c1PopLabel.setText(String.valueOf(infoStats.getClusterPop1()));
            this.c1DivLabel.setText(String.valueOf(infoStats.getDiv1()));
            this.distLabel.setText(String.valueOf(infoStats.getDist() * SOTAExperimentViewer.this.factor));
            this.c2Label.setText(String.valueOf(infoStats.getC2() + 1));
            this.c2PopLabel.setText(String.valueOf(infoStats.getClusterPop2()));
            this.c2DivLabel.setText(String.valueOf(infoStats.getDiv2()));
            this.repaint();
        }

        private void clearData(int clusterNum) {
            this.c1Label.setText(String.valueOf(clusterNum + 1));
            this.c1PopLabel.setText("");
            this.c1DivLabel.setText("");
            this.distLabel.setText("");
            this.c2Label.setText("");
            this.c2PopLabel.setText("");
            this.c2DivLabel.setText("");
            this.repaint();
        }

        private int getClosestCentroid(int centroidNum) {
            float minDist = Float.POSITIVE_INFINITY;
            int closestCentroid = centroidNum;
            for (int i = 0; i < SOTAExperimentViewer.this.numberOfCells; ++i) {
                float currDist = ExperimentUtil.geneDistance((FloatMatrix)SOTAExperimentViewer.this.centroidDataFM, null, (int)centroidNum, (int)i, (int)SOTAExperimentViewer.this.function, (float)1.0f, (boolean)false);
                if (!(currDist < minDist) || i == centroidNum) continue;
                minDist = currDist;
                closestCentroid = i;
            }
            return closestCentroid;
        }

        public void setCurrentCluster(int clusterIndex) {
            this.currCluster = clusterIndex;
        }

        public void onSelected() {
            int neighbor = this.getClosestCentroid(this.currCluster);
            if (neighbor == this.currCluster) {
                return;
            }
            float neighborDist = ExperimentUtil.geneDistance((FloatMatrix)SOTAExperimentViewer.this.centroidDataFM, null, (int)this.currCluster, (int)neighbor, (int)SOTAExperimentViewer.this.function, (float)1.0f, (boolean)false);
            if (neighborDist == Float.POSITIVE_INFINITY || neighborDist == 0.0f || neighbor >= SOTAExperimentViewer.this.numberOfCells || SOTAExperimentViewer.this.clusterDivFM == null || SOTAExperimentViewer.this.clusters[this.currCluster].length <= 0) {
                this.clearData(this.currCluster);
            } else {
                this.infoStats.setC1(this.currCluster);
                this.infoStats.setClusterPop1(SOTAExperimentViewer.this.clusters[this.currCluster].length);
                this.infoStats.setDiv1(SOTAExperimentViewer.this.clusterDivFM.get(this.currCluster, 0));
                this.infoStats.setDist(neighborDist);
                this.infoStats.setC2(neighbor);
                this.infoStats.setClusterPop2(SOTAExperimentViewer.this.clusters[neighbor].length);
                this.infoStats.setDiv2(SOTAExperimentViewer.this.clusterDivFM.get(neighbor, 0));
                this.setData1(this.infoStats);
            }
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(SOTAExperimentViewer.SAVE_CLUSTER_CMD)) {
                SOTAExperimentViewer.this.onSaveCluster();
            } else if (command.equals(SOTAExperimentViewer.SAVE_ALL_CLUSTERS_CMD)) {
                SOTAExperimentViewer.this.onSaveClusters();
            } else if (command.equals(SOTAExperimentViewer.SET_DEF_COLOR_CMD)) {
                SOTAExperimentViewer.this.onSetDefaultColor();
            } else if (command.equals(SOTAExperimentViewer.STORE_CLUSTER_CMD)) {
                SOTAExperimentViewer.this.storeCluster();
            } else if (command.equals(SOTAExperimentViewer.LAUNCH_NEW_SESSION_CMD)) {
                SOTAExperimentViewer.this.launchNewSession();
            } else if (command.equals("broadcast-matrix-to-gaggle")) {
                SOTAExperimentViewer.this.broadcastClusterGaggle();
            } else if (command.equals("broadcast-namelist-to-gaggle")) {
                SOTAExperimentViewer.this.broadcastNamelistGaggle();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            int[] cluster = null;
            cluster = SOTAExperimentViewer.this.getCluster();
            if (!e.isPopupTrigger() || cluster == null || cluster.length == 0) {
                return;
            }
            SOTAExperimentViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

