/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;
import org.tigr.util.FloatMatrix;

public class SOTAExpCentroidExpressionViewer
extends JPanel
implements IViewer {
    private int numberOfCentroids;
    private int[] clusterPopulation;
    private FloatMatrix clusterDiversity;
    private int TEXT_LEFT_MARGIN = 20;
    private int CLUSTER_POP_SPACER = 20;
    private int POP_DIV_SPACER = 20;
    private static final float INITIAL_MAX_VALUE = 3.0f;
    private static final float INITIAL_MIN_VALUE = -3.0f;
    private static final String NO_GENES_STR = "No Experiments in Cluster!";
    private static final Font ERROR_FONT = new Font("monospaced", 1, 20);
    private ColorBarHeader header;
    private Experiment experiment;
    private Experiment experimentMap;
    private IFramework framework;
    private IData data;
    private int clusterIndex;
    private int labelIndex;
    private int[][] clusters;
    private int[] samplesOrder;
    private Dimension elementSize = new Dimension(40, 20);
    private boolean isAntiAliasing = true;
    private boolean isDrawBorders = true;
    public static Color missingColor = new Color(128, 128, 128);
    public static Color maskColor = new Color(255, 255, 255, 128);
    private float maxValue = 3.0f;
    private float minValue = -3.0f;
    private float midValue = 0.0f;
    private int firstSelectedRow = -1;
    private int lastSelectedRow = -1;
    private ArrayList selectedClusterList;
    public BufferedImage posColorImage = this.createGradientImage(Color.black, Color.red);
    public BufferedImage negColorImage = this.createGradientImage(Color.green, Color.black);
    private int maxUniqueIDWidth;
    private int maxGeneNameWidth;
    private Listener listener;
    private Insets insets = new Insets(0, 10, 0, 0);
    private int numberOfGenes;
    private boolean haveColorBar = false;
    private boolean useDoubleGradient = true;
    private int exptID = 0;

    public SOTAExpCentroidExpressionViewer(Experiment centroidData, Experiment experimentMap, int[][] clusters, int[] samplesOrder, int[] clusterPop, FloatMatrix clusterDiv, ArrayList selClusterList) {
        if (centroidData == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = centroidData;
        this.exptID = this.experiment.getId();
        this.experimentMap = experimentMap;
        this.numberOfGenes = this.experiment.getNumberOfGenes();
        this.clusterPopulation = clusterPop;
        this.clusterDiversity = clusterDiv;
        this.numberOfCentroids = this.clusterPopulation.length;
        this.selectedClusterList = selClusterList;
        this.clusters = clusters == null ? SOTAExpCentroidExpressionViewer.defGenesOrder(this.experiment.getNumberOfGenes()) : clusters;
        this.samplesOrder = samplesOrder == null ? SOTAExpCentroidExpressionViewer.defSamplesOrder(this.experiment.getNumberOfSamples()) : samplesOrder;
        this.header = new ColorBarHeader(this.numberOfCentroids);
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.setBackground(Color.white);
        this.listener = new Listener();
        this.addMouseMotionListener(this.listener);
        this.addMouseListener(this.listener);
    }

    public Expression getExpression() {
        return null;
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int e) {
        this.exptID = e;
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
        this.numberOfGenes = this.experiment.getNumberOfGenes();
    }

    private static int[] defSamplesOrder(int size) {
        int[] order = new int[size];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        return order;
    }

    private static int[][] defGenesOrder(int size) {
        int[][] order = new int[1][size];
        for (int i = 0; i < order[0].length; ++i) {
            order[0][i] = i;
        }
        return order;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    public Color getMissingColor() {
        return missingColor;
    }

    protected boolean areProbesColored() {
        int[] indices = this.getCluster();
        for (int i = 0; i < indices.length; ++i) {
            if (this.data.getProbeColor(this.getMultipleArrayDataRow(i)) == null) continue;
            return true;
        }
        return false;
    }

    public void selectRows(int start, int end) {
        this.firstSelectedRow = start;
        this.lastSelectedRow = end;
        this.repaint();
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        Integer userObject = (Integer)framework.getUserObject();
        this.setClusterIndex(userObject == null ? 0 : userObject);
        IDisplayMenu menu = framework.getDisplayMenu();
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.labelIndex = menu.getLabelIndex();
        this.maxValue = Math.abs(menu.getMaxRatioScale());
        this.minValue = -Math.abs(menu.getMinRatioScale());
        this.setElementSize(menu.getElementSize());
        this.setAntialiasing(menu.isAntiAliasing());
        this.setDrawBorders(menu.isDrawingBorder());
        this.updateSize();
        this.posColorImage = menu.getPositiveGradientImage();
        this.negColorImage = menu.getNegativeGradientImage();
        this.insets.top = this.selectedClusterList.size() > 0 ? this.elementSize.height + 1 : 0;
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.header.setValues(this.minValue, this.maxValue);
        this.header.setAntiAliasing(menu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.setDrawBorders(menu.isDrawingBorder());
        this.labelIndex = menu.getLabelIndex();
        this.maxValue = Math.abs(menu.getMaxRatioScale());
        this.minValue = -Math.abs(menu.getMinRatioScale());
        this.header.setValues(this.minValue, this.maxValue);
        this.posColorImage = menu.getPositiveGradientImage();
        this.negColorImage = menu.getNegativeGradientImage();
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.setElementSize(menu.getElementSize());
        if (this.selectedClusterList.size() > 0) {
            this.insets.top = this.elementSize.height + 1;
        }
        this.setAntialiasing(menu.isAntiAliasing());
        this.haveColorBar = this.areProbesColored();
        this.updateSize();
        this.header.setAntiAliasing(menu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
    }

    public void onDataChanged(IData data) {
        this.data = data;
        this.insets.top = this.selectedClusterList.size() > 0 ? this.elementSize.height + 1 : 0;
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public void setClusterIndex(int clusterIndex) {
        this.clusterIndex = clusterIndex;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    private int getRow(int row) {
        return this.clusters[this.clusterIndex][row];
    }

    private int getColumn(int column) {
        return this.samplesOrder[column];
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    private int getMultipleArrayDataRow(int clusterArrayRow) {
        return this.experimentMap.getGeneIndexMappedToData(clusterArrayRow);
    }

    private int[] getIDataRowIndices(int[] expIndices) {
        int[] dataIndices = new int[expIndices.length];
        for (int i = 0; i < expIndices.length; ++i) {
            dataIndices[i] = this.experimentMap.getGeneIndexMappedToData(expIndices[i]);
        }
        return dataIndices;
    }

    protected IData getData() {
        return this.data;
    }

    public void setClusterColor(Color color) {
        this.data.setExperimentColor(this.getIDataRowIndices(this.getCluster()), color);
        this.insets.top = this.elementSize.height + 1;
    }

    public void saveClusters(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveAllExperimentClusters((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[][])this.getClusters());
    }

    public void saveCluster(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveExperimentCluster((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[])this.getCluster());
    }

    private void setElementSize(Dimension elementSize) {
        this.elementSize = new Dimension(elementSize);
    }

    private void setAntialiasing(boolean value) {
        this.isAntiAliasing = value;
    }

    private void setDrawBorders(boolean value) {
        this.isDrawBorders = value;
    }

    public BufferedImage createGradientImage(Color color1, Color color2) {
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics = image.createGraphics();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 255.0f, 0.0f, color2);
        graphics.setPaint(gp);
        graphics.drawRect(0, 0, 255, 1);
        return image;
    }

    private void updateSize() {
        if (this.clusters == null || this.getCluster().length == 0) {
            this.setFont(ERROR_FONT);
            Graphics2D g = (Graphics2D)this.getGraphics();
            FontMetrics metrics = g.getFontMetrics();
            int width = metrics.stringWidth(NO_GENES_STR) + 10;
            int height = metrics.getHeight() + 30;
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
            return;
        }
        this.setFont(new Font("monospaced", 0, this.elementSize.height));
        Graphics2D g = (Graphics2D)this.getGraphics();
        int width = this.elementSize.width * this.numberOfCentroids + this.insets.left + 1;
        int height = this.elementSize.height * this.experiment.getNumberOfGenes() + this.insets.top + 1;
        this.setSize(width += this.getAnnotationWidth(g) + 30, height);
        this.setPreferredSize(new Dimension(width, height));
    }

    private int getAnnotationWidth(Graphics g) {
        int maxWidth = 0;
        FontMetrics fm = g.getFontMetrics();
        for (int i = 0; i < this.numberOfGenes; ++i) {
            maxWidth = Math.max(maxWidth, fm.stringWidth(this.data.getElementAttribute(this.getMultipleArrayDataRow(i), this.labelIndex)));
        }
        return maxWidth;
    }

    private int getClusterTextWidth(Graphics2D g) {
        return this.getPopulationTextWidth(g) + this.getDiversityTextWidth(g) + this.getClusterNumberTextWidth(g);
    }

    private int getPopulationTextWidth(Graphics2D g) {
        int maxWidth = 0;
        int currWidth = 0;
        if (this.clusterPopulation == null) {
            return 0;
        }
        FontMetrics fm = g.getFontMetrics();
        for (int i = 0; i < this.clusterPopulation.length; ++i) {
            currWidth = fm.stringWidth(String.valueOf(this.clusterPopulation[i]));
            if (currWidth <= maxWidth) continue;
            maxWidth = currWidth;
        }
        return maxWidth;
    }

    private int getDiversityTextWidth(Graphics2D g) {
        int maxWidth = 0;
        int currWidth = 0;
        if (this.clusterDiversity == null) {
            return 0;
        }
        int n = this.clusterDiversity.getRowDimension();
        FontMetrics fm = g.getFontMetrics();
        for (int i = 0; i < n; ++i) {
            currWidth = fm.stringWidth(String.valueOf(this.clusterDiversity.get(i, 0)));
            if (currWidth <= maxWidth) continue;
            maxWidth = currWidth;
        }
        return maxWidth;
    }

    private int getClusterNumberTextWidth(Graphics2D g) {
        FontMetrics fm = g.getFontMetrics();
        return fm.stringWidth(String.valueOf(this.numberOfCentroids));
    }

    private Color getColor(float value) {
        int rgb;
        if (Float.isNaN(value)) {
            return missingColor;
        }
        if (this.useDoubleGradient) {
            float maximum = value < this.midValue ? this.minValue : this.maxValue;
            int colorIndex = (int)(255.0f * (value - this.midValue) / (maximum - this.midValue));
            if (colorIndex < 0) {
                colorIndex = -colorIndex;
            }
            colorIndex = colorIndex > 255 ? 255 : colorIndex;
            rgb = value < this.midValue ? this.negColorImage.getRGB(255 - colorIndex, 0) : this.posColorImage.getRGB(colorIndex, 0);
        } else {
            float span = this.maxValue - this.minValue;
            int colorIndex = value <= this.minValue ? 0 : (value >= this.maxValue ? 255 : (int)((value - this.minValue) / span * 255.0f));
            rgb = this.posColorImage.getRGB(colorIndex, 0);
        }
        return new Color(rgb);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isAntiAliasing) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.clusters == null || this.getCluster().length == 0) {
            g.setColor(new Color(0, 0, 128));
            g.setFont(ERROR_FONT);
            g.drawString(NO_GENES_STR, 10, 30);
            return;
        }
        Rectangle bounds = g.getClipBounds();
        int top = this.getTopIndex(bounds.y);
        int bottom = this.getBottomIndex(bounds.y + bounds.height, this.getCluster().length);
        int left = this.getLeftIndex(bounds.x);
        int right = this.getRightIndex(bounds.x + bounds.width, this.numberOfCentroids);
        for (int column = left; column < right; ++column) {
            for (int row = top; row < bottom; ++row) {
                this.fillRectAt(g, row, column);
            }
        }
        g.setColor(Color.black);
        if (!this.selectedClusterList.isEmpty()) {
            Color currColor = g.getColor();
            for (int i = 0; i < this.selectedClusterList.size(); ++i) {
                HCLCluster cluster = (HCLCluster)this.selectedClusterList.get(i);
                g.setColor(cluster.color);
                g.fillRect(this.elementSize.width * cluster.root + this.insets.left, 0, this.elementSize.width, this.elementSize.height);
            }
        }
        if (right >= this.numberOfCentroids) {
            String label = "";
            g.setColor(Color.black);
            int uniqX = this.elementSize.width * this.numberOfCentroids + 10;
            for (int row = top; row < bottom; ++row) {
                if (this.labelIndex >= 0) {
                    label = this.data.getElementAttribute(this.getMultipleArrayDataRow(row), this.labelIndex);
                }
                int annY = (row + 1) * this.elementSize.height + this.insets.top;
                g.drawString(label, uniqX + this.insets.left, annY);
            }
        }
    }

    private void fillRectAt(Graphics g, int row, int column) {
        boolean mask;
        int x = column * this.elementSize.width + this.insets.left;
        int y = row * this.elementSize.height + this.insets.top;
        boolean bl = mask = this.firstSelectedRow >= 0 && this.lastSelectedRow >= 0 && (row < this.firstSelectedRow || row > this.lastSelectedRow);
        if (this.clusterPopulation[column] > 0) {
            g.setColor(this.getColor(this.experiment.get(this.getRow(row), this.getColumn(column))));
        } else {
            g.setColor(missingColor);
        }
        g.fillRect(x, y, this.elementSize.width, this.elementSize.height);
        if (mask) {
            g.setColor(maskColor);
            g.fillRect(x, y, this.elementSize.width, this.elementSize.height);
        }
        if (this.isDrawBorders) {
            g.setColor(Color.black);
            g.drawRect(x, y, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private void drawRectAt(Graphics g, int row, int column, Color color) {
        g.setColor(color);
        g.drawRect(column * this.elementSize.width + this.insets.left, row * this.elementSize.height + this.insets.top, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    private void drawCentroidRectangle(Graphics g, int centroidNumber, Color color) {
        Color initColor = g.getColor();
        g.setColor(color);
        g.drawRect(centroidNumber * this.elementSize.width + this.insets.left, this.insets.top, this.elementSize.width - 1, this.numberOfGenes * this.elementSize.height - 1);
        g.setColor(initColor);
    }

    private void fillCentroid(Graphics g, int centroidNumber) {
        for (int row = 0; row < this.numberOfGenes; ++row) {
            this.fillRectAt(g, row, centroidNumber);
        }
    }

    private int getTopIndex(int top) {
        if (top < this.insets.top) {
            return 0;
        }
        return (top - this.insets.top) / this.elementSize.height;
    }

    private int getLeftIndex(int left) {
        if (left < this.insets.left) {
            return 0;
        }
        return (left - this.insets.left) / this.elementSize.width;
    }

    private int getRightIndex(int right, int limit) {
        if (right < 0) {
            return 0;
        }
        int result = right / this.elementSize.width + 1;
        return result > limit ? limit : result;
    }

    private int getBottomIndex(int bottom, int limit) {
        if (bottom < 0) {
            return 0;
        }
        int result = (bottom - this.insets.top) / this.elementSize.height + 1;
        return result > limit ? limit : result;
    }

    private int findColumn(int targetx) {
        int xSize = this.experiment.getNumberOfSamples() * this.elementSize.width;
        if (targetx >= xSize || targetx < 0) {
            return -1;
        }
        return targetx / this.elementSize.width;
    }

    private int findRow(int targety) {
        int ySize = this.getCluster().length * this.elementSize.height + this.insets.top;
        if (targety >= ySize || targety < this.insets.top) {
            return -1;
        }
        return (targety - this.insets.top) / this.elementSize.height;
    }

    private boolean isLegalPosition(int row, int column) {
        return this.isLegalRow(row) && this.isLegalColumn(column);
    }

    private boolean isLegalColumn(int column) {
        return column >= 0 && column <= this.experiment.getNumberOfSamples() - 1;
    }

    private boolean isLegalRow(int row) {
        return row >= 0 && row <= this.getCluster().length - 1;
    }

    public int getCurrentCentroidNumber() {
        return this.listener.getCurrCentroidNumber();
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    public class ColorBarHeader
    extends JPanel {
        private static final int RECT_HEIGHT = 15;
        private int elementWidth;
        private boolean isAntiAliasing = true;
        private float maxValue = 3.0f;
        private float minValue = -3.0f;
        private Insets insets = new Insets(0, 10, 0, 0);
        private int numberOfElements;
        private BufferedImage negColorImage;
        private BufferedImage posColorImage;

        public ColorBarHeader(int NumberOfElements) {
            this.numberOfElements = NumberOfElements;
            this.setBackground(Color.white);
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeInt(this.elementWidth);
            oos.writeBoolean(this.isAntiAliasing);
            oos.writeFloat(this.maxValue);
            oos.writeFloat(this.minValue);
            oos.writeObject(this.insets);
            oos.writeInt(this.numberOfElements);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.elementWidth = ois.readInt();
            this.isAntiAliasing = ois.readBoolean();
            this.maxValue = ois.readFloat();
            this.minValue = ois.readFloat();
            this.insets = (Insets)ois.readObject();
            this.numberOfElements = ois.readInt();
        }

        public void setValues(float minValue, float maxValue) {
            this.maxValue = maxValue;
            this.minValue = minValue;
        }

        public void setNegAndPosColorImages(BufferedImage neg, BufferedImage pos) {
            this.negColorImage = neg;
            this.posColorImage = pos;
        }

        public void setAntiAliasing(boolean isAntiAliasing) {
            this.isAntiAliasing = isAntiAliasing;
        }

        public void setLeftInset(int leftMargin) {
            this.insets.left = leftMargin;
        }

        private void setElementWidth(int width) {
            this.elementWidth = width;
            if (width > 12) {
                width = 12;
            }
            this.setFont(new Font("monospaced", 0, width));
        }

        public void updateSizes(int contentWidth, int elementWidth) {
            this.setElementWidth(elementWidth);
            Graphics2D g = (Graphics2D)this.getGraphics();
            if (g == null) {
                return;
            }
            if (this.isAntiAliasing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            FontMetrics fm = g.getFontMetrics();
            int maxHeight = 25 + fm.getHeight();
            int width = this.numberOfElements * elementWidth;
            this.setSize(width, maxHeight);
            this.setPreferredSize(new Dimension(width, maxHeight));
        }

        @Override
        public void paint(Graphics g1D) {
            super.paint(g1D);
            Graphics2D g = (Graphics2D)g1D;
            if (this.isAntiAliasing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.drawHeader(g);
        }

        private void drawHeader(Graphics2D g) {
            int width = this.numberOfElements * this.elementWidth;
            if (SOTAExpCentroidExpressionViewer.this.useDoubleGradient) {
                g.drawImage(this.negColorImage, this.insets.left, 0, (int)((float)width / 2.0f), 15, null);
                g.drawImage(this.posColorImage, (int)((float)width / 2.0f + (float)this.insets.left), 0, (int)((double)width / 2.0), 15, null);
            } else {
                g.drawImage(this.posColorImage, this.insets.left, 0, width, 15, null);
            }
            FontMetrics hfm = g.getFontMetrics();
            int descent = hfm.getDescent();
            int fHeight = hfm.getHeight();
            g.setColor(Color.black);
            g.drawString(String.valueOf(this.minValue), this.insets.left, 15 + fHeight);
            int textWidth = hfm.stringWidth("0.0");
            if (SOTAExpCentroidExpressionViewer.this.useDoubleGradient) {
                g.drawString("0.0", (int)((float)width / 2.0f) - textWidth / 2 + this.insets.left, 15 + fHeight);
            }
            textWidth = hfm.stringWidth(String.valueOf(this.maxValue));
            g.drawString(String.valueOf(this.maxValue), width - textWidth + this.insets.left, 15 + fHeight);
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        int x = 0;
        int y = 0;
        int currCentroidNumber;
        int oldCentroidNumber;
        Point origin;
        int originX;
        int originY;
        Rectangle expBounds;
        float xDim;
        float yDim;
        Graphics g;
        Color rectangleColor = Color.white;

        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
            this.currCentroidNumber = this.cursorOverCentroid(this.x, this.y);
            if (this.currCentroidNumber != this.oldCentroidNumber) {
                int row;
                this.g = SOTAExpCentroidExpressionViewer.this.getGraphics();
                if (this.currCentroidNumber != -1) {
                    if (this.oldCentroidNumber != -1) {
                        for (row = 0; row < SOTAExpCentroidExpressionViewer.this.numberOfGenes; ++row) {
                            SOTAExpCentroidExpressionViewer.this.fillRectAt(this.g, row, this.oldCentroidNumber);
                        }
                    }
                    SOTAExpCentroidExpressionViewer.this.drawCentroidRectangle(this.g, this.currCentroidNumber, this.rectangleColor);
                    SOTAExpCentroidExpressionViewer.this.framework.setStatusText("Cluster # " + (this.currCentroidNumber + 1) + ",  Population: " + SOTAExpCentroidExpressionViewer.this.clusterPopulation[this.currCentroidNumber] + ",  Diversity: " + SOTAExpCentroidExpressionViewer.this.clusterDiversity.get(this.currCentroidNumber, 0));
                }
                if (this.currCentroidNumber == -1 && this.oldCentroidNumber != -1) {
                    for (row = 0; row < SOTAExpCentroidExpressionViewer.this.numberOfGenes; ++row) {
                        SOTAExpCentroidExpressionViewer.this.fillRectAt(this.g, row, this.oldCentroidNumber);
                    }
                    SOTAExpCentroidExpressionViewer.this.framework.setStatusText(" ");
                }
                this.oldCentroidNumber = this.currCentroidNumber;
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Graphics g = SOTAExpCentroidExpressionViewer.this.getGraphics();
            if (this.currCentroidNumber != -1) {
                SOTAExpCentroidExpressionViewer.this.fillCentroid(g, this.currCentroidNumber);
            }
            if (this.oldCentroidNumber != -1) {
                SOTAExpCentroidExpressionViewer.this.fillCentroid(g, this.oldCentroidNumber);
            }
            this.currCentroidNumber = -1;
        }

        private int cursorOverCentroid(int x, int y) {
            this.currCentroidNumber = -1;
            this.originX = 0;
            this.originY = 0;
            this.xDim = (float)SOTAExpCentroidExpressionViewer.this.numberOfCentroids * (float)((SOTAExpCentroidExpressionViewer)SOTAExpCentroidExpressionViewer.this).elementSize.width;
            this.yDim = (float)SOTAExpCentroidExpressionViewer.this.numberOfGenes * (float)((SOTAExpCentroidExpressionViewer)SOTAExpCentroidExpressionViewer.this).elementSize.height;
            if (((SOTAExpCentroidExpressionViewer)SOTAExpCentroidExpressionViewer.this).insets.left < x && (float)x < (float)((SOTAExpCentroidExpressionViewer)SOTAExpCentroidExpressionViewer.this).insets.left + this.xDim && this.originY < y && (float)y < (float)this.originY + this.yDim) {
                this.currCentroidNumber = (int)((float)(SOTAExpCentroidExpressionViewer.this.numberOfCentroids * (x - ((SOTAExpCentroidExpressionViewer)SOTAExpCentroidExpressionViewer.this).insets.left)) / this.xDim);
            }
            return this.currCentroidNumber;
        }

        public int getCurrCentroidNumber() {
            return this.currCentroidNumber;
        }
    }
}

