/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.util.FloatMatrix;

public class SOTADiversityViewer
extends GraphViewer
implements IViewer {
    private int numPoints;
    private float initValue;
    private FloatMatrix values;

    public SOTADiversityViewer(FloatMatrix values) {
        super(new JFrame(), 0, values.getRowDimension(), 0, (int)values.get(0, 0), 0.0, (double)values.getRowDimension(), 0.0, (double)values.get(0, 0), 75, 75, 75, 75, "SOTA Tree Diversity History", "Cycle Number", "Diversity (% of Initial)");
        this.values = values;
        this.numPoints = values.getRowDimension();
        this.initValue = values.get(0, 0);
        this.setBackground(Color.lightGray);
        this.referenceLinesOn = false;
        for (int i = 0; i < this.numPoints; ++i) {
            this.addGraphElement((GraphElement)new GraphPoint((double)i, (double)values.get(i, 0), Color.black, 4));
            if (i % 5 == 0) {
                this.addGraphElement((GraphElement)new GraphTick((double)i, 10, Color.black, 0, 5, String.valueOf(i), Color.black));
                continue;
            }
            this.addGraphElement((GraphElement)new GraphTick((double)i, 5, Color.black, 0, 5, "", Color.black));
        }
        double yTickIncrement = (double)this.initValue / 10.0;
        for (int i = 0; i <= 10; ++i) {
            this.addGraphElement((GraphElement)new GraphTick((double)i * yTickIncrement, 10, Color.black, 1, 7, String.valueOf(i * 10), Color.black));
        }
    }

    public Expression getExpression() {
        return new Expression((Object)this, ((Object)((Object)this)).getClass(), "new", new Object[]{this.values});
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperimentID(int i) {
    }

    public void drawVerticalTick(Graphics2D g, double x, int length, int alignment, Color color, String label, Color tickColor) {
        this.drawVerticalTick(g, x, length, alignment, color);
        this.canvas.drawString(g, label, this.convertX(x) - label.length() * this.tickFontWidth / 2, this.canvas.getSize().height - this.postYSpacing + length + 10, tickColor, this.tickFont);
    }

    float maxYVal(FloatMatrix data, int col) {
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numPoints; ++i) {
            if (!(data.get(i, col) > max)) continue;
            max = data.get(i, col);
        }
        return max;
    }

    public void onDeselected() {
    }

    public void onSelected(IFramework framework) {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public void onDataChanged(IData data) {
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }
}

