/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class SOTAConfigDialog
extends AlgorithmDialog {
    private int result;
    private JTextField zeroTextField;
    private JTextField minTextField;
    private JTextField maxTextField;
    private float zThr;
    private int minPixDist;
    private int maxPixDist;

    public SOTAConfigDialog(Frame parent, float zeroThreshold, int minPixelDistance, int maxPixelDistance) {
        super(parent, "Tree Configuration", true);
        this.zThr = zeroThreshold;
        this.minPixDist = minPixelDistance;
        this.maxPixDist = maxPixelDistance;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel parameters1 = new JPanel(new GridLayout(0, 1));
        parameters1.setBorder(new EmptyBorder(10, 5, 10, 0));
        parameters1.setBackground(Color.white);
        parameters1.add(new JLabel("Distance threshold"));
        parameters1.add(new JLabel("Minimum pixel distance"));
        parameters1.add(new JLabel("Maximum pixel distance"));
        JPanel parameters2 = new JPanel(new GridLayout(0, 1));
        parameters2.setBorder(new EmptyBorder(10, 5, 10, 0));
        parameters2.setBackground(Color.white);
        String z = String.valueOf(zeroThreshold);
        z = z.substring(0, Math.min(5, z.length()));
        this.zeroTextField = new JTextField(z, 4);
        this.zeroTextField.setMinimumSize(new Dimension(100, 20));
        parameters2.add((Component)this.zeroTextField, "East");
        this.minTextField = new JTextField(String.valueOf(minPixelDistance), 4);
        this.minTextField.setMinimumSize(new Dimension(100, 20));
        parameters2.add((Component)this.minTextField, "East");
        this.maxTextField = new JTextField(String.valueOf(maxPixelDistance), 4);
        this.maxTextField.setMinimumSize(new Dimension(100, 20));
        parameters2.add((Component)this.maxTextField, "East");
        JButton button1 = new JButton("OK");
        button1.setActionCommand("ok-command");
        button1.addActionListener(listener);
        button1.setFocusPainted(false);
        JButton button2 = new JButton("Cancel");
        button2.setActionCommand("cancel-command");
        button2.addActionListener(listener);
        button2.setFocusPainted(false);
        JPanel buttons = new JPanel(new GridLayout(0, 2));
        buttons.add(button1);
        buttons.add(button2);
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.setForeground(Color.white);
        panel3.setBorder(BorderFactory.createLineBorder(Color.gray));
        JLabel imageControl2 = new JLabel(GUIFactory.getIcon("dialog_button_bar.gif"));
        panel3.setBackground(Color.white);
        panel3.add((Component)parameters1, "West");
        panel3.add((Component)parameters2, "Center");
        panel3.add((Component)imageControl2, "East");
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)panel3, "North");
        this.addContent(panel1);
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getZeroThreshold() {
        return Float.parseFloat(this.zeroTextField.getText());
    }

    public int getMinDistance() {
        return Integer.parseInt(this.minTextField.getText());
    }

    public int getMaxDistance() {
        return Integer.parseInt(this.maxTextField.getText());
    }

    public static void main(String[] args) {
        SOTAConfigDialog d = new SOTAConfigDialog(new Frame(), 2.0f, 3, 4);
        d.show();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    Float.parseFloat(SOTAConfigDialog.this.zeroTextField.getText());
                    Integer.parseInt(SOTAConfigDialog.this.minTextField.getText());
                    Integer.parseInt(SOTAConfigDialog.this.maxTextField.getText());
                    SOTAConfigDialog.this.result = 0;
                    SOTAConfigDialog.this.dispose();
                }
                catch (Exception exc) {
                    SOTAConfigDialog.this.result = 2;
                }
            } else if (command.equals("cancel-command")) {
                SOTAConfigDialog.this.result = 2;
                SOTAConfigDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                SOTAConfigDialog.this.zeroTextField.setText(String.valueOf(SOTAConfigDialog.this.zThr));
                SOTAConfigDialog.this.minTextField.setText(String.valueOf(SOTAConfigDialog.this.minPixDist));
                SOTAConfigDialog.this.maxTextField.setText(String.valueOf(SOTAConfigDialog.this.maxPixDist));
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(SOTAConfigDialog.this, "SOTA Tree Properties");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SOTAConfigDialog.this.result = -1;
            SOTAConfigDialog.this.dispose();
        }
    }
}

