/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.som;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.util.Hexagon;
import org.tigr.util.FloatMatrix;

public class UMatrixDistanceViewer
extends JPanel
implements IViewer {
    private int[][] clusters;
    private FloatMatrix u_matrix;
    private int dim_x;
    private int dim_y;
    private String topology;
    private boolean isAntiAliasing = true;

    public UMatrixDistanceViewer(int[][] clusters, FloatMatrix u_matrix, int dim_x, int dim_y, String topology) {
        this.clusters = clusters;
        this.u_matrix = u_matrix;
        this.dim_x = dim_x;
        this.dim_y = dim_y;
        this.topology = topology;
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 0, 10));
        this.addComponentListener(new Listener());
    }

    public UMatrixDistanceViewer(int[][] clusters, FloatMatrix u_matrix, Integer dim_x, Integer dim_y, String topology) {
        this(clusters, u_matrix, (int)dim_x, (int)dim_y, topology);
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.clusters, this.u_matrix, new Integer(this.dim_x), new Integer(this.dim_y), this.topology});
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperiment(Experiment e) {
    }

    public void setExperimentID(int id) {
    }

    public void setAntialiasing(boolean value) {
        this.isAntiAliasing = value;
    }

    @Override
    public void paint(Graphics g1) {
        super.paint(g1);
        Graphics2D g = (Graphics2D)g1;
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(Color.lightGray);
        if (this.topology.equals("hexagonal")) {
            float stepX = (float)width / ((float)this.dim_x + 0.5f);
            float stepY = (float)height / ((float)this.dim_y + 0.5f);
            Hexagon hexagon = new Hexagon(Math.round(stepX), 270);
            hexagon.translate(0, 0);
            for (int y = 0; y < this.dim_y; ++y) {
                if (y % 2 == 0) {
                    hexagon.translate(-hexagon.getA(), 0);
                } else {
                    hexagon.translate(0, 0);
                }
                for (int x = 0; x < this.dim_x; ++x) {
                    hexagon.translate(Math.round(stepX), 0);
                    if (this.clusters[x * this.dim_y + y].length == 0) {
                        g.setColor(new Color(230, 230, 230));
                        g.fillPolygon(hexagon);
                        g.setColor(Color.lightGray);
                    }
                    g.drawPolygon(hexagon);
                }
                if (y % 2 == 0) {
                    hexagon.translate(-Math.round(stepX) * this.dim_x + hexagon.getA(), hexagon.getB() + hexagon.getC());
                    continue;
                }
                hexagon.translate(-Math.round(stepX) * this.dim_x, hexagon.getB() + hexagon.getC());
            }
            g.setColor(Color.black);
            for (int y = 0; y < this.dim_y; ++y) {
                for (int x = 0; x < this.dim_x; ++x) {
                    int xValue = (int)(stepX * this.u_matrix.get(x, y));
                    Hexagon aHexagon = new Hexagon(xValue, 270);
                    aHexagon.translate(0, 0);
                    aHexagon.translate(Math.round(stepX) * x, Math.round((hexagon.getB() + hexagon.getC()) * y + (hexagon.getHeight() - aHexagon.getHeight()) / 2));
                    if (y % 2 == 0) {
                        aHexagon.translate(hexagon.getA(), 0);
                    } else {
                        aHexagon.translate((int)stepX, 0);
                    }
                    g.drawPolygon(aHexagon);
                }
            }
        } else {
            int i;
            int x;
            int y;
            float stepX = (float)width / (float)this.dim_x;
            float stepY = (float)height / (float)this.dim_y;
            g.setColor(new Color(230, 230, 230));
            for (y = 0; y < this.dim_y; ++y) {
                for (x = 0; x < this.dim_x; ++x) {
                    if (this.clusters[x * this.dim_y + y].length != 0) continue;
                    g.fillRect(Math.round((float)x * stepX) + 1, Math.round((float)y * stepY) + 1, Math.round(stepX) - 1, Math.round(stepY) - 1);
                }
            }
            g.setColor(Color.lightGray);
            for (i = 0; i < this.dim_x; ++i) {
                g.drawLine(Math.round((float)i * stepX), 0, Math.round((float)i * stepX), height);
            }
            for (i = 0; i < this.dim_y; ++i) {
                g.drawLine(0, Math.round((float)i * stepY), width, Math.round((float)i * stepY));
            }
            for (y = 0; y < this.dim_y; ++y) {
                for (x = 0; x < this.dim_x; ++x) {
                    int xValue = Math.round(stepX * this.u_matrix.get(x, y));
                    int yValue = Math.round(stepY * this.u_matrix.get(x, y));
                    g.setColor(Color.black);
                    g.drawRect(Math.round((float)x * stepX + (stepX - (float)xValue) / 2.0f), Math.round((float)y * stepY + (stepY - (float)yValue) / 2.0f), xValue, yValue);
                }
            }
        }
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework framework) {
        this.setAntialiasing(framework.getDisplayMenu().isAntiAliasing());
    }

    public void onDataChanged(IData data) {
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.setAntialiasing(menu.isAntiAliasing());
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    private void updateSize() {
        if (this.topology.equals("hexagonal")) {
            float stepX = (float)this.getWidth() / ((float)this.dim_x + 0.5f);
            Hexagon hexagon = new Hexagon(Math.round(stepX), 270);
            int height = this.dim_y * (hexagon.getB() + hexagon.getC()) + hexagon.getB();
            this.setPreferredSize(new Dimension(100, height));
        } else {
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    private class Listener
    extends ComponentAdapter {
        private boolean isRevalidate = true;

        private Listener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (!this.isRevalidate) {
                this.isRevalidate = true;
                return;
            }
            this.isRevalidate = false;
            UMatrixDistanceViewer.this.updateSize();
            UMatrixDistanceViewer.this.revalidate();
        }
    }
}

