/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.som;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.util.Hexagon;
import org.tigr.util.FloatMatrix;

public class UMatrixColorViewer
extends JPanel
implements IViewer {
    private int[][] clusters;
    private FloatMatrix u_matrix;
    private int dim_x;
    private int dim_y;
    private String topology;
    private boolean isAntiAliasing = true;

    public UMatrixColorViewer(int[][] clusters, FloatMatrix u_matrix, int dim_x, int dim_y, String topology) {
        this.clusters = clusters;
        this.u_matrix = u_matrix;
        this.dim_x = dim_x;
        this.dim_y = dim_y;
        this.topology = topology;
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 0, 10));
        this.addComponentListener(new Listener());
    }

    public UMatrixColorViewer(int[][] clusters, FloatMatrix u_matrix, Integer dim_x, Integer dim_y, String topology) {
        this(clusters, u_matrix, (int)dim_x, (int)dim_y, topology);
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.clusters, this.u_matrix, new Integer(this.dim_x), new Integer(this.dim_y), this.topology});
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperiment(Experiment e) {
    }

    public void setExperimentID(int id) {
    }

    public void setAntialiasing(boolean value) {
        this.isAntiAliasing = value;
    }

    @Override
    public void paint(Graphics g1) {
        super.paint(g1);
        Graphics2D g = (Graphics2D)g1;
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int width = this.getWidth();
        int height = this.getHeight();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, Color.black, width, 0.0f, Color.white);
        g.setPaint(gp);
        g.fillRect(0, 0, width, 20);
        FontMetrics metrics = g.getFontMetrics();
        g.setColor(Color.black);
        g.drawRect(0, 0, width, 20);
        g.drawString("great distance", 5, 35);
        g.drawString("small distance", width - metrics.stringWidth("small distance") - 5, 35);
        g.setColor(Color.lightGray);
        if (this.topology.equals("hexagonal")) {
            float stepX = (float)width / ((float)this.dim_x + 0.5f);
            float stepY = (float)height / ((float)this.dim_y + 0.5f);
            gp = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 128), Math.round(stepX), 0.0f, new Color(0, 128, 255));
            Hexagon hexagon = new Hexagon(Math.round(stepX), 270);
            hexagon.translate(0, 40);
            for (int y = 0; y < this.dim_y; ++y) {
                if (y % 2 == 0) {
                    hexagon.translate(-hexagon.getA(), 0);
                } else {
                    hexagon.translate(0, 0);
                }
                for (int x = 0; x < this.dim_x; ++x) {
                    hexagon.translate(Math.round(stepX), 0);
                    if (this.clusters[x * this.dim_y + y].length == 0) {
                        gp = new GradientPaint(hexagon.xpoints[5], 0.0f, new Color(0, 0, 128), hexagon.xpoints[1], 0.0f, new Color(0, 128, 255));
                        g.setPaint(gp);
                        g.fillPolygon(hexagon);
                    } else {
                        int value = 255 - Math.round(this.u_matrix.get(x, y) * 255.0f);
                        g.setColor(new Color(value, value, value));
                        g.fillPolygon(hexagon);
                    }
                    g.setColor(Color.lightGray);
                    g.drawPolygon(hexagon);
                }
                if (y % 2 == 0) {
                    hexagon.translate(-Math.round(stepX) * this.dim_x + hexagon.getA(), hexagon.getB() + hexagon.getC());
                    continue;
                }
                hexagon.translate(-Math.round(stepX) * this.dim_x, hexagon.getB() + hexagon.getC());
            }
        } else {
            int y;
            float stepX = (float)width / (float)this.dim_x;
            float stepY = ((float)height - 40.0f) / (float)this.dim_y;
            for (y = 0; y < this.dim_y; ++y) {
                for (int x = 0; x < this.dim_x; ++x) {
                    if (this.clusters[x * this.dim_y + y].length == 0) {
                        gp = new GradientPaint(Math.round((float)(x + 1) * stepX), 0.0f, new Color(0, 0, 128), Math.round((float)x * stepX), 0.0f, new Color(0, 128, 255));
                        g.setPaint(gp);
                    } else {
                        int value = 255 - Math.round(this.u_matrix.get(x, y) * 255.0f);
                        g.setColor(new Color(value, value, value));
                    }
                    g.drawRect(Math.round((float)x * stepX), Math.round((float)y * stepY) + 40, (int)stepX, (int)stepY);
                    g.fillRect(Math.round((float)x * stepX), Math.round((float)y * stepY) + 40, (int)stepX, (int)stepY);
                }
            }
            g.setColor(Color.lightGray);
            for (int x = 1; x < this.dim_x; ++x) {
                g.drawLine(Math.round((float)x * stepX), 40, Math.round((float)x * stepX), height + 40);
            }
            for (y = 0; y < this.dim_y; ++y) {
                g.drawLine(0, Math.round((float)y * stepY) + 40, width, Math.round((float)y * stepY) + 40);
            }
        }
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework framework) {
        this.setAntialiasing(framework.getDisplayMenu().isAntiAliasing());
    }

    public void onDataChanged(IData data) {
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.setAntialiasing(menu.isAntiAliasing());
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    private void updateSize() {
        if (this.topology.equals("hexagonal")) {
            float stepX = (float)this.getWidth() / ((float)this.dim_x + 0.5f);
            Hexagon hexagon = new Hexagon(Math.round(stepX), 270);
            int height = this.dim_y * (hexagon.getB() + hexagon.getC()) + hexagon.getB() + 40;
            this.setPreferredSize(new Dimension(100, height));
        } else {
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    private class Listener
    extends ComponentAdapter {
        private boolean isRevalidate = true;

        private Listener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (!this.isRevalidate) {
                this.isRevalidate = true;
                return;
            }
            this.isRevalidate = false;
            UMatrixColorViewer.this.updateSize();
            UMatrixColorViewer.this.revalidate();
        }
    }
}

