/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.som;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DistanceMetricPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class SOMInitDialog
extends AlgorithmDialog {
    private int result;
    private SampleSelectionPanel sampleSelectionPanel;
    private HCLSelectionPanel hclOpsPanel;
    private DistanceMetricPanel metricPanel;
    public JTextField dimXField;
    public JTextField dimYField;
    public JTextField iterField;
    public JTextField alphaField;
    public JTextField radiusField;
    public JComboBox initList;
    public JComboBox neighbList;
    public JComboBox topoList;

    public SOMInitDialog(Frame frame, int dimX, int dimY, long iterations, float alpha, float radius, int initType, int neighborhood, int topology, String globalFunctionName, boolean globalAbsoluteValue) {
        super(frame, "SOM: Self Organizing Maps", true);
        this.setSize(520, 343);
        this.setResizable(false);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.sampleSelectionPanel.setExperimentButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SOMInitDialog.this.sampleSelectionPanel.isClusterGenesSelected()) {
                    return;
                }
                int sel = SOMInitDialog.this.initList.getSelectedIndex();
                SOMInitDialog.this.initList.removeItemAt(1);
                SOMInitDialog.this.initList.insertItemAt("Random Samples", 1);
                SOMInitDialog.this.initList.setSelectedIndex(sel);
            }
        });
        this.sampleSelectionPanel.setGeneButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SOMInitDialog.this.sampleSelectionPanel.isClusterGenesSelected()) {
                    return;
                }
                int sel = SOMInitDialog.this.initList.getSelectedIndex();
                SOMInitDialog.this.initList.removeItemAt(1);
                SOMInitDialog.this.initList.insertItemAt("Random Genes", 1);
                SOMInitDialog.this.initList.setSelectedIndex(sel);
            }
        });
        this.metricPanel = new DistanceMetricPanel(globalFunctionName, globalAbsoluteValue, "Pearson Correlation", "SOM", true, true);
        JPanel parameters1 = new JPanel();
        parameters1.setBorder(new EmptyBorder(5, 10, 20, 0));
        parameters1.setBackground(Color.white);
        parameters1.setForeground(Color.black);
        parameters1.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.right = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        parameters1.add((Component)new JLabel("Dimension X"), gbc);
        gbc.gridy = 1;
        parameters1.add((Component)new JLabel("Dimension Y"), gbc);
        gbc.gridy = 2;
        parameters1.add((Component)new JLabel("Iterations"), gbc);
        gbc.gridy = 3;
        parameters1.add((Component)new JLabel("Alpha"), gbc);
        gbc.gridy = 4;
        parameters1.add((Component)new JLabel("Radius"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets.right = 0;
        gbc.fill = 2;
        this.dimXField = new JTextField(String.valueOf(dimX), 5);
        parameters1.add((Component)this.dimXField, gbc);
        gbc.gridy = 1;
        this.dimYField = new JTextField(String.valueOf(dimY), 5);
        parameters1.add((Component)this.dimYField, gbc);
        gbc.gridy = 2;
        this.iterField = new JTextField(String.valueOf(iterations), 5);
        parameters1.add((Component)this.iterField, gbc);
        gbc.gridy = 3;
        this.alphaField = new JTextField(String.valueOf(alpha), 5);
        parameters1.add((Component)this.alphaField, gbc);
        gbc.gridy = 4;
        this.radiusField = new JTextField(String.valueOf(radius), 5);
        parameters1.add((Component)this.radiusField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        JPanel parameters2 = new JPanel();
        parameters2.setLayout(new GridLayout(0, 1, 0, 10));
        parameters2.setBorder(new EmptyBorder(5, 25, 15, 10));
        parameters2.setBackground(Color.white);
        parameters2.add((Component)new JLabel("Initialization"), "West");
        parameters2.add((Component)new JLabel("Neighborhood"), "West");
        parameters2.add((Component)new JLabel("Topology"), "West");
        JPanel parameters3 = new JPanel();
        parameters3.setLayout(new GridLayout(0, 1, 10, 10));
        parameters3.setBorder(new EmptyBorder(10, 0, 15, 10));
        parameters3.setBackground(Color.white);
        this.initList = new JComboBox<String>(new String[]{"Random Vector", "Random Genes"});
        this.initList.setSelectedIndex(initType);
        FontMetrics fm = this.initList.getFontMetrics(this.initList.getFont());
        int width = fm.stringWidth("Random Samples");
        this.initList.setPreferredSize(new Dimension(width + 40, this.initList.getHeight()));
        this.neighbList = new JComboBox<String>(new String[]{"Bubble", "Gaussian"});
        this.neighbList.setSelectedIndex(neighborhood);
        this.neighbList.setPreferredSize(new Dimension(width, this.initList.getHeight()));
        this.topoList = new JComboBox<String>(new String[]{"Hexagonal", "Rectangular"});
        this.topoList.setSelectedIndex(topology);
        this.initList.setBackground(Color.white);
        this.neighbList.setBackground(Color.white);
        this.topoList.setBackground(Color.white);
        parameters3.add(this.initList);
        parameters3.add(this.neighbList);
        parameters3.add(this.topoList);
        this.hclOpsPanel = new HCLSelectionPanel();
        ParameterPanel paramPanel = new ParameterPanel();
        paramPanel.setLayout(new BorderLayout());
        paramPanel.add((Component)parameters1, "West");
        paramPanel.add((Component)parameters2, "Center");
        paramPanel.add((Component)parameters3, "East");
        JPanel panel3 = new JPanel(new GridBagLayout());
        panel3.add((Component)this.sampleSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel3.add((Component)this.metricPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel3.add((Component)paramPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel3.add((Component)this.hclOpsPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setActionListeners(listener);
        this.addContent(panel3);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isClusterGenes() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public int getDimensionX() {
        return Integer.parseInt(this.dimXField.getText());
    }

    public int getDimensionY() {
        return Integer.parseInt(this.dimYField.getText());
    }

    public long getIterations() {
        return Long.parseLong(this.iterField.getText());
    }

    public float getAlpha() {
        return Float.parseFloat(this.alphaField.getText());
    }

    public float getRadius() {
        return Float.parseFloat(this.radiusField.getText());
    }

    public int getInitType() {
        return this.initList.getSelectedIndex();
    }

    public int getNeighborhood() {
        return this.neighbList.getSelectedIndex();
    }

    public int getTopology() {
        return this.topoList.getSelectedIndex();
    }

    public boolean isHierarchicalTree() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public int getDistanceMetric() {
        return this.metricPanel.getMetricIndex();
    }

    public boolean isAbsoluteDistance() {
        return this.metricPanel.getAbsoluteSelection();
    }

    private void resetControls() {
        this.dimXField.setText("3");
        this.dimYField.setText("3");
        this.iterField.setText("2000");
        this.alphaField.setText("0.05");
        this.radiusField.setText("3.0");
        this.initList.removeItemAt(1);
        this.initList.insertItemAt("Random Genes", 1);
        this.initList.setSelectedIndex(1);
        this.neighbList.setSelectedIndex(1);
        this.topoList.setSelectedIndex(0);
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.hclOpsPanel.setHCLSelected(false);
        this.initList.setSelectedIndex(1);
        this.neighbList.setSelectedIndex(1);
        this.topoList.setSelectedIndex(0);
        this.metricPanel.reset();
    }

    private boolean validInput(int x, int y, long i, float a, float r) {
        boolean valid = true;
        if (x < 1) {
            JOptionPane.showMessageDialog(this, "x Dimension must be > 0", "Input Error!", 0);
            this.dimXField.requestFocus();
            this.dimXField.selectAll();
            valid = false;
        } else if (y < 1) {
            JOptionPane.showMessageDialog(this, "y Dimension must be > 0", "Input Error!", 0);
            this.dimYField.requestFocus();
            this.dimYField.selectAll();
            valid = false;
        } else if (i < 1L) {
            JOptionPane.showMessageDialog(this, "Number of Iterations must be > 0", "Input Error!", 0);
            this.iterField.requestFocus();
            this.iterField.selectAll();
            valid = false;
        } else if (a <= 0.0f) {
            JOptionPane.showMessageDialog(this, "Alpha value must be > 0", "Input Error!", 0);
            this.alphaField.requestFocus();
            this.alphaField.selectAll();
            valid = false;
        } else if (r <= 0.0f) {
            JOptionPane.showMessageDialog(this, "Radius value must be > 0", "Input Error!", 0);
            this.radiusField.requestFocus();
            this.radiusField.selectAll();
            valid = false;
        }
        return valid;
    }

    public static void main(String[] args) {
        SOMInitDialog dlg = new SOMInitDialog(new Frame(), 0, 0, 0L, 0.0f, 0.0f, 1, 0, 0, "Euclidean Distance", false);
        dlg.showModal();
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    int x = Integer.parseInt(SOMInitDialog.this.dimXField.getText());
                    int y = Integer.parseInt(SOMInitDialog.this.dimYField.getText());
                    long i = Long.parseLong(SOMInitDialog.this.iterField.getText());
                    float a = Float.parseFloat(SOMInitDialog.this.alphaField.getText());
                    float r = Float.parseFloat(SOMInitDialog.this.radiusField.getText());
                    if (SOMInitDialog.this.validInput(x, y, i, a, r)) {
                        SOMInitDialog.this.result = 0;
                        SOMInitDialog.this.dispose();
                    }
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(SOMInitDialog.this, "Input value " + nfe.getMessage() + " is not valid input. \nPlease enter a new value or view the parameter information help page for this algorithm.", "Input Error!", 0);
                    SOMInitDialog.this.result = 2;
                }
            } else if (command.equals("cancel-command")) {
                SOMInitDialog.this.result = 2;
                SOMInitDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                SOMInitDialog.this.resetControls();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(SOMInitDialog.this, "SOM Initialization Dialog");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SOMInitDialog.this.result = -1;
            SOMInitDialog.this.dispose();
        }
    }
}

