/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.som;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.FloatMatrix;

public class SOMExperimentViewer
implements IViewer {
    private JPopupMenu popup;
    private ExperimentViewer expViewer;
    private CentroidExperimentHeader header;
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private FloatMatrix codes;
    private Experiment experiment;

    public SOMExperimentViewer(Experiment experiment, int[][] clusters, FloatMatrix codes) {
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.expViewer = new ExperimentViewer(experiment, clusters);
        this.expViewer.getContentComponent().addMouseListener(listener);
        this.header = new CentroidExperimentHeader(this.expViewer.getHeaderComponent(), codes, clusters, "SOM Vector");
        this.codes = codes;
        this.experiment = experiment;
        this.header.setNegAndPosColorImages(this.expViewer.getPosColorImage(), this.expViewer.getNegColorImage());
        this.header.setMissingColor(this.expViewer.getMissingColor());
        this.header.addMouseListener((MouseListener)listener);
        this.header.setBackground(Color.white);
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, this.getClusters(), this.codes});
    }

    public void setExperiment(Experiment e) {
        this.expViewer.setExperiment(e);
    }

    public void setExperimentID(int id) {
        this.expViewer.setExperimentID(id);
    }

    public int getExperimentID() {
        return this.expViewer.getExperimentID();
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this.expViewer.getContentComponent();
    }

    public BufferedImage getImage() {
        return this.expViewer.getImage();
    }

    public void onSelected(IFramework framework) {
        this.expViewer.onSelected(framework);
        this.header.setCurrentCluster(((Integer)framework.getUserObject()).intValue());
        IDisplayMenu menu = framework.getDisplayMenu();
        this.header.setUseDoubleGradient(menu.getUseDoubleGradient());
        this.header.setNegAndPosColorImages(menu.getNegativeGradientImage(), menu.getPositiveGradientImage());
        this.header.setValues(menu.getMinRatioScale(), menu.getMidRatioValue(), menu.getMaxRatioScale());
        this.header.setAntiAliasing(menu.isAntiAliasing());
        this.header.setDrawBorders(menu.isDrawingBorder());
        this.header.updateSize(menu.getElementSize());
    }

    public void onDataChanged(IData data) {
        this.expViewer.onDataChanged(data);
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.expViewer.onMenuChanged(menu);
        this.header.setUseDoubleGradient(menu.getUseDoubleGradient());
        this.header.setNegAndPosColorImages(menu.getNegativeGradientImage(), menu.getPositiveGradientImage());
        this.header.setValues(menu.getMinRatioScale(), menu.getMidRatioValue(), menu.getMaxRatioScale());
        this.header.setAntiAliasing(menu.isAntiAliasing());
        this.header.setDrawBorders(menu.isDrawingBorder());
        this.header.updateSize(menu.getElementSize());
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Store cluster", GUIFactory.getIcon("new16.gif"));
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("analysis16.gif"));
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon("delete16.gif"));
        menuItem.setActionCommand(SET_DEF_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon("save16.gif"));
        menuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.expViewer.saveClusters(frame);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.expViewer.saveCluster(frame);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color newColor = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (newColor != null) {
            this.expViewer.setClusterColor(newColor);
        }
    }

    private void onSetDefaultColor() {
        this.expViewer.setClusterColor(null);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return this.expViewer.getClusters();
    }

    public Experiment getExperiment() {
        return this.expViewer.getExperiment();
    }

    public int getViewerType() {
        return this.expViewer.getViewerType();
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(SOMExperimentViewer.SAVE_CLUSTER_CMD)) {
                SOMExperimentViewer.this.onSaveCluster();
            } else if (command.equals(SOMExperimentViewer.SAVE_ALL_CLUSTERS_CMD)) {
                SOMExperimentViewer.this.onSaveClusters();
            } else if (command.equals(SOMExperimentViewer.SET_DEF_COLOR_CMD)) {
                SOMExperimentViewer.this.onSetDefaultColor();
            } else if (command.equals(SOMExperimentViewer.STORE_CLUSTER_CMD)) {
                SOMExperimentViewer.this.expViewer.storeCluster();
            } else if (command.equals(SOMExperimentViewer.LAUNCH_NEW_SESSION_CMD)) {
                SOMExperimentViewer.this.expViewer.launchNewSession();
            } else if (command.equals("broadcast-matrix-to-gaggle")) {
                SOMExperimentViewer.this.expViewer.broadcastClusterGaggle();
            } else if (command.equals("broadcast-namelist-to-gaggle")) {
                SOMExperimentViewer.this.expViewer.broadcastNamelistGaggle();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || SOMExperimentViewer.this.expViewer.getCluster() == null || SOMExperimentViewer.this.expViewer.getCluster().length == 0) {
                return;
            }
            SOMExperimentViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

