/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.som;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.util.FloatMatrix;

public class SOMExperimentHeader
extends JPanel {
    private SOMVectorPanel somVectorPanel;
    private int[][] clusters;
    private int clusterIndex;
    private static final String SOM_VECTOR_STRING = "SOM Vector";
    private Insets insets = new Insets(0, 10, 0, 0);
    private boolean useDoubleGradient = true;

    public SOMExperimentHeader(JComponent expHeader, FloatMatrix codes, int[][] clusters) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.somVectorPanel = new SOMVectorPanel(codes);
        this.clusters = clusters;
        this.add((Component)expHeader, "North");
        this.add((Component)this.somVectorPanel, "South");
    }

    public void setClusterIndex(int index) {
        this.clusterIndex = index;
    }

    private int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    private void setUseDoubleGradient(boolean useDouble) {
        this.useDoubleGradient = useDouble;
    }

    public void updateSize(Dimension size) {
        this.somVectorPanel.updateSize(size);
    }

    public void setCurrentCluster(int cluster) {
        this.somVectorPanel.setCurrentCluster(cluster);
    }

    public void setDrawBorders(boolean draw) {
        this.somVectorPanel.setDrawBorders(draw);
    }

    public void setValues(float minValue, float maxValue) {
        this.somVectorPanel.setValues(minValue, maxValue);
    }

    public void setValues(float minValue, float midValue, float maxValue) {
        this.somVectorPanel.setValues(minValue, midValue, maxValue);
    }

    public void setColorImages(BufferedImage posColorImage, BufferedImage negColorImage) {
        this.somVectorPanel.setColorImages(posColorImage, negColorImage);
    }

    public void setMissingColor(Color color) {
        this.somVectorPanel.setMissingColor(color);
    }

    public void setAntiAliasing(boolean value) {
        this.somVectorPanel.setAntiAliasing(value);
    }

    private class SOMVectorPanel
    extends JPanel {
        private FloatMatrix codes;
        private int cluster;
        private float maxValue = 3.0f;
        private float minValue = -3.0f;
        private float midValue = 0.0f;
        private Dimension elementSize;
        private boolean drawBorders = true;
        private boolean isAntiAliasing = false;
        private Color missingColor = new Color(128, 128, 128);
        private BufferedImage posColorImage;
        private BufferedImage negColorImage;

        public SOMVectorPanel(FloatMatrix codes) {
            this.setBackground(Color.white);
            this.codes = codes;
        }

        public void setColorImages(BufferedImage posColorImage, BufferedImage negColorImage) {
            this.posColorImage = posColorImage;
            this.negColorImage = negColorImage;
        }

        public void setMissingColor(Color color) {
            this.missingColor = color;
        }

        public void setCurrentCluster(int cluster) {
            this.cluster = cluster;
            SOMExperimentHeader.this.clusterIndex = cluster;
        }

        public void setDrawBorders(boolean draw) {
            this.drawBorders = draw;
        }

        public void setAntiAliasing(boolean value) {
            this.isAntiAliasing = value;
        }

        public void setLeftInset(int leftMargin) {
            ((SOMExperimentHeader)SOMExperimentHeader.this).insets.left = leftMargin;
        }

        public void setValues(float minValue, float maxValue) {
            this.maxValue = maxValue;
            this.minValue = minValue;
        }

        public void setValues(float minValue, float midValue, float maxValue) {
            this.maxValue = maxValue;
            this.minValue = minValue;
            this.midValue = midValue;
        }

        public void updateSize(Dimension size) {
            this.elementSize = new Dimension(size);
            this.setFont(new Font("monospaced", 0, size.height));
            Graphics2D g = (Graphics2D)this.getGraphics();
            if (this.isAntiAliasing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            FontMetrics metrics = g.getFontMetrics();
            int strWidth = metrics.stringWidth(SOMExperimentHeader.SOM_VECTOR_STRING) + 10;
            int width = size.width * this.codes.getColumnDimension() + strWidth;
            int height = size.height + 10;
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (SOMExperimentHeader.this.getCluster().length < 1) {
                return;
            }
            if (this.isAntiAliasing) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            int samples = this.codes.getColumnDimension();
            for (int i = 0; i < samples; ++i) {
                this.fillRectAt(g, i, this.getColor(this.codes.get(this.cluster, i)));
                if (!this.drawBorders) continue;
                this.drawRectAt(g, i, Color.black);
            }
            g.setColor(Color.black);
            g.drawString(SOMExperimentHeader.SOM_VECTOR_STRING, this.elementSize.width * samples + 10 + ((SOMExperimentHeader)SOMExperimentHeader.this).insets.left, this.elementSize.height);
        }

        private void fillRectAt(Graphics g, int sample, Color color) {
            g.setColor(color);
            g.fillRect(sample * this.elementSize.width + ((SOMExperimentHeader)SOMExperimentHeader.this).insets.left, 0, this.elementSize.width, this.elementSize.height);
        }

        private void drawRectAt(Graphics g, int sample, Color color) {
            g.setColor(color);
            g.drawRect(sample * this.elementSize.width + ((SOMExperimentHeader)SOMExperimentHeader.this).insets.left, 0, this.elementSize.width - 1, this.elementSize.height - 1);
        }

        private Color getColor(float value) {
            int rgb;
            if (Float.isNaN(value)) {
                return this.missingColor;
            }
            if (SOMExperimentHeader.this.useDoubleGradient) {
                float maximum = value < this.midValue ? this.minValue : this.maxValue;
                int colorIndex = (int)(255.0f * (value - this.midValue) / (maximum - this.midValue));
                if (colorIndex < 0) {
                    colorIndex = -colorIndex;
                }
                colorIndex = colorIndex > 255 ? 255 : colorIndex;
                rgb = value < this.midValue ? this.negColorImage.getRGB(255 - colorIndex, 0) : this.posColorImage.getRGB(colorIndex, 0);
            } else {
                float span = this.maxValue - this.minValue;
                int colorIndex = value <= this.minValue ? 0 : (value >= this.maxValue ? 255 : (int)((value - this.minValue) / span * 255.0f));
                rgb = this.posColorImage.getRGB(colorIndex, 0);
            }
            return new Color(rgb);
        }
    }
}

