/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.tigr.util.awt.ActionInfoDialog;

public class SAMPreDialog
extends ActionInfoDialog {
    JRadioButton previousButton;
    JRadioButton newButton;
    JButton okButton;
    JButton cancelButton;
    JCheckBox drawTreesBox;
    private JRadioButton sigOnly;
    private JRadioButton allClusters;
    boolean okPressed = false;

    public SAMPreDialog(JFrame parentFrame, boolean modality) {
        super(parentFrame, "SAM Initialization", modality);
        this.setBounds(0, 0, 350, 150);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        constraints.anchor = 17;
        this.previousButton = new JRadioButton("Use SAM Graph and input parameters from last run", true);
        this.newButton = new JRadioButton("Start new analysis", false);
        ButtonGroup choosePrevOrNew = new ButtonGroup();
        choosePrevOrNew.add(this.previousButton);
        choosePrevOrNew.add(this.newButton);
        this.sigOnly = new JRadioButton("Significant genes only", true);
        this.allClusters = new JRadioButton("All clusters", false);
        this.sigOnly.setEnabled(false);
        this.allClusters.setEnabled(false);
        ButtonGroup allOrSig = new ButtonGroup();
        allOrSig.add(this.sigOnly);
        allOrSig.add(this.allClusters);
        this.buildConstraints(constraints, 0, 0, 2, 1, 0, 30);
        gridbag.setConstraints(this.previousButton, constraints);
        pane.add(this.previousButton);
        this.buildConstraints(constraints, 0, 1, 2, 1, 0, 30);
        gridbag.setConstraints(this.newButton, constraints);
        pane.add(this.newButton);
        this.drawTreesBox = new JCheckBox("Draw Hierarchichal Trees for: ", false);
        this.drawTreesBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    SAMPreDialog.this.sigOnly.setEnabled(false);
                    SAMPreDialog.this.allClusters.setEnabled(false);
                } else {
                    SAMPreDialog.this.sigOnly.setEnabled(true);
                    SAMPreDialog.this.allClusters.setEnabled(true);
                }
            }
        });
        this.buildConstraints(constraints, 0, 2, 2, 1, 0, 30);
        gridbag.setConstraints(this.drawTreesBox, constraints);
        pane.add(this.drawTreesBox);
        constraints.anchor = 10;
        this.buildConstraints(constraints, 0, 3, 1, 1, 50, 10);
        gridbag.setConstraints(this.sigOnly, constraints);
        pane.add(this.sigOnly);
        this.buildConstraints(constraints, 1, 3, 1, 1, 50, 10);
        gridbag.setConstraints(this.allClusters, constraints);
        pane.add(this.allClusters);
        this.okButton = new JButton("OK");
        this.buildConstraints(constraints, 0, 4, 1, 1, 50, 10);
        gridbag.setConstraints(this.okButton, constraints);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SAMPreDialog.this.okPressed = true;
                SAMPreDialog.this.dispose();
            }
        });
        pane.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.buildConstraints(constraints, 1, 4, 1, 1, 50, 0);
        gridbag.setConstraints(this.cancelButton, constraints);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SAMPreDialog.this.okPressed = false;
                SAMPreDialog.this.dispose();
            }
        });
        pane.add(this.cancelButton);
        this.setContentPane(pane);
    }

    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean usePrevious() {
        return this.previousButton.isSelected();
    }

    public boolean drawTrees() {
        return this.drawTreesBox.isSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.sigOnly.isSelected();
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        SAMPreDialog sDialog = new SAMPreDialog(dummyFrame, true);
        sDialog.setVisible(true);
    }
}

