/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterSelector;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSigOnlyPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMAllPermsDialog;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMGUI;
import org.tigr.util.StringSplitter;

public class SAMInitDialog
extends AlgorithmDialog {
    ImageIcon forwardImage;
    ImageIcon backImage;
    JTabbedPane tabPane;
    JTabbedPane unpairedTab;
    JTabbedPane oneClassTab;
    JTextField oneClassClusterMean;
    GroupExperimentsPanel gPanel;
    TwoClassPairedMainPanel tcpmPanel;
    MultiClassPanel mPanel;
    CensoredSurvivalPanel csPanel;
    OneClassPanel oneCPanel;
    S0AndQValueCalcPanel sqPanel;
    VersionPanel vPanel;
    PermutationsPanel pPanel;
    ImputationPanel iPanel;
    OKCancelPanel oPanel;
    final int fileLoadMin = 20;
    boolean okPressed = false;
    boolean allUniquePermsUsed = false;
    Vector<String> exptNames;
    int numGenes;
    int numUniquePerms;
    HCLSigOnlyPanel hclOpsPanel;
    boolean lotsOfSamples = false;
    String lotsOfSamplesWarningText = "                                                Note: You can assign large numbers of samples quickly by using a saved text file.";
    public static final int GROUP_A = 1;
    public static final int GROUP_B = 2;
    public static final int NEITHER_GROUP = 0;
    public static final int TWO_CLASS_UNPAIRED = 4;
    public static final int TWO_CLASS_PAIRED = 5;
    public static final int MULTI_CLASS = 6;
    public static final int CENSORED_SURVIVAL = 7;
    public static final int ONE_CLASS = 8;
    public static final int BUTTON_SELECTION = 9;
    public static final int CLUSTER_SELECTION = 10;
    protected ClusterSelector unpairedSelector;
    protected ClusterSelector oneClassSelector;
    protected ClusterSelector multiClassSelector;
    protected ClusterRepository repository;

    public SAMInitDialog(JFrame parentFrame, boolean modality, Vector<String> exptNames, int numGenes, ClusterRepository repository) {
        this(parentFrame, modality, exptNames, numGenes, repository, true);
    }

    public SAMInitDialog(JFrame parentFrame, boolean modality, Vector<String> exptNames, int numGenes, ClusterRepository repository, boolean isDataAppropriate) {
        super(parentFrame, "SAM Initialization", modality, isDataAppropriate);
        this.exptNames = exptNames;
        this.numGenes = numGenes;
        this.numUniquePerms = 0;
        this.repository = repository;
        this.setBounds(0, 0, 700, 800);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        if (exptNames.size() > 20) {
            this.lotsOfSamples = true;
        }
        this.forwardImage = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("org/tigr/images/Forward24.gif")));
        this.backImage = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("org/tigr/images/Back24.gif")));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        UIManager.put("TabbedPane.selected", Color.white);
        this.tabPane = new JTabbedPane();
        this.gPanel = new GroupExperimentsPanel(exptNames);
        this.unpairedSelector = new ClusterSelector(repository, 2);
        this.unpairedTab = new JTabbedPane();
        this.unpairedTab.add("Button Selection", this.gPanel);
        this.unpairedTab.add("Cluster Selection", (Component)this.unpairedSelector);
        this.unpairedTab.setSelectedIndex(1);
        if (repository == null || repository.isEmpty()) {
            this.unpairedTab.setSelectedIndex(0);
        }
        this.tabPane.add("Two-class unpaired", this.unpairedTab);
        this.tcpmPanel = new TwoClassPairedMainPanel();
        this.tabPane.add("Two-class paired", this.tcpmPanel);
        this.mPanel = new MultiClassPanel();
        this.tabPane.add("Multi-class", this.mPanel);
        this.csPanel = new CensoredSurvivalPanel(exptNames);
        this.tabPane.add("Censored survival", this.csPanel);
        JLabel meanLabel = new JLabel("Enter the mean value to be tested against: ");
        JPanel oneClassPanel = new JPanel();
        oneClassPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.oneClassClusterMean = new JTextField("0", 7);
        this.oneClassClusterMean.setSize(15, this.oneClassClusterMean.getHeight());
        this.oneClassSelector = new ClusterSelector(repository, 1);
        oneClassPanel.add((Component)meanLabel, c);
        c.gridx = 1;
        oneClassPanel.add((Component)this.oneClassClusterMean, c);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 20;
        oneClassPanel.add((Component)this.oneClassSelector, c);
        this.oneCPanel = new OneClassPanel();
        this.oneClassTab = new JTabbedPane();
        this.oneClassTab.add("Button Selection", this.oneCPanel);
        this.oneClassTab.add("Cluster Selection", oneClassPanel);
        this.oneClassTab.setSelectedIndex(1);
        if (repository == null || repository.isEmpty()) {
            this.oneClassTab.setSelectedIndex(0);
        }
        this.tabPane.add("One-Class", this.oneClassTab);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 75);
        gridbag.setConstraints(this.tabPane, constraints);
        pane.add(this.tabPane);
        this.vPanel = new VersionPanel();
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 5);
        gridbag.setConstraints(this.vPanel, constraints);
        pane.add(this.vPanel);
        this.pPanel = new PermutationsPanel();
        this.buildConstraints(constraints, 0, 2, 1, 1, 0, 5);
        gridbag.setConstraints(this.pPanel, constraints);
        pane.add(this.pPanel);
        this.sqPanel = new S0AndQValueCalcPanel();
        this.buildConstraints(constraints, 0, 3, 1, 1, 0, 10);
        gridbag.setConstraints(this.sqPanel, constraints);
        pane.add(this.sqPanel);
        this.iPanel = new ImputationPanel();
        this.buildConstraints(constraints, 0, 4, 1, 1, 0, 5);
        gridbag.setConstraints(this.iPanel, constraints);
        pane.add(this.iPanel);
        this.hclOpsPanel = new HCLSigOnlyPanel();
        this.buildConstraints(constraints, 0, 5, 1, 1, 0, 5);
        gridbag.setConstraints(this.hclOpsPanel, constraints);
        pane.add(this.hclOpsPanel);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean isSaveMatrix() {
        return this.iPanel.saveMatrixChkBox.isSelected();
    }

    private void setTimeCourse(boolean set) {
        for (int i = 0; i < this.gPanel.timeField.length; ++i) {
            this.gPanel.timeField[i].setVisible(set);
            this.gPanel.startCB[i].setVisible(set);
            this.gPanel.endCB[i].setVisible(set);
            this.oneCPanel.timefields[i].setVisible(set);
            this.oneCPanel.startCB[i].setVisible(set);
            this.oneCPanel.endCB[i].setVisible(set);
        }
        this.unpairedTab.setSelectedIndex(0);
        this.unpairedTab.setEnabledAt(1, !set);
        this.oneClassTab.setSelectedIndex(0);
        this.oneClassTab.setEnabledAt(1, !set);
        this.gPanel.setEnabled(!set);
        if (this.tabPane.getSelectedIndex() == 1 || this.tabPane.getSelectedIndex() == 2 || this.tabPane.getSelectedIndex() == 3) {
            this.tabPane.setSelectedIndex(0);
        }
        this.tabPane.setEnabledAt(1, !set);
        this.tabPane.setEnabledAt(2, !set);
        this.tabPane.setEnabledAt(3, !set);
        this.gPanel.updateUI();
        this.gPanel.repaint();
    }

    private void getTCPRVector() {
        Vector<Integer> rpair = new Vector<Integer>();
        for (int i = 0; i < this.exptNames.size(); ++i) {
            int found = this.tcpmPanel.tcpPanel.pairedAExpts.indexOf(i);
            if (found != -1) {
                rpair.add(found + 1);
                continue;
            }
            found = this.tcpmPanel.tcpPanel.pairedBExpts.indexOf(i);
            if (found == -1) continue;
            rpair.add(-found - 1);
        }
    }

    public int getTestDesign() {
        int testDesign = 9;
        if (this.tabPane.getSelectedIndex() == 0) {
            if (this.unpairedTab.getSelectedIndex() == 1) {
                testDesign = 10;
            }
        } else if (this.tabPane.getSelectedIndex() == 2) {
            if (this.mPanel.multiClassTab.getSelectedIndex() == 1) {
                testDesign = 10;
            }
        } else if (this.tabPane.getSelectedIndex() == 4 && this.oneClassTab.getSelectedIndex() == 1) {
            testDesign = 10;
        }
        return testDesign;
    }

    public int getStudyDesign() {
        int studyDesign = 4;
        if (this.tabPane.getSelectedIndex() == 0) {
            studyDesign = 4;
        } else if (this.tabPane.getSelectedIndex() == 1) {
            studyDesign = 5;
        } else if (this.tabPane.getSelectedIndex() == 2) {
            studyDesign = 6;
        } else if (this.tabPane.getSelectedIndex() == 3) {
            studyDesign = 7;
        } else if (this.tabPane.getSelectedIndex() == 4) {
            studyDesign = 8;
        }
        return studyDesign;
    }

    public int[] getStartEnd() {
        int[] tc;
        block3: {
            block2: {
                tc = new int[this.exptNames.size()];
                if (this.getStudyDesign() != 4) break block2;
                for (int i = 0; i < tc.length; ++i) {
                    tc[i] = this.gPanel.startCB[i].isSelected() ? 1 : (this.gPanel.endCB[i].isSelected() ? 2 : 0);
                }
                break block3;
            }
            if (this.getStudyDesign() != 8) break block3;
            for (int i = 0; i < tc.length; ++i) {
                tc[i] = this.oneCPanel.startCB[i].isSelected() ? 1 : (this.oneCPanel.endCB[i].isSelected() ? 2 : 0);
            }
        }
        return tc;
    }

    public float[] getTimeCourse() {
        float[] tc;
        block3: {
            block2: {
                tc = new float[this.exptNames.size()];
                if (this.getStudyDesign() != 4) break block2;
                for (int i = 0; i < tc.length; ++i) {
                    tc[i] = Float.parseFloat(this.gPanel.timeField[i].getText());
                }
                break block3;
            }
            if (this.getStudyDesign() != 8) break block3;
            for (int i = 0; i < tc.length; ++i) {
                tc[i] = Float.parseFloat(this.oneCPanel.timefields[i].getText());
            }
        }
        return tc;
    }

    public int[] getGroupAssignments() {
        int[] groupAssignments = new int[this.exptNames.size()];
        if (this.getStudyDesign() == 4) {
            if (this.getTestDesign() == 10) {
                groupAssignments = this.getUnpairedClusterGroupAssignments();
            } else {
                for (int i = 0; i < this.exptNames.size(); ++i) {
                    groupAssignments[i] = this.gPanel.groupARadioButtons[i].isSelected() ? 1 : (this.gPanel.groupBRadioButtons[i].isSelected() ? 2 : 0);
                }
            }
        } else if (this.getStudyDesign() == 6) {
            if (this.getTestDesign() == 10) {
                groupAssignments = this.getMultiGroupClusterAssignments();
            } else {
                block1: for (int i = 0; i < this.exptNames.size(); ++i) {
                    if (this.mPanel.mulgPanel.notInGroupRadioButtons[i].isSelected()) {
                        groupAssignments[i] = 0;
                        continue;
                    }
                    for (int j = 0; j < this.mPanel.mulgPanel.exptGroupRadioButtons.length; ++j) {
                        if (!this.mPanel.mulgPanel.exptGroupRadioButtons[j][i].isSelected()) continue;
                        groupAssignments[i] = j + 1;
                        continue block1;
                    }
                }
            }
        } else if (this.getStudyDesign() == 8) {
            if (this.getTestDesign() == 10) {
                return this.getOneClassClusterAssignments();
            }
            return this.getOneClassAssignments();
        }
        return groupAssignments;
    }

    public int[] getUnpairedClusterGroupAssignments() {
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList groupAsamps = this.unpairedSelector.getGroupSamples("Group 1");
        ArrayList groupBsamps = this.unpairedSelector.getGroupSamples("Group 2");
        int toWhich = 0;
        boolean chosen = false;
        for (int i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            if (groupAsamps.contains(i)) {
                groupAssignments[i] = 1;
                doubleAssigned = true;
            }
            if (!groupBsamps.contains(i)) continue;
            groupAssignments[i] = 2;
            if (!doubleAssigned) continue;
            if (!chosen) {
                Object[] optionst = new Object[]{"GROUP 1", "GROUP 2", "NEITHER", "CANCEL"};
                int option = JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Which group should these samples be added to?", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                if (option == 0) {
                    groupAssignments[i] = 1;
                }
                if (option == 1) {
                    groupAssignments[i] = 2;
                }
                if (option == 2) {
                    groupAssignments[i] = 0;
                }
                if (option == 3) {
                    return null;
                }
                toWhich = groupAssignments[i];
                chosen = true;
                continue;
            }
            groupAssignments[i] = toWhich;
        }
        return groupAssignments;
    }

    public int[] getMultiGroupClusterAssignments() {
        int j;
        int i;
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[this.mPanel.numGroups];
        for (i = 0; i < this.mPanel.numGroups; ++i) {
            j = i + 1;
            arraylistArray[i] = this.multiClassSelector.getGroupSamples("Group " + j);
        }
        for (i = 0; i < arraylistArray[0].size(); ++i) {
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            for (j = 0; j < this.mPanel.numGroups; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[i] = j + 1;
                doubleAssigned = true;
            }
        }
        return groupAssignments;
    }

    public int[] getOneClassAssignments() {
        int[] oneClassAssignments = new int[this.oneCPanel.includeExpts.length];
        for (int i = 0; i < oneClassAssignments.length; ++i) {
            oneClassAssignments[i] = this.oneCPanel.includeExpts[i].isSelected() ? 1 : 0;
        }
        return oneClassAssignments;
    }

    public int[] getOneClassClusterAssignments() {
        ArrayList groupAsamps = this.oneClassSelector.getGroupSamples("Group 1");
        int[] groupAssignments = new int[this.exptNames.size()];
        for (int i = 0; i < this.exptNames.size(); ++i) {
            groupAssignments[i] = 0;
            if (!groupAsamps.contains(i)) continue;
            groupAssignments[i] = 1;
        }
        return groupAssignments;
    }

    public double getOneClassMean() {
        if (this.getTestDesign() == 10) {
            return Double.parseDouble(this.oneClassClusterMean.getText());
        }
        return Double.parseDouble(this.oneCPanel.meanField.getText());
    }

    public int getMultiClassNumGroups() {
        return Integer.parseInt(this.mPanel.ngPanel.numGroupsField.getText());
    }

    public int getNumValidOneClassExpts() {
        int validNum = 0;
        int[] oca = this.getTestDesign() == 9 ? this.getOneClassAssignments() : this.getOneClassClusterAssignments();
        for (int i = 0; i < oca.length; ++i) {
            if (oca[i] != 1) continue;
            ++validNum;
        }
        return validNum;
    }

    public int[] getGroupCount() {
        int[] groupAssignments = this.getGroupAssignments();
        int groupACount = 0;
        int groupBCount = 0;
        for (int i = 0; i < groupAssignments.length; ++i) {
            if (groupAssignments[i] == 1) {
                ++groupACount;
                continue;
            }
            if (groupAssignments[i] != 2) continue;
            ++groupBCount;
        }
        int[] groupCount = new int[]{groupACount, groupBCount};
        return groupCount;
    }

    public boolean[] isInSurvivalAnalysis() {
        boolean[] inAnalysis = new boolean[this.csPanel.fields.length];
        for (int i = 0; i < inAnalysis.length; ++i) {
            inAnalysis[i] = this.csPanel.fields[i].inAnalysisCheckBox.isSelected();
        }
        return inAnalysis;
    }

    public double[] getSurvivalTimes() {
        double[] survivalTimes = new double[this.exptNames.size()];
        for (int i = 0; i < survivalTimes.length; ++i) {
            try {
                double d;
                String s = this.csPanel.fields[i].timeInputField.getText();
                survivalTimes[i] = d = new Double(s).doubleValue();
                continue;
            }
            catch (NumberFormatException nfe) {
                survivalTimes[i] = 0.0;
            }
        }
        return survivalTimes;
    }

    public boolean[] isCensored() {
        boolean[] censored = new boolean[this.exptNames.size()];
        for (int i = 0; i < censored.length; ++i) {
            censored[i] = this.csPanel.fields[i].censoredRadioButton.isSelected();
        }
        return censored;
    }

    public Vector<Integer> getPairedAExpts() {
        return this.tcpmPanel.tcpPanel.pairedAExpts;
    }

    public Vector<Integer> getPairedBExpts() {
        return this.tcpmPanel.tcpPanel.pairedBExpts;
    }

    private long factorial(int n) {
        if (n == 1 || n == 0) {
            return 1L;
        }
        return this.factorial(n - 1) * (long)n;
    }

    public int getNumNeighbors() {
        String s = this.iPanel.numNeighborsField.getText();
        return Integer.parseInt(s);
    }

    public boolean isUseRSAM() {
        return this.vPanel.useRSAM.isSelected();
    }

    public int getUserNumCombs() {
        String s = this.pPanel.numPermsInputField.getText();
        return Integer.parseInt(s);
    }

    public boolean useKNearest() {
        return this.iPanel.kNearestButton.isSelected();
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.hclOpsPanel.drawSigTreesOnly();
    }

    public boolean useTusherEtAlS0() {
        return this.sqPanel.s0SelectBox.getSelectedIndex() == 0;
    }

    public double getPercentile() {
        if (this.sqPanel.s0SelectButton.isSelected()) {
            int index = this.sqPanel.s0SelectBox.getSelectedIndex();
            if (index == 0) {
                return -1.0;
            }
            if (index == 1) {
                return 5.0;
            }
            if (index == 2) {
                return 50.0;
            }
            if (index == 3) {
                return 90.0;
            }
            if (index == 4) {
                return 0.0;
            }
        } else {
            return Double.parseDouble(this.sqPanel.s0EntryField.getText());
        }
        return 0.0;
    }

    public boolean calculateQLowestFDR() {
        return this.sqPanel.qYesButton.isSelected();
    }

    public int getNumUniquePerms() {
        return this.numUniquePerms;
    }

    public boolean useAllUniquePerms() {
        return this.allUniquePermsUsed;
    }

    private int getNumUnique2ClassUnpairedPerms(int n, int k) {
        return Math.round(this.factorial(n) / (this.factorial(k) * this.factorial(n - k)));
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        Vector<String> dummyVect = new Vector<String>();
        for (int i = 0; i < 100; ++i) {
            dummyVect.add("Expt " + i);
        }
        SAMInitDialog sDialog = new SAMInitDialog(dummyFrame, true, dummyVect, 5, null);
        sDialog.setVisible(true);
        sDialog.getTCPRVector();
        float[] asd = sDialog.getTimeCourse();
        for (int i = 0; i < asd.length; ++i) {
            System.out.print(asd[i] + "   ");
        }
        System.exit(0);
    }

    public boolean isTimeCourse() {
        return this.vPanel.timecourseCB.isSelected();
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            block58: {
                String command = ae.getActionCommand();
                if (command.equals("ok-command")) {
                    if (SAMInitDialog.this.getTestDesign() == 10 && SAMInitDialog.this.repository.isEmpty()) {
                        JOptionPane.showMessageDialog(null, "Cluster Repository is Empty.", "Error", 2);
                        return;
                    }
                    try {
                        double d;
                        if (SAMInitDialog.this.sqPanel.s0EntryButton.isSelected() && ((d = Double.parseDouble(SAMInitDialog.this.sqPanel.s0EntryField.getText())) < 0.0 || d > 100.0)) {
                            JOptionPane.showMessageDialog(null, "Enter a valid percentile between 0 and 100!", "Error!", 0);
                            return;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(null, "Enter a valid percentile between 0 and 100!", "Error!", 0);
                        return;
                    }
                    try {
                        SAMInitDialog.this.getUserNumCombs();
                        if (SAMInitDialog.this.useKNearest()) {
                            SAMInitDialog.this.getNumNeighbors();
                        }
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                        return;
                    }
                    if (SAMInitDialog.this.getStudyDesign() == 4) {
                        int[] grpAssignments = SAMInitDialog.this.getTestDesign() == 9 ? SAMInitDialog.this.getGroupAssignments() : SAMInitDialog.this.getUnpairedClusterGroupAssignments();
                        int grpACounter = 0;
                        int grpBCounter = 0;
                        for (int i = 0; i < grpAssignments.length; ++i) {
                            if (grpAssignments[i] == 1) {
                                ++grpACounter;
                                continue;
                            }
                            if (grpAssignments[i] != 2) continue;
                            ++grpBCounter;
                        }
                        if (grpACounter < 2 || grpBCounter < 2) {
                            JOptionPane.showMessageDialog(null, "Group A and Group B must contain more than one sample.", "Error", 2);
                        } else {
                            try {
                                int numCombs = 0;
                                numCombs = SAMInitDialog.this.getUserNumCombs();
                                if (SAMInitDialog.this.useKNearest()) {
                                    SAMInitDialog.this.getNumNeighbors();
                                }
                                if (grpACounter + grpBCounter <= 20) {
                                    SAMInitDialog.this.numUniquePerms = SAMInitDialog.this.getNumUnique2ClassUnpairedPerms(grpACounter + grpBCounter, grpACounter);
                                    SAMAllPermsDialog sapDialog = new SAMAllPermsDialog(SAMGUI.SAMFrame, true, SAMInitDialog.this.numUniquePerms, numCombs);
                                    sapDialog.setVisible(true);
                                    SAMInitDialog.this.allUniquePermsUsed = sapDialog.useAllPerms();
                                }
                                SAMInitDialog.this.okPressed = true;
                                UIManager.put("TabbedPane.selected", Color.lightGray);
                                SAMInitDialog.this.dispose();
                            }
                            catch (NumberFormatException nfe) {
                                JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                            }
                        }
                    } else if (SAMInitDialog.this.getStudyDesign() == 5) {
                        if (SAMInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size() < 2) {
                            JOptionPane.showMessageDialog(null, "Need at least two pairs of samples!", "Error", 0);
                        } else {
                            if (SAMInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size() <= 29) {
                                int numCombs = SAMInitDialog.this.getUserNumCombs();
                                SAMInitDialog.this.numUniquePerms = (int)Math.pow(2.0, SAMInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size());
                                SAMAllPermsDialog sapDialog = new SAMAllPermsDialog(SAMGUI.SAMFrame, true, SAMInitDialog.this.numUniquePerms, numCombs);
                                sapDialog.setVisible(true);
                                SAMInitDialog.this.allUniquePermsUsed = sapDialog.useAllPerms();
                            }
                            SAMInitDialog.this.okPressed = true;
                            UIManager.put("TabbedPane.selected", Color.lightGray);
                            SAMInitDialog.this.dispose();
                        }
                    } else if (SAMInitDialog.this.getStudyDesign() == 6) {
                        int i;
                        boolean tooFew = false;
                        int[] grpAssignments = SAMInitDialog.this.getGroupAssignments();
                        int numGroups = SAMInitDialog.this.getMultiClassNumGroups();
                        int[] groupSize = new int[numGroups];
                        for (i = 0; i < groupSize.length; ++i) {
                            groupSize[i] = 0;
                        }
                        for (i = 0; i < grpAssignments.length; ++i) {
                            int currentGroup = grpAssignments[i];
                            if (currentGroup == 0) continue;
                            int n = currentGroup - 1;
                            groupSize[n] = groupSize[n] + 1;
                        }
                        for (i = 0; i < groupSize.length; ++i) {
                            if (groupSize[i] > 1) continue;
                            JOptionPane.showMessageDialog(null, "Each group must contain more than one sample.", "Error", 2);
                            tooFew = true;
                            break;
                        }
                        if (!tooFew) {
                            try {
                                SAMInitDialog.this.getUserNumCombs();
                                if (SAMInitDialog.this.useKNearest()) {
                                    SAMInitDialog.this.getNumNeighbors();
                                }
                                SAMInitDialog.this.okPressed = true;
                                UIManager.put("TabbedPane.selected", Color.lightGray);
                                SAMInitDialog.this.dispose();
                            }
                            catch (NumberFormatException nfe) {
                                JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                            }
                        }
                    } else if (SAMInitDialog.this.getStudyDesign() == 7) {
                        try {
                            boolean allSame = true;
                            int selectedCounter = 0;
                            double previousTime = 0.0;
                            for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                                if (!SAMInitDialog.this.csPanel.fields[i].inAnalysisCheckBox.isSelected()) continue;
                                ++selectedCounter;
                                double d = new Double(SAMInitDialog.this.csPanel.fields[i].timeInputField.getText());
                                if (i > 0 && previousTime != d) {
                                    allSame = false;
                                }
                                previousTime = d;
                            }
                            int numCombs = 0;
                            numCombs = SAMInitDialog.this.getUserNumCombs();
                            if (SAMInitDialog.this.useKNearest()) {
                                SAMInitDialog.this.getNumNeighbors();
                            }
                            if (selectedCounter < 2) {
                                JOptionPane.showMessageDialog(null, "At least 2 samples must be selected!", "Error", 0);
                                break block58;
                            }
                            if (allSame) {
                                JOptionPane.showMessageDialog(null, "At least one of the survival time values must be different from the rest!", "Error", 0);
                                break block58;
                            }
                            if (selectedCounter <= 10) {
                                SAMInitDialog.this.numUniquePerms = (int)SAMInitDialog.this.factorial(selectedCounter);
                                SAMAllPermsDialog sapDialog = new SAMAllPermsDialog(SAMGUI.SAMFrame, true, SAMInitDialog.this.numUniquePerms, numCombs);
                                sapDialog.setVisible(true);
                                SAMInitDialog.this.allUniquePermsUsed = sapDialog.useAllPerms();
                            }
                            SAMInitDialog.this.okPressed = true;
                            UIManager.put("TabbedPane.selected", Color.lightGray);
                            SAMInitDialog.this.dispose();
                        }
                        catch (NumberFormatException nfe) {
                            JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                        }
                    } else if (SAMInitDialog.this.getStudyDesign() == 8) {
                        try {
                            SAMInitDialog.this.getOneClassMean();
                            if (SAMInitDialog.this.getNumValidOneClassExpts() < 2) {
                                JOptionPane.showMessageDialog(null, "At least 2 samples must be selected for one-class test!", "Error", 0);
                                break block58;
                            }
                            if (SAMInitDialog.this.getNumValidOneClassExpts() <= 29) {
                                int numCombs = SAMInitDialog.this.getUserNumCombs();
                                SAMInitDialog.this.numUniquePerms = (int)Math.pow(2.0, SAMInitDialog.this.getNumValidOneClassExpts());
                                SAMAllPermsDialog sapDialog = new SAMAllPermsDialog(SAMGUI.SAMFrame, true, SAMInitDialog.this.numUniquePerms, numCombs);
                                sapDialog.setVisible(true);
                                SAMInitDialog.this.allUniquePermsUsed = sapDialog.useAllPerms();
                            }
                            SAMInitDialog.this.okPressed = true;
                            UIManager.put("TabbedPane.selected", Color.lightGray);
                            SAMInitDialog.this.dispose();
                        }
                        catch (NumberFormatException nfe) {
                            JOptionPane.showMessageDialog(null, "Invalid value for one-class mean!", "Error", 0);
                        }
                    }
                } else if (command.equals("reset-command")) {
                    if (SAMInitDialog.this.getStudyDesign() == 4) {
                        SAMInitDialog.this.gPanel.reset();
                    } else if (SAMInitDialog.this.getStudyDesign() == 6 && SAMInitDialog.this.mPanel.mulgPanel != null) {
                        SAMInitDialog.this.mPanel.reset();
                    } else if (SAMInitDialog.this.getStudyDesign() == 7) {
                        SAMInitDialog.this.csPanel.reset();
                    }
                    SAMInitDialog.this.sqPanel.reset();
                    SAMInitDialog.this.pPanel.reset();
                    SAMInitDialog.this.iPanel.reset();
                    SAMInitDialog.this.tcpmPanel.tcpPanel.reset();
                    SAMInitDialog.this.hclOpsPanel.setHCLSelected(false);
                } else if (command.equals("cancel-command")) {
                    SAMInitDialog.this.okPressed = false;
                    UIManager.put("TabbedPane.selected", Color.lightGray);
                    SAMInitDialog.this.dispose();
                } else if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(SAMInitDialog.this, "SAM Initialization Dialog");
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent we) {
            UIManager.put("TabbedPane.selected", Color.lightGray);
        }
    }

    class OKCancelPanel
    extends JPanel {
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        JCheckBox drawTreesBox = new JCheckBox("Draw Hierarchical Trees");

        OKCancelPanel() {
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (SAMInitDialog.this.getStudyDesign() == 4) {
                        int[] grpAssignments = SAMInitDialog.this.getGroupAssignments();
                        int grpACounter = 0;
                        int grpBCounter = 0;
                        for (int i = 0; i < grpAssignments.length; ++i) {
                            if (grpAssignments[i] == 1) {
                                ++grpACounter;
                                continue;
                            }
                            if (grpAssignments[i] != 2) continue;
                            ++grpBCounter;
                        }
                        if (grpACounter < 2 || grpBCounter < 2) {
                            JOptionPane.showMessageDialog(null, "Group A and Group B must contain more than one sample", "Error", 2);
                        } else {
                            try {
                                SAMInitDialog.this.getUserNumCombs();
                                if (SAMInitDialog.this.useKNearest()) {
                                    SAMInitDialog.this.getNumNeighbors();
                                }
                                SAMInitDialog.this.okPressed = true;
                                SAMInitDialog.this.dispose();
                            }
                            catch (NumberFormatException nfe) {
                                JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                            }
                        }
                    } else if (SAMInitDialog.this.getStudyDesign() == 6) {
                        int i;
                        boolean tooFew = false;
                        int[] grpAssignments = SAMInitDialog.this.getGroupAssignments();
                        int numGroups = SAMInitDialog.this.getMultiClassNumGroups();
                        int[] groupSize = new int[numGroups];
                        for (i = 0; i < groupSize.length; ++i) {
                            groupSize[i] = 0;
                        }
                        for (i = 0; i < grpAssignments.length; ++i) {
                            int currentGroup = grpAssignments[i];
                            if (currentGroup == 0) continue;
                            int n = currentGroup - 1;
                            groupSize[n] = groupSize[n] + 1;
                        }
                        for (i = 0; i < groupSize.length; ++i) {
                            if (groupSize[i] > 1) continue;
                            JOptionPane.showMessageDialog(null, "Each group must contain more than one sample.", "Error", 2);
                            tooFew = true;
                            break;
                        }
                        if (!tooFew) {
                            try {
                                SAMInitDialog.this.getUserNumCombs();
                                if (SAMInitDialog.this.useKNearest()) {
                                    SAMInitDialog.this.getNumNeighbors();
                                }
                                SAMInitDialog.this.okPressed = true;
                                SAMInitDialog.this.dispose();
                            }
                            catch (NumberFormatException nfe) {
                                JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                            }
                        }
                    } else if (SAMInitDialog.this.getStudyDesign() == 7) {
                        try {
                            boolean allSame = true;
                            int selectedCounter = 0;
                            double previousTime = 0.0;
                            for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                                if (!SAMInitDialog.this.csPanel.fields[i].inAnalysisCheckBox.isSelected()) continue;
                                ++selectedCounter;
                                double d = new Double(SAMInitDialog.this.csPanel.fields[i].timeInputField.getText());
                                if (i > 0 && previousTime != d) {
                                    allSame = false;
                                }
                                previousTime = d;
                            }
                            SAMInitDialog.this.getUserNumCombs();
                            if (SAMInitDialog.this.useKNearest()) {
                                SAMInitDialog.this.getNumNeighbors();
                            }
                            if (selectedCounter < 2) {
                                JOptionPane.showMessageDialog(null, "At least 2 samples must be selected!", "Error", 0);
                            } else if (allSame) {
                                JOptionPane.showMessageDialog(null, "At least one of the survival time values must be different from the rest!", "Error", 0);
                            } else {
                                SAMInitDialog.this.okPressed = true;
                                SAMInitDialog.this.dispose();
                            }
                        }
                        catch (NumberFormatException nfe) {
                            JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                        }
                    }
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SAMInitDialog.this.okPressed = false;
                    SAMInitDialog.this.dispose();
                }
            });
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            SAMInitDialog.this.buildConstraints(constraints, 0, 0, 2, 1, 0, 50);
            gridbag.setConstraints(this.drawTreesBox, constraints);
            this.add(this.drawTreesBox);
            SAMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 50, 50);
            gridbag.setConstraints(this.okButton, constraints);
            this.add(this.okButton);
            SAMInitDialog.this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
            gridbag.setConstraints(this.cancelButton, constraints);
            this.add(this.cancelButton);
        }
    }

    class ImputationPanel
    extends JPanel {
        JRadioButton kNearestButton;
        JRadioButton rowAverageButton;
        JTextField numNeighborsField;
        JLabel numNeighborsLabel;
        String numNeighborsText;
        JCheckBox saveMatrixChkBox;

        ImputationPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Imputation Engine", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            this.numNeighborsText = "10";
            if (SAMInitDialog.this.numGenes < 10) {
                this.numNeighborsText = Integer.toString(SAMInitDialog.this.numGenes);
            }
            this.numNeighborsField = new JTextField(this.numNeighborsText, 7);
            this.numNeighborsLabel = new JLabel("Number of neighbors:       ");
            this.kNearestButton = new JRadioButton("K-nearest neighbors imputer", true);
            this.kNearestButton.setBackground(Color.white);
            this.kNearestButton.setFocusPainted(false);
            this.kNearestButton.setForeground(UIManager.getColor("Label.foreground"));
            this.rowAverageButton = new JRadioButton("Row average imputer              ", false);
            this.rowAverageButton.setBackground(Color.white);
            this.rowAverageButton.setFocusPainted(false);
            this.rowAverageButton.setForeground(UIManager.getColor("Label.foreground"));
            this.kNearestButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ImputationPanel.this.numNeighborsLabel.setEnabled(true);
                    ImputationPanel.this.numNeighborsField.setEnabled(true);
                    ImputationPanel.this.numNeighborsField.setBackground(Color.white);
                    ImputationPanel.this.numNeighborsField.setText(ImputationPanel.this.numNeighborsText);
                }
            });
            this.rowAverageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ImputationPanel.this.numNeighborsLabel.setEnabled(false);
                    ImputationPanel.this.numNeighborsField.setEnabled(false);
                    ImputationPanel.this.numNeighborsField.setBackground(Color.gray);
                    ImputationPanel.this.numNeighborsField.setText("");
                }
            });
            ButtonGroup chooseKOrRowAvg = new ButtonGroup();
            chooseKOrRowAvg.add(this.kNearestButton);
            chooseKOrRowAvg.add(this.rowAverageButton);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 40, 50);
            constraints.anchor = 13;
            gridbag.setConstraints(this.kNearestButton, constraints);
            this.add(this.kNearestButton);
            SAMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 30, 0);
            constraints.anchor = 13;
            gridbag.setConstraints(this.numNeighborsLabel, constraints);
            this.add(this.numNeighborsLabel);
            SAMInitDialog.this.buildConstraints(constraints, 2, 0, 1, 1, 30, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.numNeighborsField, constraints);
            this.add(this.numNeighborsField);
            SAMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 50);
            constraints.anchor = 13;
            gridbag.setConstraints(this.rowAverageButton, constraints);
            this.add(this.rowAverageButton);
            SAMInitDialog.this.buildConstraints(constraints, 1, 1, 1, 1, 0, 50);
            JPanel dummy = new JPanel();
            dummy.setBackground(Color.white);
            gridbag.setConstraints(dummy, constraints);
            this.add(dummy);
            SAMInitDialog.this.buildConstraints(constraints, 2, 1, 1, 1, 0, 50);
            gridbag.setConstraints(dummy, constraints);
            this.add(dummy);
            constraints.anchor = 10;
            SAMInitDialog.this.buildConstraints(constraints, 0, 2, 3, 1, 0, 50);
            this.saveMatrixChkBox = new JCheckBox("Save Imputed Matrix", false);
            this.saveMatrixChkBox.setBackground(Color.white);
            this.saveMatrixChkBox.setFocusPainted(false);
            this.saveMatrixChkBox.setForeground(UIManager.getColor("Label.foreground"));
            gridbag.setConstraints(this.saveMatrixChkBox, constraints);
            this.add(this.saveMatrixChkBox);
        }

        private void reset() {
            this.numNeighborsField.setText(this.numNeighborsText);
            this.numNeighborsField.setBackground(Color.white);
            this.numNeighborsField.setEnabled(true);
            this.kNearestButton.setSelected(true);
            this.saveMatrixChkBox.setSelected(false);
        }
    }

    class S0AndQValueCalcPanel
    extends JPanel {
        JComboBox s0SelectBox;
        JTextField s0EntryField;
        JRadioButton s0SelectButton;
        JRadioButton s0EntryButton;
        JRadioButton qYesButton;
        JRadioButton qNoButton;

        S0AndQValueCalcPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "S0 and Q Value parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            String[] s0SelectOptions = new String[]{"Tusher et al. method", "5th percentile", "50th percentile", "90th percentile", "Minimum S Value"};
            this.setBackground(Color.white);
            this.s0SelectBox = new JComboBox<String>(s0SelectOptions);
            this.s0SelectButton = new JRadioButton("Select S0 using", true);
            this.s0SelectButton.setBackground(Color.white);
            this.s0EntryButton = new JRadioButton(" OR Enter s0 percentile (0-100)", false);
            this.s0EntryButton.setBackground(Color.white);
            this.s0EntryField = new JTextField("", 7);
            this.s0EntryField.setEnabled(false);
            this.s0EntryField.setBackground(Color.darkGray);
            ButtonGroup s0Group = new ButtonGroup();
            this.s0SelectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    S0AndQValueCalcPanel.this.s0SelectBox.setEnabled(true);
                    S0AndQValueCalcPanel.this.s0EntryField.setText("");
                    S0AndQValueCalcPanel.this.s0EntryField.setEnabled(false);
                    S0AndQValueCalcPanel.this.s0EntryField.setBackground(Color.darkGray);
                }
            });
            this.s0EntryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    S0AndQValueCalcPanel.this.s0EntryField.setText("10");
                    S0AndQValueCalcPanel.this.s0EntryField.setEnabled(true);
                    S0AndQValueCalcPanel.this.s0EntryField.setBackground(Color.white);
                    S0AndQValueCalcPanel.this.s0SelectBox.setEnabled(false);
                }
            });
            s0Group.add(this.s0SelectButton);
            s0Group.add(this.s0EntryButton);
            this.qYesButton = new JRadioButton("Yes (slow!)", false);
            this.qYesButton.setBackground(Color.white);
            this.qNoButton = new JRadioButton("No (quick)", true);
            this.qNoButton.setBackground(Color.white);
            ButtonGroup qGroup = new ButtonGroup();
            qGroup.add(this.qYesButton);
            qGroup.add(this.qNoButton);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 25, 50);
            constraints.anchor = 13;
            gridbag.setConstraints(this.s0SelectButton, constraints);
            this.add(this.s0SelectButton);
            SAMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 25, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.s0SelectBox, constraints);
            this.add(this.s0SelectBox);
            SAMInitDialog.this.buildConstraints(constraints, 2, 0, 1, 1, 25, 0);
            constraints.anchor = 13;
            gridbag.setConstraints(this.s0EntryButton, constraints);
            this.add(this.s0EntryButton);
            SAMInitDialog.this.buildConstraints(constraints, 3, 0, 1, 1, 25, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.s0EntryField, constraints);
            this.add(this.s0EntryField);
            JLabel qLabel = new JLabel("Calculate q-values?  ");
            SAMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 10, 50);
            constraints.anchor = 13;
            gridbag.setConstraints(qLabel, constraints);
            this.add(qLabel);
            SAMInitDialog.this.buildConstraints(constraints, 1, 1, 1, 1, 10, 0);
            constraints.anchor = 13;
            gridbag.setConstraints(this.qNoButton, constraints);
            this.add(this.qNoButton);
            SAMInitDialog.this.buildConstraints(constraints, 2, 1, 2, 1, 80, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.qYesButton, constraints);
            this.add(this.qYesButton);
        }

        public void reset() {
            this.s0SelectButton.setSelected(true);
            this.s0SelectBox.setEnabled(true);
            this.s0SelectBox.setSelectedIndex(0);
            this.s0EntryField.setText("");
            this.s0EntryField.setBackground(Color.darkGray);
            this.s0EntryField.setEnabled(false);
            this.qNoButton.setSelected(true);
        }
    }

    class PermutationsPanel
    extends JPanel {
        JLabel numPermsLabel;
        JTextField numPermsInputField;

        PermutationsPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Number of permutations", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            this.numPermsLabel = new JLabel("Enter number of permutations:   ");
            this.numPermsInputField = new JTextField("100", 7);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
            constraints.anchor = 13;
            gridbag.setConstraints(this.numPermsLabel, constraints);
            this.add(this.numPermsLabel);
            SAMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.numPermsInputField, constraints);
            this.add(this.numPermsInputField);
        }

        public void reset() {
            this.numPermsInputField.setText("100");
        }
    }

    class VersionPanel
    extends JPanel {
        JLabel numPermsLabel;
        JCheckBox useRSAM;
        JCheckBox timecourseCB;
        JRadioButton versionThree;
        ButtonGroup bg = new ButtonGroup();

        VersionPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "R settings", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            this.numPermsLabel = new JLabel("Enter number of permutations:   ");
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.useRSAM = new JCheckBox("Use R");
            this.useRSAM.setBackground(Color.white);
            this.useRSAM.setSelected(false);
            this.useRSAM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!VersionPanel.this.useRSAM.isSelected()) {
                        VersionPanel.this.timecourseCB.setSelected(false);
                        SAMInitDialog.this.setTimeCourse(false);
                    }
                    VersionPanel.this.timecourseCB.setEnabled(VersionPanel.this.useRSAM.isSelected());
                }
            });
            SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 0);
            constraints.anchor = 10;
            gridbag.setConstraints(this.useRSAM, constraints);
            this.add(this.useRSAM);
            this.timecourseCB = new JCheckBox("Time-Course Data");
            this.timecourseCB.setBackground(Color.white);
            this.timecourseCB.setSelected(false);
            this.timecourseCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SAMInitDialog.this.setTimeCourse(VersionPanel.this.timecourseCB.isSelected());
                }
            });
            SAMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            constraints.anchor = 10;
            gridbag.setConstraints(this.timecourseCB, constraints);
            this.add(this.timecourseCB);
        }

        public void reset() {
        }
    }

    class MultiClassPanel
    extends JPanel {
        NumGroupsPanel ngPanel;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        JTabbedPane multiClassTab;
        MultiGroupExperimentsPanel mulgPanel;
        int numGroups;

        public MultiClassPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            this.ngPanel = new NumGroupsPanel();
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            this.ngPanel.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MultiClassPanel.this.ngPanel.okPressed = true;
                    try {
                        MultiClassPanel.this.numGroups = Integer.parseInt(MultiClassPanel.this.ngPanel.numGroupsField.getText());
                        if (MultiClassPanel.this.numGroups <= 2) {
                            JOptionPane.showMessageDialog(null, "Please enter a positive integer > 2!", "Error", 0);
                        } else {
                            MultiClassPanel.this.multiClassTab = new JTabbedPane();
                            MultiClassPanel.this.mulgPanel = new MultiGroupExperimentsPanel(SAMInitDialog.this.exptNames, MultiClassPanel.this.numGroups);
                            MultiClassPanel.this.remove(MultiClassPanel.this.dummyPanel);
                            MultiClassPanel.this.multiClassTab.add("Button Selection", MultiClassPanel.this.mulgPanel);
                            SAMInitDialog.this.multiClassSelector = new ClusterSelector(SAMInitDialog.this.repository, MultiClassPanel.this.numGroups);
                            SAMInitDialog.this.buildConstraints(MultiClassPanel.this.constraints, 0, 1, 1, 1, 0, 90);
                            MultiClassPanel.this.constraints.fill = 1;
                            MultiClassPanel.this.gridbag.setConstraints(MultiClassPanel.this.multiClassTab, MultiClassPanel.this.constraints);
                            MultiClassPanel.this.multiClassTab.add("Cluster Selection", (Component)SAMInitDialog.this.multiClassSelector);
                            MultiClassPanel.this.multiClassTab.setSelectedIndex(1);
                            if (SAMInitDialog.this.repository == null || SAMInitDialog.this.repository.isEmpty()) {
                                MultiClassPanel.this.multiClassTab.setSelectedIndex(0);
                            }
                            MultiClassPanel.this.add(MultiClassPanel.this.multiClassTab);
                            MultiClassPanel.this.validate();
                            MultiClassPanel.this.ngPanel.okButton.setEnabled(false);
                            MultiClassPanel.this.ngPanel.numGroupsField.setEnabled(false);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(null, "Please enter a positive integer >= 2!", "Error", 0);
                    }
                }
            });
            this.add(this.ngPanel);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 90);
            this.dummyPanel = new JPanel();
            this.dummyPanel.setBackground(Color.white);
            this.gridbag.setConstraints(this.dummyPanel, this.constraints);
            this.add(this.dummyPanel);
        }

        private void reset() {
            this.mulgPanel.reset();
        }

        class MultiGroupExperimentsPanel
        extends JPanel {
            JLabel[] expLabels;
            JRadioButton[][] exptGroupRadioButtons;
            JRadioButton[] notInGroupRadioButtons;
            int numPanels = 0;
            JLabel lotsOfSamplesWarningLabel;

            MultiGroupExperimentsPanel(Vector<String> exptNames, int numGroups) {
                int i;
                this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments"));
                this.setBackground(Color.white);
                this.expLabels = new JLabel[exptNames.size()];
                this.exptGroupRadioButtons = new JRadioButton[numGroups][exptNames.size()];
                this.notInGroupRadioButtons = new JRadioButton[exptNames.size()];
                ButtonGroup[] chooseGroup = new ButtonGroup[exptNames.size()];
                GridBagLayout gridbag = new GridBagLayout();
                GridBagLayout gridbag2 = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag2);
                this.numPanels = exptNames.size() / 512 + 1;
                JPanel[] panels = new JPanel[this.numPanels];
                int currPanel = 0;
                for (i = 0; i < panels.length; ++i) {
                    panels[i] = new JPanel(gridbag);
                }
                for (i = 0; i < exptNames.size(); ++i) {
                    int j;
                    String s1 = exptNames.get(i);
                    this.expLabels[i] = new JLabel(s1);
                    chooseGroup[i] = new ButtonGroup();
                    for (j = 0; j < numGroups; ++j) {
                        this.exptGroupRadioButtons[j][i] = new JRadioButton("Group " + (j + 1) + "     ", j == 0);
                        chooseGroup[i].add(this.exptGroupRadioButtons[j][i]);
                    }
                    currPanel = i / 512;
                    this.notInGroupRadioButtons[i] = new JRadioButton("Not in groups", false);
                    chooseGroup[i].add(this.notInGroupRadioButtons[i]);
                    for (j = 0; j < numGroups; ++j) {
                        SAMInitDialog.this.buildConstraints(constraints, j, i % 512, 1, 1, 100, 100);
                        gridbag.setConstraints(this.exptGroupRadioButtons[j][i], constraints);
                        panels[currPanel].add(this.exptGroupRadioButtons[j][i]);
                    }
                    SAMInitDialog.this.buildConstraints(constraints, numGroups + 1, i % 512, 1, 1, 100, 100);
                    gridbag.setConstraints(this.notInGroupRadioButtons[i], constraints);
                    panels[currPanel].add(this.notInGroupRadioButtons[i]);
                }
                int maxLabelWidth = 0;
                for (int j = 0; j < this.expLabels.length; ++j) {
                    if (!(this.expLabels[j].getPreferredSize().getWidth() > (double)maxLabelWidth)) continue;
                    maxLabelWidth = (int)Math.ceil(this.expLabels[j].getPreferredSize().getWidth());
                }
                JPanel bigPanel = new JPanel(new GridBagLayout());
                for (int m = 0; m < this.numPanels; ++m) {
                    bigPanel.add((Component)panels[m], new GridBagConstraints(0, m, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                JScrollPane scroll = new JScrollPane(bigPanel);
                scroll.setVerticalScrollBarPolicy(22);
                scroll.getHorizontalScrollBar().setUnitIncrement(20);
                scroll.getVerticalScrollBar().setUnitIncrement(20);
                JPanel[] exptNameHeaderPanels = new JPanel[this.numPanels];
                GridBagLayout exptHeaderGridbag = new GridBagLayout();
                for (int i2 = 0; i2 < exptNameHeaderPanels.length; ++i2) {
                    exptNameHeaderPanels[i2] = new JPanel();
                    exptNameHeaderPanels[i2].setSize(50, panels[i2].getPreferredSize().height);
                    exptNameHeaderPanels[i2].setPreferredSize(new Dimension(maxLabelWidth + 10, panels[i2].getPreferredSize().height));
                    exptNameHeaderPanels[i2].setLayout(exptHeaderGridbag);
                }
                for (int m = 0; m < this.expLabels.length; ++m) {
                    currPanel = m / 512;
                    SAMInitDialog.this.buildConstraints(constraints, 0, m % 512, 1, 1, 100, 100);
                    constraints.fill = 1;
                    exptHeaderGridbag.setConstraints(this.expLabels[m], constraints);
                    exptNameHeaderPanels[currPanel].add(this.expLabels[m]);
                }
                JPanel headerPanel = new JPanel(new GridBagLayout());
                for (int k = 0; k < exptNameHeaderPanels.length; ++k) {
                    headerPanel.add((Component)exptNameHeaderPanels[k], new GridBagConstraints(0, k, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                scroll.setRowHeaderView(headerPanel);
                SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
                constraints.fill = 1;
                gridbag2.setConstraints(scroll, constraints);
                this.add(scroll);
                JLabel label1 = new JLabel("Note: Each group MUST each contain more than one sample.");
                label1.setHorizontalAlignment(0);
                SAMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 5);
                constraints.anchor = 13;
                gridbag2.setConstraints(label1, constraints);
                this.add(label1);
                if (SAMInitDialog.this.lotsOfSamples) {
                    this.lotsOfSamplesWarningLabel = new JLabel(SAMInitDialog.this.lotsOfSamplesWarningText);
                    this.lotsOfSamplesWarningLabel.setBackground(Color.gray);
                    this.add((Component)this.lotsOfSamplesWarningLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                JPanel panel2 = new JPanel();
                GridBagLayout gridbag3 = new GridBagLayout();
                panel2.setLayout(gridbag3);
                panel2.setBackground(Color.white);
                JButton saveButton = new JButton("  Save settings  ");
                saveButton.setFocusPainted(false);
                saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton loadButton = new JButton("  Load settings  ");
                loadButton.setFocusPainted(false);
                loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton resetButton = new JButton("  Reset  ");
                resetButton.setFocusPainted(false);
                resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                final int finNum = exptNames.size();
                resetButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        for (int i = 0; i < finNum; ++i) {
                            MultiGroupExperimentsPanel.this.exptGroupRadioButtons[0][i].setSelected(true);
                        }
                    }
                });
                JFileChooser fc = new JFileChooser(TMEV.getDataPath());
                saveButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MultiGroupExperimentsPanel.this.saveAssignments();
                    }
                });
                loadButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MultiGroupExperimentsPanel.this.loadAssignments();
                    }
                });
                constraints.anchor = 10;
                constraints.fill = 0;
                constraints.insets = new Insets(5, 5, 5, 5);
                SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 100);
                gridbag3.setConstraints(saveButton, constraints);
                panel2.add(saveButton);
                SAMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
                gridbag3.setConstraints(loadButton, constraints);
                panel2.add(loadButton);
                SAMInitDialog.this.buildConstraints(constraints, 2, 0, 1, 1, 34, 0);
                gridbag3.setConstraints(resetButton, constraints);
                panel2.add(resetButton);
                constraints.insets = new Insets(0, 0, 0, 0);
                SAMInitDialog.this.buildConstraints(constraints, 0, 3, 1, 1, 0, 5);
                constraints.anchor = 10;
                gridbag2.setConstraints(panel2, constraints);
                this.add(panel2);
            }

            private void saveAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showSaveDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        PrintWriter pw = new PrintWriter(new FileWriter(file));
                        Date currDate = new Date(System.currentTimeMillis());
                        String dateString = currDate.toString();
                        String userName = System.getProperty("user.name");
                        pw.println("# Assignment File");
                        pw.println("# User: " + userName + " Save Date: " + dateString);
                        pw.println("#");
                        pw.print("Module:\t");
                        pw.println("SAM: Multi-Class");
                        for (int i = 0; i < MultiClassPanel.this.numGroups; ++i) {
                            pw.print("Group " + (i + 1) + " Label:\t");
                            pw.println("Group " + (i + 1));
                        }
                        pw.println("#");
                        pw.println("Sample Index\tSample Name\tGroup Assignment");
                        int[] groupAssgn = SAMInitDialog.this.getGroupAssignments();
                        for (int sample = 0; sample < SAMInitDialog.this.exptNames.size(); ++sample) {
                            pw.print(String.valueOf(sample + 1) + "\t");
                            pw.print(SAMInitDialog.this.exptNames.get(sample) + "\t");
                            if (groupAssgn[sample] != 0) {
                                pw.println("Group " + groupAssgn[sample]);
                                continue;
                            }
                            pw.println("Exclude");
                        }
                        pw.flush();
                        pw.close();
                    }
                    catch (FileNotFoundException fnfe) {
                        fnfe.printStackTrace();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }

            private void loadAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showOpenDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new FileReader(file));
                        Vector<String> data = new Vector<String>();
                        while ((line = br.readLine()) != null) {
                            data.add(line.trim());
                        }
                        br.close();
                        Vector<String> groupNames = new Vector<String>();
                        Vector<Integer> sampleIndices = new Vector<Integer>();
                        Vector<String> sampleNames = new Vector<String>();
                        Vector<String> groupAssignments = new Vector<String>();
                        for (int row = 0; row < data.size(); ++row) {
                            line = (String)data.get(row);
                            if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                            String[] lineArray = line.split("\t");
                            if (lineArray[0].startsWith("Module:")) {
                                if (lineArray[1].equals("SAM: Multi-Class")) continue;
                                Object[] optionst = new Object[]{"Continue", "Cancel"};
                                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                                return;
                            }
                            if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                                groupNames.add(lineArray[1]);
                                continue;
                            }
                            try {
                                Integer.parseInt(lineArray[0]);
                            }
                            catch (NumberFormatException nfe) {
                                continue;
                            }
                            sampleIndices.add(new Integer(lineArray[0]));
                            sampleNames.add(lineArray[1]);
                            groupAssignments.add(lineArray[2]);
                        }
                        if (SAMInitDialog.this.exptNames.size() != sampleNames.size()) {
                            JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + SAMInitDialog.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                            return;
                        }
                        Vector<String> currSampleVector = new Vector<String>();
                        for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                            currSampleVector.add(SAMInitDialog.this.exptNames.get(i));
                        }
                        int fileSampleIndex = 0;
                        int groupIndex = 0;
                        for (int sample = 0; sample < SAMInitDialog.this.exptNames.size(); ++sample) {
                            boolean doIndex = false;
                            for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                                if (i == sample || !SAMInitDialog.this.exptNames.get(i).equals(SAMInitDialog.this.exptNames.get(sample))) continue;
                                doIndex = true;
                            }
                            fileSampleIndex = sampleNames.indexOf(SAMInitDialog.this.exptNames.get(sample));
                            if (fileSampleIndex == -1) {
                                doIndex = true;
                            }
                            if (doIndex) {
                                this.setStateBasedOnIndex(groupAssignments, groupNames);
                                break;
                            }
                            String groupName = (String)groupAssignments.get(fileSampleIndex);
                            groupIndex = groupNames.indexOf(groupName);
                            try {
                                this.exptGroupRadioButtons[groupIndex][sample].setSelected(true);
                                continue;
                            }
                            catch (Exception e) {
                                this.notInGroupRadioButtons[sample].setSelected(true);
                            }
                        }
                        this.repaint();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                    }
                }
            }

            private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
                Object[] optionst = new Object[]{"Continue", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                    return;
                }
                for (int sample = 0; sample < SAMInitDialog.this.exptNames.size(); ++sample) {
                    try {
                        this.exptGroupRadioButtons[groupNames.indexOf(groupAssignments.get(sample))][sample].setSelected(true);
                        continue;
                    }
                    catch (Exception e) {
                        this.notInGroupRadioButtons[sample].setSelected(true);
                    }
                }
            }

            private void reset() {
                for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                    this.exptGroupRadioButtons[0][i].setSelected(true);
                }
            }
        }

        class NumGroupsPanel
        extends JPanel {
            JTextField numGroupsField;
            JButton okButton;
            boolean okPressed = false;

            public NumGroupsPanel() {
                this.setBackground(Color.white);
                GridBagLayout gridbag = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag);
                JLabel numGroupsLabel = new JLabel("Number of groups ");
                SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(numGroupsLabel, constraints);
                this.add(numGroupsLabel);
                this.numGroupsField = new JTextField("", 7);
                constraints.anchor = 17;
                SAMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 30, 0);
                gridbag.setConstraints(this.numGroupsField, constraints);
                this.add(this.numGroupsField);
                this.okButton = new JButton("OK");
                SAMInitDialog.this.buildConstraints(constraints, 2, 0, 1, 1, 40, 0);
                gridbag.setConstraints(this.okButton, constraints);
                this.add(this.okButton);
            }

            @Override
            public void setVisible(boolean visible) {
                this.setLocation((MultiClassPanel.this.getWidth() - this.getSize().width) / 2, (MultiClassPanel.this.getHeight() - this.getSize().height) / 2);
                super.setVisible(visible);
                if (visible) {
                    // empty if block
                }
            }

            public boolean isOkPressed() {
                return this.okPressed;
            }
        }
    }

    class TwoClassPairedPanel
    extends JPanel {
        ExperimentButton[] exptButtons;
        GridBagConstraints constraints;
        GridBagLayout gridbag;
        JTextField currentATextField;
        JTextField currentBTextField;
        JButton removeCurrentAButton;
        JButton removeCurrentBButton;
        JButton loadABPairButton;
        JButton removeABPairButton;
        PairedExperimentsPanel pairPanel;
        JList pairedExptsList;
        DefaultListModel pairedListModel;
        boolean currentAFilled;
        boolean currentBFilled;
        int currentAExpt = -1;
        int currentBExpt = -1;
        Vector<Integer> pairedAExpts;
        Vector<Integer> pairedBExpts;

        public TwoClassPairedPanel() {
            int numPanels = 0;
            this.currentAFilled = false;
            this.currentBFilled = false;
            this.pairedAExpts = new Vector();
            this.pairedBExpts = new Vector();
            this.constraints = new GridBagConstraints();
            this.gridbag = new GridBagLayout();
            this.setLayout(this.gridbag);
            this.pairedListModel = new DefaultListModel();
            this.pairedExptsList = new JList(this.pairedListModel);
            this.exptButtons = new ExperimentButton[SAMInitDialog.this.exptNames.size()];
            numPanels = SAMInitDialog.this.exptNames.size() / 512 + 1;
            JPanel[] panels = new JPanel[numPanels];
            int currPanel = 0;
            for (int i = 0; i < panels.length; ++i) {
                panels[i] = new JPanel(this.gridbag);
            }
            int maxWidth = 0;
            int i = 0;
            int maxNameLength = 0;
            for (i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                String s;
                int currentNameLength;
                this.exptButtons[i] = new ExperimentButton(i);
                if (this.exptButtons[i].getPreferredSize().getWidth() > (double)maxWidth) {
                    maxWidth = (int)Math.ceil(this.exptButtons[i].getPreferredSize().getWidth());
                }
                if ((currentNameLength = (s = SAMInitDialog.this.exptNames.get(i)).length()) > maxNameLength) {
                    maxNameLength = currentNameLength;
                }
                currPanel = i / 512;
                SAMInitDialog.this.buildConstraints(this.constraints, 0, i % 512, 1, 1, 100, 100);
                this.gridbag.setConstraints(this.exptButtons[i], this.constraints);
                panels[currPanel].add(this.exptButtons[i]);
            }
            this.currentATextField = new JTextField("", maxNameLength + 2);
            this.currentBTextField = new JTextField("", maxNameLength + 2);
            this.currentATextField.setBackground(Color.white);
            this.currentBTextField.setBackground(Color.white);
            this.currentATextField.setEditable(false);
            this.currentBTextField.setEditable(false);
            JPanel bigPanel = new JPanel(new GridBagLayout());
            for (int m = 0; m < numPanels; ++m) {
                bigPanel.add((Component)panels[m], new GridBagConstraints(0, m, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JScrollPane scroll = new JScrollPane(bigPanel);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.getHorizontalScrollBar().setUnitIncrement(20);
            scroll.getVerticalScrollBar().setUnitIncrement(20);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 40, 100);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(scroll, this.constraints);
            this.add(scroll);
            this.constraints.fill = 0;
            JPanel currentSelectionPanel = new JPanel();
            GridBagLayout grid2 = new GridBagLayout();
            currentSelectionPanel.setLayout(grid2);
            this.removeCurrentAButton = new JButton("< Remove A");
            this.removeCurrentBButton = new JButton("< Remove B");
            this.loadABPairButton = new JButton("   Load Pair >>   ");
            this.removeABPairButton = new JButton("<< Remove Pair");
            this.removeCurrentAButton.setEnabled(false);
            this.removeCurrentBButton.setEnabled(false);
            this.loadABPairButton.setEnabled(false);
            this.removeABPairButton.setEnabled(false);
            this.removeCurrentAButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TwoClassPairedPanel.this.exptButtons[TwoClassPairedPanel.this.currentAExpt].setEnabled(true);
                    TwoClassPairedPanel.this.currentAExpt = -1;
                    TwoClassPairedPanel.this.currentATextField.setText("");
                    TwoClassPairedPanel.this.currentAFilled = false;
                    TwoClassPairedPanel.this.removeCurrentAButton.setEnabled(false);
                    TwoClassPairedPanel.this.loadABPairButton.setEnabled(false);
                }
            });
            this.removeCurrentBButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TwoClassPairedPanel.this.exptButtons[TwoClassPairedPanel.this.currentBExpt].setEnabled(true);
                    TwoClassPairedPanel.this.currentBExpt = -1;
                    TwoClassPairedPanel.this.currentBTextField.setText("");
                    TwoClassPairedPanel.this.currentBFilled = false;
                    TwoClassPairedPanel.this.removeCurrentBButton.setEnabled(false);
                    TwoClassPairedPanel.this.loadABPairButton.setEnabled(false);
                }
            });
            this.loadABPairButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String currentPair = "A: " + SAMInitDialog.this.exptNames.get(TwoClassPairedPanel.this.currentAExpt) + " - B: " + SAMInitDialog.this.exptNames.get(TwoClassPairedPanel.this.currentBExpt);
                    TwoClassPairedPanel.this.pairedListModel.addElement(currentPair);
                    TwoClassPairedPanel.this.pairedAExpts.add(new Integer(TwoClassPairedPanel.this.currentAExpt));
                    TwoClassPairedPanel.this.pairedBExpts.add(new Integer(TwoClassPairedPanel.this.currentBExpt));
                    TwoClassPairedPanel.this.currentAExpt = -1;
                    TwoClassPairedPanel.this.currentBExpt = -1;
                    TwoClassPairedPanel.this.currentATextField.setText("");
                    TwoClassPairedPanel.this.currentBTextField.setText("");
                    TwoClassPairedPanel.this.currentAFilled = false;
                    TwoClassPairedPanel.this.currentBFilled = false;
                    TwoClassPairedPanel.this.removeCurrentAButton.setEnabled(false);
                    TwoClassPairedPanel.this.removeCurrentBButton.setEnabled(false);
                    TwoClassPairedPanel.this.loadABPairButton.setEnabled(false);
                    TwoClassPairedPanel.this.removeABPairButton.setEnabled(true);
                    TwoClassPairedPanel.this.pairedExptsList.setSelectedIndex(TwoClassPairedPanel.this.pairedListModel.size() - 1);
                }
            });
            this.removeABPairButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int index = TwoClassPairedPanel.this.pairedExptsList.getSelectedIndex();
                    TwoClassPairedPanel.this.pairedListModel.removeElementAt(index);
                    int removedAIndex = TwoClassPairedPanel.this.pairedAExpts.remove(index);
                    int removedBIndex = TwoClassPairedPanel.this.pairedBExpts.remove(index);
                    TwoClassPairedPanel.this.exptButtons[removedAIndex].setEnabled(true);
                    TwoClassPairedPanel.this.exptButtons[removedBIndex].setEnabled(true);
                    if (TwoClassPairedPanel.this.pairedListModel.isEmpty()) {
                        TwoClassPairedPanel.this.removeABPairButton.setEnabled(false);
                    } else {
                        TwoClassPairedPanel.this.pairedExptsList.setSelectedIndex(TwoClassPairedPanel.this.pairedListModel.size() - 1);
                    }
                }
            });
            JScrollPane currentAScroll = new JScrollPane(this.currentATextField);
            currentAScroll.setMinimumSize(new Dimension(90, 50));
            JScrollPane currentBScroll = new JScrollPane(this.currentBTextField);
            currentBScroll.setMinimumSize(new Dimension(90, 50));
            currentAScroll.setHorizontalScrollBarPolicy(32);
            currentAScroll.setVerticalScrollBarPolicy(21);
            currentAScroll.getHorizontalScrollBar().setUnitIncrement(20);
            currentAScroll.getVerticalScrollBar().setUnitIncrement(20);
            currentBScroll.setHorizontalScrollBarPolicy(32);
            currentBScroll.setVerticalScrollBarPolicy(21);
            currentBScroll.getHorizontalScrollBar().setUnitIncrement(20);
            currentBScroll.getVerticalScrollBar().setUnitIncrement(20);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 20, 50);
            grid2.setConstraints(this.removeCurrentAButton, this.constraints);
            currentSelectionPanel.add(this.removeCurrentAButton);
            JLabel aLabel = new JLabel(" Current A: ");
            SAMInitDialog.this.buildConstraints(this.constraints, 1, 0, 1, 1, 20, 0);
            grid2.setConstraints(aLabel, this.constraints);
            currentSelectionPanel.add(aLabel);
            SAMInitDialog.this.buildConstraints(this.constraints, 2, 0, 1, 1, 60, 0);
            this.constraints.fill = 1;
            grid2.setConstraints(currentAScroll, this.constraints);
            currentSelectionPanel.add(currentAScroll);
            this.constraints.fill = 0;
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 20, 50);
            grid2.setConstraints(this.removeCurrentBButton, this.constraints);
            currentSelectionPanel.add(this.removeCurrentBButton);
            JLabel bLabel = new JLabel("Current B: ");
            SAMInitDialog.this.buildConstraints(this.constraints, 1, 1, 1, 1, 20, 0);
            grid2.setConstraints(bLabel, this.constraints);
            currentSelectionPanel.add(bLabel);
            SAMInitDialog.this.buildConstraints(this.constraints, 2, 1, 1, 1, 60, 0);
            this.constraints.fill = 1;
            grid2.setConstraints(currentBScroll, this.constraints);
            currentSelectionPanel.add(currentBScroll);
            this.constraints.fill = 0;
            SAMInitDialog.this.buildConstraints(this.constraints, 1, 0, 1, 1, 10, 0);
            this.gridbag.setConstraints(currentSelectionPanel, this.constraints);
            this.add(currentSelectionPanel);
            this.constraints.fill = 0;
            JPanel pairButtonsPanel = new JPanel();
            GridBagLayout grid3 = new GridBagLayout();
            pairButtonsPanel.setLayout(grid3);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 50);
            grid3.setConstraints(this.loadABPairButton, this.constraints);
            pairButtonsPanel.add(this.loadABPairButton);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 50);
            grid3.setConstraints(this.removeABPairButton, this.constraints);
            pairButtonsPanel.add(this.removeABPairButton);
            SAMInitDialog.this.buildConstraints(this.constraints, 2, 0, 1, 1, 5, 0);
            this.gridbag.setConstraints(pairButtonsPanel, this.constraints);
            this.add(pairButtonsPanel);
            SAMInitDialog.this.buildConstraints(this.constraints, 3, 0, 1, 1, 45, 0);
            this.constraints.fill = 1;
            JScrollPane pairScroll = new JScrollPane(this.pairedExptsList);
            pairScroll.setBorder(new TitledBorder("Paired Samples"));
            this.gridbag.setConstraints(pairScroll, this.constraints);
            this.add(pairScroll);
        }

        public void reset() {
            for (int i = 0; i < this.exptButtons.length; ++i) {
                this.exptButtons[i].setEnabled(true);
                this.currentATextField.setText("");
                this.currentBTextField.setText("");
                this.removeCurrentAButton.setEnabled(false);
                this.removeCurrentBButton.setEnabled(false);
                this.loadABPairButton.setEnabled(false);
                this.removeABPairButton.setEnabled(false);
                this.pairedListModel.clear();
                this.currentAFilled = false;
                this.currentBFilled = false;
                this.currentAExpt = -1;
                this.currentBExpt = -1;
                this.pairedAExpts.clear();
                this.pairedBExpts.clear();
            }
        }

        class PairedExperimentsPanel
        extends JPanel {
        }

        class ExperimentButton
        extends JButton {
            String s;
            int index;

            public ExperimentButton(int i) {
                this.index = i;
                this.s = SAMInitDialog.this.exptNames.get(i);
                this.setText(this.s);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (TwoClassPairedPanel.this.currentAFilled && TwoClassPairedPanel.this.currentBFilled) {
                            JOptionPane.showMessageDialog(null, "Clear at least one current field first!", "Error", 0);
                        } else if (!TwoClassPairedPanel.this.currentAFilled) {
                            TwoClassPairedPanel.this.currentAExpt = ExperimentButton.this.index;
                            TwoClassPairedPanel.this.currentATextField.setText(ExperimentButton.this.s);
                            TwoClassPairedPanel.this.currentAFilled = true;
                            ExperimentButton.this.setEnabled(false);
                            TwoClassPairedPanel.this.removeCurrentAButton.setEnabled(true);
                        } else if (!TwoClassPairedPanel.this.currentBFilled) {
                            TwoClassPairedPanel.this.currentBExpt = ExperimentButton.this.index;
                            TwoClassPairedPanel.this.currentBTextField.setText(ExperimentButton.this.s);
                            TwoClassPairedPanel.this.currentBFilled = true;
                            ExperimentButton.this.setEnabled(false);
                            TwoClassPairedPanel.this.removeCurrentBButton.setEnabled(true);
                        }
                        if (TwoClassPairedPanel.this.currentAFilled && TwoClassPairedPanel.this.currentBFilled) {
                            TwoClassPairedPanel.this.loadABPairButton.setEnabled(true);
                        } else {
                            TwoClassPairedPanel.this.loadABPairButton.setEnabled(false);
                        }
                    }
                });
            }
        }
    }

    class TwoClassPairedMainPanel
    extends JPanel {
        TwoClassPairedPanel tcpPanel;
        JButton saveButton;
        JButton resetButton;
        JButton loadButton;
        GridBagConstraints constraints;
        GridBagLayout gridbag;
        int dummy = 0;
        JLabel lotsOfSamplesWarningLabel;

        public TwoClassPairedMainPanel() {
            this.tcpPanel = new TwoClassPairedPanel();
            JPanel bottomPanel = new JPanel();
            bottomPanel.setBackground(Color.white);
            this.constraints = new GridBagConstraints();
            this.gridbag = new GridBagLayout();
            this.setLayout(this.gridbag);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 90);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.tcpPanel, this.constraints);
            this.add(this.tcpPanel);
            if (SAMInitDialog.this.lotsOfSamples) {
                this.lotsOfSamplesWarningLabel = new JLabel(SAMInitDialog.this.lotsOfSamplesWarningText);
                this.lotsOfSamplesWarningLabel.setBackground(Color.gray);
                this.add((Component)this.lotsOfSamplesWarningLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            GridBagLayout grid1 = new GridBagLayout();
            bottomPanel.setLayout(grid1);
            this.saveButton = new JButton("Save pairings");
            final JFileChooser fc = new JFileChooser(TMEV.getDataPath());
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int returnVal = fc.showSaveDialog(TwoClassPairedMainPanel.this);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        try {
                            PrintWriter out = new PrintWriter(new FileOutputStream(file));
                            for (int i = 0; i < TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.size(); ++i) {
                                int currentA = TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.get(i);
                                int currentB = TwoClassPairedMainPanel.this.tcpPanel.pairedBExpts.get(i);
                                out.print(currentA);
                                out.print("\t");
                                out.print(currentB);
                                out.print("\t");
                                out.println();
                            }
                            out.flush();
                            out.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            });
            this.constraints.fill = 0;
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 33, 100);
            grid1.setConstraints(this.saveButton, this.constraints);
            bottomPanel.add(this.saveButton);
            this.loadButton = new JButton("Load pairings");
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TwoClassPairedMainPanel.this.tcpPanel.reset();
                    int returnVal = fc.showOpenDialog(TwoClassPairedMainPanel.this);
                    if (returnVal == 0) {
                        try {
                            String currentLine;
                            FileReader file = new FileReader(fc.getSelectedFile());
                            BufferedReader buff = new BufferedReader(file);
                            while ((currentLine = buff.readLine()) != null) {
                                StringSplitter st = new StringSplitter('\t');
                                st.init(currentLine);
                                for (int i = 0; i < 2; ++i) {
                                    String s = st.nextToken();
                                    if (i == 0) {
                                        TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.add(new Integer(s));
                                        continue;
                                    }
                                    if (i != 1) continue;
                                    TwoClassPairedMainPanel.this.tcpPanel.pairedBExpts.add(new Integer(s));
                                }
                            }
                            buff.close();
                            for (int i = 0; i < TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.size(); ++i) {
                                int currA = TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.get(i);
                                int currB = TwoClassPairedMainPanel.this.tcpPanel.pairedBExpts.get(i);
                                String currPair = "A: " + SAMInitDialog.this.exptNames.get(currA) + " - B: " + SAMInitDialog.this.exptNames.get(currB);
                                TwoClassPairedMainPanel.this.tcpPanel.pairedListModel.addElement(currPair);
                            }
                            if (TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.size() > 0) {
                                TwoClassPairedMainPanel.this.tcpPanel.removeABPairButton.setEnabled(true);
                                TwoClassPairedMainPanel.this.tcpPanel.pairedExptsList.setSelectedIndex(TwoClassPairedMainPanel.this.tcpPanel.pairedListModel.size() - 1);
                            }
                        }
                        catch (Exception exc) {
                            JOptionPane.showMessageDialog(TwoClassPairedMainPanel.this.tcpPanel, "Incompatible file!", "Error", 2);
                        }
                    }
                }
            });
            SAMInitDialog.this.buildConstraints(this.constraints, 1, 0, 1, 1, 33, 100);
            grid1.setConstraints(this.loadButton, this.constraints);
            bottomPanel.add(this.loadButton);
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TwoClassPairedMainPanel.this.tcpPanel.reset();
                }
            });
            SAMInitDialog.this.buildConstraints(this.constraints, 2, 0, 1, 1, 34, 100);
            grid1.setConstraints(this.resetButton, this.constraints);
            bottomPanel.add(this.resetButton);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 2, 1, 1, 0, 10);
            this.gridbag.setConstraints(bottomPanel, this.constraints);
            this.add(bottomPanel);
        }
    }

    class OneClassPanel
    extends JPanel {
        JTextField meanField;
        JCheckBox[] includeExpts;
        JCheckBox[] startCB;
        JCheckBox[] endCB;
        JTextField[] timefields;
        int numPanels = 0;
        JButton saveButton;
        JButton loadButton;
        JButton resetButton;
        JLabel lotsOfSamplesWarningLabel;

        OneClassPanel() {
            int i;
            this.setBackground(Color.white);
            JLabel meanLabel = new JLabel("Enter the mean value to be tested against: ");
            this.meanField = new JTextField("0", 7);
            this.includeExpts = new JCheckBox[SAMInitDialog.this.exptNames.size()];
            this.timefields = new JTextField[SAMInitDialog.this.exptNames.size()];
            this.startCB = new JCheckBox[SAMInitDialog.this.exptNames.size()];
            this.endCB = new JCheckBox[SAMInitDialog.this.exptNames.size()];
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.numPanels = SAMInitDialog.this.exptNames.size() / 512 + 1;
            JPanel[] panels = new JPanel[this.numPanels];
            int currPanel = 0;
            for (i = 0; i < panels.length; ++i) {
                panels[i] = new JPanel(gridbag);
            }
            for (i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                currPanel = i / 512;
                this.includeExpts[i] = new JCheckBox(SAMInitDialog.this.exptNames.get(i), true);
                SAMInitDialog.this.buildConstraints(constraints, 0, i % 512, 1, 1, 100, 100);
                gridbag.setConstraints(this.includeExpts[i], constraints);
                panels[currPanel].add(this.includeExpts[i]);
                this.timefields[i] = new JTextField("0.0");
                SAMInitDialog.this.buildConstraints(constraints, 1, i % 512, 1, 1, 100, 100);
                constraints.fill = 1;
                gridbag.setConstraints(this.timefields[i], constraints);
                this.timefields[i].setVisible(false);
                panels[currPanel].add(this.timefields[i]);
                constraints.fill = 0;
                this.startCB[i] = new JCheckBox("Start");
                SAMInitDialog.this.buildConstraints(constraints, 2, i % 512, 1, 1, 100, 100);
                gridbag.setConstraints(this.startCB[i], constraints);
                this.startCB[i].setVisible(false);
                panels[currPanel].add(this.startCB[i]);
                this.endCB[i] = new JCheckBox("End");
                SAMInitDialog.this.buildConstraints(constraints, 3, i % 512, 1, 1, 100, 100);
                gridbag.setConstraints(this.endCB[i], constraints);
                this.endCB[i].setVisible(false);
                panels[currPanel].add(this.endCB[i]);
                this.startCB[i].setActionCommand(String.valueOf(i));
                this.startCB[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (OneClassPanel.this.startCB[Integer.parseInt(evt.getActionCommand())].isSelected()) {
                            OneClassPanel.this.endCB[Integer.parseInt(evt.getActionCommand())].setSelected(false);
                        }
                    }
                });
                this.endCB[i].setActionCommand(String.valueOf(i));
                this.endCB[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (OneClassPanel.this.endCB[Integer.parseInt(evt.getActionCommand())].isSelected()) {
                            OneClassPanel.this.startCB[Integer.parseInt(evt.getActionCommand())].setSelected(false);
                        }
                    }
                });
            }
            JPanel bigPanel = new JPanel(new GridBagLayout());
            for (int i2 = 0; i2 < this.numPanels; ++i2) {
                bigPanel.add((Component)panels[i2], new GridBagConstraints(0, i2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JScrollPane scroll = new JScrollPane(bigPanel);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.getVerticalScrollBar().setUnitIncrement(20);
            JPanel enterMeanPanel = new JPanel();
            GridBagLayout grid2 = new GridBagLayout();
            enterMeanPanel.setLayout(grid2);
            constraints.fill = 0;
            SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
            constraints.anchor = 13;
            grid2.setConstraints(meanLabel, constraints);
            enterMeanPanel.add(meanLabel);
            SAMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid2.setConstraints(this.meanField, constraints);
            enterMeanPanel.add(this.meanField);
            JScrollPane scroll2 = new JScrollPane(enterMeanPanel);
            JSplitPane split = new JSplitPane(1, scroll, scroll2);
            split.setOneTouchExpandable(true);
            split.setDividerLocation(300);
            constraints.fill = 1;
            SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
            gridbag.setConstraints(split, constraints);
            this.add(split);
            if (SAMInitDialog.this.lotsOfSamples) {
                this.lotsOfSamplesWarningLabel = new JLabel(SAMInitDialog.this.lotsOfSamplesWarningText);
                this.lotsOfSamplesWarningLabel.setBackground(Color.gray);
                this.add((Component)this.lotsOfSamplesWarningLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            constraints.fill = 0;
            constraints.anchor = 10;
            JPanel lsrPanel = new JPanel();
            this.loadButton = new JButton("Load settings");
            this.saveButton = new JButton("Save settings");
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (int i = 0; i < OneClassPanel.this.includeExpts.length; ++i) {
                        OneClassPanel.this.includeExpts[i].setSelected(true);
                    }
                }
            });
            JFileChooser fc = new JFileChooser(TMEV.getDataPath());
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OneClassPanel.this.saveAssignments();
                }
            });
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OneClassPanel.this.loadAssignments();
                }
            });
            GridBagLayout grid3 = new GridBagLayout();
            lsrPanel.setLayout(grid3);
            SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 100);
            grid3.setConstraints(this.saveButton, constraints);
            lsrPanel.add(this.saveButton);
            SAMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
            grid3.setConstraints(this.loadButton, constraints);
            lsrPanel.add(this.loadButton);
            SAMInitDialog.this.buildConstraints(constraints, 2, 0, 1, 1, 33, 0);
            grid3.setConstraints(this.resetButton, constraints);
            lsrPanel.add(this.resetButton);
            SAMInitDialog.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 20);
            gridbag.setConstraints(lsrPanel, constraints);
            this.add(lsrPanel);
        }

        private void saveAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showSaveDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(file));
                    Date currDate = new Date(System.currentTimeMillis());
                    String dateString = currDate.toString();
                    String userName = System.getProperty("user.name");
                    pw.println("# Assignment File");
                    pw.println("# User: " + userName + " Save Date: " + dateString);
                    pw.println("#");
                    pw.print("Module:\t");
                    pw.println("SAM: One Class");
                    pw.print("Group 1 Label:\t");
                    pw.println("Include");
                    pw.println("#");
                    pw.println("Sample Index\tSample Name\tGroup Assignment");
                    for (int sample = 0; sample < SAMInitDialog.this.exptNames.size(); ++sample) {
                        pw.print(String.valueOf(sample + 1) + "\t");
                        pw.print(SAMInitDialog.this.exptNames.get(sample) + "\t");
                        if (this.includeExpts[sample].isSelected()) {
                            pw.println("Include");
                            continue;
                        }
                        pw.println("Exclude");
                    }
                    pw.flush();
                    pw.close();
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        private void loadAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showOpenDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    Vector<String> data = new Vector<String>();
                    while ((line = br.readLine()) != null) {
                        data.add(line.trim());
                    }
                    br.close();
                    Vector<String> groupNames = new Vector<String>();
                    Vector<Integer> sampleIndices = new Vector<Integer>();
                    Vector<String> sampleNames = new Vector<String>();
                    Vector<String> groupAssignments = new Vector<String>();
                    for (int row = 0; row < data.size(); ++row) {
                        line = (String)data.get(row);
                        if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                        String[] lineArray = line.split("\t");
                        if (lineArray[0].startsWith("Module:")) {
                            if (lineArray[1].equals("SAM: One Class")) continue;
                            Object[] optionst = new Object[]{"Continue", "Cancel"};
                            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                            return;
                        }
                        if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                            groupNames.add(lineArray[1]);
                            continue;
                        }
                        try {
                            Integer.parseInt(lineArray[0]);
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                        sampleIndices.add(new Integer(lineArray[0]));
                        sampleNames.add(lineArray[1]);
                        groupAssignments.add(lineArray[2]);
                    }
                    if (SAMInitDialog.this.exptNames.size() != sampleNames.size()) {
                        JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + SAMInitDialog.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                        return;
                    }
                    Vector<String> currSampleVector = new Vector<String>();
                    for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                        currSampleVector.add(SAMInitDialog.this.exptNames.get(i));
                    }
                    int fileSampleIndex = 0;
                    int groupIndex = 0;
                    for (int sample = 0; sample < SAMInitDialog.this.exptNames.size(); ++sample) {
                        boolean doIndex = false;
                        for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                            if (i == sample || !SAMInitDialog.this.exptNames.get(i).equals(SAMInitDialog.this.exptNames.get(sample))) continue;
                            doIndex = true;
                        }
                        fileSampleIndex = sampleNames.indexOf(SAMInitDialog.this.exptNames.get(sample));
                        if (fileSampleIndex == -1) {
                            doIndex = true;
                        }
                        if (doIndex) {
                            this.setStateBasedOnIndex(groupAssignments, groupNames);
                            break;
                        }
                        String groupName = (String)groupAssignments.get(fileSampleIndex);
                        groupIndex = groupNames.indexOf(groupName);
                        try {
                            if (groupIndex == 0) {
                                this.includeExpts[sample].setSelected(true);
                            }
                            if (groupIndex != 1 && groupIndex != -1) continue;
                            this.includeExpts[sample].setSelected(false);
                            continue;
                        }
                        catch (Exception e) {
                            this.includeExpts[sample].setSelected(false);
                        }
                    }
                    this.repaint();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                }
            }
        }

        private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
            Object[] optionst = new Object[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                return;
            }
            for (int sample = 0; sample < SAMInitDialog.this.exptNames.size(); ++sample) {
                try {
                    if (groupNames.indexOf(groupAssignments.get(sample)) == 0) {
                        this.includeExpts[sample].setSelected(true);
                    }
                    if (groupNames.indexOf(groupAssignments.get(sample)) != 1 && groupNames.indexOf(groupAssignments.get(sample)) != -1) continue;
                    this.includeExpts[sample].setSelected(false);
                    continue;
                }
                catch (Exception e) {
                    this.includeExpts[sample].setSelected(false);
                }
            }
        }

        public void reset() {
            for (int i = 0; i < this.includeExpts.length; ++i) {
                this.includeExpts[i].setSelected(true);
            }
            this.meanField.setText("0");
        }
    }

    class CensoredSurvivalPanel
    extends JPanel {
        ExptTimeField[] fields;
        int numPanels = 0;
        JLabel lotsOfSamplesWarningLabel;

        CensoredSurvivalPanel(Vector<String> exptNames) {
            int i;
            this.setBorder(new TitledBorder(new EtchedBorder(), "Time / State Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            this.fields = new ExptTimeField[exptNames.size()];
            this.numPanels = exptNames.size() / 512 + 1;
            GridBagLayout gridbag = new GridBagLayout();
            GridBagLayout gridbag2 = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag2);
            JPanel[] panels = new JPanel[this.numPanels];
            int currPanel = 0;
            for (i = 0; i < panels.length; ++i) {
                panels[i] = new JPanel(gridbag);
            }
            for (i = 0; i < exptNames.size(); ++i) {
                String s1 = exptNames.get(i);
                this.fields[i] = new ExptTimeField(s1);
                currPanel = i / 512;
                SAMInitDialog.this.buildConstraints(constraints, 0, i % 512, 1, 1, 20, 100);
                gridbag.setConstraints(this.fields[i].inAnalysisCheckBox, constraints);
                panels[currPanel].add(this.fields[i].inAnalysisCheckBox);
                SAMInitDialog.this.buildConstraints(constraints, 1, i % 512, 1, 1, 20, 100);
                gridbag.setConstraints(this.fields[i].expLabel, constraints);
                panels[currPanel].add(this.fields[i].expLabel);
                SAMInitDialog.this.buildConstraints(constraints, 2, i % 512, 1, 1, 20, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(this.fields[i].timeLabel, constraints);
                panels[currPanel].add(this.fields[i].timeLabel);
                SAMInitDialog.this.buildConstraints(constraints, 3, i % 512, 1, 1, 20, 100);
                constraints.anchor = 17;
                gridbag.setConstraints(this.fields[i].timeInputField, constraints);
                panels[currPanel].add(this.fields[i].timeInputField);
                constraints.anchor = 10;
                SAMInitDialog.this.buildConstraints(constraints, 4, i % 512, 1, 1, 20, 100);
                gridbag.setConstraints(this.fields[i].censoredRadioButton, constraints);
                panels[currPanel].add(this.fields[i].censoredRadioButton);
                SAMInitDialog.this.buildConstraints(constraints, 5, i % 512, 1, 1, 20, 100);
                gridbag.setConstraints(this.fields[i].deadRadioButton, constraints);
                panels[currPanel].add(this.fields[i].deadRadioButton);
            }
            JPanel bigPanel = new JPanel(new GridBagLayout());
            for (int i2 = 0; i2 < this.numPanels; ++i2) {
                bigPanel.add((Component)panels[i2], new GridBagConstraints(0, i2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JScrollPane scroll = new JScrollPane(bigPanel);
            scroll.setHorizontalScrollBarPolicy(32);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.getHorizontalScrollBar().setUnitIncrement(20);
            scroll.getVerticalScrollBar().setUnitIncrement(20);
            SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
            constraints.fill = 1;
            gridbag2.setConstraints(scroll, constraints);
            this.add(scroll);
            if (SAMInitDialog.this.lotsOfSamples) {
                this.lotsOfSamplesWarningLabel = new JLabel(SAMInitDialog.this.lotsOfSamplesWarningText);
                this.lotsOfSamplesWarningLabel.setBackground(Color.gray);
                this.add((Component)this.lotsOfSamplesWarningLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JPanel panel2 = new JPanel();
            GridBagLayout gridbag3 = new GridBagLayout();
            panel2.setLayout(gridbag3);
            panel2.setBackground(Color.white);
            JButton saveButton = new JButton("  Save settings  ");
            saveButton.setFocusPainted(false);
            saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton loadButton = new JButton("  Load settings  ");
            loadButton.setFocusPainted(false);
            loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton resetButton = new JButton("  Reset  ");
            resetButton.setFocusPainted(false);
            resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            final int finNum = exptNames.size();
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (int i = 0; i < finNum; ++i) {
                        CensoredSurvivalPanel.this.fields[i].inAnalysisCheckBox.setSelected(true);
                        CensoredSurvivalPanel.this.fields[i].timeInputField.setText("0.0");
                        CensoredSurvivalPanel.this.fields[i].censoredRadioButton.setSelected(true);
                    }
                }
            });
            final JFileChooser fc = new JFileChooser(TMEV.getDataPath());
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int returnVal = fc.showSaveDialog(CensoredSurvivalPanel.this);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        try {
                            PrintWriter out = new PrintWriter(new FileOutputStream(file));
                            for (int i = 0; i < finNum; ++i) {
                                if (CensoredSurvivalPanel.this.fields[i].inAnalysisCheckBox.isSelected()) {
                                    out.print(1);
                                    out.print("\t");
                                    if (CensoredSurvivalPanel.this.fields[i].timeInputField.getText() == "") {
                                        out.print("0.0");
                                    } else {
                                        out.print(CensoredSurvivalPanel.this.fields[i].timeInputField.getText());
                                    }
                                    out.print("\t");
                                    if (CensoredSurvivalPanel.this.fields[i].censoredRadioButton.isSelected()) {
                                        out.print(1);
                                    } else {
                                        out.print(0);
                                    }
                                } else {
                                    out.print(0);
                                }
                                out.println();
                            }
                            out.flush();
                            out.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            });
            loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int returnVal = fc.showOpenDialog(CensoredSurvivalPanel.this);
                    if (returnVal == 0) {
                        try {
                            String currentLine;
                            FileReader file = new FileReader(fc.getSelectedFile());
                            BufferedReader buff = new BufferedReader(file);
                            Vector<String> inputVector = new Vector<String>();
                            while ((currentLine = buff.readLine()) != null) {
                                inputVector.add(currentLine);
                            }
                            buff.close();
                            for (int i = 0; i < inputVector.size(); ++i) {
                                double[] currentSettings = CensoredSurvivalPanel.this.getCurrentSettings((String)inputVector.get(i));
                                if (currentSettings[0] == 0.0) {
                                    CensoredSurvivalPanel.this.fields[i].inAnalysisCheckBox.setSelected(false);
                                    continue;
                                }
                                if (currentSettings[0] == 1.0) {
                                    CensoredSurvivalPanel.this.fields[i].inAnalysisCheckBox.setSelected(true);
                                    CensoredSurvivalPanel.this.fields[i].timeInputField.setText("" + currentSettings[1]);
                                    if (currentSettings[2] == 0.0) {
                                        CensoredSurvivalPanel.this.fields[i].deadRadioButton.setSelected(true);
                                        continue;
                                    }
                                    if (currentSettings[2] == 1.0) {
                                        CensoredSurvivalPanel.this.fields[i].censoredRadioButton.setSelected(true);
                                        continue;
                                    }
                                    for (int k = 0; k < finNum; ++k) {
                                        CensoredSurvivalPanel.this.fields[k].inAnalysisCheckBox.setSelected(false);
                                    }
                                    JOptionPane.showMessageDialog(SAMInitDialog.this.gPanel, "Incompatible file!", "Error", 2);
                                } else {
                                    for (int k = 0; k < finNum; ++k) {
                                        CensoredSurvivalPanel.this.fields[k].inAnalysisCheckBox.setSelected(false);
                                    }
                                    JOptionPane.showMessageDialog(SAMInitDialog.this.gPanel, "Incompatible file!", "Error", 2);
                                }
                                break;
                            }
                        }
                        catch (Exception e) {
                            for (int k = 0; k < finNum; ++k) {
                                CensoredSurvivalPanel.this.fields[k].inAnalysisCheckBox.setSelected(false);
                            }
                            JOptionPane.showMessageDialog(SAMInitDialog.this.gPanel, "Incompatible file!", "Error", 2);
                        }
                    }
                }
            });
            constraints.anchor = 10;
            constraints.fill = 0;
            constraints.insets = new Insets(5, 5, 5, 5);
            SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 100);
            gridbag3.setConstraints(saveButton, constraints);
            panel2.add(saveButton);
            SAMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
            gridbag3.setConstraints(loadButton, constraints);
            panel2.add(loadButton);
            SAMInitDialog.this.buildConstraints(constraints, 2, 0, 1, 1, 34, 0);
            gridbag3.setConstraints(resetButton, constraints);
            panel2.add(resetButton);
            constraints.insets = new Insets(0, 0, 0, 0);
            SAMInitDialog.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 10);
            constraints.anchor = 10;
            gridbag2.setConstraints(panel2, constraints);
            this.add(panel2);
        }

        private void reset() {
            for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                this.fields[i].inAnalysisCheckBox.setSelected(true);
                this.fields[i].timeInputField.setText("0.0");
                this.fields[i].censoredRadioButton.setSelected(true);
            }
        }

        private double[] getCurrentSettings(String currentLine) {
            Vector<Double> currentVector = new Vector<Double>();
            StringSplitter st = new StringSplitter('\t');
            st.init(currentLine);
            while (st.hasMoreTokens()) {
                String current = st.nextToken();
                currentVector.add(new Double(current));
            }
            double[] currentSettings = new double[currentVector.size()];
            for (int i = 0; i < currentSettings.length; ++i) {
                currentSettings[i] = (Double)currentVector.get(i);
            }
            return currentSettings;
        }

        private class ExptTimeField {
            JCheckBox inAnalysisCheckBox = new JCheckBox("", true);
            JLabel expLabel;
            JLabel timeLabel;
            JTextField timeInputField;
            JRadioButton censoredRadioButton;
            JRadioButton deadRadioButton;

            public ExptTimeField(String exptName) {
                this.expLabel = new JLabel(exptName);
                this.timeLabel = new JLabel("Time: ");
                this.timeInputField = new JTextField("0.0", 7);
                this.censoredRadioButton = new JRadioButton("Censored", true);
                this.deadRadioButton = new JRadioButton("Dead", false);
                ButtonGroup chooseGroup = new ButtonGroup();
                chooseGroup.add(this.censoredRadioButton);
                chooseGroup.add(this.deadRadioButton);
                this.inAnalysisCheckBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 2) {
                            ExptTimeField.this.expLabel.setEnabled(false);
                            ExptTimeField.this.timeLabel.setEnabled(false);
                            ExptTimeField.this.timeInputField.setText("");
                            ExptTimeField.this.timeInputField.setBackground(Color.darkGray);
                            ExptTimeField.this.timeInputField.setEnabled(false);
                            ExptTimeField.this.censoredRadioButton.setEnabled(false);
                            ExptTimeField.this.deadRadioButton.setEnabled(false);
                        }
                        if (e.getStateChange() == 1) {
                            ExptTimeField.this.expLabel.setEnabled(true);
                            ExptTimeField.this.timeLabel.setEnabled(true);
                            ExptTimeField.this.timeInputField.setText("0.0");
                            ExptTimeField.this.timeInputField.setBackground(Color.white);
                            ExptTimeField.this.timeInputField.setEnabled(true);
                            ExptTimeField.this.censoredRadioButton.setEnabled(true);
                            ExptTimeField.this.deadRadioButton.setEnabled(true);
                        }
                    }
                });
            }
        }
    }

    class GroupExperimentsPanel
    extends JPanel {
        JLabel[] expLabels;
        int numPanels = 0;
        JTextField[] timeField;
        JCheckBox[] startCB;
        JCheckBox[] endCB;
        JRadioButton[] groupARadioButtons;
        JRadioButton[] groupBRadioButtons;
        JRadioButton[] neitherGroupRadioButtons;
        JLabel lotsOfSamplesWarningLabel;

        GroupExperimentsPanel(Vector<String> exptNames) {
            int i;
            this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            JPanel panel1 = new JPanel();
            this.expLabels = new JLabel[exptNames.size()];
            this.groupARadioButtons = new JRadioButton[exptNames.size()];
            this.groupBRadioButtons = new JRadioButton[exptNames.size()];
            this.neitherGroupRadioButtons = new JRadioButton[exptNames.size()];
            this.timeField = new JTextField[exptNames.size()];
            this.startCB = new JCheckBox[exptNames.size()];
            this.endCB = new JCheckBox[exptNames.size()];
            ButtonGroup[] chooseGroup = new ButtonGroup[exptNames.size()];
            GridBagLayout gridbag = new GridBagLayout();
            GridBagLayout gridbag2 = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag2);
            panel1.setLayout(gridbag);
            this.numPanels = exptNames.size() / 512 + 1;
            JPanel[] panels = new JPanel[this.numPanels];
            int currPanel = 0;
            for (i = 0; i < panels.length; ++i) {
                panels[i] = new JPanel(gridbag);
            }
            for (i = 0; i < exptNames.size(); ++i) {
                String s1 = exptNames.get(i);
                this.expLabels[i] = new JLabel(s1);
                chooseGroup[i] = new ButtonGroup();
                this.groupARadioButtons[i] = new JRadioButton("Group A", true);
                chooseGroup[i].add(this.groupARadioButtons[i]);
                this.groupBRadioButtons[i] = new JRadioButton("Group B", false);
                chooseGroup[i].add(this.groupBRadioButtons[i]);
                this.neitherGroupRadioButtons[i] = new JRadioButton("Neither group", false);
                chooseGroup[i].add(this.neitherGroupRadioButtons[i]);
                this.timeField[i] = new JTextField("0.0");
                this.timeField[i].setVisible(false);
                this.startCB[i] = new JCheckBox("Start");
                this.startCB[i].setVisible(false);
                this.endCB[i] = new JCheckBox("End");
                this.endCB[i].setVisible(false);
                this.startCB[i].setActionCommand(String.valueOf(i));
                this.startCB[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (GroupExperimentsPanel.this.startCB[Integer.parseInt(evt.getActionCommand())].isSelected()) {
                            GroupExperimentsPanel.this.endCB[Integer.parseInt(evt.getActionCommand())].setSelected(false);
                        }
                    }
                });
                this.endCB[i].setActionCommand(String.valueOf(i));
                this.endCB[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (GroupExperimentsPanel.this.endCB[Integer.parseInt(evt.getActionCommand())].isSelected()) {
                            GroupExperimentsPanel.this.startCB[Integer.parseInt(evt.getActionCommand())].setSelected(false);
                        }
                    }
                });
                currPanel = i / 512;
                SAMInitDialog.this.buildConstraints(constraints, 0, i % 512, 1, 1, 25, 100);
                gridbag.setConstraints(this.expLabels[i], constraints);
                panels[currPanel].add(this.expLabels[i]);
                SAMInitDialog.this.buildConstraints(constraints, 1, i % 512, 1, 1, 25, 100);
                gridbag.setConstraints(this.groupARadioButtons[i], constraints);
                panels[currPanel].add(this.groupARadioButtons[i]);
                SAMInitDialog.this.buildConstraints(constraints, 2, i % 512, 1, 1, 25, 100);
                gridbag.setConstraints(this.groupBRadioButtons[i], constraints);
                panels[currPanel].add(this.groupBRadioButtons[i]);
                SAMInitDialog.this.buildConstraints(constraints, 3, i % 512, 1, 1, 25, 100);
                gridbag.setConstraints(this.neitherGroupRadioButtons[i], constraints);
                panels[currPanel].add(this.neitherGroupRadioButtons[i]);
                SAMInitDialog.this.buildConstraints(constraints, 4, i % 512, 1, 1, 25, 100);
                constraints.fill = 1;
                gridbag.setConstraints(this.timeField[i], constraints);
                panels[currPanel].add(this.timeField[i]);
                constraints.fill = 0;
                SAMInitDialog.this.buildConstraints(constraints, 5, i % 512, 1, 1, 25, 100);
                constraints.fill = 1;
                gridbag.setConstraints(this.startCB[i], constraints);
                panels[currPanel].add(this.startCB[i]);
                constraints.fill = 0;
                SAMInitDialog.this.buildConstraints(constraints, 6, i % 512, 1, 1, 25, 100);
                constraints.fill = 1;
                gridbag.setConstraints(this.endCB[i], constraints);
                panels[currPanel].add(this.endCB[i]);
                constraints.fill = 0;
            }
            JPanel bigPanel = new JPanel(new GridBagLayout());
            for (int i2 = 0; i2 < this.numPanels; ++i2) {
                bigPanel.add((Component)panels[i2], new GridBagConstraints(0, i2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JScrollPane scroll = new JScrollPane(bigPanel);
            scroll.setHorizontalScrollBarPolicy(32);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.getHorizontalScrollBar().setUnitIncrement(20);
            scroll.getVerticalScrollBar().setUnitIncrement(20);
            SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
            constraints.fill = 1;
            gridbag2.setConstraints(scroll, constraints);
            this.add(scroll);
            JLabel label1 = new JLabel("Note: Group A and Group B  MUST each contain more than one sample.");
            label1.setHorizontalAlignment(0);
            SAMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 5);
            constraints.anchor = 10;
            constraints.fill = 1;
            gridbag2.setConstraints(label1, constraints);
            this.add(label1);
            if (SAMInitDialog.this.lotsOfSamples) {
                this.lotsOfSamplesWarningLabel = new JLabel(SAMInitDialog.this.lotsOfSamplesWarningText);
                this.lotsOfSamplesWarningLabel.setBackground(Color.gray);
                this.add((Component)this.lotsOfSamplesWarningLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JPanel panel2 = new JPanel();
            panel2.setBackground(Color.white);
            GridBagLayout gridbag3 = new GridBagLayout();
            panel2.setLayout(gridbag3);
            JButton saveButton = new JButton("  Save grouping  ");
            saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            saveButton.setSize(180, 30);
            saveButton.setPreferredSize(new Dimension(180, 30));
            JButton loadButton = new JButton("  Load grouping  ");
            loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            loadButton.setPreferredSize(new Dimension(180, 30));
            loadButton.setSize(180, 30);
            JButton resetButton = new JButton("  Reset  ");
            resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            resetButton.setSize(180, 30);
            resetButton.setPreferredSize(new Dimension(180, 30));
            final int finNum = exptNames.size();
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (int i = 0; i < finNum; ++i) {
                        GroupExperimentsPanel.this.groupARadioButtons[i].setSelected(true);
                    }
                }
            });
            JFileChooser fc = new JFileChooser(TMEV.getDataPath());
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GroupExperimentsPanel.this.saveAssignments();
                }
            });
            loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GroupExperimentsPanel.this.loadAssignments();
                }
            });
            constraints.anchor = 10;
            constraints.fill = 0;
            constraints.insets = new Insets(5, 5, 5, 5);
            SAMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 10);
            gridbag3.setConstraints(saveButton, constraints);
            panel2.add(saveButton);
            SAMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 10);
            gridbag3.setConstraints(loadButton, constraints);
            panel2.add(loadButton);
            SAMInitDialog.this.buildConstraints(constraints, 2, 0, 1, 1, 33, 10);
            gridbag3.setConstraints(resetButton, constraints);
            panel2.add(resetButton);
            constraints.insets = new Insets(0, 0, 0, 0);
            SAMInitDialog.this.buildConstraints(constraints, 0, 3, 1, 1, 0, 5);
            constraints.anchor = 10;
            gridbag2.setConstraints(panel2, constraints);
            this.add(panel2);
        }

        private void saveAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showSaveDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(file));
                    Date currDate = new Date(System.currentTimeMillis());
                    String dateString = currDate.toString();
                    String userName = System.getProperty("user.name");
                    pw.println("# Assignment File");
                    pw.println("# User: " + userName + " Save Date: " + dateString);
                    pw.println("#");
                    pw.print("Module:\t");
                    pw.println("SAM: Two-Class Unpaired");
                    pw.print("Group 1 Label:\t");
                    pw.println("1");
                    pw.print("Group 2 Label:\t");
                    pw.println("2");
                    pw.println("#");
                    pw.println("Sample Index\tSample Name\tGroup Assignment");
                    int[] groupAssgn = SAMInitDialog.this.getGroupAssignments();
                    for (int sample = 0; sample < SAMInitDialog.this.exptNames.size(); ++sample) {
                        pw.print(String.valueOf(sample + 1) + "\t");
                        pw.print(SAMInitDialog.this.exptNames.get(sample) + "\t");
                        if (groupAssgn[sample] != 3) {
                            pw.println(groupAssgn[sample]);
                            continue;
                        }
                        pw.println("Exclude");
                    }
                    pw.flush();
                    pw.close();
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        private void loadAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showOpenDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    Vector<String> data = new Vector<String>();
                    while ((line = br.readLine()) != null) {
                        data.add(line.trim());
                    }
                    br.close();
                    Vector<String> groupNames = new Vector<String>();
                    Vector<Integer> sampleIndices = new Vector<Integer>();
                    Vector<String> sampleNames = new Vector<String>();
                    Vector<String> groupAssignments = new Vector<String>();
                    for (int row = 0; row < data.size(); ++row) {
                        line = (String)data.get(row);
                        if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                        String[] lineArray = line.split("\t");
                        if (lineArray[0].startsWith("Module:")) {
                            if (lineArray[1].equals("SAM: Two-Class Unpaired")) continue;
                            Object[] optionst = new Object[]{"Continue", "Cancel"};
                            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                            return;
                        }
                        if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                            groupNames.add(lineArray[1]);
                            continue;
                        }
                        try {
                            Integer.parseInt(lineArray[0]);
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                        sampleIndices.add(new Integer(lineArray[0]));
                        sampleNames.add(lineArray[1]);
                        groupAssignments.add(lineArray[2]);
                    }
                    if (SAMInitDialog.this.exptNames.size() != sampleNames.size()) {
                        JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + SAMInitDialog.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                        return;
                    }
                    int fileSampleIndex = 0;
                    int groupIndex = 0;
                    for (int sample = 0; sample < SAMInitDialog.this.exptNames.size(); ++sample) {
                        boolean doIndex = false;
                        for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                            if (i == sample || !SAMInitDialog.this.exptNames.get(i).equals(SAMInitDialog.this.exptNames.get(sample))) continue;
                            doIndex = true;
                        }
                        fileSampleIndex = sampleNames.indexOf(SAMInitDialog.this.exptNames.get(sample));
                        if (fileSampleIndex == -1) {
                            doIndex = true;
                        }
                        if (doIndex) {
                            this.setStateBasedOnIndex(groupAssignments, groupNames);
                            break;
                        }
                        String groupName = (String)groupAssignments.get(fileSampleIndex);
                        groupIndex = groupNames.indexOf(groupName);
                        try {
                            if (groupIndex == 0) {
                                this.groupARadioButtons[sample].setSelected(true);
                            }
                            if (groupIndex == 1) {
                                this.groupBRadioButtons[sample].setSelected(true);
                            }
                            if (groupIndex != 2 && groupIndex != -1) continue;
                            this.neitherGroupRadioButtons[sample].setSelected(true);
                            continue;
                        }
                        catch (Exception e) {
                            this.neitherGroupRadioButtons[sample].setSelected(true);
                        }
                    }
                    this.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                }
            }
        }

        private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
            Object[] optionst = new Object[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                return;
            }
            for (int sample = 0; sample < SAMInitDialog.this.exptNames.size(); ++sample) {
                try {
                    if (groupNames.indexOf(groupAssignments.get(sample)) == 0) {
                        this.groupARadioButtons[sample].setSelected(true);
                    }
                    if (groupNames.indexOf(groupAssignments.get(sample)) == 1) {
                        this.groupBRadioButtons[sample].setSelected(true);
                    }
                    if (groupNames.indexOf(groupAssignments.get(sample)) != 2 && groupNames.indexOf(groupAssignments.get(sample)) != -1) continue;
                    this.neitherGroupRadioButtons[sample].setSelected(true);
                    continue;
                }
                catch (Exception e) {
                    this.neitherGroupRadioButtons[sample].setSelected(true);
                }
            }
        }

        private void reset() {
            for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                this.groupARadioButtons[i].setSelected(true);
            }
        }
    }
}

