/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class SAMInfoViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202015030001L;
    private JComponent header;
    private JTextArea content;
    private int studyDesign;

    public SAMInfoViewer(int[][] clusters, int genes, int studyDesign) {
        this.studyDesign = studyDesign;
        this.header = this.createHeader();
        this.content = this.createContent(clusters, genes);
        this.setMaxWidth(this.content, this.header);
    }

    public SAMInfoViewer(JTextArea content, JComponent header) {
        this.content = content;
        this.header = header;
        this.setMaxWidth(content, header);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Information</b></font></body></html>"), gbc);
        return panel;
    }

    private JTextArea createContent(int[][] clusters, int genes) {
        JTextArea area = new JTextArea(clusters.length * 3, 20);
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer sb = new StringBuffer(clusters.length * 3 * 10);
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8) {
            for (int counter = 0; counter < clusters.length; ++counter) {
                if (counter == 0) {
                    sb.append("Positive Significant Genes ");
                    sb.append("\t");
                    sb.append("# of Positive Significant Genes: " + clusters[counter].length);
                    sb.append("\n\t\t");
                    sb.append("% of Positive Significant Genes: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                    sb.append("\n\n");
                    continue;
                }
                if (counter == 1) {
                    sb.append("Negative Significant Genes ");
                    sb.append("\t");
                    sb.append("# of Negative Significant Genes: " + clusters[counter].length);
                    sb.append("\n\t\t");
                    sb.append("% of Negative Significant Genes: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                    sb.append("\n\n");
                    continue;
                }
                if (counter == 2) {
                    sb.append("All Significant Genes ");
                    sb.append("\t");
                    sb.append("Total # of Significant Genes: " + clusters[counter].length);
                    sb.append("\n\t\t");
                    sb.append("% of Genes that are Significant: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                    sb.append("\n\n");
                    continue;
                }
                if (counter != 3) continue;
                sb.append("Non-Significant Genes ");
                sb.append("\t");
                sb.append("Total # of Non-Significant Genes: " + clusters[counter].length);
                sb.append("\n\t\t");
                sb.append("% of Genes that are Not Significant: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\n");
            }
        } else {
            for (int counter = 0; counter < clusters.length; ++counter) {
                if (counter == 0) {
                    sb.append("Significant Genes ");
                    sb.append("\t");
                    sb.append("# of Significant Genes: " + clusters[counter].length);
                    sb.append("\n\t\t");
                    sb.append("% of Significant Genes: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                    sb.append("\n\n");
                    continue;
                }
                if (counter != 1) continue;
                sb.append("Non-significant Genes ");
                sb.append("\t");
                sb.append("# of Non-significant Genes: " + clusters[counter].length);
                sb.append("\n\t\t");
                sb.append("% of Non-significant Genes: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\n");
            }
        }
        area.setText(sb.toString());
        area.setCaretPosition(0);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }
}

