/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.util.FloatMatrix;

public class SAMGraphViewer
extends JPanel
implements IViewer {
    private double[] yArray;
    private double[] xArray;
    private double delta;
    int originX;
    int originY;
    int studyDesign;
    int exptID = 0;

    public SAMGraphViewer(double[] xArray, double[] yArray, int studyDesign, double delta) {
        this.yArray = yArray;
        this.xArray = xArray;
        this.delta = delta;
        this.studyDesign = studyDesign;
        this.setBackground(Color.white);
    }

    public SAMGraphViewer(double[] xArray, double[] yArray, Integer studyDesign, Double delta) {
        this(xArray, yArray, (int)studyDesign, (double)delta);
    }

    public SAMGraphViewer(float[] xArray, float[] yArray, Integer studyDesign, Double delta) {
        this(SAMGraphViewer.convert(xArray), SAMGraphViewer.convert(yArray), (int)studyDesign, (double)delta);
    }

    public SAMGraphViewer(FloatMatrix xArray, FloatMatrix yArray, Integer studyDesign, Double delta) {
        this(xArray.A[0], yArray.A[0], studyDesign, delta);
    }

    public static double[] convert(float[] temp) {
        double[] returnArray = new double[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            returnArray[i] = temp[i];
        }
        return returnArray;
    }

    public Expression getExpression() {
        float[] xes = new float[this.xArray.length];
        int i = 0;
        for (double xtemp : this.xArray) {
            xes[i] = (float)xtemp;
            ++i;
        }
        FloatMatrix xFloatMatrix = new FloatMatrix(xes, 1);
        float[] yes = new float[this.yArray.length];
        i = 0;
        for (double ytemp : this.yArray) {
            yes[i] = (float)ytemp;
            ++i;
        }
        FloatMatrix yFloatMatrix = new FloatMatrix(yes, 1);
        return new Expression(this, this.getClass(), "new", new Object[]{xFloatMatrix, yFloatMatrix, new Integer(this.studyDesign), new Double(this.delta)});
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8) {
            this.paint1(g);
        } else if (this.studyDesign == 6) {
            this.paint2(g);
        }
    }

    private void paint1(Graphics g) {
        int i;
        int i2;
        int i3;
        int i4;
        Graphics2D g2D = (Graphics2D)g;
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        this.originX = (int)Math.round((double)(this.getWidth() / 2));
        this.originY = (int)Math.round((double)(this.getHeight() / 2));
        double origMaxXValue = this.getMax(this.xArray);
        double origMaxYValue = this.getMax(this.yArray);
        double origMinXValue = this.getMin(this.xArray);
        double origMinYValue = this.getMin(this.yArray);
        double xScalingFactor = this.getXScalingFactor(origMaxXValue, origMinXValue);
        double yScalingFactor = this.getYScalingFactor(origMaxYValue, origMinYValue);
        float[] dash1 = new float[]{10.0f};
        BasicStroke dashed = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);
        g2D.setStroke(new BasicStroke(2.0f));
        g2D.drawLine(0, (int)Math.round((double)(this.getHeight() / 2)), this.getWidth(), (int)Math.round((double)(this.getHeight() / 2)));
        g2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 0, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight());
        double[] xIntervalArray = new double[6];
        double[] yIntervalArray = new double[6];
        double xIncrement = 0.0;
        double yIncrement = 0.0;
        xIncrement = Math.abs(origMaxXValue) > Math.abs(origMinXValue) ? Math.abs(origMaxXValue / 5.0) : Math.abs(origMinXValue / 5.0);
        yIncrement = Math.abs(origMaxYValue) > Math.abs(origMinYValue) ? Math.abs(origMaxYValue / 5.0) : Math.abs(origMinYValue / 5.0);
        double xCounter = 0.0;
        double yCounter = 0.0;
        for (i4 = 0; i4 < xIntervalArray.length; ++i4) {
            xIntervalArray[i4] = xCounter;
            xCounter += xIncrement;
            yIntervalArray[i4] = yCounter;
            yCounter += yIncrement;
        }
        for (i4 = 1; i4 < xIntervalArray.length; ++i4) {
            g2D.drawLine((int)Math.round(xIntervalArray[i4] * xScalingFactor) + this.getWidth() / 2, this.getHeight() / 2 - 5, (int)Math.round(xIntervalArray[i4] * xScalingFactor) + this.getWidth() / 2, this.getHeight() / 2 + 5);
        }
        for (i4 = 1; i4 < xIntervalArray.length; ++i4) {
            g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[i4] * xScalingFactor), this.getHeight() / 2 - 5, this.getWidth() / 2 - (int)Math.round(xIntervalArray[i4] * xScalingFactor), this.getHeight() / 2 + 5);
        }
        g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 + (int)Math.round(xIntervalArray[5] * yScalingFactor), this.getWidth() / 2 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 - (int)Math.round(xIntervalArray[5] * yScalingFactor));
        g2D.setColor(Color.gray);
        g2D.setStroke(new BasicStroke(1.0f));
        for (i4 = 1; i4 < yIntervalArray.length; ++i4) {
            g2D.drawLine(0, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i4] * yScalingFactor), this.getWidth(), this.getHeight() / 2 + (int)Math.round(yIntervalArray[i4] * yScalingFactor));
        }
        for (i4 = 1; i4 < yIntervalArray.length; ++i4) {
            g2D.drawLine(0, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i4] * yScalingFactor), this.getWidth(), this.getHeight() / 2 - (int)Math.round(yIntervalArray[i4] * yScalingFactor));
        }
        g2D.setStroke(new BasicStroke(2.0f));
        g2D.setColor(Color.black);
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(2);
        for (i3 = 1; i3 < xIntervalArray.length; ++i3) {
            g2D.drawString(nf.format(xIntervalArray[i3]), (int)Math.round(xIntervalArray[i3] * xScalingFactor) + this.getWidth() / 2 - 10, this.getHeight() / 2 + 20);
        }
        for (i3 = 1; i3 < xIntervalArray.length; ++i3) {
            g2D.drawString("-" + nf.format(xIntervalArray[i3]), this.getWidth() / 2 - (int)Math.round(xIntervalArray[i3] * xScalingFactor) - 10, this.getHeight() / 2 + 20);
        }
        for (i3 = 1; i3 < yIntervalArray.length; ++i3) {
            g2D.drawString(nf.format(yIntervalArray[i3]), this.getWidth() / 2 - 30, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i3] * yScalingFactor) - 5);
        }
        for (i3 = 1; i3 < yIntervalArray.length; ++i3) {
            g2D.drawString("-" + nf.format(yIntervalArray[i3]), this.getWidth() / 2 - 30, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i3] * yScalingFactor) - 5);
        }
        int deltaOffset = (int)Math.round(this.delta * yScalingFactor);
        g2D.setStroke(dashed);
        g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 + (int)Math.round(xIntervalArray[5] * yScalingFactor) - deltaOffset, this.getWidth() / 2 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 - (int)Math.round(xIntervalArray[5] * yScalingFactor) - deltaOffset);
        g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 + (int)Math.round(xIntervalArray[5] * yScalingFactor) + deltaOffset, this.getWidth() / 2 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 - (int)Math.round(xIntervalArray[5] * yScalingFactor) + deltaOffset);
        g2D.setStroke(new BasicStroke(2.0f));
        boolean posSigEncountered = false;
        boolean negSigEncountered = false;
        int lowestPosSigIndex = 0;
        int highestNegSigIndex = 0;
        for (i2 = 0; i2 < this.xArray.length; ++i2) {
            if (!(this.xArray[i2] > 0.0) || !(this.yArray[i2] - this.xArray[i2] > this.delta)) continue;
            lowestPosSigIndex = i2;
            posSigEncountered = true;
            break;
        }
        for (i2 = 0; i2 < this.xArray.length; ++i2) {
            if (!(this.xArray[i2] < 0.0) || !(this.xArray[i2] - this.yArray[i2] > this.delta)) continue;
            highestNegSigIndex = i2;
            negSigEncountered = true;
        }
        Color[] pointColor = new Color[this.xArray.length];
        if (posSigEncountered && negSigEncountered) {
            for (i = 0; i < highestNegSigIndex + 1; ++i) {
                pointColor[i] = Color.green.darker();
            }
            for (i = highestNegSigIndex + 1; i < lowestPosSigIndex; ++i) {
                pointColor[i] = Color.black;
            }
            for (i = lowestPosSigIndex; i < this.xArray.length; ++i) {
                pointColor[i] = Color.red;
            }
        } else if (posSigEncountered && !negSigEncountered) {
            for (i = 0; i < lowestPosSigIndex; ++i) {
                pointColor[i] = Color.black;
            }
            for (i = lowestPosSigIndex; i < this.xArray.length; ++i) {
                pointColor[i] = Color.red;
            }
        } else if (!posSigEncountered && negSigEncountered) {
            for (i = 0; i < highestNegSigIndex + 1; ++i) {
                pointColor[i] = Color.green.darker();
            }
            for (i = highestNegSigIndex + 1; i < this.xArray.length; ++i) {
                pointColor[i] = Color.black;
            }
        } else if (!posSigEncountered && !negSigEncountered) {
            for (i = 0; i < this.xArray.length; ++i) {
                pointColor[i] = Color.black;
            }
        }
        for (i = 0; i < this.xArray.length; ++i) {
            g2D.setColor(pointColor[i]);
            this.drawPoint(g2D, this.xArray[i], this.yArray[i], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 5);
            g2D.setColor(Color.black);
        }
        g2D.drawString("X axis = Expected, Y axis = Observed", this.getWidth() / 2 + 25, this.getHeight() - 25);
    }

    private void paint2(Graphics g) {
        int i;
        int i2;
        int i3;
        int i4;
        Graphics2D g2D = (Graphics2D)g;
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        this.originX = 30;
        this.originY = (int)Math.round((double)(this.getHeight() - 30));
        double origMaxXValue = this.getMax(this.xArray);
        double origMaxYValue = this.getMax(this.yArray);
        double origMinXValue = this.getMin(this.xArray);
        double origMinYValue = this.getMin(this.yArray);
        double xScalingFactor = this.getXScalingFactor(origMaxXValue, origMinXValue);
        double yScalingFactor = this.getYScalingFactor(origMaxYValue, origMinYValue);
        float[] dash1 = new float[]{10.0f};
        BasicStroke dashed = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);
        g2D.setStroke(new BasicStroke(2.0f));
        g2D.drawLine(0, (int)Math.round((double)(this.getHeight() - 30)), this.getWidth(), (int)Math.round((double)(this.getHeight() - 30)));
        g2D.drawLine(30, 0, 30, this.getHeight());
        double[] xIntervalArray = new double[6];
        double[] yIntervalArray = new double[6];
        double xIncrement = 0.0;
        double yIncrement = 0.0;
        xIncrement = Math.abs(origMaxXValue) > Math.abs(origMinXValue) ? Math.abs(origMaxXValue / 5.0) : Math.abs(origMinXValue / 5.0);
        yIncrement = Math.abs(origMaxYValue) > Math.abs(origMinYValue) ? Math.abs(origMaxYValue / 5.0) : Math.abs(origMinYValue / 5.0);
        double xCounter = 0.0;
        double yCounter = 0.0;
        for (i4 = 0; i4 < xIntervalArray.length; ++i4) {
            xIntervalArray[i4] = xCounter;
            xCounter += xIncrement;
            yIntervalArray[i4] = yCounter;
            yCounter += yIncrement;
        }
        for (i4 = 1; i4 < xIntervalArray.length; ++i4) {
            g2D.drawLine((int)Math.round(xIntervalArray[i4] * xScalingFactor) + 30, this.getHeight() - 30 - 5, (int)Math.round(xIntervalArray[i4] * xScalingFactor) + 30, this.getHeight() - 30 + 5);
        }
        g2D.drawLine(30, this.getHeight() - 30, 30 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() - 30 - (int)Math.round(xIntervalArray[5] * yScalingFactor));
        g2D.setColor(Color.gray);
        g2D.setStroke(new BasicStroke(1.0f));
        for (i4 = 1; i4 < yIntervalArray.length; ++i4) {
            g2D.drawLine(0, this.getHeight() - 30 - (int)Math.round(yIntervalArray[i4] * yScalingFactor), this.getWidth(), this.getHeight() - 30 - (int)Math.round(yIntervalArray[i4] * yScalingFactor));
        }
        g2D.setStroke(new BasicStroke(2.0f));
        g2D.setColor(Color.black);
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(2);
        for (i3 = 1; i3 < xIntervalArray.length; ++i3) {
            g2D.drawString(nf.format(xIntervalArray[i3]), (int)Math.round(xIntervalArray[i3] * xScalingFactor) + 10, this.getHeight() - 5);
        }
        for (i3 = 1; i3 < yIntervalArray.length; ++i3) {
            g2D.drawString(nf.format(yIntervalArray[i3]), 5, this.getHeight() - 30 - (int)Math.round(yIntervalArray[i3] * yScalingFactor) - 5);
        }
        int deltaOffset = (int)Math.round(this.delta * yScalingFactor);
        g2D.setStroke(dashed);
        g2D.drawLine(30, this.getHeight() - 30 - deltaOffset, 30 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() - 30 - (int)Math.round(xIntervalArray[5] * yScalingFactor) - deltaOffset);
        g2D.drawLine(30, this.getHeight() - 30 + deltaOffset, 30 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() - 30 - (int)Math.round(xIntervalArray[5] * yScalingFactor) + deltaOffset);
        g2D.setStroke(new BasicStroke(2.0f));
        boolean posSigEncountered = false;
        boolean negSigEncountered = false;
        int lowestPosSigIndex = 0;
        int highestNegSigIndex = 0;
        for (i2 = 0; i2 < this.xArray.length; ++i2) {
            if (!(this.xArray[i2] > 0.0) || !(this.yArray[i2] - this.xArray[i2] > this.delta)) continue;
            lowestPosSigIndex = i2;
            posSigEncountered = true;
            break;
        }
        for (i2 = 0; i2 < this.xArray.length; ++i2) {
            if (!(this.xArray[i2] < 0.0) || !(this.xArray[i2] - this.yArray[i2] > this.delta)) continue;
            highestNegSigIndex = i2;
            negSigEncountered = true;
        }
        Color[] pointColor = new Color[this.xArray.length];
        if (posSigEncountered && negSigEncountered) {
            for (i = 0; i < highestNegSigIndex + 1; ++i) {
                pointColor[i] = Color.green.darker();
            }
            for (i = highestNegSigIndex + 1; i < lowestPosSigIndex; ++i) {
                pointColor[i] = Color.black;
            }
            for (i = lowestPosSigIndex; i < this.xArray.length; ++i) {
                pointColor[i] = Color.red;
            }
        } else if (posSigEncountered && !negSigEncountered) {
            for (i = 0; i < lowestPosSigIndex; ++i) {
                pointColor[i] = Color.black;
            }
            for (i = lowestPosSigIndex; i < this.xArray.length; ++i) {
                pointColor[i] = Color.red;
            }
        } else if (!posSigEncountered && negSigEncountered) {
            for (i = 0; i < highestNegSigIndex + 1; ++i) {
                pointColor[i] = Color.green.darker();
            }
            for (i = highestNegSigIndex + 1; i < this.xArray.length; ++i) {
                pointColor[i] = Color.black;
            }
        } else if (!posSigEncountered && !negSigEncountered) {
            for (i = 0; i < this.xArray.length; ++i) {
                pointColor[i] = Color.black;
            }
        }
        for (i = 0; i < this.xArray.length; ++i) {
            g2D.setColor(pointColor[i]);
            this.drawPoint(g2D, this.xArray[i], this.yArray[i], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 5);
            g2D.setColor(Color.black);
        }
        g2D.drawString("X axis = Expected, Y axis = Observed", 40, 20);
    }

    private void drawPoint(Graphics2D g2D, double xValue, double yValue, double xScale, double yScale, int diameter) {
        int xRaw = (int)Math.round(xValue * xScale);
        int yRaw = (int)Math.round(yValue * yScale);
        int xCoord = 0;
        int yCoord = 0;
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8) {
            xCoord = (int)Math.round((double)(this.getWidth() / 2)) + xRaw;
            yCoord = (int)Math.round((double)(this.getHeight() / 2)) - yRaw;
        } else if (this.studyDesign == 6) {
            xCoord = 30 + xRaw;
            yCoord = (int)Math.round((double)(this.getHeight() - 30)) - yRaw;
        }
        g2D.fillOval(xCoord, yCoord, diameter, diameter);
    }

    private double getMax(double[] array) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (!(max < array[i])) continue;
            max = array[i];
        }
        return max;
    }

    private double getMin(double[] array) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (!(min > array[i])) continue;
            min = array[i];
        }
        return min;
    }

    private double getXScalingFactor(double maxValue, double minValue) {
        double largest = 1.0;
        if (maxValue > 0.0 && minValue > 0.0) {
            largest = maxValue;
        } else if (maxValue > 0.0 && minValue < 0.0) {
            largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
        } else if (maxValue <= 0.0) {
            largest = Math.abs(minValue);
        } else if (minValue == 0.0) {
            largest = maxValue;
        }
        double scalingFactor = 0.0;
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8) {
            scalingFactor = (double)(this.getWidth() / 2 - 50) / largest;
        } else if (this.studyDesign == 6) {
            scalingFactor = (double)(this.getWidth() - 50 - 30) / largest;
        }
        return scalingFactor;
    }

    private double getYScalingFactor(double maxValue, double minValue) {
        double largest = 1.0;
        if (maxValue > 0.0 && minValue > 0.0) {
            largest = maxValue;
        } else if (maxValue > 0.0 && minValue < 0.0) {
            largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
        } else if (maxValue <= 0.0) {
            largest = Math.abs(minValue);
        } else if (minValue == 0.0) {
            largest = maxValue;
        }
        double scalingFactor = 0.0;
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8) {
            scalingFactor = (double)(this.getHeight() / 2 - 50) / largest;
        } else if (this.studyDesign == 6) {
            scalingFactor = (double)(this.getHeight() - 30 - 50) / largest;
        }
        return scalingFactor;
    }

    public void onDeselected() {
    }

    public void onDataChanged(IData data) {
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework framework) {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int id) {
    }
}

