/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.util.awt.ActionInfoDialog;

public class SAMGraph
extends ActionInfoDialog {
    private double[] observedYArray;
    private double[] expectedXArray;
    private double delta;
    private double maxDelta;
    private double minDelta;
    int studyDesign;
    boolean infiniteDeltaEncountered;
    double[] deltaGrid;
    int[] numSigGenesByDelta;
    double[] medNumFalse;
    double[] false90th;
    double[] FDRMedian;
    double[] FDR90th;
    GraphPanel gPanel;
    BottomPanel bPanel;
    private String pubNumSig;
    private String pubNumFalseSigMed;
    private String pubNumFalseSig90th;
    private String pubFDRMed;
    private String pubFDR90th;

    public SAMGraph(JFrame parentFrame, int studyDesign, double[] expectedXArray, double[] observedYArray, double delta, double[] deltaGrid, int[] numSigGenesByDelta, double[] medNumFalse, double[] false90th, double[] FDRMedian, double[] FDR90th, boolean modality) {
        super(parentFrame, "SAM Graph", modality);
        this.studyDesign = studyDesign;
        this.observedYArray = observedYArray;
        this.expectedXArray = expectedXArray;
        this.delta = delta;
        this.deltaGrid = deltaGrid;
        this.numSigGenesByDelta = numSigGenesByDelta;
        this.medNumFalse = medNumFalse;
        this.false90th = false90th;
        this.FDRMedian = FDRMedian;
        this.FDR90th = FDR90th;
        this.infiniteDeltaEncountered = false;
        this.setBounds(0, 0, 800, 700);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.gPanel = new GraphPanel(expectedXArray, observedYArray);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 70);
        gridbag.setConstraints(this.gPanel, constraints);
        pane.add(this.gPanel);
        this.bPanel = new BottomPanel();
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 30);
        gridbag.setConstraints(this.bPanel, constraints);
        pane.add(this.bPanel);
        this.setContentPane(pane);
    }

    public SAMGraph() {
        super(new JFrame(), "SAM Graph", true);
        this.setBounds(0, 0, 600, 600);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.gPanel = new GraphPanel(this.expectedXArray, this.observedYArray);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.gPanel, constraints);
        pane.add(this.gPanel);
        this.setContentPane(pane);
    }

    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    private float getMax(float[] array) {
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (!(max < array[i])) continue;
            max = array[i];
        }
        return max;
    }

    private float getMin(float[] array) {
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (!(min > array[i])) continue;
            min = array[i];
        }
        return min;
    }

    private double getMax(double[] array) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (!(max < array[i])) continue;
            max = array[i];
        }
        return max;
    }

    private double getMin(double[] array) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (!(min > array[i])) continue;
            min = array[i];
        }
        return min;
    }

    private String getNumSig(double currDel) {
        String numSig = "";
        int finalIndex = 0;
        if (currDel >= this.maxDelta) {
            numSig = "0";
        } else if (currDel <= this.minDelta) {
            numSig = String.valueOf(this.observedYArray.length);
        } else {
            int currentIndex = 0;
            for (int i = 0; i < this.deltaGrid.length; ++i) {
                if (!(this.deltaGrid[i] > currDel)) continue;
                currentIndex = i;
                break;
            }
            finalIndex = this.deltaGrid[currentIndex] - currDel > currDel - this.deltaGrid[currentIndex - 1] ? currentIndex - 1 : currentIndex;
            numSig = String.valueOf(this.numSigGenesByDelta[finalIndex]);
        }
        this.pubNumSig = numSig;
        return numSig;
    }

    private String getNumFalseSig(double currDel) {
        String numFalse = "";
        String numFalse90th = "";
        int finalIndex = 0;
        if (currDel >= this.maxDelta || currDel <= this.minDelta) {
            this.pubNumFalseSigMed = numFalse = "N/A        ";
            this.pubNumFalseSig90th = numFalse;
            this.pubFDRMed = numFalse;
            this.pubFDR90th = numFalse;
            return numFalse;
        }
        int currentIndex = 0;
        for (int i = 0; i < this.deltaGrid.length; ++i) {
            if (!(this.deltaGrid[i] >= currDel)) continue;
            currentIndex = i;
            break;
        }
        finalIndex = this.deltaGrid[currentIndex] - currDel > currDel - this.deltaGrid[currentIndex - 1] ? currentIndex - 1 : currentIndex;
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.setMinimumFractionDigits(5);
        numFalse = nf.format(this.medNumFalse[finalIndex]);
        this.pubNumFalseSig90th = nf.format(this.false90th[finalIndex]);
        this.pubFDRMed = nf.format(this.FDRMedian[finalIndex]);
        this.pubFDR90th = nf.format(this.FDR90th[finalIndex]);
        this.pubNumFalseSigMed = numFalse;
        return numFalse;
    }

    public String getNumSig() {
        return this.pubNumSig;
    }

    public String getNumFalseSigMed() {
        return this.pubNumFalseSigMed;
    }

    public String getNumFalseSig90th() {
        return this.pubNumFalseSig90th;
    }

    public String getFDRMedian() {
        return this.pubFDRMed;
    }

    public String getFDR90th() {
        return this.pubFDR90th;
    }

    public boolean useFoldChange() {
        return this.bPanel.useFoldChangeBox.isSelected();
    }

    public double getFoldChangeValue() {
        String s2 = this.bPanel.foldChangeTextField.getText();
        return Double.parseDouble(s2);
    }

    public double getDelta() {
        String s = this.bPanel.deltaTextField.getText();
        if (this.infiniteDeltaEncountered) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.parseDouble(s);
    }

    public static void main(String[] args) {
        SAMGraph sg = new SAMGraph();
        sg.setVisible(true);
    }

    private class GraphPanel
    extends JPanel {
        private double[] xArray;
        private double[] yArray;
        int originX;
        int originY;

        GraphPanel(double[] xArray, double[] yArray) {
            this.setBorder(new LineBorder(Color.black));
            this.setBackground(Color.white);
            this.xArray = xArray;
            this.yArray = yArray;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (SAMGraph.this.studyDesign == 4 || SAMGraph.this.studyDesign == 5 || SAMGraph.this.studyDesign == 7 || SAMGraph.this.studyDesign == 8) {
                this.paint1(g);
            } else if (SAMGraph.this.studyDesign == 6) {
                this.paint2(g);
            }
        }

        private void paint1(Graphics g) {
            int i;
            int i2;
            int i3;
            int i4;
            Graphics2D g2D = (Graphics2D)g;
            int panelWidth = this.getWidth();
            int panelHeight = this.getHeight();
            this.originX = (int)Math.round((double)(this.getWidth() / 2));
            this.originY = (int)Math.round((double)(this.getHeight() / 2));
            double origMaxXValue = SAMGraph.this.getMax(this.xArray);
            double origMaxYValue = SAMGraph.this.getMax(this.yArray);
            double origMinXValue = SAMGraph.this.getMin(this.xArray);
            double origMinYValue = SAMGraph.this.getMin(this.yArray);
            double xScalingFactor = this.getXScalingFactor(origMaxXValue, origMinXValue);
            double yScalingFactor = this.getYScalingFactor(origMaxYValue, origMinYValue);
            float[] dash1 = new float[]{10.0f};
            BasicStroke dashed = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);
            g2D.setStroke(new BasicStroke(2.0f));
            g2D.drawLine(0, (int)Math.round((double)(this.getHeight() / 2)), this.getWidth(), (int)Math.round((double)(this.getHeight() / 2)));
            g2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 0, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight());
            double[] xIntervalArray = new double[6];
            double[] yIntervalArray = new double[6];
            double xIncrement = 0.0;
            double yIncrement = 0.0;
            xIncrement = Math.abs(origMaxXValue) > Math.abs(origMinXValue) ? Math.abs(origMaxXValue / 5.0) : Math.abs(origMinXValue / 5.0);
            yIncrement = Math.abs(origMaxYValue) > Math.abs(origMinYValue) ? Math.abs(origMaxYValue / 5.0) : Math.abs(origMinYValue / 5.0);
            double xCounter = 0.0;
            double yCounter = 0.0;
            for (i4 = 0; i4 < xIntervalArray.length; ++i4) {
                xIntervalArray[i4] = xCounter;
                xCounter += xIncrement;
                yIntervalArray[i4] = yCounter;
                yCounter += yIncrement;
            }
            for (i4 = 1; i4 < xIntervalArray.length; ++i4) {
                g2D.drawLine((int)Math.round(xIntervalArray[i4] * xScalingFactor) + this.getWidth() / 2, this.getHeight() / 2 - 5, (int)Math.round(xIntervalArray[i4] * xScalingFactor) + this.getWidth() / 2, this.getHeight() / 2 + 5);
            }
            for (i4 = 1; i4 < xIntervalArray.length; ++i4) {
                g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[i4] * xScalingFactor), this.getHeight() / 2 - 5, this.getWidth() / 2 - (int)Math.round(xIntervalArray[i4] * xScalingFactor), this.getHeight() / 2 + 5);
            }
            g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 + (int)Math.round(xIntervalArray[5] * yScalingFactor), this.getWidth() / 2 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 - (int)Math.round(xIntervalArray[5] * yScalingFactor));
            g2D.setColor(Color.gray);
            g2D.setStroke(new BasicStroke(1.0f));
            for (i4 = 1; i4 < yIntervalArray.length; ++i4) {
                g2D.drawLine(0, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i4] * yScalingFactor), this.getWidth(), this.getHeight() / 2 + (int)Math.round(yIntervalArray[i4] * yScalingFactor));
            }
            for (i4 = 1; i4 < yIntervalArray.length; ++i4) {
                g2D.drawLine(0, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i4] * yScalingFactor), this.getWidth(), this.getHeight() / 2 - (int)Math.round(yIntervalArray[i4] * yScalingFactor));
            }
            g2D.setStroke(new BasicStroke(2.0f));
            g2D.setColor(Color.black);
            DecimalFormat nf = new DecimalFormat();
            nf.setMaximumFractionDigits(2);
            for (i3 = 1; i3 < xIntervalArray.length; ++i3) {
                g2D.drawString(nf.format(xIntervalArray[i3]), (int)Math.round(xIntervalArray[i3] * xScalingFactor) + this.getWidth() / 2 - 10, this.getHeight() / 2 + 20);
            }
            for (i3 = 1; i3 < xIntervalArray.length; ++i3) {
                g2D.drawString("-" + nf.format(xIntervalArray[i3]), this.getWidth() / 2 - (int)Math.round(xIntervalArray[i3] * xScalingFactor) - 10, this.getHeight() / 2 + 20);
            }
            for (i3 = 1; i3 < yIntervalArray.length; ++i3) {
                g2D.drawString(nf.format(yIntervalArray[i3]), this.getWidth() / 2 - 30, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i3] * yScalingFactor) - 5);
            }
            for (i3 = 1; i3 < yIntervalArray.length; ++i3) {
                g2D.drawString("-" + nf.format(yIntervalArray[i3]), this.getWidth() / 2 - 30, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i3] * yScalingFactor) - 5);
            }
            int deltaOffset = (int)Math.round(SAMGraph.this.delta * yScalingFactor);
            g2D.setStroke(dashed);
            g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 + (int)Math.round(xIntervalArray[5] * yScalingFactor) - deltaOffset, this.getWidth() / 2 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 - (int)Math.round(xIntervalArray[5] * yScalingFactor) - deltaOffset);
            g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 + (int)Math.round(xIntervalArray[5] * yScalingFactor) + deltaOffset, this.getWidth() / 2 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 - (int)Math.round(xIntervalArray[5] * yScalingFactor) + deltaOffset);
            g2D.setStroke(new BasicStroke(2.0f));
            boolean posSigEncountered = false;
            boolean negSigEncountered = false;
            int lowestPosSigIndex = 0;
            int highestNegSigIndex = 0;
            for (i2 = 0; i2 < this.xArray.length; ++i2) {
                if (!(this.xArray[i2] > 0.0) || !(this.yArray[i2] - this.xArray[i2] > SAMGraph.this.delta)) continue;
                lowestPosSigIndex = i2;
                posSigEncountered = true;
                break;
            }
            for (i2 = 0; i2 < this.xArray.length; ++i2) {
                if (!(this.xArray[i2] < 0.0) || !(this.xArray[i2] - this.yArray[i2] > SAMGraph.this.delta)) continue;
                highestNegSigIndex = i2;
                negSigEncountered = true;
            }
            Color[] pointColor = new Color[this.xArray.length];
            if (posSigEncountered && negSigEncountered) {
                for (i = 0; i < highestNegSigIndex + 1; ++i) {
                    pointColor[i] = Color.green.darker();
                }
                for (i = highestNegSigIndex + 1; i < lowestPosSigIndex; ++i) {
                    pointColor[i] = Color.black;
                }
                for (i = lowestPosSigIndex; i < this.xArray.length; ++i) {
                    pointColor[i] = Color.red;
                }
            } else if (posSigEncountered && !negSigEncountered) {
                for (i = 0; i < lowestPosSigIndex; ++i) {
                    pointColor[i] = Color.black;
                }
                for (i = lowestPosSigIndex; i < this.xArray.length; ++i) {
                    pointColor[i] = Color.red;
                }
            } else if (!posSigEncountered && negSigEncountered) {
                for (i = 0; i < highestNegSigIndex + 1; ++i) {
                    pointColor[i] = Color.green.darker();
                }
                for (i = highestNegSigIndex + 1; i < this.xArray.length; ++i) {
                    pointColor[i] = Color.black;
                }
            } else if (!posSigEncountered && !negSigEncountered) {
                for (i = 0; i < this.xArray.length; ++i) {
                    pointColor[i] = Color.black;
                }
            }
            for (i = 0; i < SAMGraph.this.expectedXArray.length; ++i) {
                g2D.setColor(pointColor[i]);
                this.drawPoint(g2D, this.xArray[i], this.yArray[i], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 5);
                g2D.setColor(Color.black);
            }
            g2D.drawString("X axis = Expected, Y axis = Observed", this.getWidth() / 2 + 25, this.getHeight() - 25);
        }

        private void paint2(Graphics g) {
            int i;
            int i2;
            int i3;
            int i4;
            Graphics2D g2D = (Graphics2D)g;
            int panelWidth = this.getWidth();
            int panelHeight = this.getHeight();
            this.originX = 30;
            this.originY = (int)Math.round((double)(this.getHeight() - 30));
            double origMaxXValue = SAMGraph.this.getMax(this.xArray);
            double origMaxYValue = SAMGraph.this.getMax(this.yArray);
            double origMinXValue = SAMGraph.this.getMin(this.xArray);
            double origMinYValue = SAMGraph.this.getMin(this.yArray);
            double xScalingFactor = this.getXScalingFactor(origMaxXValue, origMinXValue);
            double yScalingFactor = this.getYScalingFactor(origMaxYValue, origMinYValue);
            float[] dash1 = new float[]{10.0f};
            BasicStroke dashed = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);
            g2D.setStroke(new BasicStroke(2.0f));
            g2D.drawLine(0, (int)Math.round((double)(this.getHeight() - 30)), this.getWidth(), (int)Math.round((double)(this.getHeight() - 30)));
            g2D.drawLine(30, 0, 30, this.getHeight());
            double[] xIntervalArray = new double[6];
            double[] yIntervalArray = new double[6];
            double xIncrement = 0.0;
            double yIncrement = 0.0;
            xIncrement = Math.abs(origMaxXValue) > Math.abs(origMinXValue) ? Math.abs(origMaxXValue / 5.0) : Math.abs(origMinXValue / 5.0);
            yIncrement = Math.abs(origMaxYValue) > Math.abs(origMinYValue) ? Math.abs(origMaxYValue / 5.0) : Math.abs(origMinYValue / 5.0);
            double xCounter = 0.0;
            double yCounter = 0.0;
            for (i4 = 0; i4 < xIntervalArray.length; ++i4) {
                xIntervalArray[i4] = xCounter;
                xCounter += xIncrement;
                yIntervalArray[i4] = yCounter;
                yCounter += yIncrement;
            }
            for (i4 = 1; i4 < xIntervalArray.length; ++i4) {
                g2D.drawLine((int)Math.round(xIntervalArray[i4] * xScalingFactor) + 30, this.getHeight() - 30 - 5, (int)Math.round(xIntervalArray[i4] * xScalingFactor) + 30, this.getHeight() - 30 + 5);
            }
            g2D.drawLine(30, this.getHeight() - 30, 30 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() - 30 - (int)Math.round(xIntervalArray[5] * yScalingFactor));
            g2D.setColor(Color.gray);
            g2D.setStroke(new BasicStroke(1.0f));
            for (i4 = 1; i4 < yIntervalArray.length; ++i4) {
                g2D.drawLine(0, this.getHeight() - 30 - (int)Math.round(yIntervalArray[i4] * yScalingFactor), this.getWidth(), this.getHeight() - 30 - (int)Math.round(yIntervalArray[i4] * yScalingFactor));
            }
            g2D.setStroke(new BasicStroke(2.0f));
            g2D.setColor(Color.black);
            DecimalFormat nf = new DecimalFormat();
            nf.setMaximumFractionDigits(2);
            for (i3 = 1; i3 < xIntervalArray.length; ++i3) {
                g2D.drawString(nf.format(xIntervalArray[i3]), (int)Math.round(xIntervalArray[i3] * xScalingFactor) + 10, this.getHeight() - 5);
            }
            for (i3 = 1; i3 < yIntervalArray.length; ++i3) {
                g2D.drawString(nf.format(yIntervalArray[i3]), 5, this.getHeight() - 30 - (int)Math.round(yIntervalArray[i3] * yScalingFactor) - 5);
            }
            int deltaOffset = (int)Math.round(SAMGraph.this.delta * yScalingFactor);
            g2D.setStroke(dashed);
            g2D.drawLine(30, this.getHeight() - 30 - deltaOffset, 30 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() - 30 - (int)Math.round(xIntervalArray[5] * yScalingFactor) - deltaOffset);
            g2D.drawLine(30, this.getHeight() - 30 + deltaOffset, 30 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() - 30 - (int)Math.round(xIntervalArray[5] * yScalingFactor) + deltaOffset);
            g2D.setStroke(new BasicStroke(2.0f));
            boolean posSigEncountered = false;
            boolean negSigEncountered = false;
            int lowestPosSigIndex = 0;
            int highestNegSigIndex = 0;
            for (i2 = 0; i2 < this.xArray.length; ++i2) {
                if (!(this.xArray[i2] > 0.0) || !(this.yArray[i2] - this.xArray[i2] > SAMGraph.this.delta)) continue;
                lowestPosSigIndex = i2;
                posSigEncountered = true;
                break;
            }
            for (i2 = 0; i2 < this.xArray.length; ++i2) {
                if (!(this.xArray[i2] < 0.0) || !(this.xArray[i2] - this.yArray[i2] > SAMGraph.this.delta)) continue;
                highestNegSigIndex = i2;
                negSigEncountered = true;
            }
            Color[] pointColor = new Color[this.xArray.length];
            if (posSigEncountered && negSigEncountered) {
                for (i = 0; i < highestNegSigIndex + 1; ++i) {
                    pointColor[i] = Color.green.darker();
                }
                for (i = highestNegSigIndex + 1; i < lowestPosSigIndex; ++i) {
                    pointColor[i] = Color.black;
                }
                for (i = lowestPosSigIndex; i < this.xArray.length; ++i) {
                    pointColor[i] = Color.red;
                }
            } else if (posSigEncountered && !negSigEncountered) {
                for (i = 0; i < lowestPosSigIndex; ++i) {
                    pointColor[i] = Color.black;
                }
                for (i = lowestPosSigIndex; i < this.xArray.length; ++i) {
                    pointColor[i] = Color.red;
                }
            } else if (!posSigEncountered && negSigEncountered) {
                for (i = 0; i < highestNegSigIndex + 1; ++i) {
                    pointColor[i] = Color.green.darker();
                }
                for (i = highestNegSigIndex + 1; i < this.xArray.length; ++i) {
                    pointColor[i] = Color.black;
                }
            } else if (!posSigEncountered && !negSigEncountered) {
                for (i = 0; i < this.xArray.length; ++i) {
                    pointColor[i] = Color.black;
                }
            }
            for (i = 0; i < SAMGraph.this.expectedXArray.length; ++i) {
                g2D.setColor(pointColor[i]);
                this.drawPoint(g2D, this.xArray[i], this.yArray[i], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 5);
                g2D.setColor(Color.black);
            }
            g2D.drawString("X axis = Expected, Y axis = Observed", 40, 20);
        }

        private void drawPoint(Graphics2D g2D, double xValue, double yValue, double xScale, double yScale, int diameter) {
            int xRaw = (int)Math.round(xValue * xScale);
            int yRaw = (int)Math.round(yValue * yScale);
            int xCoord = 0;
            int yCoord = 0;
            if (SAMGraph.this.studyDesign == 4 || SAMGraph.this.studyDesign == 5 || SAMGraph.this.studyDesign == 7 || SAMGraph.this.studyDesign == 8) {
                xCoord = (int)Math.round((double)(this.getWidth() / 2)) + xRaw;
                yCoord = (int)Math.round((double)(this.getHeight() / 2)) - yRaw;
            } else if (SAMGraph.this.studyDesign == 6) {
                xCoord = 30 + xRaw;
                yCoord = (int)Math.round((double)(this.getHeight() - 30)) - yRaw;
            }
            g2D.fillOval(xCoord, yCoord, diameter, diameter);
        }

        private double getXScalingFactor(double maxValue, double minValue) {
            double largest = 1.0;
            if (maxValue > 0.0 && minValue > 0.0) {
                largest = maxValue;
            } else if (maxValue > 0.0 && minValue < 0.0) {
                largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
            } else if (maxValue <= 0.0) {
                largest = Math.abs(minValue);
            } else if (minValue == 0.0) {
                largest = maxValue;
            }
            double scalingFactor = 0.0;
            if (SAMGraph.this.studyDesign == 4 || SAMGraph.this.studyDesign == 5 || SAMGraph.this.studyDesign == 7 || SAMGraph.this.studyDesign == 8) {
                scalingFactor = (double)(this.getWidth() / 2 - 50) / largest;
            } else if (SAMGraph.this.studyDesign == 6) {
                scalingFactor = (double)(this.getWidth() - 50 - 30) / largest;
            }
            return scalingFactor;
        }

        private double getYScalingFactor(double maxValue, double minValue) {
            double largest = 1.0;
            if (maxValue > 0.0 && minValue > 0.0) {
                largest = maxValue;
            } else if (maxValue > 0.0 && minValue < 0.0) {
                largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
            } else if (maxValue <= 0.0) {
                largest = Math.abs(minValue);
            } else if (minValue == 0.0) {
                largest = maxValue;
            }
            double scalingFactor = 0.0;
            if (SAMGraph.this.studyDesign == 4 || SAMGraph.this.studyDesign == 5 || SAMGraph.this.studyDesign == 7 || SAMGraph.this.studyDesign == 8) {
                scalingFactor = (double)(this.getHeight() / 2 - 50) / largest;
            } else if (SAMGraph.this.studyDesign == 6) {
                scalingFactor = (double)(this.getHeight() - 30 - 50) / largest;
            }
            return scalingFactor;
        }
    }

    private class BottomPanel
    extends JPanel {
        JSlider deltaSlider;
        JTextField deltaTextField;
        JTextField foldChangeTextField;
        JLabel sigLabel;
        JLabel falseSigLabel;
        double maxValue;
        double initDelta;
        JCheckBox useFoldChangeBox;
        JButton okButton;

        BottomPanel() {
            this.setBorder(new EtchedBorder());
            double[] diffValues = new double[SAMGraph.this.observedYArray.length];
            for (int i = 0; i < diffValues.length; ++i) {
                diffValues[i] = Math.abs(SAMGraph.this.observedYArray[i] - SAMGraph.this.expectedXArray[i]);
            }
            SAMGraph.this.maxDelta = SAMGraph.this.getMax(diffValues);
            SAMGraph.this.minDelta = SAMGraph.this.getMin(diffValues);
            this.maxValue = 0.0;
            double initMax = SAMGraph.this.getMax(SAMGraph.this.observedYArray);
            double initMin = SAMGraph.this.getMin(SAMGraph.this.observedYArray);
            this.maxValue = Math.abs(initMax) > Math.abs(initMin) ? Math.abs(initMax) : Math.abs(initMin);
            this.initDelta = SAMGraph.this.delta;
            this.deltaSlider = new JSlider(0, 1000, (int)Math.round(this.initDelta * 1000.0 / this.maxValue));
            this.deltaTextField = new JTextField("" + this.initDelta, 7);
            this.deltaTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String s = BottomPanel.this.deltaTextField.getText();
                        double f = Double.parseDouble(s);
                        int sliderValue = (int)Math.round(f * 1000.0 / BottomPanel.this.maxValue);
                        if (sliderValue >= 1000) {
                            BottomPanel.this.deltaSlider.setValue(1000);
                            BottomPanel.this.deltaTextField.setText("" + (float)BottomPanel.this.maxValue);
                        } else if (sliderValue <= 0) {
                            BottomPanel.this.deltaSlider.setValue(0);
                            BottomPanel.this.deltaTextField.setText("0.0");
                        } else {
                            BottomPanel.this.deltaSlider.setValue(sliderValue);
                            BottomPanel.this.deltaTextField.setText("" + (float)f);
                        }
                    }
                    catch (Exception exc) {
                        BottomPanel.this.deltaSlider.setValue(250);
                        BottomPanel.this.deltaTextField.setText("" + (float)BottomPanel.this.initDelta);
                    }
                    String dString = BottomPanel.this.deltaTextField.getText();
                    SAMGraph.this.delta = Double.parseDouble(dString);
                    BottomPanel.this.sigLabel.setText("Number of Significant Genes: " + SAMGraph.this.getNumSig(SAMGraph.this.delta));
                    BottomPanel.this.falseSigLabel.setText("Median number of false significant genes" + SAMGraph.this.getNumFalseSig(SAMGraph.this.delta));
                    SAMGraph.this.gPanel.repaint();
                }
            });
            this.deltaTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        String s = BottomPanel.this.deltaTextField.getText();
                        double f = Double.parseDouble(s);
                        int sliderValue = (int)Math.round(f * 1000.0 / BottomPanel.this.maxValue);
                        if (sliderValue >= 1000) {
                            BottomPanel.this.deltaSlider.setValue(1000);
                            BottomPanel.this.deltaTextField.setText("" + (float)BottomPanel.this.maxValue);
                        } else if (sliderValue <= 0) {
                            BottomPanel.this.deltaSlider.setValue(0);
                            BottomPanel.this.deltaTextField.setText("0.0");
                        } else {
                            BottomPanel.this.deltaSlider.setValue(sliderValue);
                            BottomPanel.this.deltaTextField.setText("" + (float)f);
                        }
                    }
                    catch (Exception exc) {
                        BottomPanel.this.deltaSlider.setValue(250);
                        BottomPanel.this.deltaTextField.setText("" + (float)BottomPanel.this.initDelta);
                    }
                    String dString = BottomPanel.this.deltaTextField.getText();
                    SAMGraph.this.delta = Double.parseDouble(dString);
                    BottomPanel.this.sigLabel.setText("Number of Significant Genes: " + SAMGraph.this.getNumSig(SAMGraph.this.delta));
                    BottomPanel.this.falseSigLabel.setText("Median number of false significant genes: " + SAMGraph.this.getNumFalseSig(SAMGraph.this.delta));
                    SAMGraph.this.gPanel.repaint();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.deltaSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    int value = source.getValue();
                    double displayValue = (double)value * BottomPanel.this.maxValue / 1000.0;
                    if (value == 0) {
                        displayValue = 0.0;
                    }
                    BottomPanel.this.deltaTextField.setText("" + (float)displayValue);
                    String dString = BottomPanel.this.deltaTextField.getText();
                    if (!Double.isInfinite(displayValue)) {
                        SAMGraph.this.delta = Double.parseDouble(dString);
                    } else {
                        SAMGraph.this.infiniteDeltaEncountered = true;
                        SAMGraph.this.delta = Double.POSITIVE_INFINITY;
                    }
                    BottomPanel.this.sigLabel.setText("Number of Significant Genes: " + SAMGraph.this.getNumSig(SAMGraph.this.delta));
                    BottomPanel.this.falseSigLabel.setText("Median number of false significant genes: " + SAMGraph.this.getNumFalseSig(SAMGraph.this.delta));
                    SAMGraph.this.gPanel.repaint();
                }
            });
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.sigLabel = new JLabel("Number of significant genes: " + SAMGraph.this.getNumSig(SAMGraph.this.delta));
            SAMGraph.this.buildConstraints(constraints, 0, 0, 2, 1, 50, 30);
            constraints.anchor = 17;
            gridbag.setConstraints(this.sigLabel, constraints);
            this.add(this.sigLabel);
            this.falseSigLabel = new JLabel("Median number of falsely significant genes: " + SAMGraph.this.getNumFalseSig(SAMGraph.this.delta));
            SAMGraph.this.buildConstraints(constraints, 1, 0, 2, 1, 50, 0);
            constraints.anchor = 13;
            gridbag.setConstraints(this.falseSigLabel, constraints);
            this.add(this.falseSigLabel);
            JLabel label1 = new JLabel("Use slider to set delta value: ");
            SAMGraph.this.buildConstraints(constraints, 0, 1, 1, 1, 25, 40);
            constraints.anchor = 13;
            gridbag.setConstraints(label1, constraints);
            this.add(label1);
            SAMGraph.this.buildConstraints(constraints, 1, 1, 1, 1, 25, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.deltaSlider, constraints);
            this.add(this.deltaSlider);
            JLabel label2 = new JLabel("Or enter delta value here: ");
            SAMGraph.this.buildConstraints(constraints, 2, 1, 1, 1, 25, 0);
            constraints.anchor = 13;
            gridbag.setConstraints(label2, constraints);
            this.add(label2);
            SAMGraph.this.buildConstraints(constraints, 3, 1, 1, 1, 25, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.deltaTextField, constraints);
            this.add(this.deltaTextField);
            this.useFoldChangeBox = new JCheckBox("Use Fold Change:", false);
            if (SAMGraph.this.studyDesign == 5 || SAMGraph.this.studyDesign == 4) {
                this.useFoldChangeBox.setEnabled(true);
            } else {
                this.useFoldChangeBox.setEnabled(false);
            }
            this.foldChangeTextField = new JTextField("", 7);
            this.foldChangeTextField.setBackground(Color.darkGray);
            this.foldChangeTextField.setEnabled(false);
            this.useFoldChangeBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        BottomPanel.this.foldChangeTextField.setBackground(Color.darkGray);
                        BottomPanel.this.foldChangeTextField.setText("");
                        BottomPanel.this.foldChangeTextField.setEnabled(false);
                    } else if (e.getStateChange() == 1) {
                        BottomPanel.this.foldChangeTextField.setBackground(Color.white);
                        BottomPanel.this.foldChangeTextField.setText("2.0");
                        BottomPanel.this.foldChangeTextField.setEnabled(true);
                    }
                }
            });
            SAMGraph.this.buildConstraints(constraints, 0, 2, 1, 1, 30, 30);
            constraints.anchor = 13;
            gridbag.setConstraints(this.useFoldChangeBox, constraints);
            this.add(this.useFoldChangeBox);
            SAMGraph.this.buildConstraints(constraints, 1, 2, 1, 1, 30, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.foldChangeTextField, constraints);
            this.add(this.foldChangeTextField);
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (BottomPanel.this.useFoldChangeBox.isSelected()) {
                        try {
                            String foldStr = BottomPanel.this.foldChangeTextField.getText();
                            double fl = Double.parseDouble(foldStr);
                            SAMGraph.this.dispose();
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(null, "Either deselect the Use Fold Change CheckBox or enter a valid fold change value", "Error!", 2);
                        }
                    } else {
                        SAMGraph.this.dispose();
                    }
                }
            });
            SAMGraph.this.buildConstraints(constraints, 2, 2, 2, 1, 40, 0);
            constraints.anchor = 10;
            gridbag.setConstraints(this.okButton, constraints);
            this.add(this.okButton);
        }
    }
}

