/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMDeltaInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMGraphViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMPreDialog;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMScriptDeltaValueInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMState;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class SAMGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    private IData data;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private float[] dValues;
    private float[] rValues;
    private float[] qLowestFDR;
    private float[] foldChangeArray;
    private double[] xArray;
    private double[] yArray;
    private float delta;
    private float oneClassMean;
    private double[] deltaGrid;
    private double[] medNumFalse;
    private double[] false90th;
    private double[] FDRMedian;
    private double[] FDR90th;
    private int[] numSig;
    private String[] auxTitles;
    private float[][] auxData;
    protected ArrayList<String> geneLabels;
    protected ArrayList<String> sampleLabels;
    int[] groupAssignments;
    int numMultiClassGroups;
    int studyDesign;
    boolean[] inSurvivalAnalysis;
    boolean[] censored;
    private boolean drawSigTreesOnly;
    double[] survivalTimes;
    public static JFrame SAMFrame;
    boolean calculateQLowestFDR;
    Vector exptNamesVector;
    Vector geneNamesVector;
    Vector pairedGroupAExpts;
    Vector pairedGroupBExpts;
    private float[] timeCourseData;
    private int[] startOrEnd;
    boolean isTimeCourse;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        int i;
        SAMFrame = (JFrame)framework.getFrame();
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        this.exptNamesVector = new Vector();
        this.geneNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        int[] columnIndices = this.experiment.getColumnIndicesCopy();
        this.sampleLabels = new ArrayList();
        this.geneLabels = new ArrayList();
        for (i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(columnIndices[i]));
            this.sampleLabels.add(framework.getData().getFullSampleName(columnIndices[i]));
        }
        for (i = 0; i < this.experiment.getNumberOfGenes(); ++i) {
            this.geneLabels.add(String.valueOf(i));
        }
        for (i = 0; i < number_of_genes; ++i) {
            this.geneNamesVector.add(framework.getData().getGeneName(i));
        }
        this.studyDesign = 0;
        boolean useRSAM = true;
        int numCombs = 0;
        int numUniquePerms = 0;
        int numNeighbors = 0;
        this.numMultiClassGroups = 0;
        boolean useKNearest = true;
        boolean isHierarchicalTree = false;
        this.drawSigTreesOnly = true;
        boolean usePreviousGraph = false;
        boolean saveImputedMatrix = false;
        boolean useTusherEtAlS0 = false;
        boolean useAllUniquePerms = false;
        double userPercentile = 0.0;
        if (!SAMState.firstRun) {
            SAMPreDialog spDialog = new SAMPreDialog((JFrame)framework.getFrame(), true);
            spDialog.setVisible(true);
            if (!spDialog.isOkPressed()) {
                return null;
            }
            if (spDialog.usePrevious()) {
                usePreviousGraph = true;
                this.groupAssignments = SAMState.groupAssignments;
                this.isTimeCourse = SAMState.isTimeCourse;
                this.studyDesign = SAMState.studyDesign;
                this.timeCourseData = SAMState.timeCourseData;
                this.startOrEnd = SAMState.startOrEnd;
                if (this.studyDesign == 6) {
                    this.numMultiClassGroups = SAMState.numMultiClassGroups;
                }
                if (this.studyDesign == 5) {
                    this.pairedGroupAExpts = SAMState.pairedGroupAExpts;
                    this.pairedGroupBExpts = SAMState.pairedGroupBExpts;
                }
                if (this.studyDesign == 7) {
                    this.inSurvivalAnalysis = SAMState.inSurvivalAnalysis;
                    this.survivalTimes = SAMState.survivalTimes;
                    this.censored = SAMState.censored;
                } else if (this.studyDesign == 8) {
                    this.oneClassMean = (float)SAMState.oneClassMean;
                }
                useAllUniquePerms = SAMState.useAllUniquePerms;
                if (useAllUniquePerms) {
                    numUniquePerms = SAMState.numUniquePerms;
                }
                numCombs = SAMState.numCombs;
                numNeighbors = SAMState.numNeighbors;
                useKNearest = SAMState.useKNearest;
                isHierarchicalTree = spDialog.drawTrees();
                if (isHierarchicalTree) {
                    this.drawSigTreesOnly = spDialog.drawSigTreesOnly();
                }
                useTusherEtAlS0 = SAMState.useTusherEtAlS0;
                this.calculateQLowestFDR = SAMState.calculateQLowestFDR;
            } else {
                usePreviousGraph = false;
                SAMInitDialog sDialog = new SAMInitDialog((JFrame)framework.getFrame(), true, this.exptNamesVector, number_of_genes, framework.getClusterRepository(1), this.data.getDataType() != 6);
                sDialog.setVisible(true);
                if (!sDialog.isOkPressed()) {
                    return null;
                }
                SAMState.firstRun = false;
                this.studyDesign = sDialog.getStudyDesign();
                this.isTimeCourse = sDialog.isTimeCourse();
                this.timeCourseData = sDialog.getTimeCourse();
                this.startOrEnd = sDialog.getStartEnd();
                SAMState.studyDesign = this.studyDesign;
                if (this.studyDesign == 5) {
                    this.pairedGroupAExpts = sDialog.getPairedAExpts();
                    this.pairedGroupBExpts = sDialog.getPairedBExpts();
                    SAMState.pairedGroupAExpts = this.pairedGroupAExpts;
                    SAMState.pairedGroupBExpts = this.pairedGroupBExpts;
                }
                if (this.studyDesign == 6) {
                    SAMState.numMultiClassGroups = this.numMultiClassGroups = sDialog.getMultiClassNumGroups();
                }
                if (this.studyDesign == 7) {
                    this.inSurvivalAnalysis = sDialog.isInSurvivalAnalysis();
                    SAMState.inSurvivalAnalysis = this.inSurvivalAnalysis;
                    this.censored = sDialog.isCensored();
                    SAMState.censored = this.censored;
                    this.survivalTimes = sDialog.getSurvivalTimes();
                    SAMState.survivalTimes = this.survivalTimes;
                }
                if (this.studyDesign == 8) {
                    this.oneClassMean = (float)sDialog.getOneClassMean();
                    SAMState.oneClassMean = this.oneClassMean;
                }
                this.groupAssignments = sDialog.getGroupAssignments();
                SAMState.groupAssignments = this.groupAssignments;
                SAMState.useRSAM = useRSAM = sDialog.isUseRSAM();
                SAMState.numCombs = numCombs = sDialog.getUserNumCombs();
                SAMState.useAllUniquePerms = useAllUniquePerms = sDialog.useAllUniquePerms();
                if (useAllUniquePerms) {
                    SAMState.numUniquePerms = numUniquePerms = sDialog.getNumUniquePerms();
                }
                SAMState.useKNearest = useKNearest = sDialog.useKNearest();
                if (useKNearest) {
                    SAMState.numNeighbors = numNeighbors = sDialog.getNumNeighbors();
                }
                saveImputedMatrix = sDialog.isSaveMatrix();
                userPercentile = sDialog.getPercentile();
                SAMState.useTusherEtAlS0 = useTusherEtAlS0 = sDialog.useTusherEtAlS0();
                SAMState.calculateQLowestFDR = this.calculateQLowestFDR = sDialog.calculateQLowestFDR();
                isHierarchicalTree = sDialog.drawTrees();
                if (isHierarchicalTree) {
                    this.drawSigTreesOnly = sDialog.drawSigTreesOnly();
                }
            }
        } else {
            usePreviousGraph = false;
            SAMInitDialog sDialog = new SAMInitDialog((JFrame)framework.getFrame(), true, this.exptNamesVector, number_of_genes, framework.getClusterRepository(1), this.data.getDataType() != 6);
            sDialog.setVisible(true);
            if (!sDialog.isOkPressed()) {
                return null;
            }
            SAMState.firstRun = false;
            this.isTimeCourse = sDialog.isTimeCourse();
            this.timeCourseData = sDialog.getTimeCourse();
            this.startOrEnd = sDialog.getStartEnd();
            SAMState.studyDesign = this.studyDesign = sDialog.getStudyDesign();
            SAMState.timeCourseData = this.timeCourseData;
            SAMState.isTimeCourse = this.isTimeCourse;
            if (this.studyDesign == 5) {
                this.pairedGroupAExpts = sDialog.getPairedAExpts();
                this.pairedGroupBExpts = sDialog.getPairedBExpts();
                SAMState.pairedGroupAExpts = this.pairedGroupAExpts;
                SAMState.pairedGroupBExpts = this.pairedGroupBExpts;
            }
            if (this.studyDesign == 6) {
                SAMState.numMultiClassGroups = this.numMultiClassGroups = sDialog.getMultiClassNumGroups();
            }
            if (this.studyDesign == 7) {
                this.inSurvivalAnalysis = sDialog.isInSurvivalAnalysis();
                SAMState.inSurvivalAnalysis = this.inSurvivalAnalysis;
                this.censored = sDialog.isCensored();
                SAMState.censored = this.censored;
                this.survivalTimes = sDialog.getSurvivalTimes();
                SAMState.survivalTimes = this.survivalTimes;
            }
            if (this.studyDesign == 8) {
                this.oneClassMean = (float)sDialog.getOneClassMean();
                SAMState.oneClassMean = this.oneClassMean;
            }
            this.groupAssignments = sDialog.getGroupAssignments();
            SAMState.groupAssignments = this.groupAssignments;
            SAMState.useRSAM = useRSAM = sDialog.isUseRSAM();
            SAMState.numCombs = numCombs = sDialog.getUserNumCombs();
            SAMState.useAllUniquePerms = useAllUniquePerms = sDialog.useAllUniquePerms();
            if (useAllUniquePerms) {
                SAMState.numUniquePerms = numUniquePerms = sDialog.getNumUniquePerms();
            }
            SAMState.useKNearest = useKNearest = sDialog.useKNearest();
            if (useKNearest) {
                SAMState.numNeighbors = numNeighbors = sDialog.getNumNeighbors();
            }
            if (isHierarchicalTree = sDialog.drawTrees()) {
                this.drawSigTreesOnly = sDialog.drawSigTreesOnly();
            }
            saveImputedMatrix = sDialog.isSaveMatrix();
            userPercentile = sDialog.getPercentile();
            SAMState.useTusherEtAlS0 = useTusherEtAlS0 = sDialog.useTusherEtAlS0();
            SAMState.calculateQLowestFDR = this.calculateQLowestFDR = sDialog.calculateQLowestFDR();
        }
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        Listener listener = new Listener();
        try {
            int i2;
            float lowerCutoff;
            float upperCutoff;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("SAM");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "SAM Execution", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", this.experiment.getMatrix());
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
            data.addParam("distance-function", String.valueOf(function));
            data.addIntArray("group-assignments", this.groupAssignments);
            data.addParam("is-time-course", String.valueOf(this.isTimeCourse));
            data.addMatrix("time-course-data", new FloatMatrix(this.timeCourseData, 1));
            data.addIntArray("start-or-end", this.startOrEnd);
            data.addParam("study-design", String.valueOf(this.studyDesign));
            if (this.studyDesign == 5) {
                FloatMatrix pairedAExptsMatrix = new FloatMatrix(this.pairedGroupAExpts.size(), 1);
                FloatMatrix pairedBExptsMatrix = new FloatMatrix(this.pairedGroupBExpts.size(), 1);
                for (int i3 = 0; i3 < this.pairedGroupAExpts.size(); ++i3) {
                    pairedAExptsMatrix.A[i3][0] = ((Integer)this.pairedGroupAExpts.get(i3)).floatValue();
                    pairedBExptsMatrix.A[i3][0] = ((Integer)this.pairedGroupBExpts.get(i3)).floatValue();
                }
                data.addMatrix("pairedAExptsMatrix", pairedAExptsMatrix);
                data.addMatrix("pairedBExptsMatrix", pairedBExptsMatrix);
            }
            if (this.studyDesign == 6) {
                data.addParam("numMultiClassGroups", String.valueOf(this.numMultiClassGroups));
            }
            if (this.studyDesign == 7) {
                FloatMatrix inAnalysisMatrix = new FloatMatrix(this.inSurvivalAnalysis.length, 1);
                FloatMatrix isCensoredMatrix = new FloatMatrix(this.inSurvivalAnalysis.length, 1);
                FloatMatrix survivalTimesMatrix = new FloatMatrix(this.inSurvivalAnalysis.length, 1);
                for (int i4 = 0; i4 < this.inSurvivalAnalysis.length; ++i4) {
                    inAnalysisMatrix.A[i4][0] = !this.inSurvivalAnalysis[i4] ? 0.0f : 1.0f;
                    isCensoredMatrix.A[i4][0] = !this.censored[i4] ? 0.0f : 1.0f;
                    survivalTimesMatrix.A[i4][0] = (float)this.survivalTimes[i4];
                }
                data.addMatrix("inAnalysisMatrix", inAnalysisMatrix);
                data.addMatrix("isCensoredMatrix", isCensoredMatrix);
                data.addMatrix("survivalTimesMatrix", survivalTimesMatrix);
            }
            if (this.studyDesign == 8) {
                data.addParam("oneClassMean", String.valueOf(this.oneClassMean));
            }
            data.addParam("useAllUniquePerms", String.valueOf(useAllUniquePerms));
            if (useAllUniquePerms) {
                data.addParam("numUniquePerms", String.valueOf(numUniquePerms));
            }
            data.addStringArray("geneLabels", this.geneLabels.toArray(new String[this.geneLabels.size()]));
            data.addStringArray("sampleLabels", this.sampleLabels.toArray(new String[this.sampleLabels.size()]));
            data.addParam("use-r-sam", String.valueOf(useRSAM));
            data.addParam("num-combs", String.valueOf(numCombs));
            data.addParam("use-k-nearest", String.valueOf(useKNearest));
            data.addParam("num-neighbors", String.valueOf(numNeighbors));
            data.addParam("saveImputedMatrix", String.valueOf(saveImputedMatrix));
            data.addParam("use-previous-graph", String.valueOf(usePreviousGraph));
            data.addParam("userPercentile", String.valueOf(userPercentile));
            data.addParam("useTusherEtAlS0", String.valueOf(useTusherEtAlS0));
            data.addParam("calculateQLowestFDR", String.valueOf(this.calculateQLowestFDR));
            if (isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            AlgorithmParameters resultMap = result.getParams();
            int k = 0;
            k = this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8 ? 4 : 2;
            this.clusters = new int[k][];
            for (int i5 = 0; i5 < k; ++i5) {
                this.clusters[i5] = nodeList.getNode(i5).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            this.delta = resultMap.getFloat("delta");
            String numSigGenes = resultMap.getString("numSigGenes");
            String numFalseSigMed = resultMap.getString("numFalseSigMed");
            String numFalseSig90th = resultMap.getString("numFalseSig90th");
            String FDRMedianString = resultMap.getString("FDRMedian");
            String FDR90thString = resultMap.getString("FDR90th");
            float sNought = resultMap.getFloat("sNought");
            float s0Percentile = resultMap.getFloat("s0Percentile");
            float pi0Hat = resultMap.getFloat("pi0Hat");
            try {
                upperCutoff = resultMap.getFloat("upperCutoff");
            }
            catch (NumberFormatException nfe) {
                upperCutoff = Float.POSITIVE_INFINITY;
            }
            try {
                lowerCutoff = resultMap.getFloat("lowerCutoff");
            }
            catch (NumberFormatException nfe) {
                lowerCutoff = Float.NEGATIVE_INFINITY;
            }
            boolean useFoldChange = resultMap.getBoolean("useFoldChange");
            useRSAM = resultMap.getBoolean("useR");
            float foldChangeValue = resultMap.getFloat("foldChangeValue");
            FloatMatrix dValuesMatrix = result.getMatrix("dValuesMatrix");
            FloatMatrix rValuesMatrix = result.getMatrix("rValuesMatrix");
            FloatMatrix qLowestFDRMatrix = result.getMatrix("qLowestFDRMatrix");
            FloatMatrix foldChangeMatrix = result.getMatrix("foldChangeMatrix");
            this.dValues = new float[dValuesMatrix.getRowDimension()];
            this.rValues = new float[rValuesMatrix.getRowDimension()];
            this.foldChangeArray = new float[foldChangeMatrix.getRowDimension()];
            this.qLowestFDR = new float[qLowestFDRMatrix.getRowDimension()];
            for (int i6 = 0; i6 < this.dValues.length; ++i6) {
                this.dValues[i6] = dValuesMatrix.A[i6][0];
                this.rValues[i6] = rValuesMatrix.A[i6][0];
                this.qLowestFDR[i6] = qLowestFDRMatrix.A[i6][0];
                this.foldChangeArray[i6] = foldChangeMatrix.A[i6][0];
            }
            FloatMatrix dBarMatrixX = result.getMatrix("dBarMatrixX");
            FloatMatrix sortedDMatrixY = result.getMatrix("sortedDMatrixY");
            this.xArray = new double[dBarMatrixX.getRowDimension()];
            this.yArray = new double[sortedDMatrixY.getRowDimension()];
            for (int i7 = 0; i7 < this.xArray.length; ++i7) {
                this.xArray[i7] = dBarMatrixX.A[i7][0];
                this.yArray[i7] = sortedDMatrixY.A[i7][0];
            }
            FloatMatrix deltaGridMatrix = result.getMatrix("deltaGridMatrix");
            FloatMatrix medNumFalseMatrix = result.getMatrix("medNumFalseMatrix");
            FloatMatrix false90thMatrix = result.getMatrix("false90thMatrix");
            FloatMatrix numSigMatrix = result.getMatrix("numSigMatrix");
            FloatMatrix FDRMedianMatrix = result.getMatrix("FDRMedianMatrix");
            FloatMatrix FDR90thMatrix = result.getMatrix("FDR90thMatrix");
            this.deltaGrid = new double[deltaGridMatrix.getRowDimension()];
            this.medNumFalse = new double[medNumFalseMatrix.getRowDimension()];
            this.false90th = new double[false90thMatrix.getRowDimension()];
            this.numSig = new int[numSigMatrix.getRowDimension()];
            this.FDRMedian = new double[FDRMedianMatrix.getRowDimension()];
            this.FDR90th = new double[FDR90thMatrix.getRowDimension()];
            for (int i8 = 0; i8 < this.deltaGrid.length; ++i8) {
                this.deltaGrid[i8] = deltaGridMatrix.A[i8][0];
                this.medNumFalse[i8] = medNumFalseMatrix.A[i8][0];
                this.false90th[i8] = false90thMatrix.A[i8][0];
                this.numSig[i8] = (int)numSigMatrix.A[i8][0];
                this.FDRMedian[i8] = FDRMedianMatrix.A[i8][0];
                this.FDR90th[i8] = FDR90thMatrix.A[i8][0];
            }
            if (!usePreviousGraph && saveImputedMatrix) {
                FloatMatrix imputedMatrix = result.getMatrix("imputedMatrix");
                JFileChooser fc = new JFileChooser(TMEV.getDataPath());
                fc.setDialogTitle("Save imputed matrix");
                int returnVal = fc.showSaveDialog((JFrame)framework.getFrame());
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        int i9;
                        PrintWriter out = new PrintWriter(new FileOutputStream(file));
                        String[] fieldNames = framework.getData().getFieldNames();
                        for (i9 = 0; i9 < fieldNames.length; ++i9) {
                            out.print(fieldNames[i9]);
                            if (i9 >= fieldNames.length - 1) continue;
                            out.print("\t");
                        }
                        for (i9 = 0; i9 < this.experiment.getNumberOfSamples(); ++i9) {
                            out.print("\t");
                            out.print(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i9)));
                        }
                        out.print("\n");
                        for (i9 = 0; i9 < imputedMatrix.getRowDimension(); ++i9) {
                            for (int f = 0; f < fieldNames.length; ++f) {
                                out.print(framework.getData().getElementAttribute(this.experiment.getGeneIndexMappedToData(i9), f));
                                if (f >= fieldNames.length - 1) continue;
                                out.print("\t");
                            }
                            for (int j = 0; j < imputedMatrix.getColumnDimension(); ++j) {
                                out.print("\t");
                                out.print(Float.toString(imputedMatrix.A[i9][j]));
                            }
                            out.print("\n");
                        }
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.delta = this.delta;
            info.upperCutoff = upperCutoff;
            info.lowerCutoff = lowerCutoff;
            info.useAllUniquePerms = useAllUniquePerms;
            info.numUniquePerms = numUniquePerms;
            if (this.studyDesign == 4 || this.studyDesign == 5) {
                if (useFoldChange) {
                    info.useFoldChange = "Yes";
                    info.foldChangeValue = foldChangeValue;
                } else {
                    info.useFoldChange = "No";
                }
            } else {
                info.useFoldChange = "N/A";
            }
            if (this.studyDesign == 6) {
                info.numMultiClassGroups = this.numMultiClassGroups;
            }
            if (this.studyDesign == 8) {
                info.oneClassMean = this.oneClassMean;
            }
            info.numSigGenes = numSigGenes;
            info.numFalseSigMed = numFalseSigMed;
            info.numFalseSig90th = numFalseSig90th;
            info.FDRMedian = FDRMedianString;
            info.FDR90th = FDR90thString;
            info.studyDesign = this.studyDesign;
            if (useKNearest) {
                info.imputationEngine = "K-Nearest Neighbors";
                info.numNeighbors = numNeighbors;
            } else {
                info.imputationEngine = "Row Average";
            }
            info.useRSAM = useRSAM;
            info.numCombs = numCombs;
            info.sNought = sNought;
            info.s0Percentile = s0Percentile;
            info.pi0Hat = pi0Hat;
            info.hcl = isHierarchicalTree;
            info.hcl_genes = hcl_genes;
            info.hcl_samples = hcl_samples;
            info.hcl_method = hcl_method;
            Vector<String> allFields = new Vector<String>();
            allFields.add("Expected score (dExp)");
            allFields.add(" Observed score(d)");
            allFields.add("Numerator(r)");
            allFields.add("Denominator (s+s0)");
            if (this.studyDesign == 5 || this.studyDesign == 4) {
                allFields.add("Fold change(Unlogged)");
            }
            if (this.calculateQLowestFDR) {
                allFields.add("q-value (%)");
            }
            this.auxTitles = new String[allFields.size()];
            for (i2 = 0; i2 < this.auxTitles.length; ++i2) {
                this.auxTitles[i2] = (String)allFields.get(i2);
            }
            this.auxData = new float[this.experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i2 = 0; i2 < this.auxData.length; ++i2) {
                int counter = 0;
                this.auxData[i2][counter++] = new Float(dBarMatrixX.A[i2][0]).floatValue();
                this.auxData[i2][counter++] = new Float(this.dValues[i2]).floatValue();
                this.auxData[i2][counter++] = new Float(this.rValues[i2]).floatValue();
                this.auxData[i2][counter++] = new Float(this.rValues[i2] / this.dValues[i2]).floatValue();
                if (this.studyDesign == 5 || this.studyDesign == 4) {
                    this.auxData[i2][counter++] = new Float(this.foldChangeArray[i2]).floatValue();
                }
                if (!this.calculateQLowestFDR) continue;
                this.auxData[i2][counter++] = new Float(this.qLowestFDR[i2]).floatValue();
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("SAM");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    private void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addSAMGraph(root);
        this.addSAMDeltaInfo(root);
        this.addExpressionImages(root);
        this.addHierarchicalTrees(root, result_cluster, info);
        this.addCentroidViews(root);
        this.addTableViews(root);
        this.addClusterInfo(root);
        this.addGeneralInfo(root, info);
    }

    private void addSAMGraph(DefaultMutableTreeNode root) {
        SAMGraphViewer sgViewer = new SAMGraphViewer(this.xArray, this.yArray, this.studyDesign, this.delta);
        root.add(new DefaultMutableTreeNode(new LeafInfo("SAM Graph", (IViewer)sgViewer)));
    }

    private void addSAMDeltaInfo(DefaultMutableTreeNode root) {
        SAMDeltaInfoViewer sdInfoViewer = new SAMDeltaInfoViewer(this.deltaGrid, this.medNumFalse, this.false90th, this.numSig, this.FDRMedian, this.FDR90th);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Delta table", (IViewer)sdInfoViewer)));
    }

    private void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        SAMExperimentViewer expViewer = new SAMExperimentViewer(this.experiment, this.clusters, this.studyDesign, this.dValues, this.rValues, this.foldChangeArray, this.qLowestFDR, this.calculateQLowestFDR);
        if (this.studyDesign == 5 || this.studyDesign == 4 || this.studyDesign == 7 || this.studyDesign == 8) {
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i == 1) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i == 2) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("All Significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != 3) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
            }
        } else {
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != 1) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
            }
        }
        root.add(node);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        if (!this.drawSigTreesOnly) {
            if (this.studyDesign == 5 || this.studyDesign == 4 || this.studyDesign == 7 || this.studyDesign == 8) {
                for (int i = 0; i < nodeList.getSize(); ++i) {
                    if (i == 0) {
                        node.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                        continue;
                    }
                    if (i == 1) {
                        node.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                        continue;
                    }
                    if (i == 2) {
                        node.add(new DefaultMutableTreeNode(new LeafInfo("All Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                        continue;
                    }
                    if (i != 3) continue;
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                }
            } else {
                for (int i = 0; i < nodeList.getSize(); ++i) {
                    if (i == 0) {
                        node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                        continue;
                    }
                    if (i != 1) continue;
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                }
            }
        } else if (this.studyDesign == 5 || this.studyDesign == 4 || this.studyDesign == 7 || this.studyDesign == 8) {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                if (i == 0) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                    continue;
                }
                if (i == 1) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                    continue;
                }
                if (i != 2) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo("All Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
            }
        } else {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                if (i != 0) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
            }
        }
        root.add(node);
    }

    private IViewer createHCLViewer(Node clusterNode, GeneralInfo info) {
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData samples_result = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
    }

    private HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    private void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        node.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", (IViewer)new SAMInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.studyDesign))));
        root.add(node);
    }

    private void addTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode tabNode = new DefaultMutableTreeNode("Table Views");
        SAMClusterTableViewer tabViewer = new SAMClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8) {
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    tabNode.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i == 1) {
                    tabNode.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i == 2) {
                    tabNode.add(new DefaultMutableTreeNode(new LeafInfo("All Significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != 3) continue;
                tabNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
            }
        } else {
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    tabNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != 1) continue;
                tabNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
            }
        }
        root.add(tabNode);
    }

    private void addCentroidViews(DefaultMutableTreeNode root) {
        int i;
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        SAMCentroidViewer centroidViewer = new SAMCentroidViewer(this.experiment, this.clusters, this.studyDesign, this.dValues, this.rValues, this.foldChangeArray, this.qLowestFDR, this.calculateQLowestFDR);
        centroidViewer.setMeans(this.means.A);
        centroidViewer.setVariances(this.variances.A);
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8) {
            for (i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                    continue;
                }
                if (i == 1) {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                    continue;
                }
                if (i == 2) {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                    continue;
                }
                if (i != 3) continue;
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
        } else {
            for (i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                    continue;
                }
                if (i != 1) continue;
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
        }
        SAMCentroidsViewer centroidsViewer = new SAMCentroidsViewer(this.experiment, this.clusters, this.studyDesign, this.dValues, this.rValues, this.foldChangeArray, this.qLowestFDR, this.calculateQLowestFDR);
        centroidsViewer.setMeans(this.means.A);
        centroidsViewer.setVariances(this.variances.A);
        centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(0))));
        expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(1))));
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        DefaultMutableTreeNode inputSubNode = new DefaultMutableTreeNode("Input Parameters");
        DefaultMutableTreeNode computedSubNode = new DefaultMutableTreeNode("Computed Quantities");
        inputSubNode.add(new DefaultMutableTreeNode("SAM Version " + (info.useRSAM ? "2.0" : "1.0")));
        inputSubNode.add(new DefaultMutableTreeNode("Study Design: " + info.getStudyDesign()));
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 6 || this.studyDesign == 8) {
            inputSubNode.add(this.getGroupAssignmentInfo(info.studyDesign));
        }
        if (info.studyDesign == 6) {
            inputSubNode.add(new DefaultMutableTreeNode("Number of classes: " + info.numMultiClassGroups));
        }
        if (info.studyDesign == 8) {
            inputSubNode.add(new DefaultMutableTreeNode("Hypothesized one-class mean: " + info.oneClassMean));
        }
        if (info.studyDesign == 7) {
            inputSubNode.add(this.getSampleSurvivalInfo());
        }
        inputSubNode.add(new DefaultMutableTreeNode("Imputation Engine: " + info.imputationEngine));
        if (info.imputationEngine == "K-Nearest Neighbors") {
            inputSubNode.add(new DefaultMutableTreeNode("Number of K-Nearest Neighbors: " + info.numNeighbors));
        }
        inputSubNode.add(new DefaultMutableTreeNode("Delta: " + info.delta));
        inputSubNode.add(new DefaultMutableTreeNode("Upper Cutoff: " + info.upperCutoff));
        inputSubNode.add(new DefaultMutableTreeNode("Lower Cutoff: " + info.lowerCutoff));
        inputSubNode.add(new DefaultMutableTreeNode("All permutations unique? " + info.useAllUniquePerms));
        if (info.useAllUniquePerms) {
            inputSubNode.add(new DefaultMutableTreeNode("Number of unique permutations " + info.numUniquePerms));
        } else {
            inputSubNode.add(new DefaultMutableTreeNode("Number of Permutations: " + info.numCombs));
        }
        inputSubNode.add(new DefaultMutableTreeNode("Fold Change Criterion Used: " + info.useFoldChange));
        if (info.useFoldChange == "Yes") {
            inputSubNode.add(new DefaultMutableTreeNode("Fold Change Value: " + info.foldChangeValue));
        }
        inputSubNode.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        inputSubNode.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        computedSubNode.add(new DefaultMutableTreeNode("Computed Exchangeability Factor s0: " + info.sNought));
        computedSubNode.add(new DefaultMutableTreeNode("s0 Percentile: " + info.s0Percentile));
        computedSubNode.add(new DefaultMutableTreeNode("Pi0Hat: " + info.pi0Hat));
        computedSubNode.add(new DefaultMutableTreeNode("Num. False Sig. Genes (Median): " + info.numFalseSigMed));
        computedSubNode.add(new DefaultMutableTreeNode("Num. False Sig. Genes (90th %ile): " + info.numFalseSig90th));
        computedSubNode.add(new DefaultMutableTreeNode("False Discovery Rate (Median): " + info.FDRMedian + " %"));
        computedSubNode.add(new DefaultMutableTreeNode("False Discovery Rate (90th %ile): " + info.FDR90th + " %"));
        node.add(inputSubNode);
        node.add(computedSubNode);
        root.add(node);
    }

    private DefaultMutableTreeNode getSampleSurvivalInfo() {
        DefaultMutableTreeNode sampleSurvivalInfo = new DefaultMutableTreeNode("Sample information ");
        DefaultMutableTreeNode notInAnalysisNode = new DefaultMutableTreeNode("Not in analysis ");
        for (int i = 0; i < this.inSurvivalAnalysis.length; ++i) {
            DefaultMutableTreeNode sampleNode = new DefaultMutableTreeNode((String)this.exptNamesVector.get(i));
            if (this.inSurvivalAnalysis[i]) {
                sampleNode.add(new DefaultMutableTreeNode("Time: " + this.survivalTimes[i]));
                sampleNode.add(new DefaultMutableTreeNode("State: " + (this.censored[i] ? "Censored" : "Dead")));
                sampleSurvivalInfo.add(sampleNode);
                continue;
            }
            notInAnalysisNode.add(sampleNode);
        }
        if (notInAnalysisNode.getChildCount() > 0) {
            sampleSurvivalInfo.add(notInAnalysisNode);
        }
        return sampleSurvivalInfo;
    }

    private DefaultMutableTreeNode getGroupAssignmentInfo(int studyDesign) {
        DefaultMutableTreeNode groupAssignmentInfo = new DefaultMutableTreeNode("Group assigments ");
        if (studyDesign == 4) {
            DefaultMutableTreeNode groupA = new DefaultMutableTreeNode("Group A ");
            DefaultMutableTreeNode groupB = new DefaultMutableTreeNode("Group B ");
            DefaultMutableTreeNode neitherGroup = new DefaultMutableTreeNode("Neither group ");
            int neitherGroupCounter = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    groupA.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i) + (this.isTimeCourse ? ", Time = " + this.timeCourseData : "")));
                    continue;
                }
                if (this.groupAssignments[i] == 2) {
                    groupB.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i) + (this.isTimeCourse ? ", Time = " + this.timeCourseData : "")));
                    continue;
                }
                neitherGroup.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                ++neitherGroupCounter;
            }
            groupAssignmentInfo.add(groupA);
            groupAssignmentInfo.add(groupB);
            if (neitherGroupCounter > 0) {
                groupAssignmentInfo.add(neitherGroup);
            }
        } else if (studyDesign == 5) {
            int i;
            groupAssignmentInfo = new DefaultMutableTreeNode("Pairings ");
            boolean[] paired = new boolean[this.exptNamesVector.size()];
            for (int i2 = 0; i2 < paired.length; ++i2) {
                paired[i2] = false;
            }
            DefaultMutableTreeNode pairs = new DefaultMutableTreeNode("Sample Pairs");
            DefaultMutableTreeNode nonPairs = new DefaultMutableTreeNode("Unpaired Experiments");
            for (i = 0; i < this.pairedGroupAExpts.size(); ++i) {
                int currentA = (Integer)this.pairedGroupAExpts.get(i);
                int currentB = (Integer)this.pairedGroupBExpts.get(i);
                pairs.add(new DefaultMutableTreeNode("A: " + (String)this.exptNamesVector.get(currentA) + " - B: " + (String)this.exptNamesVector.get(currentB)));
                paired[currentA] = true;
                paired[currentB] = true;
            }
            for (i = 0; i < paired.length; ++i) {
                if (paired[i]) continue;
                nonPairs.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
            }
            groupAssignmentInfo.add(pairs);
            if (!nonPairs.isLeaf()) {
                groupAssignmentInfo.add(nonPairs);
            }
        } else if (studyDesign == 6) {
            int i;
            DefaultMutableTreeNode notInGroups = new DefaultMutableTreeNode("Not in groups");
            DefaultMutableTreeNode[] groups = new DefaultMutableTreeNode[this.numMultiClassGroups];
            for (i = 0; i < this.numMultiClassGroups; ++i) {
                groups[i] = new DefaultMutableTreeNode("Group " + (i + 1));
            }
            for (i = 0; i < this.groupAssignments.length; ++i) {
                int currentGroup = this.groupAssignments[i];
                if (currentGroup == 0) {
                    notInGroups.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                    continue;
                }
                groups[currentGroup - 1].add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
            }
            for (i = 0; i < groups.length; ++i) {
                groupAssignmentInfo.add(groups[i]);
            }
            if (notInGroups.getChildCount() > 0) {
                groupAssignmentInfo.add(notInGroups);
            }
        } else if (studyDesign == 8) {
            groupAssignmentInfo = new DefaultMutableTreeNode("Sample details");
            DefaultMutableTreeNode in = new DefaultMutableTreeNode("In analysis ");
            DefaultMutableTreeNode out = new DefaultMutableTreeNode("Out of analysis ");
            int outCounter = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    in.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i) + (this.isTimeCourse ? ", Time = " + this.timeCourseData : "")));
                    continue;
                }
                out.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                ++outCounter;
            }
            if (outCounter == 0) {
                out.add(new DefaultMutableTreeNode("None"));
            }
            groupAssignmentInfo.add(in);
            groupAssignmentInfo.add(out);
        }
        return groupAssignmentInfo;
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        int i;
        AlgorithmData data = new AlgorithmData();
        SAMFrame = (JFrame)framework.getFrame();
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        this.exptNamesVector = new Vector();
        this.geneNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        for (i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        for (i = 0; i < number_of_genes; ++i) {
            this.geneNamesVector.add(framework.getData().getGeneName(i));
        }
        this.studyDesign = 0;
        int numCombs = 0;
        int numUniquePerms = 0;
        int numNeighbors = 0;
        this.numMultiClassGroups = 0;
        boolean useKNearest = true;
        boolean isHierarchicalTree = false;
        boolean usePreviousGraph = false;
        boolean saveImputedMatrix = false;
        boolean useTusherEtAlS0 = false;
        boolean useAllUniquePerms = false;
        double userPercentile = 0.0;
        usePreviousGraph = false;
        SAMInitDialog sDialog = new SAMInitDialog((JFrame)framework.getFrame(), true, this.exptNamesVector, number_of_genes, framework.getClusterRepository(1), framework.getData().getDataType() != 6);
        sDialog.setVisible(true);
        if (!sDialog.isOkPressed()) {
            return null;
        }
        SAMState.firstRun = false;
        SAMScriptDeltaValueInitDialog deltaDialog = new SAMScriptDeltaValueInitDialog((JFrame)framework.getFrame());
        if (deltaDialog.showModal() != 0) {
            return null;
        }
        boolean graphInteraction = deltaDialog.interactWithGraph();
        if (!graphInteraction) {
            this.delta = deltaDialog.getDeltaValue();
        }
        data.addParam("permit-graph-interaction", String.valueOf(graphInteraction));
        data.addParam("delta", String.valueOf(this.delta));
        SAMState.studyDesign = this.studyDesign = sDialog.getStudyDesign();
        SAMState.isTimeCourse = this.isTimeCourse;
        SAMState.timeCourseData = this.timeCourseData;
        SAMState.startOrEnd = this.startOrEnd;
        if (this.studyDesign == 5) {
            this.pairedGroupAExpts = sDialog.getPairedAExpts();
            this.pairedGroupBExpts = sDialog.getPairedBExpts();
            SAMState.pairedGroupAExpts = this.pairedGroupAExpts;
            SAMState.pairedGroupBExpts = this.pairedGroupBExpts;
        }
        if (this.studyDesign == 6) {
            SAMState.numMultiClassGroups = this.numMultiClassGroups = sDialog.getMultiClassNumGroups();
        }
        if (this.studyDesign == 7) {
            this.inSurvivalAnalysis = sDialog.isInSurvivalAnalysis();
            SAMState.inSurvivalAnalysis = this.inSurvivalAnalysis;
            this.censored = sDialog.isCensored();
            SAMState.censored = this.censored;
            this.survivalTimes = sDialog.getSurvivalTimes();
            SAMState.survivalTimes = this.survivalTimes;
        }
        if (this.studyDesign == 8) {
            this.oneClassMean = (float)sDialog.getOneClassMean();
            SAMState.oneClassMean = this.oneClassMean;
        }
        this.groupAssignments = sDialog.getGroupAssignments();
        SAMState.groupAssignments = this.groupAssignments;
        SAMState.numCombs = numCombs = sDialog.getUserNumCombs();
        SAMState.useAllUniquePerms = useAllUniquePerms = sDialog.useAllUniquePerms();
        if (useAllUniquePerms) {
            SAMState.numUniquePerms = numUniquePerms = sDialog.getNumUniquePerms();
        }
        SAMState.useKNearest = useKNearest = sDialog.useKNearest();
        if (useKNearest) {
            SAMState.numNeighbors = numNeighbors = sDialog.getNumNeighbors();
        }
        isHierarchicalTree = sDialog.drawTrees();
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = sDialog.drawSigTreesOnly();
        }
        saveImputedMatrix = sDialog.isSaveMatrix();
        userPercentile = sDialog.getPercentile();
        SAMState.useTusherEtAlS0 = useTusherEtAlS0 = sDialog.useTusherEtAlS0();
        SAMState.calculateQLowestFDR = this.calculateQLowestFDR = sDialog.calculateQLowestFDR();
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
        data.addParam("distance-function", String.valueOf(function));
        data.addIntArray("group-assignments", this.groupAssignments);
        data.addParam("study-design", String.valueOf(this.studyDesign));
        if (this.studyDesign == 5) {
            FloatMatrix pairedAExptsMatrix = new FloatMatrix(this.pairedGroupAExpts.size(), 1);
            FloatMatrix pairedBExptsMatrix = new FloatMatrix(this.pairedGroupBExpts.size(), 1);
            for (int i2 = 0; i2 < this.pairedGroupAExpts.size(); ++i2) {
                pairedAExptsMatrix.A[i2][0] = ((Integer)this.pairedGroupAExpts.get(i2)).floatValue();
                pairedBExptsMatrix.A[i2][0] = ((Integer)this.pairedGroupBExpts.get(i2)).floatValue();
            }
            data.addMatrix("pairedAExptsMatrix", pairedAExptsMatrix);
            data.addMatrix("pairedBExptsMatrix", pairedBExptsMatrix);
        }
        if (this.studyDesign == 6) {
            data.addParam("numMultiClassGroups", String.valueOf(this.numMultiClassGroups));
        }
        if (this.studyDesign == 7) {
            FloatMatrix inAnalysisMatrix = new FloatMatrix(this.inSurvivalAnalysis.length, 1);
            FloatMatrix isCensoredMatrix = new FloatMatrix(this.inSurvivalAnalysis.length, 1);
            FloatMatrix survivalTimesMatrix = new FloatMatrix(this.inSurvivalAnalysis.length, 1);
            for (int i3 = 0; i3 < this.inSurvivalAnalysis.length; ++i3) {
                inAnalysisMatrix.A[i3][0] = !this.inSurvivalAnalysis[i3] ? 0.0f : 1.0f;
                isCensoredMatrix.A[i3][0] = !this.censored[i3] ? 0.0f : 1.0f;
                survivalTimesMatrix.A[i3][0] = (float)this.survivalTimes[i3];
            }
            data.addMatrix("inAnalysisMatrix", inAnalysisMatrix);
            data.addMatrix("isCensoredMatrix", isCensoredMatrix);
            data.addMatrix("survivalTimesMatrix", survivalTimesMatrix);
        }
        if (this.studyDesign == 8) {
            data.addParam("oneClassMean", String.valueOf(this.oneClassMean));
        }
        data.addParam("useAllUniquePerms", String.valueOf(useAllUniquePerms));
        if (useAllUniquePerms) {
            data.addParam("numUniquePerms", String.valueOf(numUniquePerms));
        }
        data.addParam("num-combs", String.valueOf(numCombs));
        data.addParam("use-k-nearest", String.valueOf(useKNearest));
        data.addParam("num-neighbors", String.valueOf(numNeighbors));
        data.addParam("saveImputedMatrix", String.valueOf(saveImputedMatrix));
        data.addParam("use-previous-graph", String.valueOf(usePreviousGraph));
        data.addParam("userPercentile", String.valueOf(userPercentile));
        data.addParam("useTusherEtAlS0", String.valueOf(useTusherEtAlS0));
        data.addParam("calculateQLowestFDR", String.valueOf(this.calculateQLowestFDR));
        if (isHierarchicalTree) {
            data.addParam("hierarchical-tree", String.valueOf(true));
            data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
            data.addParam("method-linkage", String.valueOf(hcl_method));
            data.addParam("calculate-genes", String.valueOf(hcl_genes));
            data.addParam("calculate-experiments", String.valueOf(hcl_samples));
            data.addParam("hcl-distance-function", String.valueOf(hcl_function));
            data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
        }
        data.addParam("name", "SAM");
        data.addParam("alg-type", "cluster-genes");
        data.addParam("output-class", "partition-output");
        String[] outputNodes = this.studyDesign == 6 ? new String[]{"Significant Genes", "Non-significant Genes"} : new String[]{"Positive Significant Genes", "Negative Significant Genes", "All Significant Genes", "Non-significant Genes"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        int i;
        Listener listener = new Listener();
        this.experiment = experiment;
        algData.addMatrix("experiment", experiment.getMatrix());
        this.data = framework.getData();
        AlgorithmParameters params = algData.getParams();
        this.drawSigTreesOnly = algData.getParams().getBoolean("draw-sig-trees-only");
        this.studyDesign = params.getInt("study-design");
        if (this.studyDesign == 4 || this.studyDesign == 8 || this.studyDesign == 6) {
            this.groupAssignments = algData.getIntArray("group-assignments");
            if (this.studyDesign == 6) {
                this.numMultiClassGroups = params.getInt("numMultiClassGroups");
            }
        } else if (this.studyDesign == 5) {
            FloatMatrix fm = algData.getMatrix("pairedAExptsMatrix");
            this.pairedGroupAExpts = new Vector();
            for (i = 0; i < fm.getRowDimension(); ++i) {
                this.pairedGroupAExpts.addElement(new Integer((int)fm.get(i, 0)));
            }
            fm = algData.getMatrix("pairedBExptsMatrix");
            this.pairedGroupBExpts = new Vector();
            for (i = 0; i < fm.getRowDimension(); ++i) {
                this.pairedGroupBExpts.addElement(new Integer((int)fm.get(i, 0)));
            }
        }
        int number_of_samples = experiment.getNumberOfSamples();
        this.exptNamesVector = new Vector();
        for (i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(i));
        }
        try {
            int i2;
            float lowerCutoff;
            float upperCutoff;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("SAM");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "SAM Execution", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            AlgorithmParameters resultMap = result.getParams();
            int k = 0;
            k = this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 || this.studyDesign == 8 ? 4 : 2;
            this.clusters = new int[k][];
            for (int i3 = 0; i3 < k; ++i3) {
                this.clusters[i3] = nodeList.getNode(i3).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            this.delta = resultMap.getFloat("delta");
            String numSigGenes = resultMap.getString("numSigGenes");
            String numFalseSigMed = resultMap.getString("numFalseSigMed");
            String numFalseSig90th = resultMap.getString("numFalseSig90th");
            String FDRMedianString = resultMap.getString("FDRMedian");
            String FDR90thString = resultMap.getString("FDR90th");
            float sNought = resultMap.getFloat("sNought");
            float s0Percentile = resultMap.getFloat("s0Percentile");
            float pi0Hat = resultMap.getFloat("pi0Hat");
            try {
                upperCutoff = resultMap.getFloat("upperCutoff");
            }
            catch (NumberFormatException nfe) {
                upperCutoff = Float.POSITIVE_INFINITY;
            }
            try {
                lowerCutoff = resultMap.getFloat("lowerCutoff");
            }
            catch (NumberFormatException nfe) {
                lowerCutoff = Float.NEGATIVE_INFINITY;
            }
            boolean useFoldChange = resultMap.getBoolean("useFoldChange");
            float foldChangeValue = resultMap.getFloat("foldChangeValue");
            FloatMatrix dValuesMatrix = result.getMatrix("dValuesMatrix");
            FloatMatrix rValuesMatrix = result.getMatrix("rValuesMatrix");
            FloatMatrix qLowestFDRMatrix = result.getMatrix("qLowestFDRMatrix");
            FloatMatrix foldChangeMatrix = result.getMatrix("foldChangeMatrix");
            this.dValues = new float[dValuesMatrix.getRowDimension()];
            this.rValues = new float[rValuesMatrix.getRowDimension()];
            this.foldChangeArray = new float[foldChangeMatrix.getRowDimension()];
            this.qLowestFDR = new float[qLowestFDRMatrix.getRowDimension()];
            for (int i4 = 0; i4 < this.dValues.length; ++i4) {
                this.dValues[i4] = dValuesMatrix.A[i4][0];
                this.rValues[i4] = rValuesMatrix.A[i4][0];
                this.qLowestFDR[i4] = qLowestFDRMatrix.A[i4][0];
                this.foldChangeArray[i4] = foldChangeMatrix.A[i4][0];
            }
            FloatMatrix dBarMatrixX = result.getMatrix("dBarMatrixX");
            FloatMatrix sortedDMatrixY = result.getMatrix("sortedDMatrixY");
            this.xArray = new double[dBarMatrixX.getRowDimension()];
            this.yArray = new double[sortedDMatrixY.getRowDimension()];
            for (int i5 = 0; i5 < this.xArray.length; ++i5) {
                this.xArray[i5] = dBarMatrixX.A[i5][0];
                this.yArray[i5] = sortedDMatrixY.A[i5][0];
            }
            FloatMatrix deltaGridMatrix = result.getMatrix("deltaGridMatrix");
            FloatMatrix medNumFalseMatrix = result.getMatrix("medNumFalseMatrix");
            FloatMatrix false90thMatrix = result.getMatrix("false90thMatrix");
            FloatMatrix numSigMatrix = result.getMatrix("numSigMatrix");
            FloatMatrix FDRMedianMatrix = result.getMatrix("FDRMedianMatrix");
            FloatMatrix FDR90thMatrix = result.getMatrix("FDR90thMatrix");
            this.deltaGrid = new double[deltaGridMatrix.getRowDimension()];
            this.medNumFalse = new double[medNumFalseMatrix.getRowDimension()];
            this.false90th = new double[false90thMatrix.getRowDimension()];
            this.numSig = new int[numSigMatrix.getRowDimension()];
            this.FDRMedian = new double[FDRMedianMatrix.getRowDimension()];
            this.FDR90th = new double[FDR90thMatrix.getRowDimension()];
            for (int i6 = 0; i6 < this.deltaGrid.length; ++i6) {
                this.deltaGrid[i6] = deltaGridMatrix.A[i6][0];
                this.medNumFalse[i6] = medNumFalseMatrix.A[i6][0];
                this.false90th[i6] = false90thMatrix.A[i6][0];
                this.numSig[i6] = (int)numSigMatrix.A[i6][0];
                this.FDRMedian[i6] = FDRMedianMatrix.A[i6][0];
                this.FDR90th[i6] = FDR90thMatrix.A[i6][0];
            }
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.delta = this.delta;
            info.upperCutoff = upperCutoff;
            info.lowerCutoff = lowerCutoff;
            info.useAllUniquePerms = params.getBoolean("useAllUniquePerms");
            if (info.useAllUniquePerms) {
                info.numUniquePerms = params.getInt("numUniquePerms");
            }
            if (this.studyDesign == 4 || this.studyDesign == 5) {
                if (params.getBoolean("useFoldChange")) {
                    info.useFoldChange = "Yes";
                    info.foldChangeValue = params.getFloat("foldChangeValue");
                } else {
                    info.useFoldChange = "No";
                }
            } else {
                info.useFoldChange = "N/A";
            }
            if (this.studyDesign == 6) {
                info.numMultiClassGroups = params.getInt("numMultiClassGroups");
            }
            if (this.studyDesign == 8) {
                info.oneClassMean = params.getFloat("oneClassMean");
            }
            info.numSigGenes = numSigGenes;
            info.numFalseSigMed = numFalseSigMed;
            info.numFalseSig90th = numFalseSig90th;
            info.FDRMedian = FDRMedianString;
            info.FDR90th = FDR90thString;
            info.studyDesign = this.studyDesign;
            if (params.getBoolean("useKNearest")) {
                info.imputationEngine = "K-Nearest Neighbors";
                info.numNeighbors = params.getInt("numNeighbors");
            } else {
                info.imputationEngine = "Row Average";
            }
            info.useRSAM = params.getBoolean("use-r-sam");
            info.numCombs = params.getInt("num-combs");
            info.sNought = sNought;
            info.s0Percentile = s0Percentile;
            info.pi0Hat = pi0Hat;
            info.hcl = params.getBoolean("hierarchical-tree");
            info.hcl_genes = params.getBoolean("calculate-genes");
            info.hcl_samples = params.getBoolean("calculate-experiments");
            if (info.hcl) {
                info.hcl_method = params.getInt("method-linkage");
            }
            Vector<String> allFields = new Vector<String>();
            allFields.add("Score(d)");
            allFields.add("Numerator(r)");
            allFields.add("Denominator (s+s0)");
            if (this.studyDesign == 5 || this.studyDesign == 4) {
                allFields.add("Fold change (Unlogged)");
            }
            if (this.calculateQLowestFDR) {
                allFields.add("q-value (%)");
            }
            this.auxTitles = new String[allFields.size()];
            for (i2 = 0; i2 < this.auxTitles.length; ++i2) {
                this.auxTitles[i2] = (String)allFields.get(i2);
            }
            this.auxData = new float[experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i2 = 0; i2 < this.auxData.length; ++i2) {
                int counter = 0;
                this.auxData[i2][counter++] = new Float(this.dValues[i2]).floatValue();
                this.auxData[i2][counter++] = new Float(this.rValues[i2]).floatValue();
                this.auxData[i2][counter++] = new Float(this.rValues[i2] / this.dValues[i2]).floatValue();
                if (this.studyDesign == 5 || this.studyDesign == 4) {
                    this.auxData[i2][counter++] = new Float(this.foldChangeArray[i2]).floatValue();
                }
                if (!this.calculateQLowestFDR) continue;
                this.auxData[i2][counter++] = new Float(this.qLowestFDR[i2]).floatValue();
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private class GeneralInfo {
        public boolean useRSAM;
        public int clusters;
        public String sigMethod;
        public String useFoldChange;
        public long time;
        private float delta;
        private float sNought;
        private float s0Percentile;
        private float pi0Hat;
        private float foldChangeValue;
        private float upperCutoff;
        private float lowerCutoff;
        private float oneClassMean;
        private String numSigGenes;
        private String numFalseSigMed;
        private String numFalseSig90th;
        private String FDRMedian;
        private String FDR90th;
        private int studyDesign;
        private int numCombs;
        private int numUniquePerms;
        private String imputationEngine;
        private int numNeighbors;
        private int numMultiClassGroups;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;
        private boolean useAllUniquePerms;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }

        public String getStudyDesign() {
            String study = "None";
            if (this.studyDesign == 4) {
                study = "Two Class Unpaired" + (SAMGUI.this.isTimeCourse ? " Time-course" : "");
            } else if (this.studyDesign == 5) {
                study = "Two Class Paired";
            } else if (this.studyDesign == 6) {
                study = "Multi Class";
            } else if (this.studyDesign == 7) {
                study = "Censored Survival";
            } else if (this.studyDesign == 8) {
                study = "One Class" + (SAMGUI.this.isTimeCourse ? " Time-course" : "");
            }
            return study;
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    SAMGUI.this.progress.setUnits(event.getIntValue());
                    SAMGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    SAMGUI.this.progress.setValue(event.getIntValue());
                    SAMGUI.this.progress.setDescription(event.getDescription());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                SAMGUI.this.algorithm.abort();
                SAMGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SAMGUI.this.algorithm.abort();
            SAMGUI.this.progress.dispose();
        }
    }
}

