/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Expression;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.util.FloatMatrix;

public class SAMExperimentViewer
extends ExperimentViewer {
    private float[] dValues;
    private float[] rValues;
    private float[] foldChangeArray;
    private float[] qLowestFDR;
    private int studyDesign;
    private boolean calculateQLowestFDR;

    public SAMExperimentViewer(Experiment experiment, int[][] clusters, int studyDesign, float[] dValues, float[] rValues, float[] foldChangeArray, float[] qLowestFDR, boolean calculateQLowestFDR) {
        super(experiment, clusters);
        this.initialize(studyDesign, dValues, rValues, foldChangeArray, qLowestFDR, calculateQLowestFDR);
    }

    public SAMExperimentViewer(Experiment experiment, ClusterWrapper clusters, int studyDesign, float[] dValues, float[] rValues, float[] foldChangeArray, float[] qLowestFDR, boolean calculateQLowestFDR) {
        super(experiment, clusters.getClusters());
        this.initialize(studyDesign, dValues, rValues, foldChangeArray, qLowestFDR, calculateQLowestFDR);
    }

    public SAMExperimentViewer(Experiment experiment, ClusterWrapper clusters, int studyDesign, FloatMatrix dValues, FloatMatrix rValues, FloatMatrix foldChangeArray, FloatMatrix qLowestFDR, boolean calculateQLowestFDR) {
        super(experiment, clusters.getClusters());
        this.initialize(studyDesign, dValues.A[0], rValues.A[0], foldChangeArray.A[0], qLowestFDR.A[0], calculateQLowestFDR);
    }

    public SAMExperimentViewer(Experiment e, int[][] clusters, int[] samplesOrder, Boolean drawAnnotations, ExperimentHeader header, Insets insets, Integer exptID, Integer studyDesign, float[] dValues, float[] rValues, float[] foldChangeArray, float[] qLowestFDR, Boolean calculateQLowestFDR) {
        super(e, clusters, samplesOrder, drawAnnotations.booleanValue(), header, insets);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
        this.getHeaderComponent().addMouseListener(listener);
        this.initialize(studyDesign, dValues, rValues, foldChangeArray, qLowestFDR, calculateQLowestFDR);
    }

    public Expression getExpression() {
        return new Expression((Object)this, ((Object)((Object)this)).getClass(), "new", new Object[]{this.getExperiment(), ClusterWrapper.wrapClusters((int[][])this.getClusters()), new Integer(this.studyDesign), new FloatMatrix((float[][])new float[][]{this.dValues}), new FloatMatrix((float[][])new float[][]{this.rValues}), new FloatMatrix((float[][])new float[][]{this.foldChangeArray}), new FloatMatrix((float[][])new float[][]{this.qLowestFDR}), new Boolean(this.calculateQLowestFDR)});
    }

    private void initialize(int studyDesign, float[] dValues, float[] rValues, float[] foldChangeArray, float[] qLowestFDR, boolean calculateQLowestFDR) {
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.studyDesign = studyDesign;
        this.dValues = dValues;
        this.rValues = rValues;
        this.foldChangeArray = foldChangeArray;
        this.qLowestFDR = qLowestFDR;
        this.calculateQLowestFDR = calculateQLowestFDR;
        this.getContentComponent().addMouseListener(listener);
        this.getHeaderComponent().addMouseListener(listener);
    }

    public void saveClusters(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent((Component)((Object)this)) : frame;
        this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
    }

    public void saveCluster(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent((Component)((Object)this)) : frame;
        this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData data, int[] rows) throws Exception {
        File file = SAMExperimentViewer.getFile(frame);
        if (file != null) {
            this.saveCluster(file, experiment, data, rows);
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData data, int[][] clusters) throws Exception {
        File file = SAMExperimentViewer.getFile(frame);
        if (file != null) {
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null || clusters[i].length == 0) continue;
                File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                this.saveCluster(aFile, experiment, data, clusters[i]);
            }
        }
    }

    private void saveCluster(File file, Experiment experiment, IData data, int[] rows) throws Exception {
        int i;
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        out.print("Original row");
        out.print("\t");
        for (i = 0; i < fieldNames.length; ++i) {
            out.print(fieldNames[i]);
            if (i >= fieldNames.length - 1) continue;
            out.print("\t");
        }
        out.print("\t");
        out.print("Score (d)");
        out.print("\t");
        out.print("Numerator (r)\t");
        out.print("Denominator (s+s0)\t");
        if (this.studyDesign == 5 || this.studyDesign == 4) {
            out.print("Fold Change");
        }
        if (this.calculateQLowestFDR) {
            out.print("\t");
            out.print("q-value (%)");
        }
        for (i = 0; i < experiment.getNumberOfSamples(); ++i) {
            out.print("\t");
            out.print(data.getFullSampleName(experiment.getSampleIndex(i)));
        }
        out.print("\n");
        for (i = 0; i < rows.length; ++i) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(rows[i]) + 1));
            out.print("\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(rows[i]), k));
                if (k >= fieldNames.length - 1) continue;
                out.print("\t");
            }
            out.print("\t");
            out.print("" + this.dValues[rows[i]]);
            out.print("\t");
            out.print("" + this.rValues[rows[i]] + "\t");
            out.print("" + this.rValues[rows[i]] / this.dValues[rows[i]] + "\t");
            if (this.studyDesign == 5 || this.studyDesign == 4) {
                out.print("" + this.foldChangeArray[rows[i]]);
            }
            if (this.calculateQLowestFDR) {
                out.print("\t");
                out.print("" + this.qLowestFDR[rows[i]]);
            }
            for (int j = 0; j < experiment.getNumberOfSamples(); ++j) {
                out.print("\t");
                out.print(Float.toString(experiment.get(rows[i], j)));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser fc = new JFileChooser(TMEV.getFile((String)"data/"));
        fc.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        fc.setFileView((FileView)new ExpressionFileView());
        int ret = fc.showSaveDialog(frame);
        if (ret == 0) {
            file = fc.getSelectedFile();
        }
        return file;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("save-cluster-cmd")) {
                SAMExperimentViewer.this.onSaveCluster();
            } else if (command.equals("save-all-clusters-cmd")) {
                SAMExperimentViewer.this.onSaveClusters();
            } else if (command.equals("set-def-color-cmd")) {
                SAMExperimentViewer.this.onSetDefaultColor();
            } else if (command.equals("store-cluster-cmd")) {
                SAMExperimentViewer.this.storeCluster();
            } else if (command.equals("launch-new-session-cmd")) {
                SAMExperimentViewer.this.launchNewSession();
            } else if (command.equals("broadcast-matrix-to-gaggle")) {
                SAMExperimentViewer.this.broadcastClusterGaggle();
            } else if (command.equals("broadcast-namelist-to-gaggle")) {
                SAMExperimentViewer.this.broadcastNamelistGaggle();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || SAMExperimentViewer.this.getCluster() == null || SAMExperimentViewer.this.getCluster().length == 0) {
                return;
            }
            SAMExperimentViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

