/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class SAMDeltaInfoViewer
extends ViewerAdapter {
    private JComponent header;
    private JTextArea content;
    private double[] deltaGrid;
    private double[] medNumFalse;
    private double[] false90th;
    private double[] FDRMedian;
    private double[] FDR90th;
    private int[] numSig;
    private JPopupMenu popup;

    public SAMDeltaInfoViewer(double[] deltaGrid, double[] medNumFalse, double[] false90th, int[] numSig, double[] FDRMedian, double[] FDR90th) {
        this.deltaGrid = deltaGrid;
        this.medNumFalse = medNumFalse;
        this.false90th = false90th;
        this.numSig = numSig;
        this.FDRMedian = FDRMedian;
        this.FDR90th = FDR90th;
        this.header = this.createHeader();
        this.content = this.createContent();
        this.setMaxWidth(this.content, this.header);
    }

    public SAMDeltaInfoViewer(JTextArea content, JComponent header) {
        this.header = header;
        this.content = content;
        this.setMaxWidth(content, header);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setBackground(Color.white);
        panel.setLayout(gridbag);
        constraints.fill = 2;
        constraints.insets = new Insets(10, 200, 10, 200);
        JLabel label1 = new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Delta Table</b></font></body></html>");
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
        gridbag.setConstraints(label1, constraints);
        panel.add(label1);
        JTextArea area = new JTextArea();
        area.setEditable(false);
        StringBuffer sb = new StringBuffer();
        sb.append("  Delta\tMedian false\t90th %ile false\t  # sig. genes\tFDR(%) Median\t   FDR(%) 90th %ile");
        area.setForeground(Color.blue);
        area.setText(sb.toString());
        area.setCaretPosition(0);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 20);
        constraints.anchor = 15;
        constraints.insets = new Insets(10, 0, 0, 0);
        gridbag.setConstraints(area, constraints);
        panel.add(area);
        return panel;
    }

    private JTextArea createContent() {
        JTextArea area = new JTextArea();
        area.setEditable(false);
        StringBuffer sb = new StringBuffer();
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(3);
        nf.setMinimumFractionDigits(3);
        for (int counter = 0; counter < this.deltaGrid.length; ++counter) {
            sb.append("  " + this.printFormat(this.deltaGrid[counter]) + "\t" + this.printFormat(this.medNumFalse[counter]) + "\t" + this.printFormat(this.false90th[counter]) + "\t  " + this.numSig[counter] + "\t" + this.printFormat(this.FDRMedian[counter]) + "\t   " + this.printFormat(this.FDR90th[counter]) + "\n");
        }
        area.setText(sb.toString());
        area.setCaretPosition(0);
        final JFileChooser fc = new JFileChooser(TMEV.getDataPath());
        fc.setDialogTitle("Save delta table");
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Save delta table", GUIFactory.getIcon("save16.gif"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int returnVal = fc.showSaveDialog(SAMDeltaInfoViewer.this.getHeaderComponent());
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        PrintWriter out = new PrintWriter(new FileOutputStream(file));
                        out.print("Delta\tMedian false\t90th %ile false\t# sig. genes\tFDR(%) Median\tFDR(%) 90th %ile\n\n");
                        for (int i = 0; i < SAMDeltaInfoViewer.this.deltaGrid.length; ++i) {
                            out.print(SAMDeltaInfoViewer.this.deltaGrid[i] + "\t" + SAMDeltaInfoViewer.this.medNumFalse[i] + "\t" + SAMDeltaInfoViewer.this.false90th[i] + "\t" + SAMDeltaInfoViewer.this.numSig[i] + "\t" + SAMDeltaInfoViewer.this.FDRMedian[i] + "\t" + SAMDeltaInfoViewer.this.FDR90th[i] + "\n");
                        }
                        out.println();
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        });
        this.popup.add(menuItem);
        area.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SAMDeltaInfoViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    private String printFormat(double d) {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(3);
        nf.setMinimumFractionDigits(3);
        if (Double.isNaN(d)) {
            return "N/A";
        }
        return nf.format(d);
    }
}

