/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Frame;
import java.beans.Expression;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;

public class SAMCentroidViewer
extends CentroidViewer {
    private float[] dValues;
    private float[] rValues;
    private float[] foldChangeArray;
    private float[] qLowestFDR;
    private int studyDesign;
    private boolean calculateQLowestFDR;

    public SAMCentroidViewer(Experiment experiment, int[][] clusters, int studyDesign, float[] dValues, float[] rValues, float[] foldChangeArray, float[] qLowestFDR, boolean calculateQLowestFDR) {
        super(experiment, clusters);
        this.initialize(studyDesign, dValues, rValues, foldChangeArray, qLowestFDR, calculateQLowestFDR);
    }

    public SAMCentroidViewer(Experiment e, ClusterWrapper clusters, Integer studyDesign, float[] dValues, float[] rValues, float[] foldChangeArray, float[] qLowestFDR, Boolean calculateQLowestFDR) {
        this(e, clusters.getClusters(), (int)studyDesign, dValues, rValues, foldChangeArray, qLowestFDR, (boolean)calculateQLowestFDR);
    }

    public SAMCentroidViewer(Experiment e, int[][] clusters, float[][] variances, float[][] means, float[][] codes, Integer studyDesign, float[] dValues, float[] rValues, float[] foldChangeArray, float[] qLowestFDR, Boolean calculateQLowestFDR) {
        super(e, clusters, variances, means, codes);
        this.initialize(studyDesign, dValues, rValues, foldChangeArray, qLowestFDR, calculateQLowestFDR);
    }

    public Expression getExpression() {
        Object[] temp = super.getExpression().getArguments();
        return new Expression((Object)this, ((Object)((Object)this)).getClass(), "new", new Object[]{temp[0], temp[1], new Integer(this.studyDesign), this.dValues, this.rValues, this.foldChangeArray, this.qLowestFDR, new Boolean(this.calculateQLowestFDR)});
    }

    private void initialize(int studyDesign, float[] dValues, float[] rValues, float[] foldChangeArray, float[] qLowestFDR, boolean calculateQLowestFDR) {
        this.studyDesign = studyDesign;
        this.dValues = dValues;
        this.rValues = rValues;
        this.qLowestFDR = qLowestFDR;
        this.calculateQLowestFDR = calculateQLowestFDR;
        this.foldChangeArray = foldChangeArray;
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData data, int[] rows) throws Exception {
        File file = SAMCentroidViewer.getFile(frame);
        if (file != null) {
            this.saveCluster(file, experiment, data, rows);
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData data, int[][] clusters) throws Exception {
        File file = SAMCentroidViewer.getFile(frame);
        if (file != null) {
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null || clusters[i].length == 0) continue;
                File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                this.saveCluster(aFile, experiment, data, clusters[i]);
            }
        }
    }

    private void saveCluster(File file, Experiment experiment, IData data, int[] rows) throws Exception {
        int i;
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        out.print("Original row");
        out.print("\t");
        for (i = 0; i < fieldNames.length; ++i) {
            out.print(fieldNames[i]);
            if (i >= fieldNames.length - 1) continue;
            out.print("\t");
        }
        out.print("\t");
        out.print("Score (d)");
        out.print("\t");
        out.print("Numerator (r)\t");
        out.print("Denominator (s+s0)\t");
        if (this.studyDesign == 5 || this.studyDesign == 4) {
            out.print("Fold change");
        }
        if (this.calculateQLowestFDR) {
            out.print("\t");
            out.print("q-value (%)");
        }
        for (i = 0; i < experiment.getNumberOfSamples(); ++i) {
            out.print("\t");
            out.print(data.getFullSampleName(experiment.getSampleIndex(i)));
        }
        out.print("\n");
        for (i = 0; i < rows.length; ++i) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(rows[i]) + 1));
            out.print("\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(rows[i]), k));
                if (k >= fieldNames.length - 1) continue;
                out.print("\t");
            }
            out.print("\t");
            out.print("" + this.dValues[rows[i]]);
            out.print("\t");
            out.print("" + this.rValues[rows[i]] + "\t");
            out.print("" + this.rValues[rows[i]] / this.dValues[rows[i]] + "\t");
            if (this.studyDesign == 5 || this.studyDesign == 4) {
                out.print("" + this.foldChangeArray[rows[i]]);
            }
            if (this.calculateQLowestFDR) {
                out.print("\t");
                out.print("" + this.qLowestFDR[rows[i]]);
            }
            for (int j = 0; j < experiment.getNumberOfSamples(); ++j) {
                out.print("\t");
                out.print(Float.toString(experiment.get(rows[i], j)));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser fc = new JFileChooser(TMEV.getFile((String)"data/"));
        fc.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        fc.setFileView((FileView)new ExpressionFileView());
        int ret = fc.showSaveDialog(frame);
        if (ret == 0) {
            file = fc.getSelectedFile();
        }
        return file;
    }
}

