/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.tigr.util.awt.ActionInfoDialog;

public class SAMAllPermsDialog
extends ActionInfoDialog {
    JRadioButton allPermsButton;
    JRadioButton somePermsButton;
    int numUniquePerms;
    int numUserPerms;
    JButton okButton;
    boolean okPressed = false;

    public SAMAllPermsDialog(JFrame parentFrame, boolean modality, int numUniquePerms, int numUserPerms) {
        super(parentFrame, "Use all possible unique permutations?", modality);
        this.numUniquePerms = numUniquePerms;
        this.numUserPerms = numUserPerms;
        this.setBounds(0, 0, 400, 150);
        this.setDefaultCloseOperation(0);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        constraints.anchor = 10;
        JLabel numUniquePermsLabel = new JLabel("There are " + numUniquePerms + " unique permutations");
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 25);
        gridbag.setConstraints(numUniquePermsLabel, constraints);
        pane.add(numUniquePermsLabel);
        this.allPermsButton = new JRadioButton("Use all of them", true);
        this.somePermsButton = new JRadioButton("Use just " + numUserPerms + " random permutations as previously specified", false);
        ButtonGroup chooseAllOrSome = new ButtonGroup();
        chooseAllOrSome.add(this.allPermsButton);
        chooseAllOrSome.add(this.somePermsButton);
        constraints.anchor = 17;
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 25);
        gridbag.setConstraints(this.allPermsButton, constraints);
        pane.add(this.allPermsButton);
        this.buildConstraints(constraints, 0, 2, 1, 1, 0, 25);
        gridbag.setConstraints(this.somePermsButton, constraints);
        pane.add(this.somePermsButton);
        constraints.anchor = 10;
        this.okButton = new JButton("OK");
        this.buildConstraints(constraints, 0, 3, 1, 1, 0, 25);
        gridbag.setConstraints(this.okButton, constraints);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SAMAllPermsDialog.this.okPressed = true;
                SAMAllPermsDialog.this.dispose();
            }
        });
        pane.add(this.okButton);
        this.setContentPane(pane);
    }

    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean useAllPerms() {
        return this.allPermsButton.isSelected();
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        SAMAllPermsDialog sDialog = new SAMAllPermsDialog(dummyFrame, true, 20, 100);
        sDialog.setVisible(true);
    }
}

