/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterSelector;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSigOnlyPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class RPInitBox
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    public static final int JUST_ALPHA = 1;
    public static final int STD_BONFERRONI = 2;
    public static final int ADJ_BONFERRONI = 3;
    public static final int MAX_T = 4;
    public static final int FALSE_NUM = 5;
    public static final int FALSE_PROP = 6;
    public static final int ONE_CLASS = 7;
    public static final int TWO_CLASS = 8;
    public static final int PAIRED = 9;
    public static final int BUTTON_SELECTION = 10;
    public static final int CLUSTER_SELECTION = 11;
    boolean okPressed = false;
    boolean okReady = false;
    Vector<String> exptNames;
    MainPanel mPanel;
    PValuePanel pPanel;
    UpDownPanel upDownPanel;
    HCLSigOnlyPanel hclOpsPanel;
    ClusterRepository repository;

    public RPInitBox(JFrame parentFrame, boolean modality, Vector<String> exptNames, ClusterRepository repository) {
        super(parentFrame, "RP Initialization", modality);
        this.exptNames = exptNames;
        this.repository = repository;
        this.setBounds(0, 0, 600, 850);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.okButton.setEnabled(true);
        this.mPanel = new MainPanel();
        JTabbedPane consolidatedPane = new JTabbedPane();
        this.pPanel = new PValuePanel();
        consolidatedPane.add("P-Value/False Discovery Parameters", this.pPanel);
        this.upDownPanel = new UpDownPanel();
        consolidatedPane.add("Targeted Genes", this.upDownPanel);
        this.hclOpsPanel = new HCLSigOnlyPanel();
        consolidatedPane.add("Hierarchical Clusters", this.hclOpsPanel);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 20);
        gridbag.setConstraints(consolidatedPane, constraints);
        pane.add(consolidatedPane);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 20);
        gridbag.setConstraints(this.hclOpsPanel, constraints);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
        gridbag.setConstraints(this.mPanel, constraints);
        pane.add(this.mPanel);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void enableOK() {
        this.okButton.setEnabled(true);
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.hclOpsPanel.drawSigTreesOnly();
    }

    public int getSelectionDesign() {
        int design = -1;
        if (this.getTestDesign() == 7) {
            design = this.mPanel.oneClassmulg.getSelectedIndex() == 0 ? 10 : 11;
        } else if (this.getTestDesign() == 8) {
            design = this.mPanel.twoClassmulg.getSelectedIndex() == 0 ? 10 : 11;
        }
        return design;
    }

    public int getTestDesign() {
        int design = -1;
        if (this.mPanel.chooseDesignPane.getSelectedIndex() == 0) {
            design = 7;
        } else if (this.mPanel.chooseDesignPane.getSelectedIndex() == 1) {
            design = 8;
        } else if (this.mPanel.chooseDesignPane.getSelectedIndex() == 2) {
            design = 9;
        }
        return design;
    }

    public int[] getOneClassAssignments() {
        int[] inGroupAssignments = new int[this.exptNames.size()];
        for (int i = 0; i < this.exptNames.size(); ++i) {
            inGroupAssignments[i] = this.mPanel.oneClassPanel.exptCheckBoxes[i].isSelected() ? 1 : 0;
        }
        return inGroupAssignments;
    }

    public int[] getClusterOneClassAssignments() {
        int j;
        int i;
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[2];
        for (i = 0; i < 2; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.oneClassClusterSelector.getGroupSamples("Samples " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            for (j = 0; j < 2; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[i] = j + 1;
                doubleAssigned = true;
            }
        }
        return groupAssignments;
    }

    public int[] getTwoClassAssignments() {
        int[] groupAssignments = new int[this.exptNames.size()];
        block0: for (int i = 0; i < this.exptNames.size(); ++i) {
            for (int j = 0; j < this.mPanel.twoClassPanel.numberGroups; ++j) {
                if (this.mPanel.twoClassPanel.rbArray[i][j].isSelected()) {
                    groupAssignments[i] = j + 1;
                    continue block0;
                }
                groupAssignments[i] = 0;
            }
        }
        return groupAssignments;
    }

    public int[] getClusterTwoClassAssignments() {
        int j;
        int i;
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[2];
        for (i = 0; i < 2; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.twoClassClusterSelector.getGroupSamples("Samples " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            for (j = 0; j < 2; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[i] = j + 1;
                doubleAssigned = true;
            }
        }
        return groupAssignments;
    }

    public int[] getPairedAExpts() {
        int[] a = new int[this.mPanel.pairedPanel.tcpPanel.pairedAExpts.size()];
        for (int i = 0; i < this.mPanel.pairedPanel.tcpPanel.pairedAExpts.size(); ++i) {
            a[i] = (Integer)this.mPanel.pairedPanel.tcpPanel.pairedAExpts.get(i);
        }
        return a;
    }

    public int[] getPairedBExpts() {
        int[] b = new int[this.mPanel.pairedPanel.tcpPanel.pairedBExpts.size()];
        for (int i = 0; i < this.mPanel.pairedPanel.tcpPanel.pairedBExpts.size(); ++i) {
            b[i] = (Integer)this.mPanel.pairedPanel.tcpPanel.pairedBExpts.get(i);
        }
        return b;
    }

    public boolean usePerms() {
        return true;
    }

    public int getNumPerms() {
        return Integer.parseInt(this.pPanel.timesField.getText());
    }

    public float getPValue() {
        return Float.parseFloat(this.pPanel.pValueInputField.getText());
    }

    public int getFalseNum() {
        return Integer.parseInt(this.pPanel.falseNumField.getText());
    }

    public double getFalseProp() {
        return Double.parseDouble(this.pPanel.falsePropField.getText());
    }

    public boolean validateFalseNum() {
        int a;
        try {
            String falseNum = this.pPanel.falseNumField.getText();
            a = Integer.parseInt(falseNum);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.pPanel.falseNumField.requestFocus();
            this.pPanel.falseNumField.selectAll();
            return false;
        }
        if (a < 0) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.pPanel.falseNumField.requestFocus();
            this.pPanel.falseNumField.selectAll();
            return false;
        }
        return true;
    }

    public boolean validateFalseProp() {
        float a;
        try {
            String falseProp = this.pPanel.falsePropField.getText();
            a = Float.parseFloat(falseProp);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.pPanel.falsePropField.requestFocus();
            this.pPanel.falsePropField.selectAll();
            return false;
        }
        if (a <= 0.0f || a > 1.0f) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.pPanel.falsePropField.requestFocus();
            this.pPanel.falsePropField.selectAll();
            return false;
        }
        return true;
    }

    public int getCorrectionMethod() {
        int method = 1;
        if (this.pPanel.falseNumButton.isSelected()) {
            method = 5;
        } else if (this.pPanel.falsePropButton.isSelected()) {
            method = 6;
        }
        return method;
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        Vector<String> dummyVect = new Vector<String>();
        for (int i = 0; i < 23; ++i) {
            dummyVect.add("Expt " + (i + 1));
        }
        dummyVect.add("Exptsdfsdfsgwegsgsgsd");
        RPInitBox oBox = new RPInitBox(dummyFrame, true, dummyVect, null);
        oBox.setVisible(true);
        System.out.println("end");
        System.exit(0);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            block23: {
                String command = ae.getActionCommand();
                if (command.equals("ok-command")) {
                    if (!RPInitBox.this.okReady) {
                        return;
                    }
                    if (RPInitBox.this.getSelectionDesign() == 11 && RPInitBox.this.repository.isEmpty()) {
                        JOptionPane.showMessageDialog(null, "Cluster Repository is Empty.", "Error", 2);
                        return;
                    }
                    try {
                        if (RPInitBox.this.pPanel.falseNumButton.isSelected() && !RPInitBox.this.validateFalseNum()) {
                            RPInitBox.this.okPressed = false;
                            return;
                        }
                        if (RPInitBox.this.pPanel.falsePropButton.isSelected() && !RPInitBox.this.validateFalseProp()) {
                            RPInitBox.this.okPressed = false;
                            return;
                        }
                        double d = Double.parseDouble(RPInitBox.this.pPanel.pValueInputField.getText());
                        if (RPInitBox.this.getTestDesign() == 7) {
                            int[] inGroupAssignments = RPInitBox.this.getSelectionDesign() == 11 ? RPInitBox.this.getClusterOneClassAssignments() : RPInitBox.this.getOneClassAssignments();
                            int inNum = 0;
                            while (inGroupAssignments[inNum] != 1) {
                                if (++inNum != inGroupAssignments.length) continue;
                                JOptionPane.showMessageDialog(null, "No samples have been assigned to the analysis.", "Error!", 0);
                                RPInitBox.this.okPressed = false;
                                return;
                            }
                        } else if (RPInitBox.this.getTestDesign() == 8) {
                            int[] inGroupAssignments = RPInitBox.this.getSelectionDesign() == 11 ? RPInitBox.this.getClusterTwoClassAssignments() : RPInitBox.this.getTwoClassAssignments();
                            int grpA = 0;
                            int grpB = 0;
                            for (int i = 0; i < inGroupAssignments.length; ++i) {
                                if (inGroupAssignments[i] == 1) {
                                    ++grpA;
                                }
                                if (inGroupAssignments[i] != 2) continue;
                                ++grpB;
                            }
                            if (grpA < 2 || grpB < 2) {
                                JOptionPane.showMessageDialog(null, "At least 2 samples must be assigned to each group.", "Error!", 0);
                                RPInitBox.this.okPressed = false;
                                return;
                            }
                        } else if (RPInitBox.this.getTestDesign() == 9 && RPInitBox.this.mPanel.pairedPanel.tcpPanel.pairedListModel.size() < 2) {
                            JOptionPane.showMessageDialog(null, "Need at least two pairs of samples!", "Error", 0);
                            return;
                        }
                        if (d <= 0.0 || d > 1.0 || RPInitBox.this.usePerms() && RPInitBox.this.getNumPerms() <= 1) {
                            JOptionPane.showMessageDialog(null, "Valid inputs: 0 < alpha < 1, and # of permutations (integer only) > 1", "Error!", 0);
                            break block23;
                        }
                        RPInitBox.this.okPressed = true;
                        RPInitBox.this.dispose();
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(null, "Valid inputs: 0 < alpha < 1, and # of permutations (integer only) > 1", "Error!", 0);
                    }
                } else if (command.equals("reset-command")) {
                    RPInitBox.this.mPanel.reset();
                    RPInitBox.this.pPanel.reset();
                } else if (command.equals("cancel-command")) {
                    RPInitBox.this.okPressed = false;
                    RPInitBox.this.dispose();
                } else if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(RPInitBox.this, "Rank Products- Initialization Dialog");
                }
            }
        }
    }

    class PValuePanel
    extends JPanel {
        JLabel numPermsLabel;
        JTextField timesField;
        JTextField pValueInputField;
        JTextField falseNumField;
        JTextField falsePropField;
        JRadioButton pValueButton;
        JRadioButton falseNumButton;
        JRadioButton falsePropButton;

        public PValuePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "P-value / false discovery parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setBackground(Color.white);
            this.setLayout(gridbag);
            this.numPermsLabel = new JLabel("Enter number of permutations");
            RPInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 25);
            constraints.anchor = 13;
            gridbag.setConstraints(this.numPermsLabel, constraints);
            this.add(this.numPermsLabel);
            this.timesField = new JTextField("100", 7);
            this.timesField.setMinimumSize(new Dimension(50, 20));
            RPInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 25);
            constraints.anchor = 17;
            gridbag.setConstraints(this.timesField, constraints);
            this.add(this.timesField);
            JPanel pValSelectionPanel = new JPanel();
            pValSelectionPanel.setBackground(Color.white);
            pValSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(1), "P-Value Cutoff ", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout pValSelectionPanelgrid = new GridBagLayout();
            pValSelectionPanel.setLayout(pValSelectionPanelgrid);
            this.pValueButton = new JRadioButton("", true);
            this.pValueButton.setFocusPainted(false);
            this.pValueButton.setForeground(UIManager.getColor("Label.foreground"));
            this.pValueButton.setBackground(Color.white);
            pValSelectionPanel.add(this.pValueButton);
            JLabel pValueLabel = new JLabel("Enter alpha (critical p-value): ");
            RPInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 25);
            constraints.anchor = 17;
            pValSelectionPanelgrid.setConstraints(pValueLabel, constraints);
            pValSelectionPanel.add(pValueLabel);
            this.pValueInputField = new JTextField("0.01", 7);
            this.pValueInputField.setMinimumSize(new Dimension(50, 20));
            RPInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 33, 0);
            constraints.anchor = 13;
            pValSelectionPanelgrid.setConstraints(this.pValueInputField, constraints);
            pValSelectionPanel.add(this.pValueInputField);
            RPInitBox.this.buildConstraints(constraints, 0, 1, 2, 1, 33, 25);
            constraints.anchor = 13;
            constraints.fill = 2;
            gridbag.setConstraints(pValSelectionPanel, constraints);
            this.add(pValSelectionPanel);
            constraints.anchor = 10;
            this.falseNumButton = new JRadioButton("EITHER, The number of false significant genes should not exceed", false);
            this.falseNumButton.setFocusPainted(false);
            this.falseNumButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falseNumButton.setBackground(Color.white);
            this.falsePropButton = new JRadioButton("OR, The proportion of false significant genes should not exceed", false);
            this.falsePropButton.setFocusPainted(false);
            this.falsePropButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falsePropButton.setBackground(Color.white);
            this.falseNumField = new JTextField(10);
            this.falseNumField.setText("10");
            this.falseNumField.setMinimumSize(new Dimension(50, 20));
            this.falsePropField = new JTextField(10);
            this.falsePropField.setText("0.05");
            this.falsePropField.setMinimumSize(new Dimension(50, 20));
            ButtonGroup chooseCorrection = new ButtonGroup();
            chooseCorrection.add(this.falseNumButton);
            chooseCorrection.add(this.falsePropButton);
            chooseCorrection.add(this.pValueButton);
            JPanel FDRPanel = new JPanel();
            FDRPanel.setBackground(Color.white);
            FDRPanel.setBorder(new TitledBorder(new EtchedBorder(1), "False discovery control ", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout grid3 = new GridBagLayout();
            FDRPanel.setLayout(grid3);
            JLabel FDRLabel = new JLabel("With confidence of [1 - alpha] : ");
            constraints.anchor = 17;
            RPInitBox.this.buildConstraints(constraints, 0, 0, 2, 1, 100, 34);
            grid3.setConstraints(FDRLabel, constraints);
            FDRPanel.add(FDRLabel);
            constraints.anchor = 10;
            RPInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 50, 33);
            constraints.anchor = 13;
            grid3.setConstraints(this.falseNumButton, constraints);
            FDRPanel.add(this.falseNumButton);
            RPInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid3.setConstraints(this.falseNumField, constraints);
            FDRPanel.add(this.falseNumField);
            RPInitBox.this.buildConstraints(constraints, 0, 2, 1, 1, 50, 33);
            constraints.anchor = 13;
            grid3.setConstraints(this.falsePropButton, constraints);
            FDRPanel.add(this.falsePropButton);
            RPInitBox.this.buildConstraints(constraints, 1, 2, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid3.setConstraints(this.falsePropField, constraints);
            FDRPanel.add(this.falsePropField);
            constraints.anchor = 10;
            RPInitBox.this.buildConstraints(constraints, 0, 3, 4, 1, 100, 50);
            gridbag.setConstraints(FDRPanel, constraints);
            this.add(FDRPanel);
        }

        protected void reset() {
            this.pValueInputField.setText("0.01");
        }
    }

    class UpDownPanel
    extends JPanel {
        JRadioButton upButton;
        JRadioButton downButton;
        JRadioButton bothButton;

        public UpDownPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Find regulated genes", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setBackground(Color.white);
            this.setLayout(gridbag);
            this.upButton = new JRadioButton("Up-Regulated", false);
            this.downButton = new JRadioButton("Down-Regulated", false);
            this.bothButton = new JRadioButton("Both", true);
            this.upButton.setBackground(Color.white);
            this.downButton.setBackground(Color.white);
            this.bothButton.setBackground(Color.white);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.upButton);
            buttonGroup.add(this.downButton);
            buttonGroup.add(this.bothButton);
            RPInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.upButton, constraints);
            this.add(this.upButton);
            RPInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.downButton, constraints);
            this.add(this.downButton);
            RPInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.bothButton, constraints);
            this.add(this.bothButton);
        }

        public int getUpDown() {
            if (this.upButton.isSelected()) {
                return 1;
            }
            if (this.downButton.isSelected()) {
                return 2;
            }
            if (this.bothButton.isSelected()) {
                return 3;
            }
            return 0;
        }
    }

    class TwoClassPairedPanel
    extends JPanel {
        ExperimentButton[] exptButtons;
        GridBagConstraints constraints;
        GridBagLayout gridbag;
        JTextField currentATextField;
        JTextField currentBTextField;
        JButton removeCurrentAButton;
        JButton removeCurrentBButton;
        JButton loadABPairButton;
        JButton removeABPairButton;
        PairedExperimentsPanel pairPanel;
        JList pairedExptsList;
        DefaultListModel pairedListModel;
        boolean currentAFilled = false;
        boolean currentBFilled = false;
        int currentAExpt = -1;
        int currentBExpt = -1;
        int numPanels = 0;
        Vector pairedAExpts = new Vector();
        Vector pairedBExpts = new Vector();

        public TwoClassPairedPanel() {
            this.constraints = new GridBagConstraints();
            this.gridbag = new GridBagLayout();
            this.setLayout(this.gridbag);
            this.pairedListModel = new DefaultListModel();
            this.pairedExptsList = new JList(this.pairedListModel);
            this.numPanels = RPInitBox.this.exptNames.size() / 512 + 1;
            JPanel[] panels = new JPanel[this.numPanels];
            int currPanel = 0;
            for (int i = 0; i < panels.length; ++i) {
                panels[i] = new JPanel(this.gridbag);
            }
            this.exptButtons = new ExperimentButton[RPInitBox.this.exptNames.size()];
            int maxWidth = 0;
            int maxNameLength = 0;
            for (int i = 0; i < RPInitBox.this.exptNames.size(); ++i) {
                String s;
                int currentNameLength;
                this.exptButtons[i] = new ExperimentButton(i);
                currPanel = i / 512;
                if (this.exptButtons[i].getPreferredSize().getWidth() > (double)maxWidth) {
                    maxWidth = (int)Math.ceil(this.exptButtons[i].getPreferredSize().getWidth());
                }
                if ((currentNameLength = (s = RPInitBox.this.exptNames.get(i)).length()) > maxNameLength) {
                    maxNameLength = currentNameLength;
                }
                RPInitBox.this.buildConstraints(this.constraints, 0, i % 512, 1, 1, 100, 100);
                this.constraints.fill = 1;
                this.gridbag.setConstraints(this.exptButtons[i], this.constraints);
                panels[currPanel].add(this.exptButtons[i]);
            }
            this.currentATextField = new JTextField("", maxNameLength + 2);
            this.currentBTextField = new JTextField("", maxNameLength + 2);
            this.currentATextField.setBackground(Color.white);
            this.currentBTextField.setBackground(Color.white);
            this.currentATextField.setEditable(false);
            this.currentBTextField.setEditable(false);
            JPanel bigPanel = new JPanel(new GridBagLayout());
            for (int i = 0; i < this.numPanels; ++i) {
                bigPanel.add((Component)panels[i], new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JScrollPane scroll = new JScrollPane(bigPanel);
            scroll.setHorizontalScrollBarPolicy(32);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.getHorizontalScrollBar().setUnitIncrement(20);
            scroll.getVerticalScrollBar().setUnitIncrement(20);
            RPInitBox.this.buildConstraints(this.constraints, 0, 0, 2, 1, 40, 100);
            this.constraints.insets = new Insets(5, 5, 5, 5);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(scroll, this.constraints);
            this.add(scroll);
            this.constraints.fill = 0;
            JPanel currentSelectionPanel = new JPanel();
            GridBagLayout grid2 = new GridBagLayout();
            currentSelectionPanel.setLayout(grid2);
            this.removeCurrentAButton = new JButton("< Remove A");
            this.removeCurrentBButton = new JButton("< Remove B");
            this.loadABPairButton = new JButton("   Load Pair >>   ");
            this.removeABPairButton = new JButton("<< Remove Pair");
            this.removeCurrentAButton.setEnabled(false);
            this.removeCurrentBButton.setEnabled(false);
            this.loadABPairButton.setEnabled(false);
            this.removeABPairButton.setEnabled(false);
            this.removeCurrentAButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TwoClassPairedPanel.this.exptButtons[TwoClassPairedPanel.this.currentAExpt].setEnabled(true);
                    TwoClassPairedPanel.this.currentAExpt = -1;
                    TwoClassPairedPanel.this.currentATextField.setText("");
                    TwoClassPairedPanel.this.currentAFilled = false;
                    TwoClassPairedPanel.this.removeCurrentAButton.setEnabled(false);
                    TwoClassPairedPanel.this.loadABPairButton.setEnabled(false);
                }
            });
            this.removeCurrentBButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TwoClassPairedPanel.this.exptButtons[TwoClassPairedPanel.this.currentBExpt].setEnabled(true);
                    TwoClassPairedPanel.this.currentBExpt = -1;
                    TwoClassPairedPanel.this.currentBTextField.setText("");
                    TwoClassPairedPanel.this.currentBFilled = false;
                    TwoClassPairedPanel.this.removeCurrentBButton.setEnabled(false);
                    TwoClassPairedPanel.this.loadABPairButton.setEnabled(false);
                }
            });
            this.loadABPairButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String currentPair = "A: " + RPInitBox.this.exptNames.get(TwoClassPairedPanel.this.currentAExpt) + " - B: " + RPInitBox.this.exptNames.get(TwoClassPairedPanel.this.currentBExpt);
                    TwoClassPairedPanel.this.pairedListModel.addElement(currentPair);
                    TwoClassPairedPanel.this.pairedAExpts.add(new Integer(TwoClassPairedPanel.this.currentAExpt));
                    TwoClassPairedPanel.this.pairedBExpts.add(new Integer(TwoClassPairedPanel.this.currentBExpt));
                    TwoClassPairedPanel.this.currentAExpt = -1;
                    TwoClassPairedPanel.this.currentBExpt = -1;
                    TwoClassPairedPanel.this.currentATextField.setText("");
                    TwoClassPairedPanel.this.currentBTextField.setText("");
                    TwoClassPairedPanel.this.currentAFilled = false;
                    TwoClassPairedPanel.this.currentBFilled = false;
                    TwoClassPairedPanel.this.removeCurrentAButton.setEnabled(false);
                    TwoClassPairedPanel.this.removeCurrentBButton.setEnabled(false);
                    TwoClassPairedPanel.this.loadABPairButton.setEnabled(false);
                    TwoClassPairedPanel.this.removeABPairButton.setEnabled(true);
                    TwoClassPairedPanel.this.pairedExptsList.setSelectedIndex(TwoClassPairedPanel.this.pairedListModel.size() - 1);
                }
            });
            this.removeABPairButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int index = TwoClassPairedPanel.this.pairedExptsList.getSelectedIndex();
                    TwoClassPairedPanel.this.pairedListModel.removeElementAt(index);
                    int removedAIndex = (Integer)TwoClassPairedPanel.this.pairedAExpts.remove(index);
                    int removedBIndex = (Integer)TwoClassPairedPanel.this.pairedBExpts.remove(index);
                    TwoClassPairedPanel.this.exptButtons[removedAIndex].setEnabled(true);
                    TwoClassPairedPanel.this.exptButtons[removedBIndex].setEnabled(true);
                    if (TwoClassPairedPanel.this.pairedListModel.isEmpty()) {
                        TwoClassPairedPanel.this.removeABPairButton.setEnabled(false);
                    } else {
                        TwoClassPairedPanel.this.pairedExptsList.setSelectedIndex(TwoClassPairedPanel.this.pairedListModel.size() - 1);
                    }
                }
            });
            JScrollPane currentAScroll = new JScrollPane(this.currentATextField);
            currentAScroll.setMinimumSize(new Dimension(90, 50));
            JScrollPane currentBScroll = new JScrollPane(this.currentBTextField);
            currentBScroll.setMinimumSize(new Dimension(90, 50));
            currentAScroll.setHorizontalScrollBarPolicy(32);
            currentAScroll.setVerticalScrollBarPolicy(21);
            currentBScroll.setHorizontalScrollBarPolicy(32);
            currentBScroll.setVerticalScrollBarPolicy(21);
            currentAScroll.getHorizontalScrollBar().setUnitIncrement(20);
            currentAScroll.getVerticalScrollBar().setUnitIncrement(20);
            currentBScroll.getHorizontalScrollBar().setUnitIncrement(20);
            currentBScroll.getVerticalScrollBar().setUnitIncrement(20);
            RPInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 20, 50);
            grid2.setConstraints(this.removeCurrentAButton, this.constraints);
            currentSelectionPanel.add(this.removeCurrentAButton);
            JLabel aLabel = new JLabel(" Current A: ");
            RPInitBox.this.buildConstraints(this.constraints, 1, 0, 1, 1, 20, 0);
            grid2.setConstraints(aLabel, this.constraints);
            currentSelectionPanel.add(aLabel);
            RPInitBox.this.buildConstraints(this.constraints, 2, 0, 1, 1, 60, 0);
            this.constraints.fill = 1;
            grid2.setConstraints(currentAScroll, this.constraints);
            currentSelectionPanel.add(currentAScroll);
            this.constraints.fill = 0;
            RPInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 20, 50);
            grid2.setConstraints(this.removeCurrentBButton, this.constraints);
            currentSelectionPanel.add(this.removeCurrentBButton);
            JLabel bLabel = new JLabel("Current B: ");
            RPInitBox.this.buildConstraints(this.constraints, 1, 1, 1, 1, 20, 0);
            grid2.setConstraints(bLabel, this.constraints);
            currentSelectionPanel.add(bLabel);
            RPInitBox.this.buildConstraints(this.constraints, 2, 1, 1, 1, 60, 0);
            this.constraints.fill = 1;
            grid2.setConstraints(currentBScroll, this.constraints);
            currentSelectionPanel.add(currentBScroll);
            this.constraints.fill = 0;
            RPInitBox.this.buildConstraints(this.constraints, 1, 1, 1, 1, 10, 0);
            this.gridbag.setConstraints(currentSelectionPanel, this.constraints);
            this.add(currentSelectionPanel);
            this.constraints.fill = 0;
            JPanel pairButtonsPanel = new JPanel();
            GridBagLayout grid3 = new GridBagLayout();
            pairButtonsPanel.setLayout(grid3);
            RPInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 50);
            grid3.setConstraints(this.loadABPairButton, this.constraints);
            pairButtonsPanel.add(this.loadABPairButton);
            RPInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 50);
            grid3.setConstraints(this.removeABPairButton, this.constraints);
            pairButtonsPanel.add(this.removeABPairButton);
            RPInitBox.this.buildConstraints(this.constraints, 2, 1, 1, 1, 5, 0);
            this.gridbag.setConstraints(pairButtonsPanel, this.constraints);
            this.add(pairButtonsPanel);
            RPInitBox.this.buildConstraints(this.constraints, 2, 0, 1, 1, 45, 0);
            this.constraints.fill = 1;
            JScrollPane pairScroll = new JScrollPane(this.pairedExptsList);
            pairScroll.setBorder(new TitledBorder("Paired Samples"));
            this.gridbag.setConstraints(pairScroll, this.constraints);
            this.add(pairScroll);
        }

        public void reset() {
            for (int i = 0; i < this.exptButtons.length; ++i) {
                this.exptButtons[i].setEnabled(true);
                this.currentATextField.setText("");
                this.currentBTextField.setText("");
                this.removeCurrentAButton.setEnabled(false);
                this.removeCurrentBButton.setEnabled(false);
                this.loadABPairButton.setEnabled(false);
                this.removeABPairButton.setEnabled(false);
                this.pairedListModel.clear();
                this.currentAFilled = false;
                this.currentBFilled = false;
                this.currentAExpt = -1;
                this.currentBExpt = -1;
                this.pairedAExpts.clear();
                this.pairedBExpts.clear();
            }
        }

        class PairedExperimentsPanel
        extends JPanel {
        }

        class ExperimentButton
        extends JButton {
            String s;
            int index;

            public ExperimentButton(int i) {
                this.index = i;
                this.s = RPInitBox.this.exptNames.get(i);
                this.setText(this.s);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (TwoClassPairedPanel.this.currentAFilled && TwoClassPairedPanel.this.currentBFilled) {
                            JOptionPane.showMessageDialog(null, "Clear at least one current field first!", "Error", 0);
                        } else if (!TwoClassPairedPanel.this.currentAFilled) {
                            TwoClassPairedPanel.this.currentAExpt = ExperimentButton.this.index;
                            TwoClassPairedPanel.this.currentATextField.setText(ExperimentButton.this.s);
                            TwoClassPairedPanel.this.currentAFilled = true;
                            ExperimentButton.this.setEnabled(false);
                            TwoClassPairedPanel.this.removeCurrentAButton.setEnabled(true);
                        } else if (!TwoClassPairedPanel.this.currentBFilled) {
                            TwoClassPairedPanel.this.currentBExpt = ExperimentButton.this.index;
                            TwoClassPairedPanel.this.currentBTextField.setText(ExperimentButton.this.s);
                            TwoClassPairedPanel.this.currentBFilled = true;
                            ExperimentButton.this.setEnabled(false);
                            TwoClassPairedPanel.this.removeCurrentBButton.setEnabled(true);
                        }
                        if (TwoClassPairedPanel.this.currentAFilled && TwoClassPairedPanel.this.currentBFilled) {
                            TwoClassPairedPanel.this.loadABPairButton.setEnabled(true);
                        } else {
                            TwoClassPairedPanel.this.loadABPairButton.setEnabled(false);
                        }
                    }
                });
            }
        }
    }

    class TwoClassPairedMainPanel
    extends JPanel {
        TwoClassPairedPanel tcpPanel;
        JButton saveButton;
        JButton resetButton;
        JButton loadButton;
        GridBagConstraints constraints;
        GridBagLayout gridbag;
        JLabel lotsOfSamplesWarningLabel;

        public TwoClassPairedMainPanel() {
            this.tcpPanel = new TwoClassPairedPanel();
            JPanel bottomPanel = new JPanel();
            bottomPanel.setBackground(Color.white);
            this.constraints = new GridBagConstraints();
            this.gridbag = new GridBagLayout();
            this.setLayout(this.gridbag);
            RPInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 90);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.tcpPanel, this.constraints);
            this.add(this.tcpPanel);
            GridBagLayout grid1 = new GridBagLayout();
            bottomPanel.setLayout(grid1);
            this.saveButton = new JButton("Save pairings");
            final JFileChooser fc = new JFileChooser(TMEV.getDataPath());
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int returnVal = fc.showSaveDialog(TwoClassPairedMainPanel.this);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        try {
                            PrintWriter out = new PrintWriter(new FileOutputStream(file));
                            for (int i = 0; i < TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.size(); ++i) {
                                int currentA = (Integer)TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.get(i);
                                int currentB = (Integer)TwoClassPairedMainPanel.this.tcpPanel.pairedBExpts.get(i);
                                out.print(currentA);
                                out.print("\t");
                                out.print(currentB);
                                out.print("\t");
                                out.println();
                            }
                            out.flush();
                            out.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            });
            this.constraints.fill = 0;
            RPInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 33, 100);
            grid1.setConstraints(this.saveButton, this.constraints);
            bottomPanel.add(this.saveButton);
            this.loadButton = new JButton("Load pairings");
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                }
            });
            RPInitBox.this.buildConstraints(this.constraints, 1, 1, 1, 1, 33, 100);
            grid1.setConstraints(this.loadButton, this.constraints);
            bottomPanel.add(this.loadButton);
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TwoClassPairedMainPanel.this.tcpPanel.reset();
                }
            });
            RPInitBox.this.buildConstraints(this.constraints, 2, 1, 1, 1, 34, 100);
            grid1.setConstraints(this.resetButton, this.constraints);
            bottomPanel.add(this.resetButton);
            RPInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 0, 10);
            this.gridbag.setConstraints(bottomPanel, this.constraints);
            this.add(bottomPanel);
        }
    }

    class MainPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        ExperimentsPanel oneClassPanel;
        ExperimentsPanel twoClassPanel;
        TwoClassPairedMainPanel pairedPanel;
        JTabbedPane chooseDesignPane;
        JTabbedPane oneClassmulg;
        JTabbedPane twoClassmulg;
        ClusterSelector oneClassClusterSelector;
        ClusterSelector twoClassClusterSelector;
        float alpha;

        public MainPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            RPInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.constraints.fill = 1;
            RPInitBox.this.okReady = true;
            try {
                this.oneClassPanel = new ExperimentsPanel(RPInitBox.this.exptNames, 1);
                this.twoClassPanel = new ExperimentsPanel(RPInitBox.this.exptNames, 2);
                this.oneClassClusterSelector = new ClusterSelector(RPInitBox.this.repository, 1, "Samples");
                if (RPInitBox.this.repository != null) {
                    this.oneClassClusterSelector.setClusterType("Experiment");
                }
                this.twoClassClusterSelector = new ClusterSelector(RPInitBox.this.repository, 2, "Samples");
                if (RPInitBox.this.repository != null) {
                    this.twoClassClusterSelector.setClusterType("Experiment");
                }
                JPanel oneClassClusterSelectorPanel = new JPanel();
                oneClassClusterSelectorPanel.setLayout(new GridBagLayout());
                JPanel twoClassClusterSelectorPanel = new JPanel();
                twoClassClusterSelectorPanel.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 1;
                c.weighty = 1.0;
                c.weightx = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.gridwidth = 1;
                c.anchor = 20;
                oneClassClusterSelectorPanel.add((Component)this.oneClassClusterSelector, c);
                twoClassClusterSelectorPanel.add((Component)this.twoClassClusterSelector, c);
                this.oneClassmulg = new JTabbedPane();
                this.oneClassmulg.add("Button Selection", this.oneClassPanel);
                this.oneClassmulg.add("Cluster Selection", oneClassClusterSelectorPanel);
                this.oneClassmulg.setSelectedIndex(1);
                if (RPInitBox.this.repository == null || RPInitBox.this.repository.isEmpty()) {
                    this.oneClassmulg.setSelectedIndex(0);
                }
                this.twoClassmulg = new JTabbedPane();
                this.twoClassmulg.add("Button Selection", this.twoClassPanel);
                this.twoClassmulg.add("Cluster Selection", twoClassClusterSelectorPanel);
                this.twoClassmulg.setSelectedIndex(1);
                if (RPInitBox.this.repository == null || RPInitBox.this.repository.isEmpty()) {
                    this.twoClassmulg.setSelectedIndex(0);
                }
                this.pairedPanel = new TwoClassPairedMainPanel();
                this.chooseDesignPane = new JTabbedPane();
                this.chooseDesignPane.add("One-Class", this.oneClassmulg);
                this.chooseDesignPane.add("Two-Class Unpaired", this.twoClassmulg);
                this.chooseDesignPane.add("Two-Class Paired", this.pairedPanel);
                RPInitBox.this.buildConstraints(this.constraints, 1, 0, 1, 3, 100, 100);
                this.constraints.fill = 1;
                this.gridbag.setConstraints(this.chooseDesignPane, this.constraints);
                this.add(this.chooseDesignPane);
                this.validate();
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, "Please enter a value greater than 0 and less than 1!", "Error", 0);
            }
        }

        protected void reset() {
            int i;
            for (i = 0; i < this.oneClassPanel.exptCheckBoxes.length; ++i) {
                this.oneClassPanel.exptCheckBoxes[i].setSelected(true);
            }
            for (i = 0; i < this.twoClassPanel.rbArray.length; ++i) {
                this.twoClassPanel.rbArray[i][2].setSelected(true);
            }
        }

        class ExperimentsPanel
        extends JPanel {
            int numPanels = 0;
            int numberGroups;
            JLabel[] expLabels;
            JCheckBox[] exptCheckBoxes;
            JRadioButton[][] rbArray;

            ExperimentsPanel(Vector<String> exptNames, int numGroups) {
                int i;
                int i2;
                this.setBorder(new TitledBorder(new EtchedBorder(), "Experiment Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
                this.setBackground(Color.white);
                this.numberGroups = numGroups;
                ButtonGroup[] chooseGroup = new ButtonGroup[exptNames.size()];
                this.expLabels = new JLabel[exptNames.size()];
                this.exptCheckBoxes = new JCheckBox[exptNames.size()];
                this.rbArray = new JRadioButton[exptNames.size()][this.numberGroups + 1];
                this.numPanels = exptNames.size() / 512 + 1;
                GridBagLayout gridbag = new GridBagLayout();
                GridBagLayout gridbag2 = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag2);
                JPanel[] panels = new JPanel[this.numPanels];
                int currPanel = 0;
                for (i2 = 0; i2 < panels.length; ++i2) {
                    panels[i2] = new JPanel(gridbag);
                }
                for (i2 = 0; i2 < exptNames.size(); ++i2) {
                    String s1 = exptNames.get(i2);
                    this.expLabels[i2] = new JLabel(s1);
                    RPInitBox.this.buildConstraints(constraints, 0, i2 % 512, 1, 1, 100, 100);
                    if (numGroups == 1) {
                        constraints.anchor = 17;
                        this.exptCheckBoxes[i2] = new JCheckBox("", true);
                        gridbag.setConstraints(this.exptCheckBoxes[i2], constraints);
                        panels[currPanel].add(this.exptCheckBoxes[i2]);
                        continue;
                    }
                    chooseGroup[i2] = new ButtonGroup();
                    for (int j = 0; j < this.numberGroups + 1; ++j) {
                        this.rbArray[i2][j] = new JRadioButton("Group " + (j + 1));
                        if (j == this.numberGroups) {
                            this.rbArray[i2][j] = new JRadioButton("Excluded");
                        }
                        chooseGroup[i2].add(this.rbArray[i2][j]);
                        RPInitBox.this.buildConstraints(constraints, j, i2 % 512, 1, 1, 100, 100);
                        gridbag.setConstraints(this.rbArray[i2][j], constraints);
                        panels[currPanel].add(this.rbArray[i2][j]);
                    }
                    this.rbArray[i2][this.numberGroups].setSelected(true);
                }
                int maxLabelWidth = 0;
                for (int i3 = 0; i3 < this.expLabels.length; ++i3) {
                    if (!(this.expLabels[i3].getPreferredSize().getWidth() > (double)maxLabelWidth)) continue;
                    maxLabelWidth = (int)Math.ceil(this.expLabels[i3].getPreferredSize().getWidth());
                }
                JPanel bigPanel = new JPanel(new GridBagLayout());
                for (int i4 = 0; i4 < this.numPanels; ++i4) {
                    bigPanel.add((Component)panels[i4], new GridBagConstraints(0, i4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                JScrollPane scroll = new JScrollPane(bigPanel);
                scroll.setHorizontalScrollBarPolicy(32);
                scroll.setVerticalScrollBarPolicy(22);
                JPanel[] exptNameHeaderPanels = new JPanel[this.numPanels];
                GridBagLayout exptHeaderGridbag = new GridBagLayout();
                for (i = 0; i < exptNameHeaderPanels.length; ++i) {
                    exptNameHeaderPanels[i] = new JPanel();
                    exptNameHeaderPanels[i].setSize(50, panels[i].getPreferredSize().height);
                    exptNameHeaderPanels[i].setPreferredSize(new Dimension(maxLabelWidth + 10, panels[i].getPreferredSize().height));
                    exptNameHeaderPanels[i].setLayout(exptHeaderGridbag);
                }
                for (i = 0; i < this.expLabels.length; ++i) {
                    currPanel = i / 512;
                    RPInitBox.this.buildConstraints(constraints, 0, i % 512, 1, 1, 100, 100);
                    constraints.fill = 1;
                    exptHeaderGridbag.setConstraints(this.expLabels[i], constraints);
                    exptNameHeaderPanels[currPanel].add(this.expLabels[i]);
                }
                JPanel headerPanel = new JPanel(new GridBagLayout());
                for (int i5 = 0; i5 < exptNameHeaderPanels.length; ++i5) {
                    headerPanel.add((Component)exptNameHeaderPanels[i5], new GridBagConstraints(0, i5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                scroll.setRowHeaderView(headerPanel);
                RPInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
                constraints.fill = 1;
                gridbag2.setConstraints(scroll, constraints);
                this.add(scroll);
                JPanel panel2 = new JPanel();
                GridBagLayout gridbag3 = new GridBagLayout();
                panel2.setLayout(gridbag3);
                panel2.setBackground(Color.white);
                JButton saveButton = new JButton("  Save settings  ");
                saveButton.setFocusPainted(false);
                saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton loadButton = new JButton("  Load settings  ");
                loadButton.setFocusPainted(false);
                loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton resetButton = new JButton("  Reset  ");
                resetButton.setFocusPainted(false);
                resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                resetButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ExperimentsPanel.this.reset();
                    }
                });
                JFileChooser fc = new JFileChooser(TMEV.getDataPath());
                saveButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (ExperimentsPanel.this.numberGroups == 1) {
                            ExperimentsPanel.this.saveOneClassAssignments();
                        }
                        if (ExperimentsPanel.this.numberGroups == 2) {
                            ExperimentsPanel.this.saveTwoClassAssignments();
                        }
                    }
                });
                loadButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (ExperimentsPanel.this.numberGroups == 1) {
                            ExperimentsPanel.this.loadOneClassAssignments();
                        }
                        if (ExperimentsPanel.this.numberGroups == 2) {
                            ExperimentsPanel.this.loadTwoClassAssignments();
                        }
                    }
                });
                constraints.anchor = 10;
                constraints.fill = 0;
                constraints.insets = new Insets(5, 5, 5, 5);
                RPInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 100);
                gridbag3.setConstraints(saveButton, constraints);
                panel2.add(saveButton);
                RPInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
                gridbag3.setConstraints(loadButton, constraints);
                panel2.add(loadButton);
                RPInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 34, 0);
                gridbag3.setConstraints(resetButton, constraints);
                panel2.add(resetButton);
                constraints.insets = new Insets(0, 0, 0, 0);
                RPInitBox.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 5);
                constraints.anchor = 10;
                gridbag2.setConstraints(panel2, constraints);
                this.add(panel2);
            }

            protected void reset() {
                int i;
                for (i = 0; i < MainPanel.this.oneClassPanel.exptCheckBoxes.length; ++i) {
                    MainPanel.this.oneClassPanel.exptCheckBoxes[i].setSelected(true);
                }
                for (i = 0; i < MainPanel.this.twoClassPanel.rbArray.length; ++i) {
                    MainPanel.this.twoClassPanel.rbArray[i][2].setSelected(true);
                }
            }

            private void saveOneClassAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showSaveDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        PrintWriter pw = new PrintWriter(new FileWriter(file));
                        Date currDate = new Date(System.currentTimeMillis());
                        String dateString = currDate.toString();
                        String userName = System.getProperty("user.name");
                        pw.println("# Assignment File");
                        pw.println("# User: " + userName + " Save Date: " + dateString);
                        pw.println("#");
                        pw.print("Module:\t");
                        pw.println("RP");
                        pw.print("Group 1 Label:\t");
                        pw.println("Include");
                        pw.println("#");
                        pw.println("Sample Index\tSample Name\tGroup Assignment");
                        for (int sample = 0; sample < RPInitBox.this.exptNames.size(); ++sample) {
                            pw.print(String.valueOf(sample + 1) + "\t");
                            pw.print(RPInitBox.this.exptNames.get(sample) + "\t");
                            if (this.exptCheckBoxes[sample].isSelected()) {
                                pw.println("Include");
                                continue;
                            }
                            pw.println("Exclude");
                        }
                        pw.flush();
                        pw.close();
                    }
                    catch (FileNotFoundException fnfe) {
                        fnfe.printStackTrace();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }

            private void saveTwoClassAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showSaveDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        PrintWriter pw = new PrintWriter(new FileWriter(file));
                        Date currDate = new Date(System.currentTimeMillis());
                        String dateString = currDate.toString();
                        String userName = System.getProperty("user.name");
                        pw.println("# Assignment File");
                        pw.println("# User: " + userName + " Save Date: " + dateString);
                        pw.println("#");
                        pw.print("Module:\t");
                        pw.println("RP: Two-Class Unpaired");
                        pw.print("Group 1 Label:\t");
                        pw.println("1");
                        pw.print("Group 2 Label:\t");
                        pw.println("2");
                        pw.println("#");
                        pw.println("Sample Index\tSample Name\tGroup Assignment");
                        int[] groupAssgn = RPInitBox.this.getTwoClassAssignments();
                        for (int sample = 0; sample < RPInitBox.this.exptNames.size(); ++sample) {
                            pw.print(String.valueOf(sample + 1) + "\t");
                            pw.print(RPInitBox.this.exptNames.get(sample) + "\t");
                            if (groupAssgn[sample] != 3) {
                                pw.println(groupAssgn[sample]);
                                continue;
                            }
                            pw.println("Exclude");
                        }
                        pw.flush();
                        pw.close();
                    }
                    catch (FileNotFoundException fnfe) {
                        fnfe.printStackTrace();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }

            private void loadOneClassAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showOpenDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new FileReader(file));
                        Vector<String> data = new Vector<String>();
                        while ((line = br.readLine()) != null) {
                            data.add(line.trim());
                        }
                        br.close();
                        Vector<String> groupNames = new Vector<String>();
                        Vector<Integer> sampleIndices = new Vector<Integer>();
                        Vector<String> sampleNames = new Vector<String>();
                        Vector<String> groupAssignments = new Vector<String>();
                        for (int row = 0; row < data.size(); ++row) {
                            line = (String)data.get(row);
                            if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                            String[] lineArray = line.split("\t");
                            if (lineArray[0].startsWith("Module:")) {
                                if (lineArray[1].equals("RP")) continue;
                                Object[] optionst = new Object[]{"Continue", "Cancel"};
                                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                                return;
                            }
                            if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                                groupNames.add(lineArray[1]);
                                continue;
                            }
                            try {
                                Integer.parseInt(lineArray[0]);
                            }
                            catch (NumberFormatException nfe) {
                                continue;
                            }
                            sampleIndices.add(new Integer(lineArray[0]));
                            sampleNames.add(lineArray[1]);
                            groupAssignments.add(lineArray[2]);
                        }
                        if (RPInitBox.this.exptNames.size() != sampleNames.size()) {
                            System.out.println(RPInitBox.this.exptNames.size() + " s length " + sampleNames.size());
                            JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + RPInitBox.this.exptNames.size() + ").<br>" + "Assingments are not set.</html>", "File Compatibility Error", 0);
                            return;
                        }
                        Vector<String> currSampleVector = new Vector<String>();
                        for (int i = 0; i < RPInitBox.this.exptNames.size(); ++i) {
                            currSampleVector.add(RPInitBox.this.exptNames.get(i));
                        }
                        int fileSampleIndex = 0;
                        int groupIndex = 0;
                        for (int sample = 0; sample < RPInitBox.this.exptNames.size(); ++sample) {
                            boolean doIndex = false;
                            for (int i = 0; i < RPInitBox.this.exptNames.size(); ++i) {
                                if (i == sample || !RPInitBox.this.exptNames.get(i).equals(RPInitBox.this.exptNames.get(sample))) continue;
                                doIndex = true;
                            }
                            fileSampleIndex = sampleNames.indexOf(RPInitBox.this.exptNames.get(sample));
                            if (fileSampleIndex == -1) {
                                doIndex = true;
                            }
                            if (doIndex) {
                                this.setOneClassStateBasedOnIndex(groupAssignments, groupNames);
                                break;
                            }
                            String groupName = (String)groupAssignments.get(fileSampleIndex);
                            groupIndex = groupNames.indexOf(groupName);
                            if (groupIndex == 0) {
                                this.exptCheckBoxes[sample].setSelected(true);
                                continue;
                            }
                            this.exptCheckBoxes[sample].setSelected(false);
                        }
                        this.repaint();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                    }
                }
            }

            private void setOneClassStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
                Object[] optionst = new Object[]{"Continue", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                    return;
                }
                for (int sample = 0; sample < RPInitBox.this.exptNames.size(); ++sample) {
                    if (groupNames.indexOf(groupAssignments.get(sample)) == 0) {
                        this.exptCheckBoxes[sample].setSelected(true);
                        continue;
                    }
                    this.exptCheckBoxes[sample].setSelected(false);
                }
            }

            private void loadTwoClassAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showOpenDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new FileReader(file));
                        Vector<String> data = new Vector<String>();
                        while ((line = br.readLine()) != null) {
                            data.add(line.trim());
                        }
                        br.close();
                        Vector<String> groupNames = new Vector<String>();
                        Vector<Integer> sampleIndices = new Vector<Integer>();
                        Vector<String> sampleNames = new Vector<String>();
                        Vector<String> groupAssignments = new Vector<String>();
                        for (int row = 0; row < data.size(); ++row) {
                            line = (String)data.get(row);
                            if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                            String[] lineArray = line.split("\t");
                            if (lineArray[0].startsWith("Module:")) {
                                if (lineArray[1].equals("RP: Two-Class Unpaired")) continue;
                                Object[] optionst = new Object[]{"Continue", "Cancel"};
                                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                                return;
                            }
                            if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                                groupNames.add(lineArray[1]);
                                continue;
                            }
                            try {
                                Integer.parseInt(lineArray[0]);
                            }
                            catch (NumberFormatException nfe) {
                                continue;
                            }
                            sampleIndices.add(new Integer(lineArray[0]));
                            sampleNames.add(lineArray[1]);
                            groupAssignments.add(lineArray[2]);
                        }
                        if (RPInitBox.this.exptNames.size() != sampleNames.size()) {
                            System.out.println(RPInitBox.this.exptNames.size() + "  " + sampleNames.size());
                            System.out.println(RPInitBox.this.exptNames.size() + " s length " + sampleNames.size());
                            JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + RPInitBox.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                            return;
                        }
                        int fileSampleIndex = 0;
                        int groupIndex = 0;
                        for (int sample = 0; sample < RPInitBox.this.exptNames.size(); ++sample) {
                            boolean doIndex = false;
                            for (int i = 0; i < RPInitBox.this.exptNames.size(); ++i) {
                                if (i == sample || !RPInitBox.this.exptNames.get(i).equals(RPInitBox.this.exptNames.get(sample))) continue;
                                doIndex = true;
                            }
                            fileSampleIndex = sampleNames.indexOf(RPInitBox.this.exptNames.get(sample));
                            if (fileSampleIndex == -1) {
                                doIndex = true;
                            }
                            if (doIndex) {
                                this.setTwoClassStateBasedOnIndex(groupAssignments, groupNames);
                                break;
                            }
                            String groupName = (String)groupAssignments.get(fileSampleIndex);
                            groupIndex = groupNames.indexOf(groupName);
                            try {
                                if (groupIndex == 0) {
                                    this.rbArray[sample][0].setSelected(true);
                                }
                                if (groupIndex == 1) {
                                    this.rbArray[sample][1].setSelected(true);
                                }
                                if (groupIndex != 2 && groupIndex != -1) continue;
                                this.rbArray[sample][2].setSelected(true);
                                continue;
                            }
                            catch (Exception e) {
                                this.rbArray[sample][2].setSelected(true);
                            }
                        }
                        this.repaint();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                    }
                }
            }

            private void setTwoClassStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
                Object[] optionst = new Object[]{"Continue", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                    return;
                }
                for (int sample = 0; sample < RPInitBox.this.exptNames.size(); ++sample) {
                    try {
                        if (groupNames.indexOf(groupAssignments.get(sample)) == 0) {
                            this.rbArray[0][sample].setSelected(true);
                        }
                        if (groupNames.indexOf(groupAssignments.get(sample)) == 1) {
                            this.rbArray[1][sample].setSelected(true);
                        }
                        if (groupNames.indexOf(groupAssignments.get(sample)) != 2 && groupNames.indexOf(groupAssignments.get(sample)) != -1) continue;
                        this.rbArray[2][sample].setSelected(true);
                        continue;
                    }
                    catch (Exception e) {
                        this.rbArray[2][sample].setSelected(true);
                    }
                }
            }
        }
    }
}

