/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rp;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rp.RPCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rp.RPCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rp.RPExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rp.RPInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rp.RPInitBox;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class RPGUI
implements IClusterGUI,
IScriptGUI {
    protected Algorithm algorithm;
    protected Progress progress;
    protected Experiment experiment;
    protected int[][] clusters;
    protected int[][] clustersWithNull;
    protected int[][] errorGenesArray = new int[1][];
    protected FloatMatrix means;
    protected FloatMatrix variances;
    protected int[][] sigGenesArrays;
    protected String[] auxTitles;
    protected Object[][] auxData;
    protected Vector<Float> fValues;
    protected Vector<Float> rawPValues;
    protected Vector<Float> adjPValues;
    protected Vector<Float> dfNumValues;
    protected Vector<Float> dfDenomValues;
    protected Vector<Float> ssGroups;
    protected Vector<Float> ssError;
    protected float[][] geneTimeMeans;
    protected float[][] geneTimeSDs;
    protected boolean drawSigTreesOnly;
    protected int upDown = 0;
    Vector<String> exptNamesVector;
    protected int[] groupAssignments;
    protected int[] groupAPaired;
    protected int[] groupBPaired;
    protected int falseNum;
    protected int correctionMethod;
    protected double falseProp;
    protected IData data;
    protected int numPerms;
    protected int dataDesign;
    protected boolean errorGenes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        IDistanceMenu menu;
        int function;
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int[] columnIndices = this.experiment.getColumnIndicesCopy();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(columnIndices[i]));
        }
        RPInitBox RPDialog = new RPInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1));
        RPDialog.setVisible(true);
        if (!RPDialog.isOkPressed()) {
            return null;
        }
        float alpha = RPDialog.getPValue();
        this.upDown = RPDialog.upDownPanel.getUpDown();
        this.dataDesign = RPDialog.getTestDesign();
        if (RPDialog.getTestDesign() == 7) {
            if (RPDialog.getSelectionDesign() == 11) {
                this.groupAssignments = RPDialog.getClusterOneClassAssignments();
            }
            if (RPDialog.getSelectionDesign() == 10) {
                this.groupAssignments = RPDialog.getOneClassAssignments();
            }
        }
        if (RPDialog.getTestDesign() == 8) {
            if (RPDialog.getSelectionDesign() == 11) {
                this.groupAssignments = RPDialog.getClusterTwoClassAssignments();
            }
            if (RPDialog.getSelectionDesign() == 10) {
                this.groupAssignments = RPDialog.getTwoClassAssignments();
            }
        }
        if (RPDialog.getTestDesign() == 9) {
            this.groupAPaired = RPDialog.getPairedAExpts();
            this.groupBPaired = RPDialog.getPairedBExpts();
        }
        boolean usePerms = RPDialog.usePerms();
        int numPerms = 0;
        if (usePerms) {
            numPerms = RPDialog.getNumPerms();
        }
        this.correctionMethod = RPDialog.getCorrectionMethod();
        if (this.correctionMethod == 5) {
            this.falseNum = RPDialog.getFalseNum();
        }
        if (this.correctionMethod == 6) {
            this.falseProp = RPDialog.getFalseProp();
        }
        boolean isHierarchicalTree = RPDialog.drawTrees();
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = RPDialog.drawSigTreesOnly();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 1;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        boolean hcl_samples_ordered = false;
        boolean hcl_genes_ordered = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
            hcl_genes_ordered = hcl_dialog.isGeneOrdering();
            hcl_samples_ordered = hcl_dialog.isSampleOrdering();
        }
        Listener listener = new Listener();
        try {
            int i;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("RP");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Running Rank Products Analysis...", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", this.experiment.getMatrix());
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
            data.addParam("distance-function", String.valueOf(function));
            data.addParam("dataDesign", String.valueOf(this.dataDesign));
            data.addIntArray("group_assignments", this.groupAssignments);
            data.addIntArray("groupA_paired_assignments", this.groupAPaired);
            data.addIntArray("groupB_paired_assignments", this.groupBPaired);
            data.addParam("usePerms", String.valueOf(usePerms));
            data.addParam("numPerms", String.valueOf(numPerms));
            data.addParam("alpha", String.valueOf(alpha));
            data.addParam("correction-method", String.valueOf(this.correctionMethod));
            data.addParam("alpha-value", String.valueOf(RPDialog.mPanel.alpha));
            data.addParam("UpOrDown", String.valueOf(this.upDown));
            data.addParam("classes", String.valueOf(RPDialog.getTestDesign()));
            if (this.correctionMethod == 5) {
                data.addParam("falseNum", String.valueOf(this.falseNum));
            }
            if (this.correctionMethod == 6) {
                data.addParam("falseProp", String.valueOf((float)this.falseProp));
            }
            if (isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
                data.addParam("hcl-genes-ordered", String.valueOf(hcl_genes_ordered));
                data.addParam("hcl-samples-ordered", String.valueOf(hcl_samples_ordered));
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            this.clustersWithNull = result.getIntMatrix("sigGenesArrays");
            if (this.upDown == 1) {
                this.clusters = new int[2][];
                this.clusters[0] = this.clustersWithNull[1];
                this.clusters[1] = this.clustersWithNull[2];
            }
            if (this.upDown == 2) {
                this.clusters = new int[2][];
                this.clusters[0] = this.clustersWithNull[0];
                this.clusters[1] = this.clustersWithNull[2];
            }
            if (this.upDown == 3) {
                this.clusters = this.clustersWithNull;
            }
            FloatMatrix geneTimeMeansMatrix = result.getMatrix("geneTimeMeansMatrix");
            FloatMatrix geneTimeSDsMatrix = result.getMatrix("geneTimeSDsMatrix");
            FloatMatrix pValuesDown = result.getMatrix("pValuesDown");
            FloatMatrix qValuesDown = result.getMatrix("qValuesDown");
            FloatMatrix rpValuesDown = result.getMatrix("RPValsDown");
            FloatMatrix pValuesUp = result.getMatrix("pValuesUp");
            FloatMatrix qValuesUp = result.getMatrix("qValuesUp");
            FloatMatrix rpValuesUp = result.getMatrix("RPValsUp");
            FloatMatrix fcValues = null;
            if (RPDialog.getTestDesign() == 8) {
                fcValues = result.getMatrix("fold_change");
            }
            this.rawPValues = new Vector();
            this.adjPValues = new Vector();
            this.fValues = new Vector();
            this.ssGroups = new Vector();
            this.ssError = new Vector();
            this.geneTimeMeans = new float[geneTimeMeansMatrix.getRowDimension()][geneTimeMeansMatrix.getColumnDimension()];
            this.geneTimeSDs = new float[geneTimeSDsMatrix.getRowDimension()][geneTimeSDsMatrix.getColumnDimension()];
            for (int i2 = 0; i2 < this.geneTimeMeans.length; ++i2) {
                for (int j = 0; j < this.geneTimeMeans[i2].length; ++j) {
                    this.geneTimeMeans[i2][j] = geneTimeMeansMatrix.A[i2][j];
                    this.geneTimeSDs[i2][j] = geneTimeSDsMatrix.A[i2][j];
                }
            }
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = alpha;
            info.usePerms = usePerms;
            info.numPerms = numPerms;
            info.correctionMethod = this.getSigMethod(this.correctionMethod);
            info.function = menu.getFunctionName(function);
            info.hcl = isHierarchicalTree;
            info.hcl_genes = hcl_genes;
            info.hcl_samples = hcl_samples;
            info.hcl_method = hcl_method;
            Vector<String> titlesVector = new Vector<String>();
            if (this.upDown != 1) {
                titlesVector.add("p-Values (Down)");
                titlesVector.add("q-Values (Down)");
                titlesVector.add("RP-Values (Down)");
            }
            if (this.upDown != 2) {
                titlesVector.add("p-Values (Up)");
                titlesVector.add("q-Values (Up)");
                titlesVector.add("RP-Values (Up)");
            }
            if (RPDialog.getTestDesign() == 8) {
                titlesVector.add("Fold Change");
            }
            titlesVector.add("Mean");
            titlesVector.add("std.dev");
            this.auxTitles = new String[titlesVector.size()];
            for (i = 0; i < this.auxTitles.length; ++i) {
                this.auxTitles[i] = (String)titlesVector.get(i);
            }
            this.auxData = new Object[this.experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i = 0; i < this.auxData.length; ++i) {
                int counter = 0;
                if (this.upDown != 1) {
                    this.auxData[i][counter++] = Float.valueOf(pValuesDown.get(i, 0));
                    this.auxData[i][counter++] = Float.valueOf(qValuesDown.get(i, 0));
                    this.auxData[i][counter++] = Float.valueOf(rpValuesDown.get(i, 0));
                }
                if (this.upDown != 2) {
                    this.auxData[i][counter++] = Float.valueOf(pValuesUp.get(i, 0));
                    this.auxData[i][counter++] = Float.valueOf(qValuesUp.get(i, 0));
                    this.auxData[i][counter++] = Float.valueOf(rpValuesUp.get(i, 0));
                }
                if (RPDialog.getTestDesign() == 8) {
                    this.auxData[i][counter++] = Float.valueOf(fcValues.get(i, 0));
                }
                this.auxData[i][counter++] = new Float(this.geneTimeMeans[i][0]);
                this.auxData[i][counter++] = new Float(this.geneTimeSDs[i][0]);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        IDistanceMenu menu;
        int function;
        this.experiment = framework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        RPInitBox RPDialog = new RPInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1));
        RPDialog.setVisible(true);
        if (!RPDialog.isOkPressed()) {
            return null;
        }
        float alpha = RPDialog.getPValue();
        if (RPDialog.getTestDesign() == 7) {
            if (RPDialog.getSelectionDesign() == 11) {
                this.groupAssignments = RPDialog.getClusterOneClassAssignments();
            }
            if (RPDialog.getSelectionDesign() == 10) {
                this.groupAssignments = RPDialog.getOneClassAssignments();
            }
        }
        if (RPDialog.getTestDesign() == 8) {
            if (RPDialog.getSelectionDesign() == 11) {
                this.groupAssignments = RPDialog.getClusterTwoClassAssignments();
            }
            if (RPDialog.getSelectionDesign() == 10) {
                this.groupAssignments = RPDialog.getTwoClassAssignments();
            }
        }
        boolean usePerms = RPDialog.usePerms();
        int numPerms = 0;
        if (usePerms) {
            numPerms = RPDialog.getNumPerms();
        }
        this.correctionMethod = RPDialog.getCorrectionMethod();
        if (this.correctionMethod == 5) {
            this.falseNum = RPDialog.getFalseNum();
        }
        if (this.correctionMethod == 6) {
            this.falseProp = RPDialog.getFalseProp();
        }
        boolean isHierarchicalTree = RPDialog.drawTrees();
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = RPDialog.drawSigTreesOnly();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 1;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        AlgorithmData data = new AlgorithmData();
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
        data.addParam("distance-function", String.valueOf(function));
        data.addIntArray("condition_assignments", this.groupAssignments);
        data.addParam("usePerms", String.valueOf(usePerms));
        data.addParam("numPerms", String.valueOf(numPerms));
        data.addParam("alpha", String.valueOf(alpha));
        data.addParam("correction-method", String.valueOf(this.correctionMethod));
        if (this.correctionMethod == 5) {
            data.addParam("falseNum", String.valueOf(this.falseNum));
        }
        if (this.correctionMethod == 6) {
            data.addParam("falseProp", String.valueOf((float)this.falseProp));
        }
        if (isHierarchicalTree) {
            data.addParam("hierarchical-tree", String.valueOf(true));
            data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
            data.addParam("method-linkage", String.valueOf(hcl_method));
            data.addParam("calculate-genes", String.valueOf(hcl_genes));
            data.addParam("calculate-experiments", String.valueOf(hcl_samples));
            data.addParam("hcl-distance-function", String.valueOf(hcl_function));
            data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
        }
        data.addParam("name", "RP");
        data.addParam("alg-type", "cluster-genes");
        data.addParam("output-class", "partition-output");
        String[] outputNodes = new String[]{"Significant Genes", "Non-significant Genes"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        Listener listener = new Listener();
        this.experiment = experiment;
        this.data = framework.getData();
        this.groupAssignments = algData.getIntArray("condition_assignments");
        this.correctionMethod = algData.getParams().getInt("correction-method");
        if (this.correctionMethod == 5) {
            this.falseNum = algData.getParams().getInt("falseNum");
        }
        if (this.correctionMethod == 6) {
            this.falseProp = algData.getParams().getFloat("falseProp");
        }
        this.drawSigTreesOnly = algData.getParams().getBoolean("draw-sig-trees-only");
        this.rawPValues = new Vector();
        this.adjPValues = new Vector();
        this.exptNamesVector = new Vector();
        int number_of_samples = experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(this.data.getFullSampleName(i));
        }
        try {
            int i;
            algData.addMatrix("experiment", experiment.getMatrix());
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("RP");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Running Rank Products Analysis...", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            int k = 2;
            this.clusters = new int[k][];
            for (int i2 = 0; i2 < k; ++i2) {
                this.clusters[i2] = nodeList.getNode(i2).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            this.fValues = new Vector();
            this.ssGroups = new Vector();
            this.ssError = new Vector();
            AlgorithmParameters params = algData.getParams();
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = params.getFloat("alpha");
            info.correctionMethod = this.getSigMethod(params.getInt("correction-method"));
            info.usePerms = params.getBoolean("usePerms");
            info.numPerms = params.getInt("numPerms");
            info.function = framework.getDistanceMenu().getFunctionName(params.getInt("distance-function"));
            info.hcl = params.getBoolean("hierarchical-tree");
            info.hcl_genes = params.getBoolean("calculate-genes");
            info.hcl_samples = params.getBoolean("calculate-experiments");
            if (info.hcl) {
                info.hcl_method = params.getInt("method-linkage");
            }
            Vector<String> titlesVector = new Vector<String>();
            for (i = 0; i < this.geneTimeMeans[0].length; ++i) {
                titlesVector.add("Group" + (i + 1) + " mean");
                titlesVector.add("Group" + (i + 1) + " std.dev");
            }
            this.auxTitles = new String[titlesVector.size()];
            for (i = 0; i < this.auxTitles.length; ++i) {
                this.auxTitles[i] = (String)titlesVector.get(i);
            }
            this.auxData = new Object[experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i = 0; i < this.auxData.length; ++i) {
                int counter = 0;
                for (int j = 0; j < this.geneTimeMeans[i].length; ++j) {
                    this.auxData[i][counter++] = new Float(this.geneTimeMeans[i][j]);
                    this.auxData[i][counter++] = new Float(this.geneTimeSDs[i][j]);
                }
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    protected String getSigMethod(int sigMethod) {
        String methodName = "";
        if (sigMethod == 1) {
            methodName = "Just alpha (uncorrected)";
        } else if (sigMethod == 2) {
            methodName = "Standard Bonferroni correction";
        } else if (sigMethod == 3) {
            methodName = "Adjusted Bonferroni correction";
        } else if (sigMethod == 4) {
            methodName = "Westfall Young stepdown - MaxT";
        } else if (sigMethod == 5) {
            methodName = "False significant number: " + this.falseNum + " or less";
        } else if (sigMethod == 6) {
            methodName = "False significant proportion: " + this.falseProp + " or less";
        }
        return methodName;
    }

    protected DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("RP");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    protected void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addExpressionImages(root);
        this.addHierarchicalTrees(root, result_cluster, info);
        this.addCentroidViews(root);
        this.addTableViews(root);
        this.addClusterInfo(root);
        this.addGeneralInfo(root, info);
    }

    protected void addTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table Views");
        ClusterTableViewer tabViewer = new ClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i] == null) continue;
            if (i == 0 && (this.upDown == 2 || this.upDown == 3)) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
                continue;
            }
            if (i == 1 && this.upDown == 3 || i == 0 && this.upDown == 1) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
                continue;
            }
            if (i != this.clusters.length - 1) continue;
            node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    protected void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        RPExperimentViewer expViewer = new RPExperimentViewer(this.experiment, this.clusters, null, null, null, null, null, null, null, null, null);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i] == null) continue;
            if (i == 0 && (this.upDown == 2 || this.upDown == 3)) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
                continue;
            }
            if (i == 1 && this.upDown == 3 || i == 0 && this.upDown == 1) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
                continue;
            }
            if (i != this.clusters.length - 1) continue;
            node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
        }
        if (this.errorGenes) {
            RPExperimentViewer errorGenesIViewer = new RPExperimentViewer(this.experiment, this.errorGenesArray, null, null, null, null, null, null, null, null, null);
            node.add(new DefaultMutableTreeNode(new LeafInfo("Invalid Genes ", (IViewer)errorGenesIViewer, (Object)new Integer(0))));
        }
        root.add(node);
    }

    protected void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        for (int i = 0; i < nodeList.getSize(); ++i) {
            if (i == 0 && this.upDown != 1) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                continue;
            }
            if (i == 1 && this.upDown != 2) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                continue;
            }
            if (i != nodeList.getSize() - 1 || this.drawSigTreesOnly) continue;
            node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
        }
        root.add(node);
    }

    protected IViewer createHCLViewer(Node clusterNode, GeneralInfo info) {
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData samples_result = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
    }

    protected HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    protected void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        node.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", (IViewer)new RPInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.upDown))));
        root.add(node);
    }

    protected void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        RPCentroidViewer centroidViewer = new RPCentroidViewer(this.experiment, this.clusters, null, null, null, null, null, null, null, null, null);
        centroidViewer.setMeans(this.means.A);
        centroidViewer.setVariances(this.variances.A);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i == 0) {
                if (this.upDown != 1) {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                } else {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                }
            }
            if (i == 1) {
                if (this.upDown == 3) {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                } else {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                }
            }
            if (i != 2) continue;
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
        }
        RPCentroidsViewer centroidsViewer = new RPCentroidsViewer(this.experiment, this.clusters, this.geneTimeMeans, this.geneTimeSDs, this.rawPValues, this.adjPValues, this.fValues, this.ssGroups, this.ssError, this.dfNumValues, this.dfDenomValues);
        centroidsViewer.setMeans(this.means.A);
        centroidsViewer.setVariances(this.variances.A);
        centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(0))));
        expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(1))));
        root.add(centroidNode);
        root.add(expressionNode);
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(this.getConditionAssignmentInfo());
        if (info.correctionMethod.startsWith("False")) {
            if (!info.correctionMethod.startsWith("False significant number")) {
                node.add(new DefaultMutableTreeNode("Confidence (1 - alpha) : " + (1.0 - this.falseProp) * 100.0 + " %"));
            }
        } else {
            node.add(new DefaultMutableTreeNode("Alpha (overall threshold p-value): " + info.alpha));
        }
        if (this.upDown == 1) {
            node.add(new DefaultMutableTreeNode("Find up-regulated genes"));
        }
        if (this.upDown == 2) {
            node.add(new DefaultMutableTreeNode("Find down-regulated genes"));
        }
        if (this.upDown == 3) {
            node.add(new DefaultMutableTreeNode("Find up and down-regulated genes"));
        }
        if (info.correctionMethod.startsWith("False")) {
            node.add(new DefaultMutableTreeNode(info.correctionMethod));
        } else {
            node.add(new DefaultMutableTreeNode("Significance determined by: " + info.correctionMethod));
        }
        node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time - 1L) + " ms"));
        node.add(new DefaultMutableTreeNode(info.function));
        root.add(node);
    }

    protected DefaultMutableTreeNode getTimeAssignmentInfo() {
        DefaultMutableTreeNode groupAssignmentInfo = new DefaultMutableTreeNode("Time assignments ");
        return groupAssignmentInfo;
    }

    protected DefaultMutableTreeNode getConditionAssignmentInfo() {
        DefaultMutableTreeNode groupAssignmentInfo = new DefaultMutableTreeNode("Group assignments ");
        DefaultMutableTreeNode notInGroups = new DefaultMutableTreeNode("Samples Excluded");
        DefaultMutableTreeNode groupA = new DefaultMutableTreeNode("Samples Included");
        if (this.dataDesign == 7) {
            groupA = new DefaultMutableTreeNode("Samples Included");
        } else if (this.dataDesign == 8 || this.dataDesign == 9) {
            groupA = new DefaultMutableTreeNode("Group A");
        }
        DefaultMutableTreeNode groupB = new DefaultMutableTreeNode("Group B");
        if (this.dataDesign != 9) {
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                int currentGroup = this.groupAssignments[i];
                if (currentGroup == 0) {
                    notInGroups.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                    continue;
                }
                if (currentGroup == 1) {
                    groupA.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                    continue;
                }
                groupB.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
            }
        } else {
            for (int i = 0; i < this.groupAPaired.length; ++i) {
                groupA.add(new DefaultMutableTreeNode(this.exptNamesVector.get(this.groupAPaired[i])));
                groupB.add(new DefaultMutableTreeNode(this.exptNamesVector.get(this.groupBPaired[i])));
            }
        }
        groupAssignmentInfo.add(groupA);
        if (this.dataDesign == 8 || this.dataDesign == 9) {
            groupAssignmentInfo.add(groupB);
        }
        if (notInGroups.getChildCount() > 0) {
            groupAssignmentInfo.add(notInGroups);
        }
        return groupAssignmentInfo;
    }

    protected class GeneralInfo {
        public int clusters;
        public String correctionMethod;
        public float alpha;
        public long time;
        public String function;
        protected boolean hcl;
        protected boolean usePerms;
        protected int hcl_method;
        protected int numPerms;
        protected boolean hcl_genes;
        protected boolean hcl_samples;

        protected GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        protected Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    RPGUI.this.progress.setUnits(event.getIntValue());
                    RPGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    RPGUI.this.progress.setValue(event.getIntValue());
                    RPGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                RPGUI.this.algorithm.abort();
                RPGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            RPGUI.this.algorithm.abort();
            RPGUI.this.progress.dispose();
        }
    }
}

